/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.HITReviewStatus;
import software.amazon.awssdk.services.mturk.model.HITStatus;
import software.amazon.awssdk.services.mturk.model.QualificationRequirement;
import software.amazon.awssdk.services.mturk.model.QualificationRequirementListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HIT
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HIT> {
    private static final SdkField<String> HIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HITId").getter(HIT.getter(HIT::hitId)).setter(HIT.setter(Builder::hitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITId").build()}).build();
    private static final SdkField<String> HIT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HITTypeId").getter(HIT.getter(HIT::hitTypeId)).setter(HIT.setter(Builder::hitTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITTypeId").build()}).build();
    private static final SdkField<String> HIT_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HITGroupId").getter(HIT.getter(HIT::hitGroupId)).setter(HIT.setter(Builder::hitGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITGroupId").build()}).build();
    private static final SdkField<String> HIT_LAYOUT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HITLayoutId").getter(HIT.getter(HIT::hitLayoutId)).setter(HIT.setter(Builder::hitLayoutId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITLayoutId").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(HIT.getter(HIT::creationTime)).setter(HIT.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(HIT.getter(HIT::title)).setter(HIT.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(HIT.getter(HIT::description)).setter(HIT.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> QUESTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Question").getter(HIT.getter(HIT::question)).setter(HIT.setter(Builder::question)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Question").build()}).build();
    private static final SdkField<String> KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Keywords").getter(HIT.getter(HIT::keywords)).setter(HIT.setter(Builder::keywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keywords").build()}).build();
    private static final SdkField<String> HIT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HITStatus").getter(HIT.getter(HIT::hitStatusAsString)).setter(HIT.setter(Builder::hitStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITStatus").build()}).build();
    private static final SdkField<Integer> MAX_ASSIGNMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAssignments").getter(HIT.getter(HIT::maxAssignments)).setter(HIT.setter(Builder::maxAssignments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAssignments").build()}).build();
    private static final SdkField<String> REWARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reward").getter(HIT.getter(HIT::reward)).setter(HIT.setter(Builder::reward)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reward").build()}).build();
    private static final SdkField<Long> AUTO_APPROVAL_DELAY_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AutoApprovalDelayInSeconds").getter(HIT.getter(HIT::autoApprovalDelayInSeconds)).setter(HIT.setter(Builder::autoApprovalDelayInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoApprovalDelayInSeconds").build()}).build();
    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Expiration").getter(HIT.getter(HIT::expiration)).setter(HIT.setter(Builder::expiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration").build()}).build();
    private static final SdkField<Long> ASSIGNMENT_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AssignmentDurationInSeconds").getter(HIT.getter(HIT::assignmentDurationInSeconds)).setter(HIT.setter(Builder::assignmentDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentDurationInSeconds").build()}).build();
    private static final SdkField<String> REQUESTER_ANNOTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequesterAnnotation").getter(HIT.getter(HIT::requesterAnnotation)).setter(HIT.setter(Builder::requesterAnnotation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterAnnotation").build()}).build();
    private static final SdkField<List<QualificationRequirement>> QUALIFICATION_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QualificationRequirements").getter(HIT.getter(HIT::qualificationRequirements)).setter(HIT.setter(Builder::qualificationRequirements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationRequirements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QualificationRequirement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HIT_REVIEW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HITReviewStatus").getter(HIT.getter(HIT::hitReviewStatusAsString)).setter(HIT.setter(Builder::hitReviewStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITReviewStatus").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_ASSIGNMENTS_PENDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfAssignmentsPending").getter(HIT.getter(HIT::numberOfAssignmentsPending)).setter(HIT.setter(Builder::numberOfAssignmentsPending)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAssignmentsPending").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_ASSIGNMENTS_AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfAssignmentsAvailable").getter(HIT.getter(HIT::numberOfAssignmentsAvailable)).setter(HIT.setter(Builder::numberOfAssignmentsAvailable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAssignmentsAvailable").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_ASSIGNMENTS_COMPLETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfAssignmentsCompleted").getter(HIT.getter(HIT::numberOfAssignmentsCompleted)).setter(HIT.setter(Builder::numberOfAssignmentsCompleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAssignmentsCompleted").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIT_ID_FIELD, HIT_TYPE_ID_FIELD, HIT_GROUP_ID_FIELD, HIT_LAYOUT_ID_FIELD, CREATION_TIME_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, QUESTION_FIELD, KEYWORDS_FIELD, HIT_STATUS_FIELD, MAX_ASSIGNMENTS_FIELD, REWARD_FIELD, AUTO_APPROVAL_DELAY_IN_SECONDS_FIELD, EXPIRATION_FIELD, ASSIGNMENT_DURATION_IN_SECONDS_FIELD, REQUESTER_ANNOTATION_FIELD, QUALIFICATION_REQUIREMENTS_FIELD, HIT_REVIEW_STATUS_FIELD, NUMBER_OF_ASSIGNMENTS_PENDING_FIELD, NUMBER_OF_ASSIGNMENTS_AVAILABLE_FIELD, NUMBER_OF_ASSIGNMENTS_COMPLETED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String hitId;
    private final String hitTypeId;
    private final String hitGroupId;
    private final String hitLayoutId;
    private final Instant creationTime;
    private final String title;
    private final String description;
    private final String question;
    private final String keywords;
    private final String hitStatus;
    private final Integer maxAssignments;
    private final String reward;
    private final Long autoApprovalDelayInSeconds;
    private final Instant expiration;
    private final Long assignmentDurationInSeconds;
    private final String requesterAnnotation;
    private final List<QualificationRequirement> qualificationRequirements;
    private final String hitReviewStatus;
    private final Integer numberOfAssignmentsPending;
    private final Integer numberOfAssignmentsAvailable;
    private final Integer numberOfAssignmentsCompleted;

    private HIT(BuilderImpl builder) {
        this.hitId = builder.hitId;
        this.hitTypeId = builder.hitTypeId;
        this.hitGroupId = builder.hitGroupId;
        this.hitLayoutId = builder.hitLayoutId;
        this.creationTime = builder.creationTime;
        this.title = builder.title;
        this.description = builder.description;
        this.question = builder.question;
        this.keywords = builder.keywords;
        this.hitStatus = builder.hitStatus;
        this.maxAssignments = builder.maxAssignments;
        this.reward = builder.reward;
        this.autoApprovalDelayInSeconds = builder.autoApprovalDelayInSeconds;
        this.expiration = builder.expiration;
        this.assignmentDurationInSeconds = builder.assignmentDurationInSeconds;
        this.requesterAnnotation = builder.requesterAnnotation;
        this.qualificationRequirements = builder.qualificationRequirements;
        this.hitReviewStatus = builder.hitReviewStatus;
        this.numberOfAssignmentsPending = builder.numberOfAssignmentsPending;
        this.numberOfAssignmentsAvailable = builder.numberOfAssignmentsAvailable;
        this.numberOfAssignmentsCompleted = builder.numberOfAssignmentsCompleted;
    }

    public String hitId() {
        return this.hitId;
    }

    public String hitTypeId() {
        return this.hitTypeId;
    }

    public String hitGroupId() {
        return this.hitGroupId;
    }

    public String hitLayoutId() {
        return this.hitLayoutId;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public String title() {
        return this.title;
    }

    public String description() {
        return this.description;
    }

    public String question() {
        return this.question;
    }

    public String keywords() {
        return this.keywords;
    }

    public HITStatus hitStatus() {
        return HITStatus.fromValue(this.hitStatus);
    }

    public String hitStatusAsString() {
        return this.hitStatus;
    }

    public Integer maxAssignments() {
        return this.maxAssignments;
    }

    public String reward() {
        return this.reward;
    }

    public Long autoApprovalDelayInSeconds() {
        return this.autoApprovalDelayInSeconds;
    }

    public Instant expiration() {
        return this.expiration;
    }

    public Long assignmentDurationInSeconds() {
        return this.assignmentDurationInSeconds;
    }

    public String requesterAnnotation() {
        return this.requesterAnnotation;
    }

    public boolean hasQualificationRequirements() {
        return this.qualificationRequirements != null && !(this.qualificationRequirements instanceof SdkAutoConstructList);
    }

    public List<QualificationRequirement> qualificationRequirements() {
        return this.qualificationRequirements;
    }

    public HITReviewStatus hitReviewStatus() {
        return HITReviewStatus.fromValue(this.hitReviewStatus);
    }

    public String hitReviewStatusAsString() {
        return this.hitReviewStatus;
    }

    public Integer numberOfAssignmentsPending() {
        return this.numberOfAssignmentsPending;
    }

    public Integer numberOfAssignmentsAvailable() {
        return this.numberOfAssignmentsAvailable;
    }

    public Integer numberOfAssignmentsCompleted() {
        return this.numberOfAssignmentsCompleted;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitLayoutId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.question());
        hashCode = 31 * hashCode + Objects.hashCode(this.keywords());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAssignments());
        hashCode = 31 * hashCode + Objects.hashCode(this.reward());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoApprovalDelayInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterAnnotation());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualificationRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitReviewStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAssignmentsPending());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAssignmentsAvailable());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAssignmentsCompleted());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HIT)) {
            return false;
        }
        HIT other = (HIT)obj;
        return Objects.equals(this.hitId(), other.hitId()) && Objects.equals(this.hitTypeId(), other.hitTypeId()) && Objects.equals(this.hitGroupId(), other.hitGroupId()) && Objects.equals(this.hitLayoutId(), other.hitLayoutId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.question(), other.question()) && Objects.equals(this.keywords(), other.keywords()) && Objects.equals(this.hitStatusAsString(), other.hitStatusAsString()) && Objects.equals(this.maxAssignments(), other.maxAssignments()) && Objects.equals(this.reward(), other.reward()) && Objects.equals(this.autoApprovalDelayInSeconds(), other.autoApprovalDelayInSeconds()) && Objects.equals(this.expiration(), other.expiration()) && Objects.equals(this.assignmentDurationInSeconds(), other.assignmentDurationInSeconds()) && Objects.equals(this.requesterAnnotation(), other.requesterAnnotation()) && Objects.equals(this.qualificationRequirements(), other.qualificationRequirements()) && Objects.equals(this.hitReviewStatusAsString(), other.hitReviewStatusAsString()) && Objects.equals(this.numberOfAssignmentsPending(), other.numberOfAssignmentsPending()) && Objects.equals(this.numberOfAssignmentsAvailable(), other.numberOfAssignmentsAvailable()) && Objects.equals(this.numberOfAssignmentsCompleted(), other.numberOfAssignmentsCompleted());
    }

    public String toString() {
        return ToString.builder((String)"HIT").add("HITId", (Object)this.hitId()).add("HITTypeId", (Object)this.hitTypeId()).add("HITGroupId", (Object)this.hitGroupId()).add("HITLayoutId", (Object)this.hitLayoutId()).add("CreationTime", (Object)this.creationTime()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("Question", (Object)this.question()).add("Keywords", (Object)this.keywords()).add("HITStatus", (Object)this.hitStatusAsString()).add("MaxAssignments", (Object)this.maxAssignments()).add("Reward", (Object)this.reward()).add("AutoApprovalDelayInSeconds", (Object)this.autoApprovalDelayInSeconds()).add("Expiration", (Object)this.expiration()).add("AssignmentDurationInSeconds", (Object)this.assignmentDurationInSeconds()).add("RequesterAnnotation", (Object)this.requesterAnnotation()).add("QualificationRequirements", this.qualificationRequirements()).add("HITReviewStatus", (Object)this.hitReviewStatusAsString()).add("NumberOfAssignmentsPending", (Object)this.numberOfAssignmentsPending()).add("NumberOfAssignmentsAvailable", (Object)this.numberOfAssignmentsAvailable()).add("NumberOfAssignmentsCompleted", (Object)this.numberOfAssignmentsCompleted()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HITId": {
                return Optional.ofNullable(clazz.cast(this.hitId()));
            }
            case "HITTypeId": {
                return Optional.ofNullable(clazz.cast(this.hitTypeId()));
            }
            case "HITGroupId": {
                return Optional.ofNullable(clazz.cast(this.hitGroupId()));
            }
            case "HITLayoutId": {
                return Optional.ofNullable(clazz.cast(this.hitLayoutId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Question": {
                return Optional.ofNullable(clazz.cast(this.question()));
            }
            case "Keywords": {
                return Optional.ofNullable(clazz.cast(this.keywords()));
            }
            case "HITStatus": {
                return Optional.ofNullable(clazz.cast(this.hitStatusAsString()));
            }
            case "MaxAssignments": {
                return Optional.ofNullable(clazz.cast(this.maxAssignments()));
            }
            case "Reward": {
                return Optional.ofNullable(clazz.cast(this.reward()));
            }
            case "AutoApprovalDelayInSeconds": {
                return Optional.ofNullable(clazz.cast(this.autoApprovalDelayInSeconds()));
            }
            case "Expiration": {
                return Optional.ofNullable(clazz.cast(this.expiration()));
            }
            case "AssignmentDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.assignmentDurationInSeconds()));
            }
            case "RequesterAnnotation": {
                return Optional.ofNullable(clazz.cast(this.requesterAnnotation()));
            }
            case "QualificationRequirements": {
                return Optional.ofNullable(clazz.cast(this.qualificationRequirements()));
            }
            case "HITReviewStatus": {
                return Optional.ofNullable(clazz.cast(this.hitReviewStatusAsString()));
            }
            case "NumberOfAssignmentsPending": {
                return Optional.ofNullable(clazz.cast(this.numberOfAssignmentsPending()));
            }
            case "NumberOfAssignmentsAvailable": {
                return Optional.ofNullable(clazz.cast(this.numberOfAssignmentsAvailable()));
            }
            case "NumberOfAssignmentsCompleted": {
                return Optional.ofNullable(clazz.cast(this.numberOfAssignmentsCompleted()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HIT, T> g) {
        return obj -> g.apply((HIT)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hitId;
        private String hitTypeId;
        private String hitGroupId;
        private String hitLayoutId;
        private Instant creationTime;
        private String title;
        private String description;
        private String question;
        private String keywords;
        private String hitStatus;
        private Integer maxAssignments;
        private String reward;
        private Long autoApprovalDelayInSeconds;
        private Instant expiration;
        private Long assignmentDurationInSeconds;
        private String requesterAnnotation;
        private List<QualificationRequirement> qualificationRequirements = DefaultSdkAutoConstructList.getInstance();
        private String hitReviewStatus;
        private Integer numberOfAssignmentsPending;
        private Integer numberOfAssignmentsAvailable;
        private Integer numberOfAssignmentsCompleted;

        private BuilderImpl() {
        }

        private BuilderImpl(HIT model) {
            this.hitId(model.hitId);
            this.hitTypeId(model.hitTypeId);
            this.hitGroupId(model.hitGroupId);
            this.hitLayoutId(model.hitLayoutId);
            this.creationTime(model.creationTime);
            this.title(model.title);
            this.description(model.description);
            this.question(model.question);
            this.keywords(model.keywords);
            this.hitStatus(model.hitStatus);
            this.maxAssignments(model.maxAssignments);
            this.reward(model.reward);
            this.autoApprovalDelayInSeconds(model.autoApprovalDelayInSeconds);
            this.expiration(model.expiration);
            this.assignmentDurationInSeconds(model.assignmentDurationInSeconds);
            this.requesterAnnotation(model.requesterAnnotation);
            this.qualificationRequirements(model.qualificationRequirements);
            this.hitReviewStatus(model.hitReviewStatus);
            this.numberOfAssignmentsPending(model.numberOfAssignmentsPending);
            this.numberOfAssignmentsAvailable(model.numberOfAssignmentsAvailable);
            this.numberOfAssignmentsCompleted(model.numberOfAssignmentsCompleted);
        }

        public final String getHitId() {
            return this.hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final void setHitId(String hitId) {
            this.hitId = hitId;
        }

        public final String getHitTypeId() {
            return this.hitTypeId;
        }

        @Override
        public final Builder hitTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
            return this;
        }

        public final void setHitTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
        }

        public final String getHitGroupId() {
            return this.hitGroupId;
        }

        @Override
        public final Builder hitGroupId(String hitGroupId) {
            this.hitGroupId = hitGroupId;
            return this;
        }

        public final void setHitGroupId(String hitGroupId) {
            this.hitGroupId = hitGroupId;
        }

        public final String getHitLayoutId() {
            return this.hitLayoutId;
        }

        @Override
        public final Builder hitLayoutId(String hitLayoutId) {
            this.hitLayoutId = hitLayoutId;
            return this;
        }

        public final void setHitLayoutId(String hitLayoutId) {
            this.hitLayoutId = hitLayoutId;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getQuestion() {
            return this.question;
        }

        @Override
        public final Builder question(String question) {
            this.question = question;
            return this;
        }

        public final void setQuestion(String question) {
            this.question = question;
        }

        public final String getKeywords() {
            return this.keywords;
        }

        @Override
        public final Builder keywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        public final void setKeywords(String keywords) {
            this.keywords = keywords;
        }

        public final String getHitStatus() {
            return this.hitStatus;
        }

        @Override
        public final Builder hitStatus(String hitStatus) {
            this.hitStatus = hitStatus;
            return this;
        }

        @Override
        public final Builder hitStatus(HITStatus hitStatus) {
            this.hitStatus(hitStatus == null ? null : hitStatus.toString());
            return this;
        }

        public final void setHitStatus(String hitStatus) {
            this.hitStatus = hitStatus;
        }

        public final Integer getMaxAssignments() {
            return this.maxAssignments;
        }

        @Override
        public final Builder maxAssignments(Integer maxAssignments) {
            this.maxAssignments = maxAssignments;
            return this;
        }

        public final void setMaxAssignments(Integer maxAssignments) {
            this.maxAssignments = maxAssignments;
        }

        public final String getReward() {
            return this.reward;
        }

        @Override
        public final Builder reward(String reward) {
            this.reward = reward;
            return this;
        }

        public final void setReward(String reward) {
            this.reward = reward;
        }

        public final Long getAutoApprovalDelayInSeconds() {
            return this.autoApprovalDelayInSeconds;
        }

        @Override
        public final Builder autoApprovalDelayInSeconds(Long autoApprovalDelayInSeconds) {
            this.autoApprovalDelayInSeconds = autoApprovalDelayInSeconds;
            return this;
        }

        public final void setAutoApprovalDelayInSeconds(Long autoApprovalDelayInSeconds) {
            this.autoApprovalDelayInSeconds = autoApprovalDelayInSeconds;
        }

        public final Instant getExpiration() {
            return this.expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        public final Long getAssignmentDurationInSeconds() {
            return this.assignmentDurationInSeconds;
        }

        @Override
        public final Builder assignmentDurationInSeconds(Long assignmentDurationInSeconds) {
            this.assignmentDurationInSeconds = assignmentDurationInSeconds;
            return this;
        }

        public final void setAssignmentDurationInSeconds(Long assignmentDurationInSeconds) {
            this.assignmentDurationInSeconds = assignmentDurationInSeconds;
        }

        public final String getRequesterAnnotation() {
            return this.requesterAnnotation;
        }

        @Override
        public final Builder requesterAnnotation(String requesterAnnotation) {
            this.requesterAnnotation = requesterAnnotation;
            return this;
        }

        public final void setRequesterAnnotation(String requesterAnnotation) {
            this.requesterAnnotation = requesterAnnotation;
        }

        public final Collection<QualificationRequirement.Builder> getQualificationRequirements() {
            return this.qualificationRequirements != null ? (Collection)this.qualificationRequirements.stream().map(QualificationRequirement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder qualificationRequirements(Collection<QualificationRequirement> qualificationRequirements) {
            this.qualificationRequirements = QualificationRequirementListCopier.copy(qualificationRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationRequirements(QualificationRequirement ... qualificationRequirements) {
            this.qualificationRequirements(Arrays.asList(qualificationRequirements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationRequirements(Consumer<QualificationRequirement.Builder> ... qualificationRequirements) {
            this.qualificationRequirements(Stream.of(qualificationRequirements).map(c -> (QualificationRequirement)((QualificationRequirement.Builder)QualificationRequirement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQualificationRequirements(Collection<QualificationRequirement.BuilderImpl> qualificationRequirements) {
            this.qualificationRequirements = QualificationRequirementListCopier.copyFromBuilder(qualificationRequirements);
        }

        public final String getHitReviewStatus() {
            return this.hitReviewStatus;
        }

        @Override
        public final Builder hitReviewStatus(String hitReviewStatus) {
            this.hitReviewStatus = hitReviewStatus;
            return this;
        }

        @Override
        public final Builder hitReviewStatus(HITReviewStatus hitReviewStatus) {
            this.hitReviewStatus(hitReviewStatus == null ? null : hitReviewStatus.toString());
            return this;
        }

        public final void setHitReviewStatus(String hitReviewStatus) {
            this.hitReviewStatus = hitReviewStatus;
        }

        public final Integer getNumberOfAssignmentsPending() {
            return this.numberOfAssignmentsPending;
        }

        @Override
        public final Builder numberOfAssignmentsPending(Integer numberOfAssignmentsPending) {
            this.numberOfAssignmentsPending = numberOfAssignmentsPending;
            return this;
        }

        public final void setNumberOfAssignmentsPending(Integer numberOfAssignmentsPending) {
            this.numberOfAssignmentsPending = numberOfAssignmentsPending;
        }

        public final Integer getNumberOfAssignmentsAvailable() {
            return this.numberOfAssignmentsAvailable;
        }

        @Override
        public final Builder numberOfAssignmentsAvailable(Integer numberOfAssignmentsAvailable) {
            this.numberOfAssignmentsAvailable = numberOfAssignmentsAvailable;
            return this;
        }

        public final void setNumberOfAssignmentsAvailable(Integer numberOfAssignmentsAvailable) {
            this.numberOfAssignmentsAvailable = numberOfAssignmentsAvailable;
        }

        public final Integer getNumberOfAssignmentsCompleted() {
            return this.numberOfAssignmentsCompleted;
        }

        @Override
        public final Builder numberOfAssignmentsCompleted(Integer numberOfAssignmentsCompleted) {
            this.numberOfAssignmentsCompleted = numberOfAssignmentsCompleted;
            return this;
        }

        public final void setNumberOfAssignmentsCompleted(Integer numberOfAssignmentsCompleted) {
            this.numberOfAssignmentsCompleted = numberOfAssignmentsCompleted;
        }

        public HIT build() {
            return new HIT(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HIT> {
        public Builder hitId(String var1);

        public Builder hitTypeId(String var1);

        public Builder hitGroupId(String var1);

        public Builder hitLayoutId(String var1);

        public Builder creationTime(Instant var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder question(String var1);

        public Builder keywords(String var1);

        public Builder hitStatus(String var1);

        public Builder hitStatus(HITStatus var1);

        public Builder maxAssignments(Integer var1);

        public Builder reward(String var1);

        public Builder autoApprovalDelayInSeconds(Long var1);

        public Builder expiration(Instant var1);

        public Builder assignmentDurationInSeconds(Long var1);

        public Builder requesterAnnotation(String var1);

        public Builder qualificationRequirements(Collection<QualificationRequirement> var1);

        public Builder qualificationRequirements(QualificationRequirement ... var1);

        public Builder qualificationRequirements(Consumer<QualificationRequirement.Builder> ... var1);

        public Builder hitReviewStatus(String var1);

        public Builder hitReviewStatus(HITReviewStatus var1);

        public Builder numberOfAssignmentsPending(Integer var1);

        public Builder numberOfAssignmentsAvailable(Integer var1);

        public Builder numberOfAssignmentsCompleted(Integer var1);
    }
}

