/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQualificationScoreResponse extends MTurkResponse implements
        ToCopyableBuilder<GetQualificationScoreResponse.Builder, GetQualificationScoreResponse> {
    private static final SdkField<Qualification> QUALIFICATION_FIELD = SdkField.<Qualification> builder(MarshallingType.SDK_POJO)
            .memberName("Qualification").getter(getter(GetQualificationScoreResponse::qualification))
            .setter(setter(Builder::qualification)).constructor(Qualification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Qualification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUALIFICATION_FIELD));

    private final Qualification qualification;

    private GetQualificationScoreResponse(BuilderImpl builder) {
        super(builder);
        this.qualification = builder.qualification;
    }

    /**
     * <p>
     * The Qualification data structure of the Qualification assigned to a user, including the Qualification type and
     * the value (score).
     * </p>
     * 
     * @return The Qualification data structure of the Qualification assigned to a user, including the Qualification
     *         type and the value (score).
     */
    public Qualification qualification() {
        return qualification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(qualification());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQualificationScoreResponse)) {
            return false;
        }
        GetQualificationScoreResponse other = (GetQualificationScoreResponse) obj;
        return Objects.equals(qualification(), other.qualification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetQualificationScoreResponse").add("Qualification", qualification()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Qualification":
            return Optional.ofNullable(clazz.cast(qualification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQualificationScoreResponse, T> g) {
        return obj -> g.apply((GetQualificationScoreResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetQualificationScoreResponse> {
        /**
         * <p>
         * The Qualification data structure of the Qualification assigned to a user, including the Qualification type
         * and the value (score).
         * </p>
         * 
         * @param qualification
         *        The Qualification data structure of the Qualification assigned to a user, including the Qualification
         *        type and the value (score).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualification(Qualification qualification);

        /**
         * <p>
         * The Qualification data structure of the Qualification assigned to a user, including the Qualification type
         * and the value (score).
         * </p>
         * This is a convenience that creates an instance of the {@link Qualification.Builder} avoiding the need to
         * create one manually via {@link Qualification#builder()}.
         *
         * When the {@link Consumer} completes, {@link Qualification.Builder#build()} is called immediately and its
         * result is passed to {@link #qualification(Qualification)}.
         * 
         * @param qualification
         *        a consumer that will call methods on {@link Qualification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qualification(Qualification)
         */
        default Builder qualification(Consumer<Qualification.Builder> qualification) {
            return qualification(Qualification.builder().applyMutation(qualification).build());
        }
    }

    static final class BuilderImpl extends MTurkResponse.BuilderImpl implements Builder {
        private Qualification qualification;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQualificationScoreResponse model) {
            super(model);
            qualification(model.qualification);
        }

        public final Qualification.Builder getQualification() {
            return qualification != null ? qualification.toBuilder() : null;
        }

        @Override
        public final Builder qualification(Qualification qualification) {
            this.qualification = qualification;
            return this;
        }

        public final void setQualification(Qualification.BuilderImpl qualification) {
            this.qualification = qualification != null ? qualification.build() : null;
        }

        @Override
        public GetQualificationScoreResponse build() {
            return new GetQualificationScoreResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
