/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQualificationTypesResponse extends MTurkResponse implements
        ToCopyableBuilder<ListQualificationTypesResponse.Builder, ListQualificationTypesResponse> {
    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumResults").getter(getter(ListQualificationTypesResponse::numResults))
            .setter(setter(Builder::numResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListQualificationTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<QualificationType>> QUALIFICATION_TYPES_FIELD = SdkField
            .<List<QualificationType>> builder(MarshallingType.LIST)
            .memberName("QualificationTypes")
            .getter(getter(ListQualificationTypesResponse::qualificationTypes))
            .setter(setter(Builder::qualificationTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QualificationType> builder(MarshallingType.SDK_POJO)
                                            .constructor(QualificationType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, QUALIFICATION_TYPES_FIELD));

    private final Integer numResults;

    private final String nextToken;

    private final List<QualificationType> qualificationTypes;

    private ListQualificationTypesResponse(BuilderImpl builder) {
        super(builder);
        this.numResults = builder.numResults;
        this.nextToken = builder.nextToken;
        this.qualificationTypes = builder.qualificationTypes;
    }

    /**
     * <p>
     * The number of Qualification types on this page in the filtered results list, equivalent to the number of types
     * this operation returns.
     * </p>
     * 
     * @return The number of Qualification types on this page in the filtered results list, equivalent to the number of
     *         types this operation returns.
     */
    public Integer numResults() {
        return numResults;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the QualificationTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasQualificationTypes() {
        return qualificationTypes != null && !(qualificationTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of QualificationType elements returned by the query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQualificationTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of QualificationType elements returned by the query.
     */
    public List<QualificationType> qualificationTypes() {
        return qualificationTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(numResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasQualificationTypes() ? qualificationTypes() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQualificationTypesResponse)) {
            return false;
        }
        ListQualificationTypesResponse other = (ListQualificationTypesResponse) obj;
        return Objects.equals(numResults(), other.numResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasQualificationTypes() == other.hasQualificationTypes()
                && Objects.equals(qualificationTypes(), other.qualificationTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListQualificationTypesResponse").add("NumResults", numResults()).add("NextToken", nextToken())
                .add("QualificationTypes", hasQualificationTypes() ? qualificationTypes() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumResults":
            return Optional.ofNullable(clazz.cast(numResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "QualificationTypes":
            return Optional.ofNullable(clazz.cast(qualificationTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQualificationTypesResponse, T> g) {
        return obj -> g.apply((ListQualificationTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListQualificationTypesResponse> {
        /**
         * <p>
         * The number of Qualification types on this page in the filtered results list, equivalent to the number of
         * types this operation returns.
         * </p>
         * 
         * @param numResults
         *        The number of Qualification types on this page in the filtered results list, equivalent to the number
         *        of types this operation returns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numResults(Integer numResults);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of QualificationType elements returned by the query.
         * </p>
         * 
         * @param qualificationTypes
         *        The list of QualificationType elements returned by the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationTypes(Collection<QualificationType> qualificationTypes);

        /**
         * <p>
         * The list of QualificationType elements returned by the query.
         * </p>
         * 
         * @param qualificationTypes
         *        The list of QualificationType elements returned by the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationTypes(QualificationType... qualificationTypes);

        /**
         * <p>
         * The list of QualificationType elements returned by the query.
         * </p>
         * This is a convenience that creates an instance of the {@link List<QualificationType>.Builder} avoiding the
         * need to create one manually via {@link List<QualificationType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<QualificationType>.Builder#build()} is called immediately
         * and its result is passed to {@link #qualificationTypes(List<QualificationType>)}.
         * 
         * @param qualificationTypes
         *        a consumer that will call methods on {@link List<QualificationType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qualificationTypes(List<QualificationType>)
         */
        Builder qualificationTypes(Consumer<QualificationType.Builder>... qualificationTypes);
    }

    static final class BuilderImpl extends MTurkResponse.BuilderImpl implements Builder {
        private Integer numResults;

        private String nextToken;

        private List<QualificationType> qualificationTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListQualificationTypesResponse model) {
            super(model);
            numResults(model.numResults);
            nextToken(model.nextToken);
            qualificationTypes(model.qualificationTypes);
        }

        public final Integer getNumResults() {
            return numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<QualificationType.Builder> getQualificationTypes() {
            if (qualificationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return qualificationTypes != null ? qualificationTypes.stream().map(QualificationType::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder qualificationTypes(Collection<QualificationType> qualificationTypes) {
            this.qualificationTypes = QualificationTypeListCopier.copy(qualificationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationTypes(QualificationType... qualificationTypes) {
            qualificationTypes(Arrays.asList(qualificationTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationTypes(Consumer<QualificationType.Builder>... qualificationTypes) {
            qualificationTypes(Stream.of(qualificationTypes).map(c -> QualificationType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setQualificationTypes(Collection<QualificationType.BuilderImpl> qualificationTypes) {
            this.qualificationTypes = QualificationTypeListCopier.copyFromBuilder(qualificationTypes);
        }

        @Override
        public ListQualificationTypesResponse build() {
            return new ListQualificationTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
