/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssignmentResponse extends MTurkResponse implements
        ToCopyableBuilder<GetAssignmentResponse.Builder, GetAssignmentResponse> {
    private static final SdkField<Assignment> ASSIGNMENT_FIELD = SdkField.<Assignment> builder(MarshallingType.SDK_POJO)
            .memberName("Assignment").getter(getter(GetAssignmentResponse::assignment)).setter(setter(Builder::assignment))
            .constructor(Assignment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Assignment").build()).build();

    private static final SdkField<HIT> HIT_FIELD = SdkField.<HIT> builder(MarshallingType.SDK_POJO).memberName("HIT")
            .getter(getter(GetAssignmentResponse::hit)).setter(setter(Builder::hit)).constructor(HIT::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HIT").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGNMENT_FIELD, HIT_FIELD));

    private final Assignment assignment;

    private final HIT hit;

    private GetAssignmentResponse(BuilderImpl builder) {
        super(builder);
        this.assignment = builder.assignment;
        this.hit = builder.hit;
    }

    /**
     * <p>
     * The assignment. The response includes one Assignment element.
     * </p>
     * 
     * @return The assignment. The response includes one Assignment element.
     */
    public Assignment assignment() {
        return assignment;
    }

    /**
     * <p>
     * The HIT associated with this assignment. The response includes one HIT element.
     * </p>
     * 
     * @return The HIT associated with this assignment. The response includes one HIT element.
     */
    public HIT hit() {
        return hit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assignment());
        hashCode = 31 * hashCode + Objects.hashCode(hit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssignmentResponse)) {
            return false;
        }
        GetAssignmentResponse other = (GetAssignmentResponse) obj;
        return Objects.equals(assignment(), other.assignment()) && Objects.equals(hit(), other.hit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAssignmentResponse").add("Assignment", assignment()).add("HIT", hit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Assignment":
            return Optional.ofNullable(clazz.cast(assignment()));
        case "HIT":
            return Optional.ofNullable(clazz.cast(hit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssignmentResponse, T> g) {
        return obj -> g.apply((GetAssignmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAssignmentResponse> {
        /**
         * <p>
         * The assignment. The response includes one Assignment element.
         * </p>
         * 
         * @param assignment
         *        The assignment. The response includes one Assignment element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignment(Assignment assignment);

        /**
         * <p>
         * The assignment. The response includes one Assignment element.
         * </p>
         * This is a convenience that creates an instance of the {@link Assignment.Builder} avoiding the need to create
         * one manually via {@link Assignment#builder()}.
         *
         * When the {@link Consumer} completes, {@link Assignment.Builder#build()} is called immediately and its result
         * is passed to {@link #assignment(Assignment)}.
         * 
         * @param assignment
         *        a consumer that will call methods on {@link Assignment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assignment(Assignment)
         */
        default Builder assignment(Consumer<Assignment.Builder> assignment) {
            return assignment(Assignment.builder().applyMutation(assignment).build());
        }

        /**
         * <p>
         * The HIT associated with this assignment. The response includes one HIT element.
         * </p>
         * 
         * @param hit
         *        The HIT associated with this assignment. The response includes one HIT element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hit(HIT hit);

        /**
         * <p>
         * The HIT associated with this assignment. The response includes one HIT element.
         * </p>
         * This is a convenience that creates an instance of the {@link HIT.Builder} avoiding the need to create one
         * manually via {@link HIT#builder()}.
         *
         * When the {@link Consumer} completes, {@link HIT.Builder#build()} is called immediately and its result is
         * passed to {@link #hit(HIT)}.
         * 
         * @param hit
         *        a consumer that will call methods on {@link HIT.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hit(HIT)
         */
        default Builder hit(Consumer<HIT.Builder> hit) {
            return hit(HIT.builder().applyMutation(hit).build());
        }
    }

    static final class BuilderImpl extends MTurkResponse.BuilderImpl implements Builder {
        private Assignment assignment;

        private HIT hit;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssignmentResponse model) {
            super(model);
            assignment(model.assignment);
            hit(model.hit);
        }

        public final Assignment.Builder getAssignment() {
            return assignment != null ? assignment.toBuilder() : null;
        }

        @Override
        public final Builder assignment(Assignment assignment) {
            this.assignment = assignment;
            return this;
        }

        public final void setAssignment(Assignment.BuilderImpl assignment) {
            this.assignment = assignment != null ? assignment.build() : null;
        }

        public final HIT.Builder getHit() {
            return hit != null ? hit.toBuilder() : null;
        }

        @Override
        public final Builder hit(HIT hit) {
            this.hit = hit;
            return this;
        }

        public final void setHit(HIT.BuilderImpl hit) {
            this.hit = hit != null ? hit.build() : null;
        }

        @Override
        public GetAssignmentResponse build() {
            return new GetAssignmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
