/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.AssignmentStatus;
import software.amazon.awssdk.services.mturk.model.AssignmentStatusListCopier;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssignmentsForHitRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, ListAssignmentsForHitRequest> {
    private static final SdkField<String> HIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HITId").getter(ListAssignmentsForHitRequest.getter(ListAssignmentsForHitRequest::hitId)).setter(ListAssignmentsForHitRequest.setter(Builder::hitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAssignmentsForHitRequest.getter(ListAssignmentsForHitRequest::nextToken)).setter(ListAssignmentsForHitRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListAssignmentsForHitRequest.getter(ListAssignmentsForHitRequest::maxResults)).setter(ListAssignmentsForHitRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<List<String>> ASSIGNMENT_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssignmentStatuses").getter(ListAssignmentsForHitRequest.getter(ListAssignmentsForHitRequest::assignmentStatusesAsStrings)).setter(ListAssignmentsForHitRequest.setter(Builder::assignmentStatusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIT_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, ASSIGNMENT_STATUSES_FIELD));
    private final String hitId;
    private final String nextToken;
    private final Integer maxResults;
    private final List<String> assignmentStatuses;

    private ListAssignmentsForHitRequest(BuilderImpl builder) {
        super(builder);
        this.hitId = builder.hitId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.assignmentStatuses = builder.assignmentStatuses;
    }

    public String hitId() {
        return this.hitId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public List<AssignmentStatus> assignmentStatuses() {
        return AssignmentStatusListCopier.copyStringToEnum(this.assignmentStatuses);
    }

    public boolean hasAssignmentStatuses() {
        return this.assignmentStatuses != null && !(this.assignmentStatuses instanceof SdkAutoConstructList);
    }

    public List<String> assignmentStatusesAsStrings() {
        return this.assignmentStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentStatusesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssignmentsForHitRequest)) {
            return false;
        }
        ListAssignmentsForHitRequest other = (ListAssignmentsForHitRequest)((Object)obj);
        return Objects.equals(this.hitId(), other.hitId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.assignmentStatusesAsStrings(), other.assignmentStatusesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"ListAssignmentsForHitRequest").add("HITId", (Object)this.hitId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("AssignmentStatuses", this.assignmentStatusesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HITId": {
                return Optional.ofNullable(clazz.cast(this.hitId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "AssignmentStatuses": {
                return Optional.ofNullable(clazz.cast(this.assignmentStatusesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssignmentsForHitRequest, T> g) {
        return obj -> g.apply((ListAssignmentsForHitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String hitId;
        private String nextToken;
        private Integer maxResults;
        private List<String> assignmentStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssignmentsForHitRequest model) {
            super(model);
            this.hitId(model.hitId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.assignmentStatusesWithStrings(model.assignmentStatuses);
        }

        public final String getHitId() {
            return this.hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final void setHitId(String hitId) {
            this.hitId = hitId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<String> getAssignmentStatuses() {
            return this.assignmentStatuses;
        }

        @Override
        public final Builder assignmentStatusesWithStrings(Collection<String> assignmentStatuses) {
            this.assignmentStatuses = AssignmentStatusListCopier.copy(assignmentStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignmentStatusesWithStrings(String ... assignmentStatuses) {
            this.assignmentStatusesWithStrings(Arrays.asList(assignmentStatuses));
            return this;
        }

        @Override
        public final Builder assignmentStatuses(Collection<AssignmentStatus> assignmentStatuses) {
            this.assignmentStatuses = AssignmentStatusListCopier.copyEnumToString(assignmentStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignmentStatuses(AssignmentStatus ... assignmentStatuses) {
            this.assignmentStatuses(Arrays.asList(assignmentStatuses));
            return this;
        }

        public final void setAssignmentStatuses(Collection<String> assignmentStatuses) {
            this.assignmentStatuses = AssignmentStatusListCopier.copy(assignmentStatuses);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssignmentsForHitRequest build() {
            return new ListAssignmentsForHitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssignmentsForHitRequest> {
        public Builder hitId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder assignmentStatusesWithStrings(Collection<String> var1);

        public Builder assignmentStatusesWithStrings(String ... var1);

        public Builder assignmentStatuses(Collection<AssignmentStatus> var1);

        public Builder assignmentStatuses(AssignmentStatus ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

