/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssignmentsForHitRequest extends MTurkRequest implements
        ToCopyableBuilder<ListAssignmentsForHitRequest.Builder, ListAssignmentsForHitRequest> {
    private static final SdkField<String> HIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HITId")
            .getter(getter(ListAssignmentsForHitRequest::hitId)).setter(setter(Builder::hitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAssignmentsForHitRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListAssignmentsForHitRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<List<String>> ASSIGNMENT_STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssignmentStatuses")
            .getter(getter(ListAssignmentsForHitRequest::assignmentStatusesAsStrings))
            .setter(setter(Builder::assignmentStatusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIT_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, ASSIGNMENT_STATUSES_FIELD));

    private final String hitId;

    private final String nextToken;

    private final Integer maxResults;

    private final List<String> assignmentStatuses;

    private ListAssignmentsForHitRequest(BuilderImpl builder) {
        super(builder);
        this.hitId = builder.hitId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.assignmentStatuses = builder.assignmentStatuses;
    }

    /**
     * <p>
     * The ID of the HIT.
     * </p>
     * 
     * @return The ID of the HIT.
     */
    public final String hitId() {
        return hitId;
    }

    /**
     * <p>
     * Pagination token
     * </p>
     * 
     * @return Pagination token
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The status of the assignments to return: Submitted | Approved | Rejected
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssignmentStatuses} method.
     * </p>
     * 
     * @return The status of the assignments to return: Submitted | Approved | Rejected
     */
    public final List<AssignmentStatus> assignmentStatuses() {
        return AssignmentStatusListCopier.copyStringToEnum(assignmentStatuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the AssignmentStatuses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssignmentStatuses() {
        return assignmentStatuses != null && !(assignmentStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of the assignments to return: Submitted | Approved | Rejected
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssignmentStatuses} method.
     * </p>
     * 
     * @return The status of the assignments to return: Submitted | Approved | Rejected
     */
    public final List<String> assignmentStatusesAsStrings() {
        return assignmentStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hitId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssignmentStatuses() ? assignmentStatusesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssignmentsForHitRequest)) {
            return false;
        }
        ListAssignmentsForHitRequest other = (ListAssignmentsForHitRequest) obj;
        return Objects.equals(hitId(), other.hitId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && hasAssignmentStatuses() == other.hasAssignmentStatuses()
                && Objects.equals(assignmentStatusesAsStrings(), other.assignmentStatusesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssignmentsForHitRequest").add("HITId", hitId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults())
                .add("AssignmentStatuses", hasAssignmentStatuses() ? assignmentStatusesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HITId":
            return Optional.ofNullable(clazz.cast(hitId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "AssignmentStatuses":
            return Optional.ofNullable(clazz.cast(assignmentStatusesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssignmentsForHitRequest, T> g) {
        return obj -> g.apply((ListAssignmentsForHitRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAssignmentsForHitRequest> {
        /**
         * <p>
         * The ID of the HIT.
         * </p>
         * 
         * @param hitId
         *        The ID of the HIT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitId(String hitId);

        /**
         * <p>
         * Pagination token
         * </p>
         * 
         * @param nextToken
         *        Pagination token
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The status of the assignments to return: Submitted | Approved | Rejected
         * </p>
         * 
         * @param assignmentStatuses
         *        The status of the assignments to return: Submitted | Approved | Rejected
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentStatusesWithStrings(Collection<String> assignmentStatuses);

        /**
         * <p>
         * The status of the assignments to return: Submitted | Approved | Rejected
         * </p>
         * 
         * @param assignmentStatuses
         *        The status of the assignments to return: Submitted | Approved | Rejected
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentStatusesWithStrings(String... assignmentStatuses);

        /**
         * <p>
         * The status of the assignments to return: Submitted | Approved | Rejected
         * </p>
         * 
         * @param assignmentStatuses
         *        The status of the assignments to return: Submitted | Approved | Rejected
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentStatuses(Collection<AssignmentStatus> assignmentStatuses);

        /**
         * <p>
         * The status of the assignments to return: Submitted | Approved | Rejected
         * </p>
         * 
         * @param assignmentStatuses
         *        The status of the assignments to return: Submitted | Approved | Rejected
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentStatuses(AssignmentStatus... assignmentStatuses);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String hitId;

        private String nextToken;

        private Integer maxResults;

        private List<String> assignmentStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssignmentsForHitRequest model) {
            super(model);
            hitId(model.hitId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            assignmentStatusesWithStrings(model.assignmentStatuses);
        }

        public final String getHitId() {
            return hitId;
        }

        public final void setHitId(String hitId) {
            this.hitId = hitId;
        }

        @Override
        @Transient
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getAssignmentStatuses() {
            if (assignmentStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return assignmentStatuses;
        }

        public final void setAssignmentStatuses(Collection<String> assignmentStatuses) {
            this.assignmentStatuses = AssignmentStatusListCopier.copy(assignmentStatuses);
        }

        @Override
        @Transient
        public final Builder assignmentStatusesWithStrings(Collection<String> assignmentStatuses) {
            this.assignmentStatuses = AssignmentStatusListCopier.copy(assignmentStatuses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assignmentStatusesWithStrings(String... assignmentStatuses) {
            assignmentStatusesWithStrings(Arrays.asList(assignmentStatuses));
            return this;
        }

        @Override
        @Transient
        public final Builder assignmentStatuses(Collection<AssignmentStatus> assignmentStatuses) {
            this.assignmentStatuses = AssignmentStatusListCopier.copyEnumToString(assignmentStatuses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assignmentStatuses(AssignmentStatus... assignmentStatuses) {
            assignmentStatuses(Arrays.asList(assignmentStatuses));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssignmentsForHitRequest build() {
            return new ListAssignmentsForHitRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
