/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHiTsResponse extends MTurkResponse implements
        ToCopyableBuilder<ListHiTsResponse.Builder, ListHiTsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListHiTsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumResults").getter(getter(ListHiTsResponse::numResults)).setter(setter(Builder::numResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumResults").build()).build();

    private static final SdkField<List<HIT>> HI_TS_FIELD = SdkField
            .<List<HIT>> builder(MarshallingType.LIST)
            .memberName("HITs")
            .getter(getter(ListHiTsResponse::hiTs))
            .setter(setter(Builder::hiTs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HIT> builder(MarshallingType.SDK_POJO)
                                            .constructor(HIT::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            NUM_RESULTS_FIELD, HI_TS_FIELD));

    private final String nextToken;

    private final Integer numResults;

    private final List<HIT> hiTs;

    private ListHiTsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.numResults = builder.numResults;
        this.hiTs = builder.hiTs;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The number of HITs on this page in the filtered results list, equivalent to the number of HITs being returned by
     * this call.
     * </p>
     * 
     * @return The number of HITs on this page in the filtered results list, equivalent to the number of HITs being
     *         returned by this call.
     */
    public final Integer numResults() {
        return numResults;
    }

    /**
     * Returns true if the HITs property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasHiTs() {
        return hiTs != null && !(hiTs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of HIT elements returned by the query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHiTs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of HIT elements returned by the query.
     */
    public final List<HIT> hiTs() {
        return hiTs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(numResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasHiTs() ? hiTs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHiTsResponse)) {
            return false;
        }
        ListHiTsResponse other = (ListHiTsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(numResults(), other.numResults())
                && hasHiTs() == other.hasHiTs() && Objects.equals(hiTs(), other.hiTs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHiTsResponse").add("NextToken", nextToken()).add("NumResults", numResults())
                .add("HITs", hasHiTs() ? hiTs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "NumResults":
            return Optional.ofNullable(clazz.cast(numResults()));
        case "HITs":
            return Optional.ofNullable(clazz.cast(hiTs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHiTsResponse, T> g) {
        return obj -> g.apply((ListHiTsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListHiTsResponse> {
        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The number of HITs on this page in the filtered results list, equivalent to the number of HITs being returned
         * by this call.
         * </p>
         * 
         * @param numResults
         *        The number of HITs on this page in the filtered results list, equivalent to the number of HITs being
         *        returned by this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numResults(Integer numResults);

        /**
         * <p>
         * The list of HIT elements returned by the query.
         * </p>
         * 
         * @param hiTs
         *        The list of HIT elements returned by the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiTs(Collection<HIT> hiTs);

        /**
         * <p>
         * The list of HIT elements returned by the query.
         * </p>
         * 
         * @param hiTs
         *        The list of HIT elements returned by the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiTs(HIT... hiTs);

        /**
         * <p>
         * The list of HIT elements returned by the query.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HIT>.Builder} avoiding the need to create
         * one manually via {@link List<HIT>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HIT>.Builder#build()} is called immediately and its result
         * is passed to {@link #hiTs(List<HIT>)}.
         * 
         * @param hiTs
         *        a consumer that will call methods on {@link List<HIT>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hiTs(List<HIT>)
         */
        Builder hiTs(Consumer<HIT.Builder>... hiTs);
    }

    static final class BuilderImpl extends MTurkResponse.BuilderImpl implements Builder {
        private String nextToken;

        private Integer numResults;

        private List<HIT> hiTs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListHiTsResponse model) {
            super(model);
            nextToken(model.nextToken);
            numResults(model.numResults);
            hiTs(model.hiTs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getNumResults() {
            return numResults;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        @Override
        @Transient
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final List<HIT.Builder> getHiTs() {
            List<HIT.Builder> result = HITListCopier.copyToBuilder(this.hiTs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHiTs(Collection<HIT.BuilderImpl> hiTs) {
            this.hiTs = HITListCopier.copyFromBuilder(hiTs);
        }

        @Override
        @Transient
        public final Builder hiTs(Collection<HIT> hiTs) {
            this.hiTs = HITListCopier.copy(hiTs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder hiTs(HIT... hiTs) {
            hiTs(Arrays.asList(hiTs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder hiTs(Consumer<HIT.Builder>... hiTs) {
            hiTs(Stream.of(hiTs).map(c -> HIT.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListHiTsResponse build() {
            return new ListHiTsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
