/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains both ReviewResult and ReviewAction elements for a particular HIT.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReviewReport implements SdkPojo, Serializable, ToCopyableBuilder<ReviewReport.Builder, ReviewReport> {
    private static final SdkField<List<ReviewResultDetail>> REVIEW_RESULTS_FIELD = SdkField
            .<List<ReviewResultDetail>> builder(MarshallingType.LIST)
            .memberName("ReviewResults")
            .getter(getter(ReviewReport::reviewResults))
            .setter(setter(Builder::reviewResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReviewResultDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReviewResultDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ReviewActionDetail>> REVIEW_ACTIONS_FIELD = SdkField
            .<List<ReviewActionDetail>> builder(MarshallingType.LIST)
            .memberName("ReviewActions")
            .getter(getter(ReviewReport::reviewActions))
            .setter(setter(Builder::reviewActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReviewActionDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReviewActionDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVIEW_RESULTS_FIELD,
            REVIEW_ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ReviewResultDetail> reviewResults;

    private final List<ReviewActionDetail> reviewActions;

    private ReviewReport(BuilderImpl builder) {
        this.reviewResults = builder.reviewResults;
        this.reviewActions = builder.reviewActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReviewResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReviewResults() {
        return reviewResults != null && !(reviewResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ReviewResults objects for each action specified in the Review Policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReviewResults} method.
     * </p>
     * 
     * @return A list of ReviewResults objects for each action specified in the Review Policy.
     */
    public final List<ReviewResultDetail> reviewResults() {
        return reviewResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReviewActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReviewActions() {
        return reviewActions != null && !(reviewActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ReviewAction objects for each action specified in the Review Policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReviewActions} method.
     * </p>
     * 
     * @return A list of ReviewAction objects for each action specified in the Review Policy.
     */
    public final List<ReviewActionDetail> reviewActions() {
        return reviewActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasReviewResults() ? reviewResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReviewActions() ? reviewActions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewReport)) {
            return false;
        }
        ReviewReport other = (ReviewReport) obj;
        return hasReviewResults() == other.hasReviewResults() && Objects.equals(reviewResults(), other.reviewResults())
                && hasReviewActions() == other.hasReviewActions() && Objects.equals(reviewActions(), other.reviewActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReviewReport").add("ReviewResults", hasReviewResults() ? reviewResults() : null)
                .add("ReviewActions", hasReviewActions() ? reviewActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReviewResults":
            return Optional.ofNullable(clazz.cast(reviewResults()));
        case "ReviewActions":
            return Optional.ofNullable(clazz.cast(reviewActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReviewReport, T> g) {
        return obj -> g.apply((ReviewReport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReviewReport> {
        /**
         * <p>
         * A list of ReviewResults objects for each action specified in the Review Policy.
         * </p>
         * 
         * @param reviewResults
         *        A list of ReviewResults objects for each action specified in the Review Policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewResults(Collection<ReviewResultDetail> reviewResults);

        /**
         * <p>
         * A list of ReviewResults objects for each action specified in the Review Policy.
         * </p>
         * 
         * @param reviewResults
         *        A list of ReviewResults objects for each action specified in the Review Policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewResults(ReviewResultDetail... reviewResults);

        /**
         * <p>
         * A list of ReviewResults objects for each action specified in the Review Policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ReviewResultDetail>.Builder}
         * avoiding the need to create one manually via {@link List<ReviewResultDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReviewResultDetail>.Builder#build()} is called immediately
         * and its result is passed to {@link #reviewResults(List<ReviewResultDetail>)}.
         * 
         * @param reviewResults
         *        a consumer that will call methods on {@link List<ReviewResultDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reviewResults(List<ReviewResultDetail>)
         */
        Builder reviewResults(Consumer<ReviewResultDetail.Builder>... reviewResults);

        /**
         * <p>
         * A list of ReviewAction objects for each action specified in the Review Policy.
         * </p>
         * 
         * @param reviewActions
         *        A list of ReviewAction objects for each action specified in the Review Policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewActions(Collection<ReviewActionDetail> reviewActions);

        /**
         * <p>
         * A list of ReviewAction objects for each action specified in the Review Policy.
         * </p>
         * 
         * @param reviewActions
         *        A list of ReviewAction objects for each action specified in the Review Policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewActions(ReviewActionDetail... reviewActions);

        /**
         * <p>
         * A list of ReviewAction objects for each action specified in the Review Policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ReviewActionDetail>.Builder}
         * avoiding the need to create one manually via {@link List<ReviewActionDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReviewActionDetail>.Builder#build()} is called immediately
         * and its result is passed to {@link #reviewActions(List<ReviewActionDetail>)}.
         * 
         * @param reviewActions
         *        a consumer that will call methods on {@link List<ReviewActionDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reviewActions(List<ReviewActionDetail>)
         */
        Builder reviewActions(Consumer<ReviewActionDetail.Builder>... reviewActions);
    }

    static final class BuilderImpl implements Builder {
        private List<ReviewResultDetail> reviewResults = DefaultSdkAutoConstructList.getInstance();

        private List<ReviewActionDetail> reviewActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewReport model) {
            reviewResults(model.reviewResults);
            reviewActions(model.reviewActions);
        }

        public final List<ReviewResultDetail.Builder> getReviewResults() {
            List<ReviewResultDetail.Builder> result = ReviewResultDetailListCopier.copyToBuilder(this.reviewResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReviewResults(Collection<ReviewResultDetail.BuilderImpl> reviewResults) {
            this.reviewResults = ReviewResultDetailListCopier.copyFromBuilder(reviewResults);
        }

        @Override
        @Transient
        public final Builder reviewResults(Collection<ReviewResultDetail> reviewResults) {
            this.reviewResults = ReviewResultDetailListCopier.copy(reviewResults);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reviewResults(ReviewResultDetail... reviewResults) {
            reviewResults(Arrays.asList(reviewResults));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reviewResults(Consumer<ReviewResultDetail.Builder>... reviewResults) {
            reviewResults(Stream.of(reviewResults).map(c -> ReviewResultDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ReviewActionDetail.Builder> getReviewActions() {
            List<ReviewActionDetail.Builder> result = ReviewActionDetailListCopier.copyToBuilder(this.reviewActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReviewActions(Collection<ReviewActionDetail.BuilderImpl> reviewActions) {
            this.reviewActions = ReviewActionDetailListCopier.copyFromBuilder(reviewActions);
        }

        @Override
        @Transient
        public final Builder reviewActions(Collection<ReviewActionDetail> reviewActions) {
            this.reviewActions = ReviewActionDetailListCopier.copy(reviewActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reviewActions(ReviewActionDetail... reviewActions) {
            reviewActions(Arrays.asList(reviewActions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reviewActions(Consumer<ReviewActionDetail.Builder>... reviewActions) {
            reviewActions(Stream.of(reviewActions).map(c -> ReviewActionDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ReviewReport build() {
            return new ReviewReport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
