/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHitTypeRequest extends MTurkRequest implements
        ToCopyableBuilder<CreateHitTypeRequest.Builder, CreateHitTypeRequest> {
    private static final SdkField<Long> AUTO_APPROVAL_DELAY_IN_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AutoApprovalDelayInSeconds")
            .getter(getter(CreateHitTypeRequest::autoApprovalDelayInSeconds))
            .setter(setter(Builder::autoApprovalDelayInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoApprovalDelayInSeconds").build())
            .build();

    private static final SdkField<Long> ASSIGNMENT_DURATION_IN_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AssignmentDurationInSeconds")
            .getter(getter(CreateHitTypeRequest::assignmentDurationInSeconds))
            .setter(setter(Builder::assignmentDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentDurationInSeconds")
                    .build()).build();

    private static final SdkField<String> REWARD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reward")
            .getter(getter(CreateHitTypeRequest::reward)).setter(setter(Builder::reward))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reward").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(CreateHitTypeRequest::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> KEYWORDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Keywords").getter(getter(CreateHitTypeRequest::keywords)).setter(setter(Builder::keywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keywords").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateHitTypeRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<QualificationRequirement>> QUALIFICATION_REQUIREMENTS_FIELD = SdkField
            .<List<QualificationRequirement>> builder(MarshallingType.LIST)
            .memberName("QualificationRequirements")
            .getter(getter(CreateHitTypeRequest::qualificationRequirements))
            .setter(setter(Builder::qualificationRequirements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationRequirements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QualificationRequirement> builder(MarshallingType.SDK_POJO)
                                            .constructor(QualificationRequirement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTO_APPROVAL_DELAY_IN_SECONDS_FIELD, ASSIGNMENT_DURATION_IN_SECONDS_FIELD, REWARD_FIELD, TITLE_FIELD,
            KEYWORDS_FIELD, DESCRIPTION_FIELD, QUALIFICATION_REQUIREMENTS_FIELD));

    private final Long autoApprovalDelayInSeconds;

    private final Long assignmentDurationInSeconds;

    private final String reward;

    private final String title;

    private final String keywords;

    private final String description;

    private final List<QualificationRequirement> qualificationRequirements;

    private CreateHitTypeRequest(BuilderImpl builder) {
        super(builder);
        this.autoApprovalDelayInSeconds = builder.autoApprovalDelayInSeconds;
        this.assignmentDurationInSeconds = builder.assignmentDurationInSeconds;
        this.reward = builder.reward;
        this.title = builder.title;
        this.keywords = builder.keywords;
        this.description = builder.description;
        this.qualificationRequirements = builder.qualificationRequirements;
    }

    /**
     * <p>
     * The number of seconds after an assignment for the HIT has been submitted, after which the assignment is
     * considered Approved automatically unless the Requester explicitly rejects it.
     * </p>
     * 
     * @return The number of seconds after an assignment for the HIT has been submitted, after which the assignment is
     *         considered Approved automatically unless the Requester explicitly rejects it.
     */
    public final Long autoApprovalDelayInSeconds() {
        return autoApprovalDelayInSeconds;
    }

    /**
     * <p>
     * The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker does not
     * complete the assignment within the specified duration, the assignment is considered abandoned. If the HIT is
     * still active (that is, its lifetime has not elapsed), the assignment becomes available for other users to find
     * and accept.
     * </p>
     * 
     * @return The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker
     *         does not complete the assignment within the specified duration, the assignment is considered abandoned.
     *         If the HIT is still active (that is, its lifetime has not elapsed), the assignment becomes available for
     *         other users to find and accept.
     */
    public final Long assignmentDurationInSeconds() {
        return assignmentDurationInSeconds;
    }

    /**
     * <p>
     * The amount of money the Requester will pay a Worker for successfully completing the HIT.
     * </p>
     * 
     * @return The amount of money the Requester will pay a Worker for successfully completing the HIT.
     */
    public final String reward() {
        return reward;
    }

    /**
     * <p>
     * The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On the
     * Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is mentioned.
     * </p>
     * 
     * @return The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On
     *         the Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is
     *         mentioned.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * One or more words or phrases that describe the HIT, separated by commas. These words are used in searches to find
     * HITs.
     * </p>
     * 
     * @return One or more words or phrases that describe the HIT, separated by commas. These words are used in searches
     *         to find HITs.
     */
    public final String keywords() {
        return keywords;
    }

    /**
     * <p>
     * A general description of the HIT. A description includes detailed information about the kind of task the HIT
     * contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of search
     * results, and in the HIT and assignment screens. A good description gives the user enough information to evaluate
     * the HIT before accepting it.
     * </p>
     * 
     * @return A general description of the HIT. A description includes detailed information about the kind of task the
     *         HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of
     *         search results, and in the HIT and assignment screens. A good description gives the user enough
     *         information to evaluate the HIT before accepting it.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the QualificationRequirements property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasQualificationRequirements() {
        return qualificationRequirements != null && !(qualificationRequirements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and
     * ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT.
     * Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each
     * <code>QualificationRequirement</code> structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQualificationRequirements()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between
     *         zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the
     *         HIT. Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each
     *         <code>QualificationRequirement</code> structure.
     */
    public final List<QualificationRequirement> qualificationRequirements() {
        return qualificationRequirements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoApprovalDelayInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(reward());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(keywords());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasQualificationRequirements() ? qualificationRequirements() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHitTypeRequest)) {
            return false;
        }
        CreateHitTypeRequest other = (CreateHitTypeRequest) obj;
        return Objects.equals(autoApprovalDelayInSeconds(), other.autoApprovalDelayInSeconds())
                && Objects.equals(assignmentDurationInSeconds(), other.assignmentDurationInSeconds())
                && Objects.equals(reward(), other.reward()) && Objects.equals(title(), other.title())
                && Objects.equals(keywords(), other.keywords()) && Objects.equals(description(), other.description())
                && hasQualificationRequirements() == other.hasQualificationRequirements()
                && Objects.equals(qualificationRequirements(), other.qualificationRequirements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHitTypeRequest").add("AutoApprovalDelayInSeconds", autoApprovalDelayInSeconds())
                .add("AssignmentDurationInSeconds", assignmentDurationInSeconds()).add("Reward", reward()).add("Title", title())
                .add("Keywords", keywords()).add("Description", description())
                .add("QualificationRequirements", hasQualificationRequirements() ? qualificationRequirements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoApprovalDelayInSeconds":
            return Optional.ofNullable(clazz.cast(autoApprovalDelayInSeconds()));
        case "AssignmentDurationInSeconds":
            return Optional.ofNullable(clazz.cast(assignmentDurationInSeconds()));
        case "Reward":
            return Optional.ofNullable(clazz.cast(reward()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Keywords":
            return Optional.ofNullable(clazz.cast(keywords()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "QualificationRequirements":
            return Optional.ofNullable(clazz.cast(qualificationRequirements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHitTypeRequest, T> g) {
        return obj -> g.apply((CreateHitTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateHitTypeRequest> {
        /**
         * <p>
         * The number of seconds after an assignment for the HIT has been submitted, after which the assignment is
         * considered Approved automatically unless the Requester explicitly rejects it.
         * </p>
         * 
         * @param autoApprovalDelayInSeconds
         *        The number of seconds after an assignment for the HIT has been submitted, after which the assignment
         *        is considered Approved automatically unless the Requester explicitly rejects it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoApprovalDelayInSeconds(Long autoApprovalDelayInSeconds);

        /**
         * <p>
         * The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker does
         * not complete the assignment within the specified duration, the assignment is considered abandoned. If the HIT
         * is still active (that is, its lifetime has not elapsed), the assignment becomes available for other users to
         * find and accept.
         * </p>
         * 
         * @param assignmentDurationInSeconds
         *        The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker
         *        does not complete the assignment within the specified duration, the assignment is considered
         *        abandoned. If the HIT is still active (that is, its lifetime has not elapsed), the assignment becomes
         *        available for other users to find and accept.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentDurationInSeconds(Long assignmentDurationInSeconds);

        /**
         * <p>
         * The amount of money the Requester will pay a Worker for successfully completing the HIT.
         * </p>
         * 
         * @param reward
         *        The amount of money the Requester will pay a Worker for successfully completing the HIT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reward(String reward);

        /**
         * <p>
         * The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On the
         * Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is
         * mentioned.
         * </p>
         * 
         * @param title
         *        The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains.
         *        On the Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the
         *        HIT is mentioned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * One or more words or phrases that describe the HIT, separated by commas. These words are used in searches to
         * find HITs.
         * </p>
         * 
         * @param keywords
         *        One or more words or phrases that describe the HIT, separated by commas. These words are used in
         *        searches to find HITs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywords(String keywords);

        /**
         * <p>
         * A general description of the HIT. A description includes detailed information about the kind of task the HIT
         * contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of search
         * results, and in the HIT and assignment screens. A good description gives the user enough information to
         * evaluate the HIT before accepting it.
         * </p>
         * 
         * @param description
         *        A general description of the HIT. A description includes detailed information about the kind of task
         *        the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded
         *        view of search results, and in the HIT and assignment screens. A good description gives the user
         *        enough information to evaluate the HIT before accepting it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero
         * and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT.
         * Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each
         * <code>QualificationRequirement</code> structure.
         * </p>
         * 
         * @param qualificationRequirements
         *        Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between
         *        zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept
         *        the HIT. Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on
         *        each <code>QualificationRequirement</code> structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationRequirements(Collection<QualificationRequirement> qualificationRequirements);

        /**
         * <p>
         * Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero
         * and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT.
         * Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each
         * <code>QualificationRequirement</code> structure.
         * </p>
         * 
         * @param qualificationRequirements
         *        Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between
         *        zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept
         *        the HIT. Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on
         *        each <code>QualificationRequirement</code> structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationRequirements(QualificationRequirement... qualificationRequirements);

        /**
         * <p>
         * Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero
         * and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT.
         * Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each
         * <code>QualificationRequirement</code> structure.
         * </p>
         * This is a convenience that creates an instance of the {@link List<QualificationRequirement>.Builder} avoiding
         * the need to create one manually via {@link List<QualificationRequirement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<QualificationRequirement>.Builder#build()} is called
         * immediately and its result is passed to {@link #qualificationRequirements(List<QualificationRequirement>)}.
         * 
         * @param qualificationRequirements
         *        a consumer that will call methods on {@link List<QualificationRequirement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qualificationRequirements(List<QualificationRequirement>)
         */
        Builder qualificationRequirements(Consumer<QualificationRequirement.Builder>... qualificationRequirements);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private Long autoApprovalDelayInSeconds;

        private Long assignmentDurationInSeconds;

        private String reward;

        private String title;

        private String keywords;

        private String description;

        private List<QualificationRequirement> qualificationRequirements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHitTypeRequest model) {
            super(model);
            autoApprovalDelayInSeconds(model.autoApprovalDelayInSeconds);
            assignmentDurationInSeconds(model.assignmentDurationInSeconds);
            reward(model.reward);
            title(model.title);
            keywords(model.keywords);
            description(model.description);
            qualificationRequirements(model.qualificationRequirements);
        }

        public final Long getAutoApprovalDelayInSeconds() {
            return autoApprovalDelayInSeconds;
        }

        public final void setAutoApprovalDelayInSeconds(Long autoApprovalDelayInSeconds) {
            this.autoApprovalDelayInSeconds = autoApprovalDelayInSeconds;
        }

        @Override
        @Transient
        public final Builder autoApprovalDelayInSeconds(Long autoApprovalDelayInSeconds) {
            this.autoApprovalDelayInSeconds = autoApprovalDelayInSeconds;
            return this;
        }

        public final Long getAssignmentDurationInSeconds() {
            return assignmentDurationInSeconds;
        }

        public final void setAssignmentDurationInSeconds(Long assignmentDurationInSeconds) {
            this.assignmentDurationInSeconds = assignmentDurationInSeconds;
        }

        @Override
        @Transient
        public final Builder assignmentDurationInSeconds(Long assignmentDurationInSeconds) {
            this.assignmentDurationInSeconds = assignmentDurationInSeconds;
            return this;
        }

        public final String getReward() {
            return reward;
        }

        public final void setReward(String reward) {
            this.reward = reward;
        }

        @Override
        @Transient
        public final Builder reward(String reward) {
            this.reward = reward;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        @Transient
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getKeywords() {
            return keywords;
        }

        public final void setKeywords(String keywords) {
            this.keywords = keywords;
        }

        @Override
        @Transient
        public final Builder keywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<QualificationRequirement.Builder> getQualificationRequirements() {
            List<QualificationRequirement.Builder> result = QualificationRequirementListCopier
                    .copyToBuilder(this.qualificationRequirements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQualificationRequirements(Collection<QualificationRequirement.BuilderImpl> qualificationRequirements) {
            this.qualificationRequirements = QualificationRequirementListCopier.copyFromBuilder(qualificationRequirements);
        }

        @Override
        @Transient
        public final Builder qualificationRequirements(Collection<QualificationRequirement> qualificationRequirements) {
            this.qualificationRequirements = QualificationRequirementListCopier.copy(qualificationRequirements);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder qualificationRequirements(QualificationRequirement... qualificationRequirements) {
            qualificationRequirements(Arrays.asList(qualificationRequirements));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder qualificationRequirements(Consumer<QualificationRequirement.Builder>... qualificationRequirements) {
            qualificationRequirements(Stream.of(qualificationRequirements)
                    .map(c -> QualificationRequirement.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHitTypeRequest build() {
            return new CreateHitTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
