/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * HIT Review Policy data structures represent HIT review policies, which you specify when you create a HIT.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReviewPolicy implements SdkPojo, Serializable, ToCopyableBuilder<ReviewPolicy.Builder, ReviewPolicy> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(ReviewPolicy::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<List<PolicyParameter>> PARAMETERS_FIELD = SdkField
            .<List<PolicyParameter>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(ReviewPolicy::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD,
            PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyName;

    private final List<PolicyParameter> parameters;

    private ReviewPolicy(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * Name of a Review Policy: SimplePlurality/2011-09-01 or ScoreMyKnownAnswers/2011-09-01
     * </p>
     * 
     * @return Name of a Review Policy: SimplePlurality/2011-09-01 or ScoreMyKnownAnswers/2011-09-01
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Name of the parameter from the Review policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return Name of the parameter from the Review policy.
     */
    public final List<PolicyParameter> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewPolicy)) {
            return false;
        }
        ReviewPolicy other = (ReviewPolicy) obj;
        return Objects.equals(policyName(), other.policyName()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReviewPolicy").add("PolicyName", policyName())
                .add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReviewPolicy, T> g) {
        return obj -> g.apply((ReviewPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReviewPolicy> {
        /**
         * <p>
         * Name of a Review Policy: SimplePlurality/2011-09-01 or ScoreMyKnownAnswers/2011-09-01
         * </p>
         * 
         * @param policyName
         *        Name of a Review Policy: SimplePlurality/2011-09-01 or ScoreMyKnownAnswers/2011-09-01
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * Name of the parameter from the Review policy.
         * </p>
         * 
         * @param parameters
         *        Name of the parameter from the Review policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<PolicyParameter> parameters);

        /**
         * <p>
         * Name of the parameter from the Review policy.
         * </p>
         * 
         * @param parameters
         *        Name of the parameter from the Review policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(PolicyParameter... parameters);

        /**
         * <p>
         * Name of the parameter from the Review policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PolicyParameter>.Builder} avoiding
         * the need to create one manually via {@link List<PolicyParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyParameter>.Builder#build()} is called immediately and
         * its result is passed to {@link #parameters(List<PolicyParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link List<PolicyParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(List<PolicyParameter>)
         */
        Builder parameters(Consumer<PolicyParameter.Builder>... parameters);
    }

    static final class BuilderImpl implements Builder {
        private String policyName;

        private List<PolicyParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewPolicy model) {
            policyName(model.policyName);
            parameters(model.parameters);
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final List<PolicyParameter.Builder> getParameters() {
            List<PolicyParameter.Builder> result = PolicyParameterListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<PolicyParameter.BuilderImpl> parameters) {
            this.parameters = PolicyParameterListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<PolicyParameter> parameters) {
            this.parameters = PolicyParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(PolicyParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<PolicyParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> PolicyParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ReviewPolicy build() {
            return new ReviewPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
