/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateQualificationWithWorkerRequest extends MTurkRequest implements
        ToCopyableBuilder<AssociateQualificationWithWorkerRequest.Builder, AssociateQualificationWithWorkerRequest> {
    private static final SdkField<String> QUALIFICATION_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QualificationTypeId").getter(getter(AssociateQualificationWithWorkerRequest::qualificationTypeId))
            .setter(setter(Builder::qualificationTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationTypeId").build())
            .build();

    private static final SdkField<String> WORKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkerId").getter(getter(AssociateQualificationWithWorkerRequest::workerId))
            .setter(setter(Builder::workerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerId").build()).build();

    private static final SdkField<Integer> INTEGER_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IntegerValue").getter(getter(AssociateQualificationWithWorkerRequest::integerValue))
            .setter(setter(Builder::integerValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerValue").build()).build();

    private static final SdkField<Boolean> SEND_NOTIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SendNotification").getter(getter(AssociateQualificationWithWorkerRequest::sendNotification))
            .setter(setter(Builder::sendNotification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendNotification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUALIFICATION_TYPE_ID_FIELD,
            WORKER_ID_FIELD, INTEGER_VALUE_FIELD, SEND_NOTIFICATION_FIELD));

    private final String qualificationTypeId;

    private final String workerId;

    private final Integer integerValue;

    private final Boolean sendNotification;

    private AssociateQualificationWithWorkerRequest(BuilderImpl builder) {
        super(builder);
        this.qualificationTypeId = builder.qualificationTypeId;
        this.workerId = builder.workerId;
        this.integerValue = builder.integerValue;
        this.sendNotification = builder.sendNotification;
    }

    /**
     * <p>
     * The ID of the Qualification type to use for the assigned Qualification.
     * </p>
     * 
     * @return The ID of the Qualification type to use for the assigned Qualification.
     */
    public final String qualificationTypeId() {
        return qualificationTypeId;
    }

    /**
     * <p>
     * The ID of the Worker to whom the Qualification is being assigned. Worker IDs are included with submitted HIT
     * assignments and Qualification requests.
     * </p>
     * 
     * @return The ID of the Worker to whom the Qualification is being assigned. Worker IDs are included with submitted
     *         HIT assignments and Qualification requests.
     */
    public final String workerId() {
        return workerId;
    }

    /**
     * <p>
     * The value of the Qualification to assign.
     * </p>
     * 
     * @return The value of the Qualification to assign.
     */
    public final Integer integerValue() {
        return integerValue;
    }

    /**
     * <p>
     * Specifies whether to send a notification email message to the Worker saying that the qualification was assigned
     * to the Worker. Note: this is true by default.
     * </p>
     * 
     * @return Specifies whether to send a notification email message to the Worker saying that the qualification was
     *         assigned to the Worker. Note: this is true by default.
     */
    public final Boolean sendNotification() {
        return sendNotification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(qualificationTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(workerId());
        hashCode = 31 * hashCode + Objects.hashCode(integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(sendNotification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateQualificationWithWorkerRequest)) {
            return false;
        }
        AssociateQualificationWithWorkerRequest other = (AssociateQualificationWithWorkerRequest) obj;
        return Objects.equals(qualificationTypeId(), other.qualificationTypeId()) && Objects.equals(workerId(), other.workerId())
                && Objects.equals(integerValue(), other.integerValue())
                && Objects.equals(sendNotification(), other.sendNotification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateQualificationWithWorkerRequest").add("QualificationTypeId", qualificationTypeId())
                .add("WorkerId", workerId()).add("IntegerValue", integerValue()).add("SendNotification", sendNotification())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QualificationTypeId":
            return Optional.ofNullable(clazz.cast(qualificationTypeId()));
        case "WorkerId":
            return Optional.ofNullable(clazz.cast(workerId()));
        case "IntegerValue":
            return Optional.ofNullable(clazz.cast(integerValue()));
        case "SendNotification":
            return Optional.ofNullable(clazz.cast(sendNotification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateQualificationWithWorkerRequest, T> g) {
        return obj -> g.apply((AssociateQualificationWithWorkerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateQualificationWithWorkerRequest> {
        /**
         * <p>
         * The ID of the Qualification type to use for the assigned Qualification.
         * </p>
         * 
         * @param qualificationTypeId
         *        The ID of the Qualification type to use for the assigned Qualification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationTypeId(String qualificationTypeId);

        /**
         * <p>
         * The ID of the Worker to whom the Qualification is being assigned. Worker IDs are included with submitted HIT
         * assignments and Qualification requests.
         * </p>
         * 
         * @param workerId
         *        The ID of the Worker to whom the Qualification is being assigned. Worker IDs are included with
         *        submitted HIT assignments and Qualification requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerId(String workerId);

        /**
         * <p>
         * The value of the Qualification to assign.
         * </p>
         * 
         * @param integerValue
         *        The value of the Qualification to assign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerValue(Integer integerValue);

        /**
         * <p>
         * Specifies whether to send a notification email message to the Worker saying that the qualification was
         * assigned to the Worker. Note: this is true by default.
         * </p>
         * 
         * @param sendNotification
         *        Specifies whether to send a notification email message to the Worker saying that the qualification was
         *        assigned to the Worker. Note: this is true by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendNotification(Boolean sendNotification);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String qualificationTypeId;

        private String workerId;

        private Integer integerValue;

        private Boolean sendNotification;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateQualificationWithWorkerRequest model) {
            super(model);
            qualificationTypeId(model.qualificationTypeId);
            workerId(model.workerId);
            integerValue(model.integerValue);
            sendNotification(model.sendNotification);
        }

        public final String getQualificationTypeId() {
            return qualificationTypeId;
        }

        public final void setQualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
        }

        @Override
        @Transient
        public final Builder qualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
            return this;
        }

        public final String getWorkerId() {
            return workerId;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Override
        @Transient
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final Integer getIntegerValue() {
            return integerValue;
        }

        public final void setIntegerValue(Integer integerValue) {
            this.integerValue = integerValue;
        }

        @Override
        @Transient
        public final Builder integerValue(Integer integerValue) {
            this.integerValue = integerValue;
            return this;
        }

        public final Boolean getSendNotification() {
            return sendNotification;
        }

        public final void setSendNotification(Boolean sendNotification) {
            this.sendNotification = sendNotification;
        }

        @Override
        @Transient
        public final Builder sendNotification(Boolean sendNotification) {
            this.sendNotification = sendNotification;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateQualificationWithWorkerRequest build() {
            return new AssociateQualificationWithWorkerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
