/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mturk.DefaultMTurkAsyncClient;
import software.amazon.awssdk.services.mturk.DefaultMTurkBaseClientBuilder;
import software.amazon.awssdk.services.mturk.MTurkAsyncClient;
import software.amazon.awssdk.services.mturk.MTurkAsyncClientBuilder;
import software.amazon.awssdk.services.mturk.MTurkServiceClientConfiguration;
import software.amazon.awssdk.services.mturk.endpoints.MTurkEndpointProvider;

@SdkInternalApi
final class DefaultMTurkAsyncClientBuilder
extends DefaultMTurkBaseClientBuilder<MTurkAsyncClientBuilder, MTurkAsyncClient>
implements MTurkAsyncClientBuilder {
    DefaultMTurkAsyncClientBuilder() {
    }

    @Override
    public DefaultMTurkAsyncClientBuilder endpointProvider(MTurkEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MTurkAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMTurkAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        MTurkServiceClientConfiguration serviceClientConfiguration = MTurkServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultMTurkAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

