/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.services.mturk.model.QualificationTypeStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateQualificationTypeRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, CreateQualificationTypeRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateQualificationTypeRequest.getter(CreateQualificationTypeRequest::name)).setter(CreateQualificationTypeRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Keywords").getter(CreateQualificationTypeRequest.getter(CreateQualificationTypeRequest::keywords)).setter(CreateQualificationTypeRequest.setter(Builder::keywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keywords").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateQualificationTypeRequest.getter(CreateQualificationTypeRequest::description)).setter(CreateQualificationTypeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> QUALIFICATION_TYPE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QualificationTypeStatus").getter(CreateQualificationTypeRequest.getter(CreateQualificationTypeRequest::qualificationTypeStatusAsString)).setter(CreateQualificationTypeRequest.setter(Builder::qualificationTypeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationTypeStatus").build()}).build();
    private static final SdkField<Long> RETRY_DELAY_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RetryDelayInSeconds").getter(CreateQualificationTypeRequest.getter(CreateQualificationTypeRequest::retryDelayInSeconds)).setter(CreateQualificationTypeRequest.setter(Builder::retryDelayInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryDelayInSeconds").build()}).build();
    private static final SdkField<String> TEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Test").getter(CreateQualificationTypeRequest.getter(CreateQualificationTypeRequest::test)).setter(CreateQualificationTypeRequest.setter(Builder::test)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Test").build()}).build();
    private static final SdkField<String> ANSWER_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnswerKey").getter(CreateQualificationTypeRequest.getter(CreateQualificationTypeRequest::answerKey)).setter(CreateQualificationTypeRequest.setter(Builder::answerKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerKey").build()}).build();
    private static final SdkField<Long> TEST_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TestDurationInSeconds").getter(CreateQualificationTypeRequest.getter(CreateQualificationTypeRequest::testDurationInSeconds)).setter(CreateQualificationTypeRequest.setter(Builder::testDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestDurationInSeconds").build()}).build();
    private static final SdkField<Boolean> AUTO_GRANTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoGranted").getter(CreateQualificationTypeRequest.getter(CreateQualificationTypeRequest::autoGranted)).setter(CreateQualificationTypeRequest.setter(Builder::autoGranted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoGranted").build()}).build();
    private static final SdkField<Integer> AUTO_GRANTED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AutoGrantedValue").getter(CreateQualificationTypeRequest.getter(CreateQualificationTypeRequest::autoGrantedValue)).setter(CreateQualificationTypeRequest.setter(Builder::autoGrantedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoGrantedValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, KEYWORDS_FIELD, DESCRIPTION_FIELD, QUALIFICATION_TYPE_STATUS_FIELD, RETRY_DELAY_IN_SECONDS_FIELD, TEST_FIELD, ANSWER_KEY_FIELD, TEST_DURATION_IN_SECONDS_FIELD, AUTO_GRANTED_FIELD, AUTO_GRANTED_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Keywords", KEYWORDS_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("QualificationTypeStatus", QUALIFICATION_TYPE_STATUS_FIELD);
            this.put("RetryDelayInSeconds", RETRY_DELAY_IN_SECONDS_FIELD);
            this.put("Test", TEST_FIELD);
            this.put("AnswerKey", ANSWER_KEY_FIELD);
            this.put("TestDurationInSeconds", TEST_DURATION_IN_SECONDS_FIELD);
            this.put("AutoGranted", AUTO_GRANTED_FIELD);
            this.put("AutoGrantedValue", AUTO_GRANTED_VALUE_FIELD);
        }
    });
    private final String name;
    private final String keywords;
    private final String description;
    private final String qualificationTypeStatus;
    private final Long retryDelayInSeconds;
    private final String test;
    private final String answerKey;
    private final Long testDurationInSeconds;
    private final Boolean autoGranted;
    private final Integer autoGrantedValue;

    private CreateQualificationTypeRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.keywords = builder.keywords;
        this.description = builder.description;
        this.qualificationTypeStatus = builder.qualificationTypeStatus;
        this.retryDelayInSeconds = builder.retryDelayInSeconds;
        this.test = builder.test;
        this.answerKey = builder.answerKey;
        this.testDurationInSeconds = builder.testDurationInSeconds;
        this.autoGranted = builder.autoGranted;
        this.autoGrantedValue = builder.autoGrantedValue;
    }

    public final String name() {
        return this.name;
    }

    public final String keywords() {
        return this.keywords;
    }

    public final String description() {
        return this.description;
    }

    public final QualificationTypeStatus qualificationTypeStatus() {
        return QualificationTypeStatus.fromValue(this.qualificationTypeStatus);
    }

    public final String qualificationTypeStatusAsString() {
        return this.qualificationTypeStatus;
    }

    public final Long retryDelayInSeconds() {
        return this.retryDelayInSeconds;
    }

    public final String test() {
        return this.test;
    }

    public final String answerKey() {
        return this.answerKey;
    }

    public final Long testDurationInSeconds() {
        return this.testDurationInSeconds;
    }

    public final Boolean autoGranted() {
        return this.autoGranted;
    }

    public final Integer autoGrantedValue() {
        return this.autoGrantedValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.keywords());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualificationTypeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryDelayInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.test());
        hashCode = 31 * hashCode + Objects.hashCode(this.answerKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.testDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoGranted());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoGrantedValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQualificationTypeRequest)) {
            return false;
        }
        CreateQualificationTypeRequest other = (CreateQualificationTypeRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.keywords(), other.keywords()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.qualificationTypeStatusAsString(), other.qualificationTypeStatusAsString()) && Objects.equals(this.retryDelayInSeconds(), other.retryDelayInSeconds()) && Objects.equals(this.test(), other.test()) && Objects.equals(this.answerKey(), other.answerKey()) && Objects.equals(this.testDurationInSeconds(), other.testDurationInSeconds()) && Objects.equals(this.autoGranted(), other.autoGranted()) && Objects.equals(this.autoGrantedValue(), other.autoGrantedValue());
    }

    public final String toString() {
        return ToString.builder((String)"CreateQualificationTypeRequest").add("Name", (Object)this.name()).add("Keywords", (Object)this.keywords()).add("Description", (Object)this.description()).add("QualificationTypeStatus", (Object)this.qualificationTypeStatusAsString()).add("RetryDelayInSeconds", (Object)this.retryDelayInSeconds()).add("Test", (Object)this.test()).add("AnswerKey", (Object)this.answerKey()).add("TestDurationInSeconds", (Object)this.testDurationInSeconds()).add("AutoGranted", (Object)this.autoGranted()).add("AutoGrantedValue", (Object)this.autoGrantedValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Keywords": {
                return Optional.ofNullable(clazz.cast(this.keywords()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "QualificationTypeStatus": {
                return Optional.ofNullable(clazz.cast(this.qualificationTypeStatusAsString()));
            }
            case "RetryDelayInSeconds": {
                return Optional.ofNullable(clazz.cast(this.retryDelayInSeconds()));
            }
            case "Test": {
                return Optional.ofNullable(clazz.cast(this.test()));
            }
            case "AnswerKey": {
                return Optional.ofNullable(clazz.cast(this.answerKey()));
            }
            case "TestDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.testDurationInSeconds()));
            }
            case "AutoGranted": {
                return Optional.ofNullable(clazz.cast(this.autoGranted()));
            }
            case "AutoGrantedValue": {
                return Optional.ofNullable(clazz.cast(this.autoGrantedValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateQualificationTypeRequest, T> g) {
        return obj -> g.apply((CreateQualificationTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String name;
        private String keywords;
        private String description;
        private String qualificationTypeStatus;
        private Long retryDelayInSeconds;
        private String test;
        private String answerKey;
        private Long testDurationInSeconds;
        private Boolean autoGranted;
        private Integer autoGrantedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQualificationTypeRequest model) {
            super(model);
            this.name(model.name);
            this.keywords(model.keywords);
            this.description(model.description);
            this.qualificationTypeStatus(model.qualificationTypeStatus);
            this.retryDelayInSeconds(model.retryDelayInSeconds);
            this.test(model.test);
            this.answerKey(model.answerKey);
            this.testDurationInSeconds(model.testDurationInSeconds);
            this.autoGranted(model.autoGranted);
            this.autoGrantedValue(model.autoGrantedValue);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getKeywords() {
            return this.keywords;
        }

        public final void setKeywords(String keywords) {
            this.keywords = keywords;
        }

        @Override
        public final Builder keywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getQualificationTypeStatus() {
            return this.qualificationTypeStatus;
        }

        public final void setQualificationTypeStatus(String qualificationTypeStatus) {
            this.qualificationTypeStatus = qualificationTypeStatus;
        }

        @Override
        public final Builder qualificationTypeStatus(String qualificationTypeStatus) {
            this.qualificationTypeStatus = qualificationTypeStatus;
            return this;
        }

        @Override
        public final Builder qualificationTypeStatus(QualificationTypeStatus qualificationTypeStatus) {
            this.qualificationTypeStatus(qualificationTypeStatus == null ? null : qualificationTypeStatus.toString());
            return this;
        }

        public final Long getRetryDelayInSeconds() {
            return this.retryDelayInSeconds;
        }

        public final void setRetryDelayInSeconds(Long retryDelayInSeconds) {
            this.retryDelayInSeconds = retryDelayInSeconds;
        }

        @Override
        public final Builder retryDelayInSeconds(Long retryDelayInSeconds) {
            this.retryDelayInSeconds = retryDelayInSeconds;
            return this;
        }

        public final String getTest() {
            return this.test;
        }

        public final void setTest(String test) {
            this.test = test;
        }

        @Override
        public final Builder test(String test) {
            this.test = test;
            return this;
        }

        public final String getAnswerKey() {
            return this.answerKey;
        }

        public final void setAnswerKey(String answerKey) {
            this.answerKey = answerKey;
        }

        @Override
        public final Builder answerKey(String answerKey) {
            this.answerKey = answerKey;
            return this;
        }

        public final Long getTestDurationInSeconds() {
            return this.testDurationInSeconds;
        }

        public final void setTestDurationInSeconds(Long testDurationInSeconds) {
            this.testDurationInSeconds = testDurationInSeconds;
        }

        @Override
        public final Builder testDurationInSeconds(Long testDurationInSeconds) {
            this.testDurationInSeconds = testDurationInSeconds;
            return this;
        }

        public final Boolean getAutoGranted() {
            return this.autoGranted;
        }

        public final void setAutoGranted(Boolean autoGranted) {
            this.autoGranted = autoGranted;
        }

        @Override
        public final Builder autoGranted(Boolean autoGranted) {
            this.autoGranted = autoGranted;
            return this;
        }

        public final Integer getAutoGrantedValue() {
            return this.autoGrantedValue;
        }

        public final void setAutoGrantedValue(Integer autoGrantedValue) {
            this.autoGrantedValue = autoGrantedValue;
        }

        @Override
        public final Builder autoGrantedValue(Integer autoGrantedValue) {
            this.autoGrantedValue = autoGrantedValue;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQualificationTypeRequest build() {
            return new CreateQualificationTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateQualificationTypeRequest> {
        public Builder name(String var1);

        public Builder keywords(String var1);

        public Builder description(String var1);

        public Builder qualificationTypeStatus(String var1);

        public Builder qualificationTypeStatus(QualificationTypeStatus var1);

        public Builder retryDelayInSeconds(Long var1);

        public Builder test(String var1);

        public Builder answerKey(String var1);

        public Builder testDurationInSeconds(Long var1);

        public Builder autoGranted(Boolean var1);

        public Builder autoGrantedValue(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

