/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQualificationTypesRequest extends MTurkRequest implements
        ToCopyableBuilder<ListQualificationTypesRequest.Builder, ListQualificationTypesRequest> {
    private static final SdkField<String> QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListQualificationTypesRequest::query)).setter(setter(Builder::query))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Query").build()).build();

    private static final SdkField<Boolean> MUST_BE_REQUESTABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ListQualificationTypesRequest::mustBeRequestable)).setter(setter(Builder::mustBeRequestable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MustBeRequestable").build()).build();

    private static final SdkField<Boolean> MUST_BE_OWNED_BY_CALLER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ListQualificationTypesRequest::mustBeOwnedByCaller)).setter(setter(Builder::mustBeOwnedByCaller))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MustBeOwnedByCaller").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListQualificationTypesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListQualificationTypesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_FIELD,
            MUST_BE_REQUESTABLE_FIELD, MUST_BE_OWNED_BY_CALLER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String query;

    private final Boolean mustBeRequestable;

    private final Boolean mustBeOwnedByCaller;

    private final String nextToken;

    private final Integer maxResults;

    private ListQualificationTypesRequest(BuilderImpl builder) {
        super(builder);
        this.query = builder.query;
        this.mustBeRequestable = builder.mustBeRequestable;
        this.mustBeOwnedByCaller = builder.mustBeOwnedByCaller;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * A text query against all of the searchable attributes of Qualification types.
     * </p>
     * 
     * @return A text query against all of the searchable attributes of Qualification types.
     */
    public String query() {
        return query;
    }

    /**
     * <p>
     * Specifies that only Qualification types that a user can request through the Amazon Mechanical Turk web site, such
     * as by taking a Qualification test, are returned as results of the search. Some Qualification types, such as those
     * assigned automatically by the system, cannot be requested directly by users. If false, all Qualification types,
     * including those managed by the system, are considered. Valid values are True | False.
     * </p>
     * 
     * @return Specifies that only Qualification types that a user can request through the Amazon Mechanical Turk web
     *         site, such as by taking a Qualification test, are returned as results of the search. Some Qualification
     *         types, such as those assigned automatically by the system, cannot be requested directly by users. If
     *         false, all Qualification types, including those managed by the system, are considered. Valid values are
     *         True | False.
     */
    public Boolean mustBeRequestable() {
        return mustBeRequestable;
    }

    /**
     * <p>
     * Specifies that only Qualification types that the Requester created are returned. If false, the operation returns
     * all Qualification types.
     * </p>
     * 
     * @return Specifies that only Qualification types that the Requester created are returned. If false, the operation
     *         returns all Qualification types.
     */
    public Boolean mustBeOwnedByCaller() {
        return mustBeOwnedByCaller;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call.
     * </p>
     * 
     * @return The maximum number of results to return in a single call.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(query());
        hashCode = 31 * hashCode + Objects.hashCode(mustBeRequestable());
        hashCode = 31 * hashCode + Objects.hashCode(mustBeOwnedByCaller());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQualificationTypesRequest)) {
            return false;
        }
        ListQualificationTypesRequest other = (ListQualificationTypesRequest) obj;
        return Objects.equals(query(), other.query()) && Objects.equals(mustBeRequestable(), other.mustBeRequestable())
                && Objects.equals(mustBeOwnedByCaller(), other.mustBeOwnedByCaller())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        return ToString.builder("ListQualificationTypesRequest").add("Query", query())
                .add("MustBeRequestable", mustBeRequestable()).add("MustBeOwnedByCaller", mustBeOwnedByCaller())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Query":
            return Optional.ofNullable(clazz.cast(query()));
        case "MustBeRequestable":
            return Optional.ofNullable(clazz.cast(mustBeRequestable()));
        case "MustBeOwnedByCaller":
            return Optional.ofNullable(clazz.cast(mustBeOwnedByCaller()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQualificationTypesRequest, T> g) {
        return obj -> g.apply((ListQualificationTypesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListQualificationTypesRequest> {
        /**
         * <p>
         * A text query against all of the searchable attributes of Qualification types.
         * </p>
         * 
         * @param query
         *        A text query against all of the searchable attributes of Qualification types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder query(String query);

        /**
         * <p>
         * Specifies that only Qualification types that a user can request through the Amazon Mechanical Turk web site,
         * such as by taking a Qualification test, are returned as results of the search. Some Qualification types, such
         * as those assigned automatically by the system, cannot be requested directly by users. If false, all
         * Qualification types, including those managed by the system, are considered. Valid values are True | False.
         * </p>
         * 
         * @param mustBeRequestable
         *        Specifies that only Qualification types that a user can request through the Amazon Mechanical Turk web
         *        site, such as by taking a Qualification test, are returned as results of the search. Some
         *        Qualification types, such as those assigned automatically by the system, cannot be requested directly
         *        by users. If false, all Qualification types, including those managed by the system, are considered.
         *        Valid values are True | False.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mustBeRequestable(Boolean mustBeRequestable);

        /**
         * <p>
         * Specifies that only Qualification types that the Requester created are returned. If false, the operation
         * returns all Qualification types.
         * </p>
         * 
         * @param mustBeOwnedByCaller
         *        Specifies that only Qualification types that the Requester created are returned. If false, the
         *        operation returns all Qualification types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mustBeOwnedByCaller(Boolean mustBeOwnedByCaller);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String query;

        private Boolean mustBeRequestable;

        private Boolean mustBeOwnedByCaller;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQualificationTypesRequest model) {
            super(model);
            query(model.query);
            mustBeRequestable(model.mustBeRequestable);
            mustBeOwnedByCaller(model.mustBeOwnedByCaller);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getQuery() {
            return query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        public final Boolean getMustBeRequestable() {
            return mustBeRequestable;
        }

        @Override
        public final Builder mustBeRequestable(Boolean mustBeRequestable) {
            this.mustBeRequestable = mustBeRequestable;
            return this;
        }

        public final void setMustBeRequestable(Boolean mustBeRequestable) {
            this.mustBeRequestable = mustBeRequestable;
        }

        public final Boolean getMustBeOwnedByCaller() {
            return mustBeOwnedByCaller;
        }

        @Override
        public final Builder mustBeOwnedByCaller(Boolean mustBeOwnedByCaller) {
            this.mustBeOwnedByCaller = mustBeOwnedByCaller;
            return this;
        }

        public final void setMustBeOwnedByCaller(Boolean mustBeOwnedByCaller) {
            this.mustBeOwnedByCaller = mustBeOwnedByCaller;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListQualificationTypesRequest build() {
            return new ListQualificationTypesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
