/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data structure is returned multiple times for each result specified in the Review Policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReviewResultDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ReviewResultDetail.Builder, ReviewResultDetail> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReviewResultDetail::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()).build();

    private static final SdkField<String> SUBJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReviewResultDetail::subjectId)).setter(setter(Builder::subjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectId").build()).build();

    private static final SdkField<String> SUBJECT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReviewResultDetail::subjectType)).setter(setter(Builder::subjectType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectType").build()).build();

    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReviewResultDetail::questionId)).setter(setter(Builder::questionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReviewResultDetail::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReviewResultDetail::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD,
            SUBJECT_ID_FIELD, SUBJECT_TYPE_FIELD, QUESTION_ID_FIELD, KEY_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionId;

    private final String subjectId;

    private final String subjectType;

    private final String questionId;

    private final String key;

    private final String value;

    private ReviewResultDetail(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.subjectId = builder.subjectId;
        this.subjectType = builder.subjectType;
        this.questionId = builder.questionId;
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * A unique identifier of the Review action result.
     * </p>
     * 
     * @return A unique identifier of the Review action result.
     */
    public String actionId() {
        return actionId;
    }

    /**
     * <p>
     * The HITID or AssignmentId about which this result was taken. Note that HIT-level Review Policies will often emit
     * results about both the HIT itself and its Assignments, while Assignment-level review policies generally only emit
     * results about the Assignment itself.
     * </p>
     * 
     * @return The HITID or AssignmentId about which this result was taken. Note that HIT-level Review Policies will
     *         often emit results about both the HIT itself and its Assignments, while Assignment-level review policies
     *         generally only emit results about the Assignment itself.
     */
    public String subjectId() {
        return subjectId;
    }

    /**
     * <p>
     * The type of the object from the SubjectId field.
     * </p>
     * 
     * @return The type of the object from the SubjectId field.
     */
    public String subjectType() {
        return subjectType;
    }

    /**
     * <p>
     * Specifies the QuestionId the result is describing. Depending on whether the TargetType is a HIT or Assignment
     * this results could specify multiple values. If TargetType is HIT and QuestionId is absent, then the result
     * describes results of the HIT, including the HIT agreement score. If ObjectType is Assignment and QuestionId is
     * absent, then the result describes the Worker's performance on the HIT.
     * </p>
     * 
     * @return Specifies the QuestionId the result is describing. Depending on whether the TargetType is a HIT or
     *         Assignment this results could specify multiple values. If TargetType is HIT and QuestionId is absent,
     *         then the result describes results of the HIT, including the HIT agreement score. If ObjectType is
     *         Assignment and QuestionId is absent, then the result describes the Worker's performance on the HIT.
     */
    public String questionId() {
        return questionId;
    }

    /**
     * <p>
     * Key identifies the particular piece of reviewed information.
     * </p>
     * 
     * @return Key identifies the particular piece of reviewed information.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The values of Key provided by the review policies you have selected.
     * </p>
     * 
     * @return The values of Key provided by the review policies you have selected.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(subjectId());
        hashCode = 31 * hashCode + Objects.hashCode(subjectType());
        hashCode = 31 * hashCode + Objects.hashCode(questionId());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewResultDetail)) {
            return false;
        }
        ReviewResultDetail other = (ReviewResultDetail) obj;
        return Objects.equals(actionId(), other.actionId()) && Objects.equals(subjectId(), other.subjectId())
                && Objects.equals(subjectType(), other.subjectType()) && Objects.equals(questionId(), other.questionId())
                && Objects.equals(key(), other.key()) && Objects.equals(value(), other.value());
    }

    @Override
    public String toString() {
        return ToString.builder("ReviewResultDetail").add("ActionId", actionId()).add("SubjectId", subjectId())
                .add("SubjectType", subjectType()).add("QuestionId", questionId()).add("Key", key()).add("Value", value())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "SubjectId":
            return Optional.ofNullable(clazz.cast(subjectId()));
        case "SubjectType":
            return Optional.ofNullable(clazz.cast(subjectType()));
        case "QuestionId":
            return Optional.ofNullable(clazz.cast(questionId()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReviewResultDetail, T> g) {
        return obj -> g.apply((ReviewResultDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReviewResultDetail> {
        /**
         * <p>
         * A unique identifier of the Review action result.
         * </p>
         * 
         * @param actionId
         *        A unique identifier of the Review action result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * <p>
         * The HITID or AssignmentId about which this result was taken. Note that HIT-level Review Policies will often
         * emit results about both the HIT itself and its Assignments, while Assignment-level review policies generally
         * only emit results about the Assignment itself.
         * </p>
         * 
         * @param subjectId
         *        The HITID or AssignmentId about which this result was taken. Note that HIT-level Review Policies will
         *        often emit results about both the HIT itself and its Assignments, while Assignment-level review
         *        policies generally only emit results about the Assignment itself.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectId(String subjectId);

        /**
         * <p>
         * The type of the object from the SubjectId field.
         * </p>
         * 
         * @param subjectType
         *        The type of the object from the SubjectId field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectType(String subjectType);

        /**
         * <p>
         * Specifies the QuestionId the result is describing. Depending on whether the TargetType is a HIT or Assignment
         * this results could specify multiple values. If TargetType is HIT and QuestionId is absent, then the result
         * describes results of the HIT, including the HIT agreement score. If ObjectType is Assignment and QuestionId
         * is absent, then the result describes the Worker's performance on the HIT.
         * </p>
         * 
         * @param questionId
         *        Specifies the QuestionId the result is describing. Depending on whether the TargetType is a HIT or
         *        Assignment this results could specify multiple values. If TargetType is HIT and QuestionId is absent,
         *        then the result describes results of the HIT, including the HIT agreement score. If ObjectType is
         *        Assignment and QuestionId is absent, then the result describes the Worker's performance on the HIT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionId(String questionId);

        /**
         * <p>
         * Key identifies the particular piece of reviewed information.
         * </p>
         * 
         * @param key
         *        Key identifies the particular piece of reviewed information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The values of Key provided by the review policies you have selected.
         * </p>
         * 
         * @param value
         *        The values of Key provided by the review policies you have selected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String actionId;

        private String subjectId;

        private String subjectType;

        private String questionId;

        private String key;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewResultDetail model) {
            actionId(model.actionId);
            subjectId(model.subjectId);
            subjectType(model.subjectType);
            questionId(model.questionId);
            key(model.key);
            value(model.value);
        }

        public final String getActionId() {
            return actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getSubjectId() {
            return subjectId;
        }

        @Override
        public final Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        public final void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }

        public final String getSubjectType() {
            return subjectType;
        }

        @Override
        public final Builder subjectType(String subjectType) {
            this.subjectType = subjectType;
            return this;
        }

        public final void setSubjectType(String subjectType) {
            this.subjectType = subjectType;
        }

        public final String getQuestionId() {
            return questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public ReviewResultDetail build() {
            return new ReviewResultDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
