/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReviewPolicyResultsForHitResponse extends MTurkResponse implements
        ToCopyableBuilder<ListReviewPolicyResultsForHitResponse.Builder, ListReviewPolicyResultsForHitResponse> {
    private static final SdkField<String> HIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListReviewPolicyResultsForHitResponse::hitId)).setter(setter(Builder::hitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITId").build()).build();

    private static final SdkField<ReviewPolicy> ASSIGNMENT_REVIEW_POLICY_FIELD = SdkField
            .<ReviewPolicy> builder(MarshallingType.SDK_POJO)
            .getter(getter(ListReviewPolicyResultsForHitResponse::assignmentReviewPolicy))
            .setter(setter(Builder::assignmentReviewPolicy)).constructor(ReviewPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentReviewPolicy").build())
            .build();

    private static final SdkField<ReviewPolicy> HIT_REVIEW_POLICY_FIELD = SdkField
            .<ReviewPolicy> builder(MarshallingType.SDK_POJO)
            .getter(getter(ListReviewPolicyResultsForHitResponse::hitReviewPolicy)).setter(setter(Builder::hitReviewPolicy))
            .constructor(ReviewPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITReviewPolicy").build()).build();

    private static final SdkField<ReviewReport> ASSIGNMENT_REVIEW_REPORT_FIELD = SdkField
            .<ReviewReport> builder(MarshallingType.SDK_POJO)
            .getter(getter(ListReviewPolicyResultsForHitResponse::assignmentReviewReport))
            .setter(setter(Builder::assignmentReviewReport)).constructor(ReviewReport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentReviewReport").build())
            .build();

    private static final SdkField<ReviewReport> HIT_REVIEW_REPORT_FIELD = SdkField
            .<ReviewReport> builder(MarshallingType.SDK_POJO)
            .getter(getter(ListReviewPolicyResultsForHitResponse::hitReviewReport)).setter(setter(Builder::hitReviewReport))
            .constructor(ReviewReport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITReviewReport").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListReviewPolicyResultsForHitResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIT_ID_FIELD,
            ASSIGNMENT_REVIEW_POLICY_FIELD, HIT_REVIEW_POLICY_FIELD, ASSIGNMENT_REVIEW_REPORT_FIELD, HIT_REVIEW_REPORT_FIELD,
            NEXT_TOKEN_FIELD));

    private final String hitId;

    private final ReviewPolicy assignmentReviewPolicy;

    private final ReviewPolicy hitReviewPolicy;

    private final ReviewReport assignmentReviewReport;

    private final ReviewReport hitReviewReport;

    private final String nextToken;

    private ListReviewPolicyResultsForHitResponse(BuilderImpl builder) {
        super(builder);
        this.hitId = builder.hitId;
        this.assignmentReviewPolicy = builder.assignmentReviewPolicy;
        this.hitReviewPolicy = builder.hitReviewPolicy;
        this.assignmentReviewReport = builder.assignmentReviewReport;
        this.hitReviewReport = builder.hitReviewReport;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The HITId of the HIT for which results have been returned.
     * </p>
     * 
     * @return The HITId of the HIT for which results have been returned.
     */
    public String hitId() {
        return hitId;
    }

    /**
     * <p>
     * The name of the Assignment-level Review Policy. This contains only the PolicyName element.
     * </p>
     * 
     * @return The name of the Assignment-level Review Policy. This contains only the PolicyName element.
     */
    public ReviewPolicy assignmentReviewPolicy() {
        return assignmentReviewPolicy;
    }

    /**
     * <p>
     * The name of the HIT-level Review Policy. This contains only the PolicyName element.
     * </p>
     * 
     * @return The name of the HIT-level Review Policy. This contains only the PolicyName element.
     */
    public ReviewPolicy hitReviewPolicy() {
        return hitReviewPolicy;
    }

    /**
     * <p>
     * Contains both ReviewResult and ReviewAction elements for an Assignment.
     * </p>
     * 
     * @return Contains both ReviewResult and ReviewAction elements for an Assignment.
     */
    public ReviewReport assignmentReviewReport() {
        return assignmentReviewReport;
    }

    /**
     * <p>
     * Contains both ReviewResult and ReviewAction elements for a particular HIT.
     * </p>
     * 
     * @return Contains both ReviewResult and ReviewAction elements for a particular HIT.
     */
    public ReviewReport hitReviewReport() {
        return hitReviewReport;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hitId());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentReviewPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hitReviewPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentReviewReport());
        hashCode = 31 * hashCode + Objects.hashCode(hitReviewReport());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReviewPolicyResultsForHitResponse)) {
            return false;
        }
        ListReviewPolicyResultsForHitResponse other = (ListReviewPolicyResultsForHitResponse) obj;
        return Objects.equals(hitId(), other.hitId()) && Objects.equals(assignmentReviewPolicy(), other.assignmentReviewPolicy())
                && Objects.equals(hitReviewPolicy(), other.hitReviewPolicy())
                && Objects.equals(assignmentReviewReport(), other.assignmentReviewReport())
                && Objects.equals(hitReviewReport(), other.hitReviewReport()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListReviewPolicyResultsForHitResponse").add("HITId", hitId())
                .add("AssignmentReviewPolicy", assignmentReviewPolicy()).add("HITReviewPolicy", hitReviewPolicy())
                .add("AssignmentReviewReport", assignmentReviewReport()).add("HITReviewReport", hitReviewReport())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HITId":
            return Optional.ofNullable(clazz.cast(hitId()));
        case "AssignmentReviewPolicy":
            return Optional.ofNullable(clazz.cast(assignmentReviewPolicy()));
        case "HITReviewPolicy":
            return Optional.ofNullable(clazz.cast(hitReviewPolicy()));
        case "AssignmentReviewReport":
            return Optional.ofNullable(clazz.cast(assignmentReviewReport()));
        case "HITReviewReport":
            return Optional.ofNullable(clazz.cast(hitReviewReport()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReviewPolicyResultsForHitResponse, T> g) {
        return obj -> g.apply((ListReviewPolicyResultsForHitResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListReviewPolicyResultsForHitResponse> {
        /**
         * <p>
         * The HITId of the HIT for which results have been returned.
         * </p>
         * 
         * @param hitId
         *        The HITId of the HIT for which results have been returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitId(String hitId);

        /**
         * <p>
         * The name of the Assignment-level Review Policy. This contains only the PolicyName element.
         * </p>
         * 
         * @param assignmentReviewPolicy
         *        The name of the Assignment-level Review Policy. This contains only the PolicyName element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentReviewPolicy(ReviewPolicy assignmentReviewPolicy);

        /**
         * <p>
         * The name of the Assignment-level Review Policy. This contains only the PolicyName element.
         * </p>
         * This is a convenience that creates an instance of the {@link ReviewPolicy.Builder} avoiding the need to
         * create one manually via {@link ReviewPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReviewPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #assignmentReviewPolicy(ReviewPolicy)}.
         * 
         * @param assignmentReviewPolicy
         *        a consumer that will call methods on {@link ReviewPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assignmentReviewPolicy(ReviewPolicy)
         */
        default Builder assignmentReviewPolicy(Consumer<ReviewPolicy.Builder> assignmentReviewPolicy) {
            return assignmentReviewPolicy(ReviewPolicy.builder().applyMutation(assignmentReviewPolicy).build());
        }

        /**
         * <p>
         * The name of the HIT-level Review Policy. This contains only the PolicyName element.
         * </p>
         * 
         * @param hitReviewPolicy
         *        The name of the HIT-level Review Policy. This contains only the PolicyName element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitReviewPolicy(ReviewPolicy hitReviewPolicy);

        /**
         * <p>
         * The name of the HIT-level Review Policy. This contains only the PolicyName element.
         * </p>
         * This is a convenience that creates an instance of the {@link ReviewPolicy.Builder} avoiding the need to
         * create one manually via {@link ReviewPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReviewPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #hitReviewPolicy(ReviewPolicy)}.
         * 
         * @param hitReviewPolicy
         *        a consumer that will call methods on {@link ReviewPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hitReviewPolicy(ReviewPolicy)
         */
        default Builder hitReviewPolicy(Consumer<ReviewPolicy.Builder> hitReviewPolicy) {
            return hitReviewPolicy(ReviewPolicy.builder().applyMutation(hitReviewPolicy).build());
        }

        /**
         * <p>
         * Contains both ReviewResult and ReviewAction elements for an Assignment.
         * </p>
         * 
         * @param assignmentReviewReport
         *        Contains both ReviewResult and ReviewAction elements for an Assignment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentReviewReport(ReviewReport assignmentReviewReport);

        /**
         * <p>
         * Contains both ReviewResult and ReviewAction elements for an Assignment.
         * </p>
         * This is a convenience that creates an instance of the {@link ReviewReport.Builder} avoiding the need to
         * create one manually via {@link ReviewReport#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReviewReport.Builder#build()} is called immediately and its
         * result is passed to {@link #assignmentReviewReport(ReviewReport)}.
         * 
         * @param assignmentReviewReport
         *        a consumer that will call methods on {@link ReviewReport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assignmentReviewReport(ReviewReport)
         */
        default Builder assignmentReviewReport(Consumer<ReviewReport.Builder> assignmentReviewReport) {
            return assignmentReviewReport(ReviewReport.builder().applyMutation(assignmentReviewReport).build());
        }

        /**
         * <p>
         * Contains both ReviewResult and ReviewAction elements for a particular HIT.
         * </p>
         * 
         * @param hitReviewReport
         *        Contains both ReviewResult and ReviewAction elements for a particular HIT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitReviewReport(ReviewReport hitReviewReport);

        /**
         * <p>
         * Contains both ReviewResult and ReviewAction elements for a particular HIT.
         * </p>
         * This is a convenience that creates an instance of the {@link ReviewReport.Builder} avoiding the need to
         * create one manually via {@link ReviewReport#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReviewReport.Builder#build()} is called immediately and its
         * result is passed to {@link #hitReviewReport(ReviewReport)}.
         * 
         * @param hitReviewReport
         *        a consumer that will call methods on {@link ReviewReport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hitReviewReport(ReviewReport)
         */
        default Builder hitReviewReport(Consumer<ReviewReport.Builder> hitReviewReport) {
            return hitReviewReport(ReviewReport.builder().applyMutation(hitReviewReport).build());
        }

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MTurkResponse.BuilderImpl implements Builder {
        private String hitId;

        private ReviewPolicy assignmentReviewPolicy;

        private ReviewPolicy hitReviewPolicy;

        private ReviewReport assignmentReviewReport;

        private ReviewReport hitReviewReport;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReviewPolicyResultsForHitResponse model) {
            super(model);
            hitId(model.hitId);
            assignmentReviewPolicy(model.assignmentReviewPolicy);
            hitReviewPolicy(model.hitReviewPolicy);
            assignmentReviewReport(model.assignmentReviewReport);
            hitReviewReport(model.hitReviewReport);
            nextToken(model.nextToken);
        }

        public final String getHitId() {
            return hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final void setHitId(String hitId) {
            this.hitId = hitId;
        }

        public final ReviewPolicy.Builder getAssignmentReviewPolicy() {
            return assignmentReviewPolicy != null ? assignmentReviewPolicy.toBuilder() : null;
        }

        @Override
        public final Builder assignmentReviewPolicy(ReviewPolicy assignmentReviewPolicy) {
            this.assignmentReviewPolicy = assignmentReviewPolicy;
            return this;
        }

        public final void setAssignmentReviewPolicy(ReviewPolicy.BuilderImpl assignmentReviewPolicy) {
            this.assignmentReviewPolicy = assignmentReviewPolicy != null ? assignmentReviewPolicy.build() : null;
        }

        public final ReviewPolicy.Builder getHitReviewPolicy() {
            return hitReviewPolicy != null ? hitReviewPolicy.toBuilder() : null;
        }

        @Override
        public final Builder hitReviewPolicy(ReviewPolicy hitReviewPolicy) {
            this.hitReviewPolicy = hitReviewPolicy;
            return this;
        }

        public final void setHitReviewPolicy(ReviewPolicy.BuilderImpl hitReviewPolicy) {
            this.hitReviewPolicy = hitReviewPolicy != null ? hitReviewPolicy.build() : null;
        }

        public final ReviewReport.Builder getAssignmentReviewReport() {
            return assignmentReviewReport != null ? assignmentReviewReport.toBuilder() : null;
        }

        @Override
        public final Builder assignmentReviewReport(ReviewReport assignmentReviewReport) {
            this.assignmentReviewReport = assignmentReviewReport;
            return this;
        }

        public final void setAssignmentReviewReport(ReviewReport.BuilderImpl assignmentReviewReport) {
            this.assignmentReviewReport = assignmentReviewReport != null ? assignmentReviewReport.build() : null;
        }

        public final ReviewReport.Builder getHitReviewReport() {
            return hitReviewReport != null ? hitReviewReport.toBuilder() : null;
        }

        @Override
        public final Builder hitReviewReport(ReviewReport hitReviewReport) {
            this.hitReviewReport = hitReviewReport;
            return this;
        }

        public final void setHitReviewReport(ReviewReport.BuilderImpl hitReviewReport) {
            this.hitReviewReport = hitReviewReport != null ? hitReviewReport.build() : null;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListReviewPolicyResultsForHitResponse build() {
            return new ListReviewPolicyResultsForHitResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
