/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateQualificationTypeRequest extends MTurkRequest implements
        ToCopyableBuilder<CreateQualificationTypeRequest.Builder, CreateQualificationTypeRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateQualificationTypeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> KEYWORDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateQualificationTypeRequest::keywords)).setter(setter(Builder::keywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keywords").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateQualificationTypeRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> QUALIFICATION_TYPE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateQualificationTypeRequest::qualificationTypeStatusAsString))
            .setter(setter(Builder::qualificationTypeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationTypeStatus").build())
            .build();

    private static final SdkField<Long> RETRY_DELAY_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CreateQualificationTypeRequest::retryDelayInSeconds)).setter(setter(Builder::retryDelayInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryDelayInSeconds").build())
            .build();

    private static final SdkField<String> TEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateQualificationTypeRequest::test)).setter(setter(Builder::test))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Test").build()).build();

    private static final SdkField<String> ANSWER_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateQualificationTypeRequest::answerKey)).setter(setter(Builder::answerKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerKey").build()).build();

    private static final SdkField<Long> TEST_DURATION_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CreateQualificationTypeRequest::testDurationInSeconds)).setter(setter(Builder::testDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestDurationInSeconds").build())
            .build();

    private static final SdkField<Boolean> AUTO_GRANTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateQualificationTypeRequest::autoGranted)).setter(setter(Builder::autoGranted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoGranted").build()).build();

    private static final SdkField<Integer> AUTO_GRANTED_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateQualificationTypeRequest::autoGrantedValue)).setter(setter(Builder::autoGrantedValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoGrantedValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, KEYWORDS_FIELD,
            DESCRIPTION_FIELD, QUALIFICATION_TYPE_STATUS_FIELD, RETRY_DELAY_IN_SECONDS_FIELD, TEST_FIELD, ANSWER_KEY_FIELD,
            TEST_DURATION_IN_SECONDS_FIELD, AUTO_GRANTED_FIELD, AUTO_GRANTED_VALUE_FIELD));

    private final String name;

    private final String keywords;

    private final String description;

    private final String qualificationTypeStatus;

    private final Long retryDelayInSeconds;

    private final String test;

    private final String answerKey;

    private final Long testDurationInSeconds;

    private final Boolean autoGranted;

    private final Integer autoGrantedValue;

    private CreateQualificationTypeRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.keywords = builder.keywords;
        this.description = builder.description;
        this.qualificationTypeStatus = builder.qualificationTypeStatus;
        this.retryDelayInSeconds = builder.retryDelayInSeconds;
        this.test = builder.test;
        this.answerKey = builder.answerKey;
        this.testDurationInSeconds = builder.testDurationInSeconds;
        this.autoGranted = builder.autoGranted;
        this.autoGrantedValue = builder.autoGrantedValue;
    }

    /**
     * <p>
     * The name you give to the Qualification type. The type name is used to represent the Qualification to Workers, and
     * to find the type using a Qualification type search. It must be unique across all of your Qualification types.
     * </p>
     * 
     * @return The name you give to the Qualification type. The type name is used to represent the Qualification to
     *         Workers, and to find the type using a Qualification type search. It must be unique across all of your
     *         Qualification types.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * One or more words or phrases that describe the Qualification type, separated by commas. The keywords of a type
     * make the type easier to find during a search.
     * </p>
     * 
     * @return One or more words or phrases that describe the Qualification type, separated by commas. The keywords of a
     *         type make the type easier to find during a search.
     */
    public String keywords() {
        return keywords;
    }

    /**
     * <p>
     * A long description for the Qualification type. On the Amazon Mechanical Turk website, the long description is
     * displayed when a Worker examines a Qualification type.
     * </p>
     * 
     * @return A long description for the Qualification type. On the Amazon Mechanical Turk website, the long
     *         description is displayed when a Worker examines a Qualification type.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The initial status of the Qualification type.
     * </p>
     * <p>
     * Constraints: Valid values are: Active | Inactive
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualificationTypeStatus} will return {@link QualificationTypeStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #qualificationTypeStatusAsString}.
     * </p>
     * 
     * @return The initial status of the Qualification type.</p>
     *         <p>
     *         Constraints: Valid values are: Active | Inactive
     * @see QualificationTypeStatus
     */
    public QualificationTypeStatus qualificationTypeStatus() {
        return QualificationTypeStatus.fromValue(qualificationTypeStatus);
    }

    /**
     * <p>
     * The initial status of the Qualification type.
     * </p>
     * <p>
     * Constraints: Valid values are: Active | Inactive
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualificationTypeStatus} will return {@link QualificationTypeStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #qualificationTypeStatusAsString}.
     * </p>
     * 
     * @return The initial status of the Qualification type.</p>
     *         <p>
     *         Constraints: Valid values are: Active | Inactive
     * @see QualificationTypeStatus
     */
    public String qualificationTypeStatusAsString() {
        return qualificationTypeStatus;
    }

    /**
     * <p>
     * The number of seconds that a Worker must wait after requesting a Qualification of the Qualification type before
     * the worker can retry the Qualification request.
     * </p>
     * <p>
     * Constraints: None. If not specified, retries are disabled and Workers can request a Qualification of this type
     * only once, even if the Worker has not been granted the Qualification. It is not possible to disable retries for a
     * Qualification type after it has been created with retries enabled. If you want to disable retries, you must
     * delete existing retry-enabled Qualification type and then create a new Qualification type with retries disabled.
     * </p>
     * 
     * @return The number of seconds that a Worker must wait after requesting a Qualification of the Qualification type
     *         before the worker can retry the Qualification request.</p>
     *         <p>
     *         Constraints: None. If not specified, retries are disabled and Workers can request a Qualification of this
     *         type only once, even if the Worker has not been granted the Qualification. It is not possible to disable
     *         retries for a Qualification type after it has been created with retries enabled. If you want to disable
     *         retries, you must delete existing retry-enabled Qualification type and then create a new Qualification
     *         type with retries disabled.
     */
    public Long retryDelayInSeconds() {
        return retryDelayInSeconds;
    }

    /**
     * <p>
     * The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type.
     * If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified.
     * </p>
     * <p>
     * Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be
     * specified if AutoGranted is true.
     * </p>
     * <p>
     * Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.
     * </p>
     * 
     * @return The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this
     *         type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified. </p>
     *         <p>
     *         Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter
     *         cannot be specified if AutoGranted is true.
     *         </p>
     *         <p>
     *         Constraints: None. If not specified, the Worker may request the Qualification without answering any
     *         questions.
     */
    public String test() {
        return test;
    }

    /**
     * <p>
     * The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data
     * structure.
     * </p>
     * <p>
     * Constraints: Must not be longer than 65535 bytes.
     * </p>
     * <p>
     * Constraints: None. If not specified, you must process Qualification requests manually.
     * </p>
     * 
     * @return The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data
     *         structure.</p>
     *         <p>
     *         Constraints: Must not be longer than 65535 bytes.
     *         </p>
     *         <p>
     *         Constraints: None. If not specified, you must process Qualification requests manually.
     */
    public String answerKey() {
        return answerKey;
    }

    /**
     * <p>
     * The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker
     * requests the Qualification.
     * </p>
     * 
     * @return The number of seconds the Worker has to complete the Qualification test, starting from the time the
     *         Worker requests the Qualification.
     */
    public Long testDurationInSeconds() {
        return testDurationInSeconds;
    }

    /**
     * <p>
     * Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with
     * a Qualification test.
     * </p>
     * <p>
     * Constraints: If the Test parameter is specified, this parameter cannot be true.
     * </p>
     * 
     * @return Specifies whether requests for the Qualification type are granted immediately, without prompting the
     *         Worker with a Qualification test.</p>
     *         <p>
     *         Constraints: If the Test parameter is specified, this parameter cannot be true.
     */
    public Boolean autoGranted() {
        return autoGranted;
    }

    /**
     * <p>
     * The Qualification value to use for automatically granted Qualifications. This parameter is used only if the
     * AutoGranted parameter is true.
     * </p>
     * 
     * @return The Qualification value to use for automatically granted Qualifications. This parameter is used only if
     *         the AutoGranted parameter is true.
     */
    public Integer autoGrantedValue() {
        return autoGrantedValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(keywords());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(qualificationTypeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retryDelayInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(test());
        hashCode = 31 * hashCode + Objects.hashCode(answerKey());
        hashCode = 31 * hashCode + Objects.hashCode(testDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(autoGranted());
        hashCode = 31 * hashCode + Objects.hashCode(autoGrantedValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQualificationTypeRequest)) {
            return false;
        }
        CreateQualificationTypeRequest other = (CreateQualificationTypeRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(keywords(), other.keywords())
                && Objects.equals(description(), other.description())
                && Objects.equals(qualificationTypeStatusAsString(), other.qualificationTypeStatusAsString())
                && Objects.equals(retryDelayInSeconds(), other.retryDelayInSeconds()) && Objects.equals(test(), other.test())
                && Objects.equals(answerKey(), other.answerKey())
                && Objects.equals(testDurationInSeconds(), other.testDurationInSeconds())
                && Objects.equals(autoGranted(), other.autoGranted())
                && Objects.equals(autoGrantedValue(), other.autoGrantedValue());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateQualificationTypeRequest").add("Name", name()).add("Keywords", keywords())
                .add("Description", description()).add("QualificationTypeStatus", qualificationTypeStatusAsString())
                .add("RetryDelayInSeconds", retryDelayInSeconds()).add("Test", test()).add("AnswerKey", answerKey())
                .add("TestDurationInSeconds", testDurationInSeconds()).add("AutoGranted", autoGranted())
                .add("AutoGrantedValue", autoGrantedValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Keywords":
            return Optional.ofNullable(clazz.cast(keywords()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "QualificationTypeStatus":
            return Optional.ofNullable(clazz.cast(qualificationTypeStatusAsString()));
        case "RetryDelayInSeconds":
            return Optional.ofNullable(clazz.cast(retryDelayInSeconds()));
        case "Test":
            return Optional.ofNullable(clazz.cast(test()));
        case "AnswerKey":
            return Optional.ofNullable(clazz.cast(answerKey()));
        case "TestDurationInSeconds":
            return Optional.ofNullable(clazz.cast(testDurationInSeconds()));
        case "AutoGranted":
            return Optional.ofNullable(clazz.cast(autoGranted()));
        case "AutoGrantedValue":
            return Optional.ofNullable(clazz.cast(autoGrantedValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateQualificationTypeRequest, T> g) {
        return obj -> g.apply((CreateQualificationTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateQualificationTypeRequest> {
        /**
         * <p>
         * The name you give to the Qualification type. The type name is used to represent the Qualification to Workers,
         * and to find the type using a Qualification type search. It must be unique across all of your Qualification
         * types.
         * </p>
         * 
         * @param name
         *        The name you give to the Qualification type. The type name is used to represent the Qualification to
         *        Workers, and to find the type using a Qualification type search. It must be unique across all of your
         *        Qualification types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * One or more words or phrases that describe the Qualification type, separated by commas. The keywords of a
         * type make the type easier to find during a search.
         * </p>
         * 
         * @param keywords
         *        One or more words or phrases that describe the Qualification type, separated by commas. The keywords
         *        of a type make the type easier to find during a search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywords(String keywords);

        /**
         * <p>
         * A long description for the Qualification type. On the Amazon Mechanical Turk website, the long description is
         * displayed when a Worker examines a Qualification type.
         * </p>
         * 
         * @param description
         *        A long description for the Qualification type. On the Amazon Mechanical Turk website, the long
         *        description is displayed when a Worker examines a Qualification type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The initial status of the Qualification type.
         * </p>
         * <p>
         * Constraints: Valid values are: Active | Inactive
         * </p>
         * 
         * @param qualificationTypeStatus
         *        The initial status of the Qualification type.</p>
         *        <p>
         *        Constraints: Valid values are: Active | Inactive
         * @see QualificationTypeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualificationTypeStatus
         */
        Builder qualificationTypeStatus(String qualificationTypeStatus);

        /**
         * <p>
         * The initial status of the Qualification type.
         * </p>
         * <p>
         * Constraints: Valid values are: Active | Inactive
         * </p>
         * 
         * @param qualificationTypeStatus
         *        The initial status of the Qualification type.</p>
         *        <p>
         *        Constraints: Valid values are: Active | Inactive
         * @see QualificationTypeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualificationTypeStatus
         */
        Builder qualificationTypeStatus(QualificationTypeStatus qualificationTypeStatus);

        /**
         * <p>
         * The number of seconds that a Worker must wait after requesting a Qualification of the Qualification type
         * before the worker can retry the Qualification request.
         * </p>
         * <p>
         * Constraints: None. If not specified, retries are disabled and Workers can request a Qualification of this
         * type only once, even if the Worker has not been granted the Qualification. It is not possible to disable
         * retries for a Qualification type after it has been created with retries enabled. If you want to disable
         * retries, you must delete existing retry-enabled Qualification type and then create a new Qualification type
         * with retries disabled.
         * </p>
         * 
         * @param retryDelayInSeconds
         *        The number of seconds that a Worker must wait after requesting a Qualification of the Qualification
         *        type before the worker can retry the Qualification request.</p>
         *        <p>
         *        Constraints: None. If not specified, retries are disabled and Workers can request a Qualification of
         *        this type only once, even if the Worker has not been granted the Qualification. It is not possible to
         *        disable retries for a Qualification type after it has been created with retries enabled. If you want
         *        to disable retries, you must delete existing retry-enabled Qualification type and then create a new
         *        Qualification type with retries disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryDelayInSeconds(Long retryDelayInSeconds);

        /**
         * <p>
         * The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this
         * type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified.
         * </p>
         * <p>
         * Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter
         * cannot be specified if AutoGranted is true.
         * </p>
         * <p>
         * Constraints: None. If not specified, the Worker may request the Qualification without answering any
         * questions.
         * </p>
         * 
         * @param test
         *        The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of
         *        this type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified.
         *        </p>
         *        <p>
         *        Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This
         *        parameter cannot be specified if AutoGranted is true.
         *        </p>
         *        <p>
         *        Constraints: None. If not specified, the Worker may request the Qualification without answering any
         *        questions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder test(String test);

        /**
         * <p>
         * The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data
         * structure.
         * </p>
         * <p>
         * Constraints: Must not be longer than 65535 bytes.
         * </p>
         * <p>
         * Constraints: None. If not specified, you must process Qualification requests manually.
         * </p>
         * 
         * @param answerKey
         *        The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey
         *        data structure.</p>
         *        <p>
         *        Constraints: Must not be longer than 65535 bytes.
         *        </p>
         *        <p>
         *        Constraints: None. If not specified, you must process Qualification requests manually.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerKey(String answerKey);

        /**
         * <p>
         * The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker
         * requests the Qualification.
         * </p>
         * 
         * @param testDurationInSeconds
         *        The number of seconds the Worker has to complete the Qualification test, starting from the time the
         *        Worker requests the Qualification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testDurationInSeconds(Long testDurationInSeconds);

        /**
         * <p>
         * Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker
         * with a Qualification test.
         * </p>
         * <p>
         * Constraints: If the Test parameter is specified, this parameter cannot be true.
         * </p>
         * 
         * @param autoGranted
         *        Specifies whether requests for the Qualification type are granted immediately, without prompting the
         *        Worker with a Qualification test.</p>
         *        <p>
         *        Constraints: If the Test parameter is specified, this parameter cannot be true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoGranted(Boolean autoGranted);

        /**
         * <p>
         * The Qualification value to use for automatically granted Qualifications. This parameter is used only if the
         * AutoGranted parameter is true.
         * </p>
         * 
         * @param autoGrantedValue
         *        The Qualification value to use for automatically granted Qualifications. This parameter is used only
         *        if the AutoGranted parameter is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoGrantedValue(Integer autoGrantedValue);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String name;

        private String keywords;

        private String description;

        private String qualificationTypeStatus;

        private Long retryDelayInSeconds;

        private String test;

        private String answerKey;

        private Long testDurationInSeconds;

        private Boolean autoGranted;

        private Integer autoGrantedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQualificationTypeRequest model) {
            super(model);
            name(model.name);
            keywords(model.keywords);
            description(model.description);
            qualificationTypeStatus(model.qualificationTypeStatus);
            retryDelayInSeconds(model.retryDelayInSeconds);
            test(model.test);
            answerKey(model.answerKey);
            testDurationInSeconds(model.testDurationInSeconds);
            autoGranted(model.autoGranted);
            autoGrantedValue(model.autoGrantedValue);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getKeywords() {
            return keywords;
        }

        @Override
        public final Builder keywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        public final void setKeywords(String keywords) {
            this.keywords = keywords;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getQualificationTypeStatusAsString() {
            return qualificationTypeStatus;
        }

        @Override
        public final Builder qualificationTypeStatus(String qualificationTypeStatus) {
            this.qualificationTypeStatus = qualificationTypeStatus;
            return this;
        }

        @Override
        public final Builder qualificationTypeStatus(QualificationTypeStatus qualificationTypeStatus) {
            this.qualificationTypeStatus(qualificationTypeStatus.toString());
            return this;
        }

        public final void setQualificationTypeStatus(String qualificationTypeStatus) {
            this.qualificationTypeStatus = qualificationTypeStatus;
        }

        public final Long getRetryDelayInSeconds() {
            return retryDelayInSeconds;
        }

        @Override
        public final Builder retryDelayInSeconds(Long retryDelayInSeconds) {
            this.retryDelayInSeconds = retryDelayInSeconds;
            return this;
        }

        public final void setRetryDelayInSeconds(Long retryDelayInSeconds) {
            this.retryDelayInSeconds = retryDelayInSeconds;
        }

        public final String getTest() {
            return test;
        }

        @Override
        public final Builder test(String test) {
            this.test = test;
            return this;
        }

        public final void setTest(String test) {
            this.test = test;
        }

        public final String getAnswerKey() {
            return answerKey;
        }

        @Override
        public final Builder answerKey(String answerKey) {
            this.answerKey = answerKey;
            return this;
        }

        public final void setAnswerKey(String answerKey) {
            this.answerKey = answerKey;
        }

        public final Long getTestDurationInSeconds() {
            return testDurationInSeconds;
        }

        @Override
        public final Builder testDurationInSeconds(Long testDurationInSeconds) {
            this.testDurationInSeconds = testDurationInSeconds;
            return this;
        }

        public final void setTestDurationInSeconds(Long testDurationInSeconds) {
            this.testDurationInSeconds = testDurationInSeconds;
        }

        public final Boolean getAutoGranted() {
            return autoGranted;
        }

        @Override
        public final Builder autoGranted(Boolean autoGranted) {
            this.autoGranted = autoGranted;
            return this;
        }

        public final void setAutoGranted(Boolean autoGranted) {
            this.autoGranted = autoGranted;
        }

        public final Integer getAutoGrantedValue() {
            return autoGrantedValue;
        }

        @Override
        public final Builder autoGrantedValue(Integer autoGrantedValue) {
            this.autoGrantedValue = autoGrantedValue;
            return this;
        }

        public final void setAutoGrantedValue(Integer autoGrantedValue) {
            this.autoGrantedValue = autoGrantedValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQualificationTypeRequest build() {
            return new CreateQualificationTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
