/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotifyWorkersRequest extends MTurkRequest implements
        ToCopyableBuilder<NotifyWorkersRequest.Builder, NotifyWorkersRequest> {
    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NotifyWorkersRequest::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<String> MESSAGE_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NotifyWorkersRequest::messageText)).setter(setter(Builder::messageText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageText").build()).build();

    private static final SdkField<List<String>> WORKER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(NotifyWorkersRequest::workerIds))
            .setter(setter(Builder::workerIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD,
            MESSAGE_TEXT_FIELD, WORKER_IDS_FIELD));

    private final String subject;

    private final String messageText;

    private final List<String> workerIds;

    private NotifyWorkersRequest(BuilderImpl builder) {
        super(builder);
        this.subject = builder.subject;
        this.messageText = builder.messageText;
        this.workerIds = builder.workerIds;
    }

    /**
     * <p>
     * The subject line of the email message to send. Can include up to 200 characters.
     * </p>
     * 
     * @return The subject line of the email message to send. Can include up to 200 characters.
     */
    public String subject() {
        return subject;
    }

    /**
     * <p>
     * The text of the email message to send. Can include up to 4,096 characters
     * </p>
     * 
     * @return The text of the email message to send. Can include up to 4,096 characters
     */
    public String messageText() {
        return messageText;
    }

    /**
     * <p>
     * A list of Worker IDs you wish to notify. You can notify upto 100 Workers at a time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of Worker IDs you wish to notify. You can notify upto 100 Workers at a time.
     */
    public List<String> workerIds() {
        return workerIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(messageText());
        hashCode = 31 * hashCode + Objects.hashCode(workerIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyWorkersRequest)) {
            return false;
        }
        NotifyWorkersRequest other = (NotifyWorkersRequest) obj;
        return Objects.equals(subject(), other.subject()) && Objects.equals(messageText(), other.messageText())
                && Objects.equals(workerIds(), other.workerIds());
    }

    @Override
    public String toString() {
        return ToString.builder("NotifyWorkersRequest").add("Subject", subject()).add("MessageText", messageText())
                .add("WorkerIds", workerIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "MessageText":
            return Optional.ofNullable(clazz.cast(messageText()));
        case "WorkerIds":
            return Optional.ofNullable(clazz.cast(workerIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotifyWorkersRequest, T> g) {
        return obj -> g.apply((NotifyWorkersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkRequest.Builder, SdkPojo, CopyableBuilder<Builder, NotifyWorkersRequest> {
        /**
         * <p>
         * The subject line of the email message to send. Can include up to 200 characters.
         * </p>
         * 
         * @param subject
         *        The subject line of the email message to send. Can include up to 200 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The text of the email message to send. Can include up to 4,096 characters
         * </p>
         * 
         * @param messageText
         *        The text of the email message to send. Can include up to 4,096 characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageText(String messageText);

        /**
         * <p>
         * A list of Worker IDs you wish to notify. You can notify upto 100 Workers at a time.
         * </p>
         * 
         * @param workerIds
         *        A list of Worker IDs you wish to notify. You can notify upto 100 Workers at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerIds(Collection<String> workerIds);

        /**
         * <p>
         * A list of Worker IDs you wish to notify. You can notify upto 100 Workers at a time.
         * </p>
         * 
         * @param workerIds
         *        A list of Worker IDs you wish to notify. You can notify upto 100 Workers at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerIds(String... workerIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String subject;

        private String messageText;

        private List<String> workerIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyWorkersRequest model) {
            super(model);
            subject(model.subject);
            messageText(model.messageText);
            workerIds(model.workerIds);
        }

        public final String getSubject() {
            return subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getMessageText() {
            return messageText;
        }

        @Override
        public final Builder messageText(String messageText) {
            this.messageText = messageText;
            return this;
        }

        public final void setMessageText(String messageText) {
            this.messageText = messageText;
        }

        public final Collection<String> getWorkerIds() {
            return workerIds;
        }

        @Override
        public final Builder workerIds(Collection<String> workerIds) {
            this.workerIds = CustomerIdListCopier.copy(workerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workerIds(String... workerIds) {
            workerIds(Arrays.asList(workerIds));
            return this;
        }

        public final void setWorkerIds(Collection<String> workerIds) {
            this.workerIds = CustomerIdListCopier.copy(workerIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public NotifyWorkersRequest build() {
            return new NotifyWorkersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
