/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RejectQualificationRequestRequest extends MTurkRequest implements
        ToCopyableBuilder<RejectQualificationRequestRequest.Builder, RejectQualificationRequestRequest> {
    private static final SdkField<String> QUALIFICATION_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QualificationRequestId").getter(getter(RejectQualificationRequestRequest::qualificationRequestId))
            .setter(setter(Builder::qualificationRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationRequestId").build())
            .build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(RejectQualificationRequestRequest::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            QUALIFICATION_REQUEST_ID_FIELD, REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String qualificationRequestId;

    private final String reason;

    private RejectQualificationRequestRequest(BuilderImpl builder) {
        super(builder);
        this.qualificationRequestId = builder.qualificationRequestId;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The ID of the Qualification request, as returned by the <code>ListQualificationRequests</code> operation.
     * </p>
     * 
     * @return The ID of the Qualification request, as returned by the <code>ListQualificationRequests</code> operation.
     */
    public final String qualificationRequestId() {
        return qualificationRequestId;
    }

    /**
     * <p>
     * A text message explaining why the request was rejected, to be shown to the Worker who made the request.
     * </p>
     * 
     * @return A text message explaining why the request was rejected, to be shown to the Worker who made the request.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(qualificationRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectQualificationRequestRequest)) {
            return false;
        }
        RejectQualificationRequestRequest other = (RejectQualificationRequestRequest) obj;
        return Objects.equals(qualificationRequestId(), other.qualificationRequestId())
                && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RejectQualificationRequestRequest").add("QualificationRequestId", qualificationRequestId())
                .add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QualificationRequestId":
            return Optional.ofNullable(clazz.cast(qualificationRequestId()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QualificationRequestId", QUALIFICATION_REQUEST_ID_FIELD);
        map.put("Reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RejectQualificationRequestRequest, T> g) {
        return obj -> g.apply((RejectQualificationRequestRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkRequest.Builder, SdkPojo, CopyableBuilder<Builder, RejectQualificationRequestRequest> {
        /**
         * <p>
         * The ID of the Qualification request, as returned by the <code>ListQualificationRequests</code> operation.
         * </p>
         * 
         * @param qualificationRequestId
         *        The ID of the Qualification request, as returned by the <code>ListQualificationRequests</code>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationRequestId(String qualificationRequestId);

        /**
         * <p>
         * A text message explaining why the request was rejected, to be shown to the Worker who made the request.
         * </p>
         * 
         * @param reason
         *        A text message explaining why the request was rejected, to be shown to the Worker who made the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String qualificationRequestId;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectQualificationRequestRequest model) {
            super(model);
            qualificationRequestId(model.qualificationRequestId);
            reason(model.reason);
        }

        public final String getQualificationRequestId() {
            return qualificationRequestId;
        }

        public final void setQualificationRequestId(String qualificationRequestId) {
            this.qualificationRequestId = qualificationRequestId;
        }

        @Override
        public final Builder qualificationRequestId(String qualificationRequestId) {
            this.qualificationRequestId = qualificationRequestId;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RejectQualificationRequestRequest build() {
            return new RejectQualificationRequestRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
