/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.MTurkResponse;
import software.amazon.awssdk.services.mturk.model.WorkerBlock;
import software.amazon.awssdk.services.mturk.model.WorkerBlockListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkerBlocksResponse
extends MTurkResponse
implements ToCopyableBuilder<Builder, ListWorkerBlocksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWorkerBlocksResponse.getter(ListWorkerBlocksResponse::nextToken)).setter(ListWorkerBlocksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumResults").getter(ListWorkerBlocksResponse.getter(ListWorkerBlocksResponse::numResults)).setter(ListWorkerBlocksResponse.setter(Builder::numResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumResults").build()}).build();
    private static final SdkField<List<WorkerBlock>> WORKER_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkerBlocks").getter(ListWorkerBlocksResponse.getter(ListWorkerBlocksResponse::workerBlocks)).setter(ListWorkerBlocksResponse.setter(Builder::workerBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerBlocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkerBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, NUM_RESULTS_FIELD, WORKER_BLOCKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWorkerBlocksResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer numResults;
    private final List<WorkerBlock> workerBlocks;

    private ListWorkerBlocksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.numResults = builder.numResults;
        this.workerBlocks = builder.workerBlocks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer numResults() {
        return this.numResults;
    }

    public final boolean hasWorkerBlocks() {
        return this.workerBlocks != null && !(this.workerBlocks instanceof SdkAutoConstructList);
    }

    public final List<WorkerBlock> workerBlocks() {
        return this.workerBlocks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.numResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkerBlocks() ? this.workerBlocks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkerBlocksResponse)) {
            return false;
        }
        ListWorkerBlocksResponse other = (ListWorkerBlocksResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.numResults(), other.numResults()) && this.hasWorkerBlocks() == other.hasWorkerBlocks() && Objects.equals(this.workerBlocks(), other.workerBlocks());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkerBlocksResponse").add("NextToken", (Object)this.nextToken()).add("NumResults", (Object)this.numResults()).add("WorkerBlocks", this.hasWorkerBlocks() ? this.workerBlocks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "NumResults": {
                return Optional.ofNullable(clazz.cast(this.numResults()));
            }
            case "WorkerBlocks": {
                return Optional.ofNullable(clazz.cast(this.workerBlocks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("NumResults", NUM_RESULTS_FIELD);
        map.put("WorkerBlocks", WORKER_BLOCKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkerBlocksResponse, T> g) {
        return obj -> g.apply((ListWorkerBlocksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer numResults;
        private List<WorkerBlock> workerBlocks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkerBlocksResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.numResults(model.numResults);
            this.workerBlocks(model.workerBlocks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getNumResults() {
            return this.numResults;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final List<WorkerBlock.Builder> getWorkerBlocks() {
            List<WorkerBlock.Builder> result = WorkerBlockListCopier.copyToBuilder(this.workerBlocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkerBlocks(Collection<WorkerBlock.BuilderImpl> workerBlocks) {
            this.workerBlocks = WorkerBlockListCopier.copyFromBuilder(workerBlocks);
        }

        @Override
        public final Builder workerBlocks(Collection<WorkerBlock> workerBlocks) {
            this.workerBlocks = WorkerBlockListCopier.copy(workerBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workerBlocks(WorkerBlock ... workerBlocks) {
            this.workerBlocks(Arrays.asList(workerBlocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workerBlocks(Consumer<WorkerBlock.Builder> ... workerBlocks) {
            this.workerBlocks(Stream.of(workerBlocks).map(c -> (WorkerBlock)((WorkerBlock.Builder)WorkerBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkerBlocksResponse build() {
            return new ListWorkerBlocksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MTurkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkerBlocksResponse> {
        public Builder nextToken(String var1);

        public Builder numResults(Integer var1);

        public Builder workerBlocks(Collection<WorkerBlock> var1);

        public Builder workerBlocks(WorkerBlock ... var1);

        public Builder workerBlocks(Consumer<WorkerBlock.Builder> ... var1);
    }
}

