/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.mturk.MTurkClient;
import software.amazon.awssdk.services.mturk.MTurkServiceClientConfiguration;
import software.amazon.awssdk.services.mturk.internal.MTurkServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.mturk.model.AcceptQualificationRequestRequest;
import software.amazon.awssdk.services.mturk.model.AcceptQualificationRequestResponse;
import software.amazon.awssdk.services.mturk.model.ApproveAssignmentRequest;
import software.amazon.awssdk.services.mturk.model.ApproveAssignmentResponse;
import software.amazon.awssdk.services.mturk.model.AssociateQualificationWithWorkerRequest;
import software.amazon.awssdk.services.mturk.model.AssociateQualificationWithWorkerResponse;
import software.amazon.awssdk.services.mturk.model.CreateAdditionalAssignmentsForHitRequest;
import software.amazon.awssdk.services.mturk.model.CreateAdditionalAssignmentsForHitResponse;
import software.amazon.awssdk.services.mturk.model.CreateHitRequest;
import software.amazon.awssdk.services.mturk.model.CreateHitResponse;
import software.amazon.awssdk.services.mturk.model.CreateHitTypeRequest;
import software.amazon.awssdk.services.mturk.model.CreateHitTypeResponse;
import software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeRequest;
import software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeResponse;
import software.amazon.awssdk.services.mturk.model.CreateQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.CreateQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.CreateWorkerBlockRequest;
import software.amazon.awssdk.services.mturk.model.CreateWorkerBlockResponse;
import software.amazon.awssdk.services.mturk.model.DeleteHitRequest;
import software.amazon.awssdk.services.mturk.model.DeleteHitResponse;
import software.amazon.awssdk.services.mturk.model.DeleteQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.DeleteQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.DeleteWorkerBlockRequest;
import software.amazon.awssdk.services.mturk.model.DeleteWorkerBlockResponse;
import software.amazon.awssdk.services.mturk.model.DisassociateQualificationFromWorkerRequest;
import software.amazon.awssdk.services.mturk.model.DisassociateQualificationFromWorkerResponse;
import software.amazon.awssdk.services.mturk.model.GetAccountBalanceRequest;
import software.amazon.awssdk.services.mturk.model.GetAccountBalanceResponse;
import software.amazon.awssdk.services.mturk.model.GetAssignmentRequest;
import software.amazon.awssdk.services.mturk.model.GetAssignmentResponse;
import software.amazon.awssdk.services.mturk.model.GetFileUploadUrlRequest;
import software.amazon.awssdk.services.mturk.model.GetFileUploadUrlResponse;
import software.amazon.awssdk.services.mturk.model.GetHitRequest;
import software.amazon.awssdk.services.mturk.model.GetHitResponse;
import software.amazon.awssdk.services.mturk.model.GetQualificationScoreRequest;
import software.amazon.awssdk.services.mturk.model.GetQualificationScoreResponse;
import software.amazon.awssdk.services.mturk.model.GetQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.GetQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest;
import software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse;
import software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest;
import software.amazon.awssdk.services.mturk.model.ListBonusPaymentsResponse;
import software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.ListHiTsRequest;
import software.amazon.awssdk.services.mturk.model.ListHiTsResponse;
import software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest;
import software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse;
import software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest;
import software.amazon.awssdk.services.mturk.model.ListQualificationTypesResponse;
import software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest;
import software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse;
import software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest;
import software.amazon.awssdk.services.mturk.model.ListReviewableHiTsResponse;
import software.amazon.awssdk.services.mturk.model.ListWorkerBlocksRequest;
import software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse;
import software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.MTurkException;
import software.amazon.awssdk.services.mturk.model.NotifyWorkersRequest;
import software.amazon.awssdk.services.mturk.model.NotifyWorkersResponse;
import software.amazon.awssdk.services.mturk.model.RejectAssignmentRequest;
import software.amazon.awssdk.services.mturk.model.RejectAssignmentResponse;
import software.amazon.awssdk.services.mturk.model.RejectQualificationRequestRequest;
import software.amazon.awssdk.services.mturk.model.RejectQualificationRequestResponse;
import software.amazon.awssdk.services.mturk.model.RequestErrorException;
import software.amazon.awssdk.services.mturk.model.SendBonusRequest;
import software.amazon.awssdk.services.mturk.model.SendBonusResponse;
import software.amazon.awssdk.services.mturk.model.SendTestEventNotificationRequest;
import software.amazon.awssdk.services.mturk.model.SendTestEventNotificationResponse;
import software.amazon.awssdk.services.mturk.model.ServiceException;
import software.amazon.awssdk.services.mturk.model.UpdateExpirationForHitRequest;
import software.amazon.awssdk.services.mturk.model.UpdateExpirationForHitResponse;
import software.amazon.awssdk.services.mturk.model.UpdateHitReviewStatusRequest;
import software.amazon.awssdk.services.mturk.model.UpdateHitReviewStatusResponse;
import software.amazon.awssdk.services.mturk.model.UpdateHitTypeOfHitRequest;
import software.amazon.awssdk.services.mturk.model.UpdateHitTypeOfHitResponse;
import software.amazon.awssdk.services.mturk.model.UpdateNotificationSettingsRequest;
import software.amazon.awssdk.services.mturk.model.UpdateNotificationSettingsResponse;
import software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.transform.AcceptQualificationRequestRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ApproveAssignmentRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.AssociateQualificationWithWorkerRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateAdditionalAssignmentsForHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateHitTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateHitWithHitTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateQualificationTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateWorkerBlockRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.DeleteHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.DeleteQualificationTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.DeleteWorkerBlockRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.DisassociateQualificationFromWorkerRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetAccountBalanceRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetAssignmentRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetFileUploadUrlRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetQualificationScoreRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetQualificationTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListAssignmentsForHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListBonusPaymentsRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListHiTsForQualificationTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListHiTsRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListQualificationRequestsRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListQualificationTypesRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListReviewPolicyResultsForHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListReviewableHiTsRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListWorkerBlocksRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListWorkersWithQualificationTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.NotifyWorkersRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.RejectAssignmentRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.RejectQualificationRequestRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.SendBonusRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.SendTestEventNotificationRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateExpirationForHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateHitReviewStatusRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateHitTypeOfHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateNotificationSettingsRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateQualificationTypeRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultMTurkClient
implements MTurkClient {
    private static final Logger log = Logger.loggerFor(DefaultMTurkClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMTurkClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"MTurk#2.32.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcceptQualificationRequestResponse acceptQualificationRequest(AcceptQualificationRequestRequest acceptQualificationRequestRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptQualificationRequestResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acceptQualificationRequestRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, acceptQualificationRequestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptQualificationRequest");
            AcceptQualificationRequestResponse acceptQualificationRequestResponse = (AcceptQualificationRequestResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptQualificationRequest").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)acceptQualificationRequestRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcceptQualificationRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acceptQualificationRequestResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$acceptQualificationRequest$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApproveAssignmentResponse approveAssignment(ApproveAssignmentRequest approveAssignmentRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ApproveAssignmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)approveAssignmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, approveAssignmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ApproveAssignment");
            ApproveAssignmentResponse approveAssignmentResponse = (ApproveAssignmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApproveAssignment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)approveAssignmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ApproveAssignmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return approveAssignmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$approveAssignment$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateQualificationWithWorkerResponse associateQualificationWithWorker(AssociateQualificationWithWorkerRequest associateQualificationWithWorkerRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateQualificationWithWorkerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateQualificationWithWorkerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, associateQualificationWithWorkerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateQualificationWithWorker");
            AssociateQualificationWithWorkerResponse associateQualificationWithWorkerResponse = (AssociateQualificationWithWorkerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateQualificationWithWorker").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateQualificationWithWorkerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateQualificationWithWorkerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateQualificationWithWorkerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$associateQualificationWithWorker$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAdditionalAssignmentsForHitResponse createAdditionalAssignmentsForHIT(CreateAdditionalAssignmentsForHitRequest createAdditionalAssignmentsForHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAdditionalAssignmentsForHitResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAdditionalAssignmentsForHitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, createAdditionalAssignmentsForHitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAdditionalAssignmentsForHIT");
            CreateAdditionalAssignmentsForHitResponse createAdditionalAssignmentsForHitResponse = (CreateAdditionalAssignmentsForHitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAdditionalAssignmentsForHIT").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAdditionalAssignmentsForHitRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAdditionalAssignmentsForHitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAdditionalAssignmentsForHitResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$createAdditionalAssignmentsForHIT$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHitResponse createHIT(CreateHitRequest createHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateHitResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createHitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, createHitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHIT");
            CreateHitResponse createHitResponse = (CreateHitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHIT").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createHitRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateHitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createHitResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$createHIT$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHitTypeResponse createHITType(CreateHitTypeRequest createHitTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateHitTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createHitTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, createHitTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHITType");
            CreateHitTypeResponse createHitTypeResponse = (CreateHitTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHITType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createHitTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateHitTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createHitTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$createHITType$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHitWithHitTypeResponse createHITWithHITType(CreateHitWithHitTypeRequest createHitWithHitTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateHitWithHitTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createHitWithHitTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, createHitWithHitTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHITWithHITType");
            CreateHitWithHitTypeResponse createHitWithHitTypeResponse = (CreateHitWithHitTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHITWithHITType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createHitWithHitTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateHitWithHitTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createHitWithHitTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$createHITWithHITType$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateQualificationTypeResponse createQualificationType(CreateQualificationTypeRequest createQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateQualificationTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createQualificationTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, createQualificationTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateQualificationType");
            CreateQualificationTypeResponse createQualificationTypeResponse = (CreateQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateQualificationType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createQualificationTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateQualificationTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createQualificationTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$createQualificationType$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorkerBlockResponse createWorkerBlock(CreateWorkerBlockRequest createWorkerBlockRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkerBlockResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createWorkerBlockRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, createWorkerBlockRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorkerBlock");
            CreateWorkerBlockResponse createWorkerBlockResponse = (CreateWorkerBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkerBlock").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createWorkerBlockRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorkerBlockRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorkerBlockResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$createWorkerBlock$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteHitResponse deleteHIT(DeleteHitRequest deleteHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteHitResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteHitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, deleteHitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteHIT");
            DeleteHitResponse deleteHitResponse = (DeleteHitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHIT").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteHitRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteHitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteHitResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$deleteHIT$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteQualificationTypeResponse deleteQualificationType(DeleteQualificationTypeRequest deleteQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteQualificationTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteQualificationTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, deleteQualificationTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteQualificationType");
            DeleteQualificationTypeResponse deleteQualificationTypeResponse = (DeleteQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteQualificationType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteQualificationTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteQualificationTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteQualificationTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$deleteQualificationType$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWorkerBlockResponse deleteWorkerBlock(DeleteWorkerBlockRequest deleteWorkerBlockRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkerBlockResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteWorkerBlockRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, deleteWorkerBlockRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorkerBlock");
            DeleteWorkerBlockResponse deleteWorkerBlockResponse = (DeleteWorkerBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkerBlock").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteWorkerBlockRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWorkerBlockRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWorkerBlockResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$deleteWorkerBlock$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateQualificationFromWorkerResponse disassociateQualificationFromWorker(DisassociateQualificationFromWorkerRequest disassociateQualificationFromWorkerRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateQualificationFromWorkerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateQualificationFromWorkerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, disassociateQualificationFromWorkerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateQualificationFromWorker");
            DisassociateQualificationFromWorkerResponse disassociateQualificationFromWorkerResponse = (DisassociateQualificationFromWorkerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateQualificationFromWorker").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateQualificationFromWorkerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateQualificationFromWorkerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateQualificationFromWorkerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$disassociateQualificationFromWorker$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccountBalanceResponse getAccountBalance(GetAccountBalanceRequest getAccountBalanceRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccountBalanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAccountBalanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, getAccountBalanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccountBalance");
            GetAccountBalanceResponse getAccountBalanceResponse = (GetAccountBalanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccountBalance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAccountBalanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAccountBalanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAccountBalanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$getAccountBalance$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAssignmentResponse getAssignment(GetAssignmentRequest getAssignmentRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAssignmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAssignmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, getAssignmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAssignment");
            GetAssignmentResponse getAssignmentResponse = (GetAssignmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAssignment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAssignmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAssignmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAssignmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$getAssignment$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFileUploadUrlResponse getFileUploadURL(GetFileUploadUrlRequest getFileUploadUrlRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFileUploadUrlResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getFileUploadUrlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, getFileUploadUrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFileUploadURL");
            GetFileUploadUrlResponse getFileUploadUrlResponse = (GetFileUploadUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFileUploadURL").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getFileUploadUrlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetFileUploadUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFileUploadUrlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$getFileUploadURL$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHitResponse getHIT(GetHitRequest getHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetHitResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getHitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, getHitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHIT");
            GetHitResponse getHitResponse = (GetHitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHIT").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getHitRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetHitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getHitResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$getHIT$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQualificationScoreResponse getQualificationScore(GetQualificationScoreRequest getQualificationScoreRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQualificationScoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getQualificationScoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, getQualificationScoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQualificationScore");
            GetQualificationScoreResponse getQualificationScoreResponse = (GetQualificationScoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQualificationScore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getQualificationScoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetQualificationScoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getQualificationScoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$getQualificationScore$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQualificationTypeResponse getQualificationType(GetQualificationTypeRequest getQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQualificationTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getQualificationTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, getQualificationTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQualificationType");
            GetQualificationTypeResponse getQualificationTypeResponse = (GetQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQualificationType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getQualificationTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetQualificationTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getQualificationTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$getQualificationType$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssignmentsForHitResponse listAssignmentsForHIT(ListAssignmentsForHitRequest listAssignmentsForHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssignmentsForHitResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAssignmentsForHitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, listAssignmentsForHitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssignmentsForHIT");
            ListAssignmentsForHitResponse listAssignmentsForHitResponse = (ListAssignmentsForHitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssignmentsForHIT").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAssignmentsForHitRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAssignmentsForHitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAssignmentsForHitResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$listAssignmentsForHIT$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBonusPaymentsResponse listBonusPayments(ListBonusPaymentsRequest listBonusPaymentsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBonusPaymentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBonusPaymentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, listBonusPaymentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBonusPayments");
            ListBonusPaymentsResponse listBonusPaymentsResponse = (ListBonusPaymentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBonusPayments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listBonusPaymentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBonusPaymentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBonusPaymentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$listBonusPayments$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHiTsResponse listHITs(ListHiTsRequest listHiTsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListHiTsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listHiTsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, listHiTsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListHITs");
            ListHiTsResponse listHiTsResponse = (ListHiTsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHITs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listHiTsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListHiTsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listHiTsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$listHITs$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHiTsForQualificationTypeResponse listHITsForQualificationType(ListHiTsForQualificationTypeRequest listHiTsForQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListHiTsForQualificationTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listHiTsForQualificationTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, listHiTsForQualificationTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListHITsForQualificationType");
            ListHiTsForQualificationTypeResponse listHiTsForQualificationTypeResponse = (ListHiTsForQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHITsForQualificationType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listHiTsForQualificationTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListHiTsForQualificationTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listHiTsForQualificationTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$listHITsForQualificationType$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListQualificationRequestsResponse listQualificationRequests(ListQualificationRequestsRequest listQualificationRequestsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListQualificationRequestsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listQualificationRequestsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, listQualificationRequestsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListQualificationRequests");
            ListQualificationRequestsResponse listQualificationRequestsResponse = (ListQualificationRequestsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQualificationRequests").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listQualificationRequestsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListQualificationRequestsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listQualificationRequestsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$listQualificationRequests$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListQualificationTypesResponse listQualificationTypes(ListQualificationTypesRequest listQualificationTypesRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListQualificationTypesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listQualificationTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, listQualificationTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListQualificationTypes");
            ListQualificationTypesResponse listQualificationTypesResponse = (ListQualificationTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQualificationTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listQualificationTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListQualificationTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listQualificationTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$listQualificationTypes$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReviewPolicyResultsForHitResponse listReviewPolicyResultsForHIT(ListReviewPolicyResultsForHitRequest listReviewPolicyResultsForHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReviewPolicyResultsForHitResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listReviewPolicyResultsForHitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, listReviewPolicyResultsForHitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReviewPolicyResultsForHIT");
            ListReviewPolicyResultsForHitResponse listReviewPolicyResultsForHitResponse = (ListReviewPolicyResultsForHitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReviewPolicyResultsForHIT").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listReviewPolicyResultsForHitRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReviewPolicyResultsForHitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReviewPolicyResultsForHitResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$listReviewPolicyResultsForHIT$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReviewableHiTsResponse listReviewableHITs(ListReviewableHiTsRequest listReviewableHiTsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReviewableHiTsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listReviewableHiTsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, listReviewableHiTsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReviewableHITs");
            ListReviewableHiTsResponse listReviewableHiTsResponse = (ListReviewableHiTsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReviewableHITs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listReviewableHiTsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReviewableHiTsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReviewableHiTsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$listReviewableHITs$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorkerBlocksResponse listWorkerBlocks(ListWorkerBlocksRequest listWorkerBlocksRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkerBlocksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listWorkerBlocksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, listWorkerBlocksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkerBlocks");
            ListWorkerBlocksResponse listWorkerBlocksResponse = (ListWorkerBlocksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkerBlocks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listWorkerBlocksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWorkerBlocksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorkerBlocksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$listWorkerBlocks$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorkersWithQualificationTypeResponse listWorkersWithQualificationType(ListWorkersWithQualificationTypeRequest listWorkersWithQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkersWithQualificationTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listWorkersWithQualificationTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, listWorkersWithQualificationTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkersWithQualificationType");
            ListWorkersWithQualificationTypeResponse listWorkersWithQualificationTypeResponse = (ListWorkersWithQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkersWithQualificationType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listWorkersWithQualificationTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWorkersWithQualificationTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorkersWithQualificationTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$listWorkersWithQualificationType$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifyWorkersResponse notifyWorkers(NotifyWorkersRequest notifyWorkersRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, NotifyWorkersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)notifyWorkersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, notifyWorkersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"NotifyWorkers");
            NotifyWorkersResponse notifyWorkersResponse = (NotifyWorkersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("NotifyWorkers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)notifyWorkersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new NotifyWorkersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return notifyWorkersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$notifyWorkers$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RejectAssignmentResponse rejectAssignment(RejectAssignmentRequest rejectAssignmentRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectAssignmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rejectAssignmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, rejectAssignmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectAssignment");
            RejectAssignmentResponse rejectAssignmentResponse = (RejectAssignmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectAssignment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rejectAssignmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RejectAssignmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rejectAssignmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$rejectAssignment$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RejectQualificationRequestResponse rejectQualificationRequest(RejectQualificationRequestRequest rejectQualificationRequestRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectQualificationRequestResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rejectQualificationRequestRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, rejectQualificationRequestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectQualificationRequest");
            RejectQualificationRequestResponse rejectQualificationRequestResponse = (RejectQualificationRequestResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectQualificationRequest").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rejectQualificationRequestRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RejectQualificationRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rejectQualificationRequestResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$rejectQualificationRequest$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendBonusResponse sendBonus(SendBonusRequest sendBonusRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendBonusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendBonusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, sendBonusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendBonus");
            SendBonusResponse sendBonusResponse = (SendBonusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendBonus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)sendBonusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendBonusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return sendBonusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$sendBonus$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendTestEventNotificationResponse sendTestEventNotification(SendTestEventNotificationRequest sendTestEventNotificationRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendTestEventNotificationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendTestEventNotificationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, sendTestEventNotificationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendTestEventNotification");
            SendTestEventNotificationResponse sendTestEventNotificationResponse = (SendTestEventNotificationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendTestEventNotification").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)sendTestEventNotificationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendTestEventNotificationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return sendTestEventNotificationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$sendTestEventNotification$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateExpirationForHitResponse updateExpirationForHIT(UpdateExpirationForHitRequest updateExpirationForHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateExpirationForHitResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateExpirationForHitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, updateExpirationForHitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateExpirationForHIT");
            UpdateExpirationForHitResponse updateExpirationForHitResponse = (UpdateExpirationForHitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateExpirationForHIT").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateExpirationForHitRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateExpirationForHitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateExpirationForHitResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$updateExpirationForHIT$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateHitReviewStatusResponse updateHITReviewStatus(UpdateHitReviewStatusRequest updateHitReviewStatusRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateHitReviewStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateHitReviewStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, updateHitReviewStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateHITReviewStatus");
            UpdateHitReviewStatusResponse updateHitReviewStatusResponse = (UpdateHitReviewStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateHITReviewStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateHitReviewStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateHitReviewStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateHitReviewStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$updateHITReviewStatus$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateHitTypeOfHitResponse updateHITTypeOfHIT(UpdateHitTypeOfHitRequest updateHitTypeOfHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateHitTypeOfHitResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateHitTypeOfHitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, updateHitTypeOfHitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateHITTypeOfHIT");
            UpdateHitTypeOfHitResponse updateHitTypeOfHitResponse = (UpdateHitTypeOfHitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateHITTypeOfHIT").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateHitTypeOfHitRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateHitTypeOfHitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateHitTypeOfHitResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$updateHITTypeOfHIT$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNotificationSettingsResponse updateNotificationSettings(UpdateNotificationSettingsRequest updateNotificationSettingsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNotificationSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateNotificationSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, updateNotificationSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNotificationSettings");
            UpdateNotificationSettingsResponse updateNotificationSettingsResponse = (UpdateNotificationSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNotificationSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateNotificationSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateNotificationSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateNotificationSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$updateNotificationSettings$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateQualificationTypeResponse updateQualificationType(UpdateQualificationTypeRequest updateQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateQualificationTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "RequestError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateQualificationTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(clientConfiguration, updateQualificationTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateQualificationType");
            UpdateQualificationTypeResponse updateQualificationTypeResponse = (UpdateQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateQualificationType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateQualificationTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateQualificationTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateQualificationTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMTurkClient.lambda$updateQualificationType$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "mturk-requester";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        MTurkServiceClientConfigurationBuilder serviceConfigBuilder = new MTurkServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MTurkException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final MTurkServiceClientConfiguration serviceClientConfiguration() {
        return new MTurkServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateQualificationType$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateNotificationSettings$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateHITTypeOfHIT$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateHITReviewStatus$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateExpirationForHIT$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendTestEventNotification$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendBonus$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rejectQualificationRequest$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rejectAssignment$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$notifyWorkers$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorkersWithQualificationType$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorkerBlocks$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReviewableHITs$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReviewPolicyResultsForHIT$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listQualificationTypes$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listQualificationRequests$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listHITsForQualificationType$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listHITs$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBonusPayments$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssignmentsForHIT$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getQualificationType$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getQualificationScore$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getHIT$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFileUploadURL$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAssignment$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccountBalance$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateQualificationFromWorker$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWorkerBlock$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteQualificationType$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteHIT$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorkerBlock$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createQualificationType$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createHITWithHITType$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createHITType$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createHIT$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAdditionalAssignmentsForHIT$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateQualificationWithWorker$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$approveAssignment$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acceptQualificationRequest$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

