/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBonusPaymentsRequest extends MTurkRequest implements
        ToCopyableBuilder<ListBonusPaymentsRequest.Builder, ListBonusPaymentsRequest> {
    private static final SdkField<String> HIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListBonusPaymentsRequest::hitId)).setter(setter(Builder::hitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITId").build()).build();

    private static final SdkField<String> ASSIGNMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListBonusPaymentsRequest::assignmentId)).setter(setter(Builder::assignmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListBonusPaymentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListBonusPaymentsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIT_ID_FIELD,
            ASSIGNMENT_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String hitId;

    private final String assignmentId;

    private final String nextToken;

    private final Integer maxResults;

    private ListBonusPaymentsRequest(BuilderImpl builder) {
        super(builder);
        this.hitId = builder.hitId;
        this.assignmentId = builder.assignmentId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the HIT associated with the bonus payments to retrieve. If not specified, all bonus payments for all
     * assignments for the given HIT are returned. Either the HITId parameter or the AssignmentId parameter must be
     * specified
     * </p>
     * 
     * @return The ID of the HIT associated with the bonus payments to retrieve. If not specified, all bonus payments
     *         for all assignments for the given HIT are returned. Either the HITId parameter or the AssignmentId
     *         parameter must be specified
     */
    public String hitId() {
        return hitId;
    }

    /**
     * <p>
     * The ID of the assignment associated with the bonus payments to retrieve. If specified, only bonus payments for
     * the given assignment are returned. Either the HITId parameter or the AssignmentId parameter must be specified
     * </p>
     * 
     * @return The ID of the assignment associated with the bonus payments to retrieve. If specified, only bonus
     *         payments for the given assignment are returned. Either the HITId parameter or the AssignmentId parameter
     *         must be specified
     */
    public String assignmentId() {
        return assignmentId;
    }

    /**
     * <p>
     * Pagination token
     * </p>
     * 
     * @return Pagination token
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hitId());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBonusPaymentsRequest)) {
            return false;
        }
        ListBonusPaymentsRequest other = (ListBonusPaymentsRequest) obj;
        return Objects.equals(hitId(), other.hitId()) && Objects.equals(assignmentId(), other.assignmentId())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListBonusPaymentsRequest").add("HITId", hitId()).add("AssignmentId", assignmentId())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HITId":
            return Optional.ofNullable(clazz.cast(hitId()));
        case "AssignmentId":
            return Optional.ofNullable(clazz.cast(assignmentId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBonusPaymentsRequest, T> g) {
        return obj -> g.apply((ListBonusPaymentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListBonusPaymentsRequest> {
        /**
         * <p>
         * The ID of the HIT associated with the bonus payments to retrieve. If not specified, all bonus payments for
         * all assignments for the given HIT are returned. Either the HITId parameter or the AssignmentId parameter must
         * be specified
         * </p>
         * 
         * @param hitId
         *        The ID of the HIT associated with the bonus payments to retrieve. If not specified, all bonus payments
         *        for all assignments for the given HIT are returned. Either the HITId parameter or the AssignmentId
         *        parameter must be specified
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitId(String hitId);

        /**
         * <p>
         * The ID of the assignment associated with the bonus payments to retrieve. If specified, only bonus payments
         * for the given assignment are returned. Either the HITId parameter or the AssignmentId parameter must be
         * specified
         * </p>
         * 
         * @param assignmentId
         *        The ID of the assignment associated with the bonus payments to retrieve. If specified, only bonus
         *        payments for the given assignment are returned. Either the HITId parameter or the AssignmentId
         *        parameter must be specified
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentId(String assignmentId);

        /**
         * <p>
         * Pagination token
         * </p>
         * 
         * @param nextToken
         *        Pagination token
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String hitId;

        private String assignmentId;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBonusPaymentsRequest model) {
            super(model);
            hitId(model.hitId);
            assignmentId(model.assignmentId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getHitId() {
            return hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final void setHitId(String hitId) {
            this.hitId = hitId;
        }

        public final String getAssignmentId() {
            return assignmentId;
        }

        @Override
        public final Builder assignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
            return this;
        }

        public final void setAssignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBonusPaymentsRequest build() {
            return new ListBonusPaymentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
