/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Qualification data structure represents a Qualification assigned to a user, including the Qualification type and
 * the value (score).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Qualification implements SdkPojo, Serializable, ToCopyableBuilder<Qualification.Builder, Qualification> {
    private static final SdkField<String> QUALIFICATION_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Qualification::qualificationTypeId)).setter(setter(Builder::qualificationTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationTypeId").build())
            .build();

    private static final SdkField<String> WORKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Qualification::workerId)).setter(setter(Builder::workerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerId").build()).build();

    private static final SdkField<Instant> GRANT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Qualification::grantTime)).setter(setter(Builder::grantTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantTime").build()).build();

    private static final SdkField<Integer> INTEGER_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Qualification::integerValue)).setter(setter(Builder::integerValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerValue").build()).build();

    private static final SdkField<Locale> LOCALE_VALUE_FIELD = SdkField.<Locale> builder(MarshallingType.SDK_POJO)
            .getter(getter(Qualification::localeValue)).setter(setter(Builder::localeValue)).constructor(Locale::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocaleValue").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Qualification::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUALIFICATION_TYPE_ID_FIELD,
            WORKER_ID_FIELD, GRANT_TIME_FIELD, INTEGER_VALUE_FIELD, LOCALE_VALUE_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String qualificationTypeId;

    private final String workerId;

    private final Instant grantTime;

    private final Integer integerValue;

    private final Locale localeValue;

    private final String status;

    private Qualification(BuilderImpl builder) {
        this.qualificationTypeId = builder.qualificationTypeId;
        this.workerId = builder.workerId;
        this.grantTime = builder.grantTime;
        this.integerValue = builder.integerValue;
        this.localeValue = builder.localeValue;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the Qualification type for the Qualification.
     * </p>
     * 
     * @return The ID of the Qualification type for the Qualification.
     */
    public String qualificationTypeId() {
        return qualificationTypeId;
    }

    /**
     * <p>
     * The ID of the Worker who possesses the Qualification.
     * </p>
     * 
     * @return The ID of the Worker who possesses the Qualification.
     */
    public String workerId() {
        return workerId;
    }

    /**
     * <p>
     * The date and time the Qualification was granted to the Worker. If the Worker's Qualification was revoked, and
     * then re-granted based on a new Qualification request, GrantTime is the date and time of the last call to the
     * AcceptQualificationRequest operation.
     * </p>
     * 
     * @return The date and time the Qualification was granted to the Worker. If the Worker's Qualification was revoked,
     *         and then re-granted based on a new Qualification request, GrantTime is the date and time of the last call
     *         to the AcceptQualificationRequest operation.
     */
    public Instant grantTime() {
        return grantTime;
    }

    /**
     * <p>
     * The value (score) of the Qualification, if the Qualification has an integer value.
     * </p>
     * 
     * @return The value (score) of the Qualification, if the Qualification has an integer value.
     */
    public Integer integerValue() {
        return integerValue;
    }

    /**
     * Returns the value of the LocaleValue property for this object.
     * 
     * @return The value of the LocaleValue property for this object.
     */
    public Locale localeValue() {
        return localeValue;
    }

    /**
     * <p>
     * The status of the Qualification. Valid values are Granted | Revoked.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QualificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Qualification. Valid values are Granted | Revoked.
     * @see QualificationStatus
     */
    public QualificationStatus status() {
        return QualificationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Qualification. Valid values are Granted | Revoked.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QualificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Qualification. Valid values are Granted | Revoked.
     * @see QualificationStatus
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(qualificationTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(workerId());
        hashCode = 31 * hashCode + Objects.hashCode(grantTime());
        hashCode = 31 * hashCode + Objects.hashCode(integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(localeValue());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Qualification)) {
            return false;
        }
        Qualification other = (Qualification) obj;
        return Objects.equals(qualificationTypeId(), other.qualificationTypeId()) && Objects.equals(workerId(), other.workerId())
                && Objects.equals(grantTime(), other.grantTime()) && Objects.equals(integerValue(), other.integerValue())
                && Objects.equals(localeValue(), other.localeValue()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Qualification").add("QualificationTypeId", qualificationTypeId()).add("WorkerId", workerId())
                .add("GrantTime", grantTime()).add("IntegerValue", integerValue()).add("LocaleValue", localeValue())
                .add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QualificationTypeId":
            return Optional.ofNullable(clazz.cast(qualificationTypeId()));
        case "WorkerId":
            return Optional.ofNullable(clazz.cast(workerId()));
        case "GrantTime":
            return Optional.ofNullable(clazz.cast(grantTime()));
        case "IntegerValue":
            return Optional.ofNullable(clazz.cast(integerValue()));
        case "LocaleValue":
            return Optional.ofNullable(clazz.cast(localeValue()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Qualification, T> g) {
        return obj -> g.apply((Qualification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Qualification> {
        /**
         * <p>
         * The ID of the Qualification type for the Qualification.
         * </p>
         * 
         * @param qualificationTypeId
         *        The ID of the Qualification type for the Qualification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationTypeId(String qualificationTypeId);

        /**
         * <p>
         * The ID of the Worker who possesses the Qualification.
         * </p>
         * 
         * @param workerId
         *        The ID of the Worker who possesses the Qualification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerId(String workerId);

        /**
         * <p>
         * The date and time the Qualification was granted to the Worker. If the Worker's Qualification was revoked, and
         * then re-granted based on a new Qualification request, GrantTime is the date and time of the last call to the
         * AcceptQualificationRequest operation.
         * </p>
         * 
         * @param grantTime
         *        The date and time the Qualification was granted to the Worker. If the Worker's Qualification was
         *        revoked, and then re-granted based on a new Qualification request, GrantTime is the date and time of
         *        the last call to the AcceptQualificationRequest operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantTime(Instant grantTime);

        /**
         * <p>
         * The value (score) of the Qualification, if the Qualification has an integer value.
         * </p>
         * 
         * @param integerValue
         *        The value (score) of the Qualification, if the Qualification has an integer value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerValue(Integer integerValue);

        /**
         * Sets the value of the LocaleValue property for this object.
         *
         * @param localeValue
         *        The new value for the LocaleValue property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeValue(Locale localeValue);

        /**
         * Sets the value of the LocaleValue property for this object.
         *
         * This is a convenience that creates an instance of the {@link Locale.Builder} avoiding the need to create one
         * manually via {@link Locale#builder()}.
         *
         * When the {@link Consumer} completes, {@link Locale.Builder#build()} is called immediately and its result is
         * passed to {@link #localeValue(Locale)}.
         * 
         * @param localeValue
         *        a consumer that will call methods on {@link Locale.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localeValue(Locale)
         */
        default Builder localeValue(Consumer<Locale.Builder> localeValue) {
            return localeValue(Locale.builder().applyMutation(localeValue).build());
        }

        /**
         * <p>
         * The status of the Qualification. Valid values are Granted | Revoked.
         * </p>
         * 
         * @param status
         *        The status of the Qualification. Valid values are Granted | Revoked.
         * @see QualificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualificationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Qualification. Valid values are Granted | Revoked.
         * </p>
         * 
         * @param status
         *        The status of the Qualification. Valid values are Granted | Revoked.
         * @see QualificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualificationStatus
         */
        Builder status(QualificationStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String qualificationTypeId;

        private String workerId;

        private Instant grantTime;

        private Integer integerValue;

        private Locale localeValue;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Qualification model) {
            qualificationTypeId(model.qualificationTypeId);
            workerId(model.workerId);
            grantTime(model.grantTime);
            integerValue(model.integerValue);
            localeValue(model.localeValue);
            status(model.status);
        }

        public final String getQualificationTypeId() {
            return qualificationTypeId;
        }

        @Override
        public final Builder qualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
            return this;
        }

        public final void setQualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
        }

        public final String getWorkerId() {
            return workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        public final Instant getGrantTime() {
            return grantTime;
        }

        @Override
        public final Builder grantTime(Instant grantTime) {
            this.grantTime = grantTime;
            return this;
        }

        public final void setGrantTime(Instant grantTime) {
            this.grantTime = grantTime;
        }

        public final Integer getIntegerValue() {
            return integerValue;
        }

        @Override
        public final Builder integerValue(Integer integerValue) {
            this.integerValue = integerValue;
            return this;
        }

        public final void setIntegerValue(Integer integerValue) {
            this.integerValue = integerValue;
        }

        public final Locale.Builder getLocaleValue() {
            return localeValue != null ? localeValue.toBuilder() : null;
        }

        @Override
        public final Builder localeValue(Locale localeValue) {
            this.localeValue = localeValue;
            return this;
        }

        public final void setLocaleValue(Locale.BuilderImpl localeValue) {
            this.localeValue = localeValue != null ? localeValue.build() : null;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QualificationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Qualification build() {
            return new Qualification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
