/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.EventType;
import software.amazon.awssdk.services.mturk.model.EventTypeListCopier;
import software.amazon.awssdk.services.mturk.model.NotificationTransport;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationSpecification> {
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotificationSpecification.getter(NotificationSpecification::destination)).setter(NotificationSpecification.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<String> TRANSPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotificationSpecification.getter(NotificationSpecification::transportAsString)).setter(NotificationSpecification.setter(Builder::transport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transport").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotificationSpecification.getter(NotificationSpecification::version)).setter(NotificationSpecification.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<List<String>> EVENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(NotificationSpecification.getter(NotificationSpecification::eventTypesAsStrings)).setter(NotificationSpecification.setter(Builder::eventTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD, TRANSPORT_FIELD, VERSION_FIELD, EVENT_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String destination;
    private final String transport;
    private final String version;
    private final List<String> eventTypes;

    private NotificationSpecification(BuilderImpl builder) {
        this.destination = builder.destination;
        this.transport = builder.transport;
        this.version = builder.version;
        this.eventTypes = builder.eventTypes;
    }

    public String destination() {
        return this.destination;
    }

    public NotificationTransport transport() {
        return NotificationTransport.fromValue(this.transport);
    }

    public String transportAsString() {
        return this.transport;
    }

    public String version() {
        return this.version;
    }

    public List<EventType> eventTypes() {
        return EventTypeListCopier.copyStringToEnum(this.eventTypes);
    }

    public List<String> eventTypesAsStrings() {
        return this.eventTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.transportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationSpecification)) {
            return false;
        }
        NotificationSpecification other = (NotificationSpecification)obj;
        return Objects.equals(this.destination(), other.destination()) && Objects.equals(this.transportAsString(), other.transportAsString()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.eventTypesAsStrings(), other.eventTypesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"NotificationSpecification").add("Destination", (Object)this.destination()).add("Transport", (Object)this.transportAsString()).add("Version", (Object)this.version()).add("EventTypes", this.eventTypesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Transport": {
                return Optional.ofNullable(clazz.cast(this.transportAsString()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "EventTypes": {
                return Optional.ofNullable(clazz.cast(this.eventTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationSpecification, T> g) {
        return obj -> g.apply((NotificationSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destination;
        private String transport;
        private String version;
        private List<String> eventTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationSpecification model) {
            this.destination(model.destination);
            this.transport(model.transport);
            this.version(model.version);
            this.eventTypesWithStrings(model.eventTypes);
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final String getTransportAsString() {
            return this.transport;
        }

        @Override
        public final Builder transport(String transport) {
            this.transport = transport;
            return this;
        }

        @Override
        public final Builder transport(NotificationTransport transport) {
            this.transport(transport.toString());
            return this;
        }

        public final void setTransport(String transport) {
            this.transport = transport;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Collection<String> getEventTypesAsStrings() {
            return this.eventTypes;
        }

        @Override
        public final Builder eventTypesWithStrings(Collection<String> eventTypes) {
            this.eventTypes = EventTypeListCopier.copy(eventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypesWithStrings(String ... eventTypes) {
            this.eventTypesWithStrings(Arrays.asList(eventTypes));
            return this;
        }

        @Override
        public final Builder eventTypes(Collection<EventType> eventTypes) {
            this.eventTypes = EventTypeListCopier.copyEnumToString(eventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypes(EventType ... eventTypes) {
            this.eventTypes(Arrays.asList(eventTypes));
            return this;
        }

        public final void setEventTypesWithStrings(Collection<String> eventTypes) {
            this.eventTypes = EventTypeListCopier.copy(eventTypes);
        }

        public NotificationSpecification build() {
            return new NotificationSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationSpecification> {
        public Builder destination(String var1);

        public Builder transport(String var1);

        public Builder transport(NotificationTransport var1);

        public Builder version(String var1);

        public Builder eventTypesWithStrings(Collection<String> var1);

        public Builder eventTypesWithStrings(String ... var1);

        public Builder eventTypes(Collection<EventType> var1);

        public Builder eventTypes(EventType ... var1);
    }
}

