/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mturk.model.ReviewActionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReviewActionDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReviewActionDetail> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReviewActionDetail.getter(ReviewActionDetail::actionId)).setter(ReviewActionDetail.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()}).build();
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReviewActionDetail.getter(ReviewActionDetail::actionName)).setter(ReviewActionDetail.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReviewActionDetail.getter(ReviewActionDetail::targetId)).setter(ReviewActionDetail.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReviewActionDetail.getter(ReviewActionDetail::targetType)).setter(ReviewActionDetail.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReviewActionDetail.getter(ReviewActionDetail::statusAsString)).setter(ReviewActionDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> COMPLETE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ReviewActionDetail.getter(ReviewActionDetail::completeTime)).setter(ReviewActionDetail.setter(Builder::completeTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompleteTime").build()}).build();
    private static final SdkField<String> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReviewActionDetail.getter(ReviewActionDetail::result)).setter(ReviewActionDetail.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReviewActionDetail.getter(ReviewActionDetail::errorCode)).setter(ReviewActionDetail.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD, ACTION_NAME_FIELD, TARGET_ID_FIELD, TARGET_TYPE_FIELD, STATUS_FIELD, COMPLETE_TIME_FIELD, RESULT_FIELD, ERROR_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionId;
    private final String actionName;
    private final String targetId;
    private final String targetType;
    private final String status;
    private final Instant completeTime;
    private final String result;
    private final String errorCode;

    private ReviewActionDetail(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.actionName = builder.actionName;
        this.targetId = builder.targetId;
        this.targetType = builder.targetType;
        this.status = builder.status;
        this.completeTime = builder.completeTime;
        this.result = builder.result;
        this.errorCode = builder.errorCode;
    }

    public String actionId() {
        return this.actionId;
    }

    public String actionName() {
        return this.actionName;
    }

    public String targetId() {
        return this.targetId;
    }

    public String targetType() {
        return this.targetType;
    }

    public ReviewActionStatus status() {
        return ReviewActionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant completeTime() {
        return this.completeTime;
    }

    public String result() {
        return this.result;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.completeTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewActionDetail)) {
            return false;
        }
        ReviewActionDetail other = (ReviewActionDetail)obj;
        return Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.targetType(), other.targetType()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.completeTime(), other.completeTime()) && Objects.equals(this.result(), other.result()) && Objects.equals(this.errorCode(), other.errorCode());
    }

    public String toString() {
        return ToString.builder((String)"ReviewActionDetail").add("ActionId", (Object)this.actionId()).add("ActionName", (Object)this.actionName()).add("TargetId", (Object)this.targetId()).add("TargetType", (Object)this.targetType()).add("Status", (Object)this.statusAsString()).add("CompleteTime", (Object)this.completeTime()).add("Result", (Object)this.result()).add("ErrorCode", (Object)this.errorCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "ActionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "TargetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetType()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CompleteTime": {
                return Optional.ofNullable(clazz.cast(this.completeTime()));
            }
            case "Result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReviewActionDetail, T> g) {
        return obj -> g.apply((ReviewActionDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionId;
        private String actionName;
        private String targetId;
        private String targetType;
        private String status;
        private Instant completeTime;
        private String result;
        private String errorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewActionDetail model) {
            this.actionId(model.actionId);
            this.actionName(model.actionName);
            this.targetId(model.targetId);
            this.targetType(model.targetType);
            this.status(model.status);
            this.completeTime(model.completeTime);
            this.result(model.result);
            this.errorCode(model.errorCode);
        }

        public final String getActionId() {
            return this.actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getActionName() {
            return this.actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReviewActionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCompleteTime() {
            return this.completeTime;
        }

        @Override
        public final Builder completeTime(Instant completeTime) {
            this.completeTime = completeTime;
            return this;
        }

        public final void setCompleteTime(Instant completeTime) {
            this.completeTime = completeTime;
        }

        public final String getResult() {
            return this.result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ReviewActionDetail build() {
            return new ReviewActionDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReviewActionDetail> {
        public Builder actionId(String var1);

        public Builder actionName(String var1);

        public Builder targetId(String var1);

        public Builder targetType(String var1);

        public Builder status(String var1);

        public Builder status(ReviewActionStatus var1);

        public Builder completeTime(Instant var1);

        public Builder result(String var1);

        public Builder errorCode(String var1);
    }
}

