/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendTestEventNotificationRequest extends MTurkRequest implements
        ToCopyableBuilder<SendTestEventNotificationRequest.Builder, SendTestEventNotificationRequest> {
    private static final SdkField<NotificationSpecification> NOTIFICATION_FIELD = SdkField
            .<NotificationSpecification> builder(MarshallingType.SDK_POJO)
            .getter(getter(SendTestEventNotificationRequest::notification)).setter(setter(Builder::notification))
            .constructor(NotificationSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notification").build()).build();

    private static final SdkField<String> TEST_EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SendTestEventNotificationRequest::testEventTypeAsString)).setter(setter(Builder::testEventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestEventType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_FIELD,
            TEST_EVENT_TYPE_FIELD));

    private final NotificationSpecification notification;

    private final String testEventType;

    private SendTestEventNotificationRequest(BuilderImpl builder) {
        super(builder);
        this.notification = builder.notification;
        this.testEventType = builder.testEventType;
    }

    /**
     * <p>
     * The notification specification to test. This value is identical to the value you would provide to the
     * UpdateNotificationSettings operation when you establish the notification specification for a HIT type.
     * </p>
     * 
     * @return The notification specification to test. This value is identical to the value you would provide to the
     *         UpdateNotificationSettings operation when you establish the notification specification for a HIT type.
     */
    public NotificationSpecification notification() {
        return notification;
    }

    /**
     * <p>
     * The event to simulate to test the notification specification. This event is included in the test message even if
     * the notification specification does not include the event type. The notification specification does not filter
     * out the test event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #testEventType}
     * will return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #testEventTypeAsString}.
     * </p>
     * 
     * @return The event to simulate to test the notification specification. This event is included in the test message
     *         even if the notification specification does not include the event type. The notification specification
     *         does not filter out the test event.
     * @see EventType
     */
    public EventType testEventType() {
        return EventType.fromValue(testEventType);
    }

    /**
     * <p>
     * The event to simulate to test the notification specification. This event is included in the test message even if
     * the notification specification does not include the event type. The notification specification does not filter
     * out the test event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #testEventType}
     * will return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #testEventTypeAsString}.
     * </p>
     * 
     * @return The event to simulate to test the notification specification. This event is included in the test message
     *         even if the notification specification does not include the event type. The notification specification
     *         does not filter out the test event.
     * @see EventType
     */
    public String testEventTypeAsString() {
        return testEventType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notification());
        hashCode = 31 * hashCode + Objects.hashCode(testEventTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendTestEventNotificationRequest)) {
            return false;
        }
        SendTestEventNotificationRequest other = (SendTestEventNotificationRequest) obj;
        return Objects.equals(notification(), other.notification())
                && Objects.equals(testEventTypeAsString(), other.testEventTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SendTestEventNotificationRequest").add("Notification", notification())
                .add("TestEventType", testEventTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Notification":
            return Optional.ofNullable(clazz.cast(notification()));
        case "TestEventType":
            return Optional.ofNullable(clazz.cast(testEventTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendTestEventNotificationRequest, T> g) {
        return obj -> g.apply((SendTestEventNotificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendTestEventNotificationRequest> {
        /**
         * <p>
         * The notification specification to test. This value is identical to the value you would provide to the
         * UpdateNotificationSettings operation when you establish the notification specification for a HIT type.
         * </p>
         * 
         * @param notification
         *        The notification specification to test. This value is identical to the value you would provide to the
         *        UpdateNotificationSettings operation when you establish the notification specification for a HIT type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(NotificationSpecification notification);

        /**
         * <p>
         * The notification specification to test. This value is identical to the value you would provide to the
         * UpdateNotificationSettings operation when you establish the notification specification for a HIT type.
         * </p>
         * This is a convenience that creates an instance of the {@link NotificationSpecification.Builder} avoiding the
         * need to create one manually via {@link NotificationSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotificationSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #notification(NotificationSpecification)}.
         * 
         * @param notification
         *        a consumer that will call methods on {@link NotificationSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notification(NotificationSpecification)
         */
        default Builder notification(Consumer<NotificationSpecification.Builder> notification) {
            return notification(NotificationSpecification.builder().applyMutation(notification).build());
        }

        /**
         * <p>
         * The event to simulate to test the notification specification. This event is included in the test message even
         * if the notification specification does not include the event type. The notification specification does not
         * filter out the test event.
         * </p>
         * 
         * @param testEventType
         *        The event to simulate to test the notification specification. This event is included in the test
         *        message even if the notification specification does not include the event type. The notification
         *        specification does not filter out the test event.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder testEventType(String testEventType);

        /**
         * <p>
         * The event to simulate to test the notification specification. This event is included in the test message even
         * if the notification specification does not include the event type. The notification specification does not
         * filter out the test event.
         * </p>
         * 
         * @param testEventType
         *        The event to simulate to test the notification specification. This event is included in the test
         *        message even if the notification specification does not include the event type. The notification
         *        specification does not filter out the test event.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder testEventType(EventType testEventType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private NotificationSpecification notification;

        private String testEventType;

        private BuilderImpl() {
        }

        private BuilderImpl(SendTestEventNotificationRequest model) {
            super(model);
            notification(model.notification);
            testEventType(model.testEventType);
        }

        public final NotificationSpecification.Builder getNotification() {
            return notification != null ? notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(NotificationSpecification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(NotificationSpecification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final String getTestEventTypeAsString() {
            return testEventType;
        }

        @Override
        public final Builder testEventType(String testEventType) {
            this.testEventType = testEventType;
            return this;
        }

        @Override
        public final Builder testEventType(EventType testEventType) {
            this.testEventType(testEventType == null ? null : testEventType.toString());
            return this;
        }

        public final void setTestEventType(String testEventType) {
            this.testEventType = testEventType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendTestEventNotificationRequest build() {
            return new SendTestEventNotificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
