/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaa.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Internal only API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatisticSet implements SdkPojo, Serializable, ToCopyableBuilder<StatisticSet.Builder, StatisticSet> {
    private static final SdkField<Double> MAXIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Maximum")
            .getter(getter(StatisticSet::maximum)).setter(setter(Builder::maximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maximum").build()).build();

    private static final SdkField<Double> MINIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Minimum")
            .getter(getter(StatisticSet::minimum)).setter(setter(Builder::minimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Minimum").build()).build();

    private static final SdkField<Integer> SAMPLE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SampleCount").getter(getter(StatisticSet::sampleCount)).setter(setter(Builder::sampleCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleCount").build()).build();

    private static final SdkField<Double> SUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Sum")
            .getter(getter(StatisticSet::sum)).setter(setter(Builder::sum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sum").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_FIELD, MINIMUM_FIELD,
            SAMPLE_COUNT_FIELD, SUM_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double maximum;

    private final Double minimum;

    private final Integer sampleCount;

    private final Double sum;

    private StatisticSet(BuilderImpl builder) {
        this.maximum = builder.maximum;
        this.minimum = builder.minimum;
        this.sampleCount = builder.sampleCount;
        this.sum = builder.sum;
    }

    /**
     * <p>
     * Internal only API.
     * </p>
     * 
     * @return Internal only API.
     */
    public final Double maximum() {
        return maximum;
    }

    /**
     * <p>
     * Internal only API.
     * </p>
     * 
     * @return Internal only API.
     */
    public final Double minimum() {
        return minimum;
    }

    /**
     * <p>
     * Internal only API.
     * </p>
     * 
     * @return Internal only API.
     */
    public final Integer sampleCount() {
        return sampleCount;
    }

    /**
     * <p>
     * Internal only API.
     * </p>
     * 
     * @return Internal only API.
     */
    public final Double sum() {
        return sum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximum());
        hashCode = 31 * hashCode + Objects.hashCode(minimum());
        hashCode = 31 * hashCode + Objects.hashCode(sampleCount());
        hashCode = 31 * hashCode + Objects.hashCode(sum());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatisticSet)) {
            return false;
        }
        StatisticSet other = (StatisticSet) obj;
        return Objects.equals(maximum(), other.maximum()) && Objects.equals(minimum(), other.minimum())
                && Objects.equals(sampleCount(), other.sampleCount()) && Objects.equals(sum(), other.sum());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatisticSet").add("Maximum", maximum()).add("Minimum", minimum())
                .add("SampleCount", sampleCount()).add("Sum", sum()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Maximum":
            return Optional.ofNullable(clazz.cast(maximum()));
        case "Minimum":
            return Optional.ofNullable(clazz.cast(minimum()));
        case "SampleCount":
            return Optional.ofNullable(clazz.cast(sampleCount()));
        case "Sum":
            return Optional.ofNullable(clazz.cast(sum()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatisticSet, T> g) {
        return obj -> g.apply((StatisticSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatisticSet> {
        /**
         * <p>
         * Internal only API.
         * </p>
         * 
         * @param maximum
         *        Internal only API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Double maximum);

        /**
         * <p>
         * Internal only API.
         * </p>
         * 
         * @param minimum
         *        Internal only API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(Double minimum);

        /**
         * <p>
         * Internal only API.
         * </p>
         * 
         * @param sampleCount
         *        Internal only API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleCount(Integer sampleCount);

        /**
         * <p>
         * Internal only API.
         * </p>
         * 
         * @param sum
         *        Internal only API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sum(Double sum);
    }

    static final class BuilderImpl implements Builder {
        private Double maximum;

        private Double minimum;

        private Integer sampleCount;

        private Double sum;

        private BuilderImpl() {
        }

        private BuilderImpl(StatisticSet model) {
            maximum(model.maximum);
            minimum(model.minimum);
            sampleCount(model.sampleCount);
            sum(model.sum);
        }

        public final Double getMaximum() {
            return maximum;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        @Override
        @Transient
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final Double getMinimum() {
            return minimum;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        @Override
        @Transient
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final Integer getSampleCount() {
            return sampleCount;
        }

        public final void setSampleCount(Integer sampleCount) {
            this.sampleCount = sampleCount;
        }

        @Override
        @Transient
        public final Builder sampleCount(Integer sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public final Double getSum() {
            return sum;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        @Override
        @Transient
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        @Override
        public StatisticSet build() {
            return new StatisticSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
