/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEnvironmentResponse extends MwaaResponse implements
        ToCopyableBuilder<GetEnvironmentResponse.Builder, GetEnvironmentResponse> {
    private static final SdkField<Environment> ENVIRONMENT_FIELD = SdkField.<Environment> builder(MarshallingType.SDK_POJO)
            .memberName("Environment").getter(getter(GetEnvironmentResponse::environment)).setter(setter(Builder::environment))
            .constructor(Environment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_FIELD));

    private final Environment environment;

    private GetEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.environment = builder.environment;
    }

    /**
     * <p>
     * An object containing all available details about the environment.
     * </p>
     * 
     * @return An object containing all available details about the environment.
     */
    public final Environment environment() {
        return environment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnvironmentResponse)) {
            return false;
        }
        GetEnvironmentResponse other = (GetEnvironmentResponse) obj;
        return Objects.equals(environment(), other.environment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEnvironmentResponse").add("Environment", environment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEnvironmentResponse, T> g) {
        return obj -> g.apply((GetEnvironmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MwaaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEnvironmentResponse> {
        /**
         * <p>
         * An object containing all available details about the environment.
         * </p>
         * 
         * @param environment
         *        An object containing all available details about the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Environment environment);

        /**
         * <p>
         * An object containing all available details about the environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link Environment.Builder} avoiding the need to
         * create one manually via {@link Environment#builder()}.
         *
         * When the {@link Consumer} completes, {@link Environment.Builder#build()} is called immediately and its result
         * is passed to {@link #environment(Environment)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link Environment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(Environment)
         */
        default Builder environment(Consumer<Environment.Builder> environment) {
            return environment(Environment.builder().applyMutation(environment).build());
        }
    }

    static final class BuilderImpl extends MwaaResponse.BuilderImpl implements Builder {
        private Environment environment;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnvironmentResponse model) {
            super(model);
            environment(model.environment);
        }

        public final Environment.Builder getEnvironment() {
            return environment != null ? environment.toBuilder() : null;
        }

        public final void setEnvironment(Environment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        public final Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public GetEnvironmentResponse build() {
            return new GetEnvironmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
