/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon Managed Workflows for Apache Airflow (MWAA) environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Environment implements SdkPojo, Serializable, ToCopyableBuilder<Environment.Builder, Environment> {
    private static final SdkField<Map<String, String>> AIRFLOW_CONFIGURATION_OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AirflowConfigurationOptions")
            .getter(getter(Environment::airflowConfigurationOptions))
            .setter(setter(Builder::airflowConfigurationOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowConfigurationOptions")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> AIRFLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AirflowVersion").getter(getter(Environment::airflowVersion)).setter(setter(Builder::airflowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowVersion").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Environment::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(Environment::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> DAG_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DagS3Path").getter(getter(Environment::dagS3Path)).setter(setter(Builder::dagS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagS3Path").build()).build();

    private static final SdkField<String> ENVIRONMENT_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentClass").getter(getter(Environment::environmentClass))
            .setter(setter(Builder::environmentClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentClass").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(Environment::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KmsKey")
            .getter(getter(Environment::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()).build();

    private static final SdkField<LastUpdate> LAST_UPDATE_FIELD = SdkField.<LastUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("LastUpdate").getter(getter(Environment::lastUpdate)).setter(setter(Builder::lastUpdate))
            .constructor(LastUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdate").build()).build();

    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField
            .<LoggingConfiguration> builder(MarshallingType.SDK_POJO).memberName("LoggingConfiguration")
            .getter(getter(Environment::loggingConfiguration)).setter(setter(Builder::loggingConfiguration))
            .constructor(LoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build())
            .build();

    private static final SdkField<Integer> MAX_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxWorkers").getter(getter(Environment::maxWorkers)).setter(setter(Builder::maxWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWorkers").build()).build();

    private static final SdkField<Integer> MIN_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinWorkers").getter(getter(Environment::minWorkers)).setter(setter(Builder::minWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinWorkers").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Environment::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("NetworkConfiguration")
            .getter(getter(Environment::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build())
            .build();

    private static final SdkField<String> PLUGINS_S3_OBJECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PluginsS3ObjectVersion").getter(getter(Environment::pluginsS3ObjectVersion))
            .setter(setter(Builder::pluginsS3ObjectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginsS3ObjectVersion").build())
            .build();

    private static final SdkField<String> PLUGINS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PluginsS3Path").getter(getter(Environment::pluginsS3Path)).setter(setter(Builder::pluginsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginsS3Path").build()).build();

    private static final SdkField<String> REQUIREMENTS_S3_OBJECT_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequirementsS3ObjectVersion")
            .getter(getter(Environment::requirementsS3ObjectVersion))
            .setter(setter(Builder::requirementsS3ObjectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirementsS3ObjectVersion")
                    .build()).build();

    private static final SdkField<String> REQUIREMENTS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequirementsS3Path").getter(getter(Environment::requirementsS3Path))
            .setter(setter(Builder::requirementsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirementsS3Path").build())
            .build();

    private static final SdkField<Integer> SCHEDULERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Schedulers").getter(getter(Environment::schedulers)).setter(setter(Builder::schedulers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedulers").build()).build();

    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRoleArn").getter(getter(Environment::serviceRoleArn)).setter(setter(Builder::serviceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()).build();

    private static final SdkField<String> SOURCE_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceBucketArn").getter(getter(Environment::sourceBucketArn)).setter(setter(Builder::sourceBucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBucketArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Environment::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Environment::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WEBSERVER_ACCESS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebserverAccessMode").getter(getter(Environment::webserverAccessModeAsString))
            .setter(setter(Builder::webserverAccessMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverAccessMode").build())
            .build();

    private static final SdkField<String> WEBSERVER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebserverUrl").getter(getter(Environment::webserverUrl)).setter(setter(Builder::webserverUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverUrl").build()).build();

    private static final SdkField<String> WEEKLY_MAINTENANCE_WINDOW_START_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WeeklyMaintenanceWindowStart")
            .getter(getter(Environment::weeklyMaintenanceWindowStart))
            .setter(setter(Builder::weeklyMaintenanceWindowStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceWindowStart")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AIRFLOW_CONFIGURATION_OPTIONS_FIELD, AIRFLOW_VERSION_FIELD, ARN_FIELD, CREATED_AT_FIELD, DAG_S3_PATH_FIELD,
            ENVIRONMENT_CLASS_FIELD, EXECUTION_ROLE_ARN_FIELD, KMS_KEY_FIELD, LAST_UPDATE_FIELD, LOGGING_CONFIGURATION_FIELD,
            MAX_WORKERS_FIELD, MIN_WORKERS_FIELD, NAME_FIELD, NETWORK_CONFIGURATION_FIELD, PLUGINS_S3_OBJECT_VERSION_FIELD,
            PLUGINS_S3_PATH_FIELD, REQUIREMENTS_S3_OBJECT_VERSION_FIELD, REQUIREMENTS_S3_PATH_FIELD, SCHEDULERS_FIELD,
            SERVICE_ROLE_ARN_FIELD, SOURCE_BUCKET_ARN_FIELD, STATUS_FIELD, TAGS_FIELD, WEBSERVER_ACCESS_MODE_FIELD,
            WEBSERVER_URL_FIELD, WEEKLY_MAINTENANCE_WINDOW_START_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> airflowConfigurationOptions;

    private final String airflowVersion;

    private final String arn;

    private final Instant createdAt;

    private final String dagS3Path;

    private final String environmentClass;

    private final String executionRoleArn;

    private final String kmsKey;

    private final LastUpdate lastUpdate;

    private final LoggingConfiguration loggingConfiguration;

    private final Integer maxWorkers;

    private final Integer minWorkers;

    private final String name;

    private final NetworkConfiguration networkConfiguration;

    private final String pluginsS3ObjectVersion;

    private final String pluginsS3Path;

    private final String requirementsS3ObjectVersion;

    private final String requirementsS3Path;

    private final Integer schedulers;

    private final String serviceRoleArn;

    private final String sourceBucketArn;

    private final String status;

    private final Map<String, String> tags;

    private final String webserverAccessMode;

    private final String webserverUrl;

    private final String weeklyMaintenanceWindowStart;

    private Environment(BuilderImpl builder) {
        this.airflowConfigurationOptions = builder.airflowConfigurationOptions;
        this.airflowVersion = builder.airflowVersion;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.dagS3Path = builder.dagS3Path;
        this.environmentClass = builder.environmentClass;
        this.executionRoleArn = builder.executionRoleArn;
        this.kmsKey = builder.kmsKey;
        this.lastUpdate = builder.lastUpdate;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.maxWorkers = builder.maxWorkers;
        this.minWorkers = builder.minWorkers;
        this.name = builder.name;
        this.networkConfiguration = builder.networkConfiguration;
        this.pluginsS3ObjectVersion = builder.pluginsS3ObjectVersion;
        this.pluginsS3Path = builder.pluginsS3Path;
        this.requirementsS3ObjectVersion = builder.requirementsS3ObjectVersion;
        this.requirementsS3Path = builder.requirementsS3Path;
        this.schedulers = builder.schedulers;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.sourceBucketArn = builder.sourceBucketArn;
        this.status = builder.status;
        this.tags = builder.tags;
        this.webserverAccessMode = builder.webserverAccessMode;
        this.webserverUrl = builder.webserverUrl;
        this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
    }

    /**
     * For responses, this returns true if the service returned a value for the AirflowConfigurationOptions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAirflowConfigurationOptions() {
        return airflowConfigurationOptions != null && !(airflowConfigurationOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs containing the Apache Airflow configuration options attached to your environment. To
     * learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache
     * Airflow configuration options</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAirflowConfigurationOptions} method.
     * </p>
     * 
     * @return A list of key-value pairs containing the Apache Airflow configuration options attached to your
     *         environment. To learn more, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow
     *         configuration options</a>.
     */
    public final Map<String, String> airflowConfigurationOptions() {
        return airflowConfigurationOptions;
    }

    /**
     * <p>
     * The Apache Airflow version on your environment. Valid values: <code>1.10.12</code>, <code>2.0.2</code>,
     * <code>2.2.2</code>, and <code>2.4.3</code>.
     * </p>
     * 
     * @return The Apache Airflow version on your environment. Valid values: <code>1.10.12</code>, <code>2.0.2</code>,
     *         <code>2.2.2</code>, and <code>2.4.3</code>.
     */
    public final String airflowVersion() {
        return airflowVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon MWAA environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon MWAA environment.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The day and time the environment was created.
     * </p>
     * 
     * @return The day and time the environment was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. To learn more, see
     * <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating
     * DAGs</a>.
     * </p>
     * 
     * @return The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. To learn
     *         more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding
     *         or updating DAGs</a>.
     */
    public final String dagS3Path() {
        return dagS3Path;
    }

    /**
     * <p>
     * The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>
     * . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon
     * MWAA environment class</a>.
     * </p>
     * 
     * @return The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>,
     *         <code>mw1.large</code>. To learn more, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment
     *         class</a>.
     */
    public final String environmentClass() {
        return environmentClass;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web Services
     * resources in your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. To learn
     * more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution
     * role</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web
     *         Services resources in your environment. For example,
     *         <code>arn:aws:iam::123456789:role/my-execution-role</code>. To learn more, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution
     *         role</a>.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (KMS) encryption key used to encrypt the data in your environment.
     * </p>
     * 
     * @return The Amazon Web Services Key Management Service (KMS) encryption key used to encrypt the data in your
     *         environment.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The status of the last update on the environment.
     * </p>
     * 
     * @return The status of the last update on the environment.
     */
    public final LastUpdate lastUpdate() {
        return lastUpdate;
    }

    /**
     * <p>
     * The Apache Airflow logs published to CloudWatch Logs.
     * </p>
     * 
     * @return The Apache Airflow logs published to CloudWatch Logs.
     */
    public final LoggingConfiguration loggingConfiguration() {
        return loggingConfiguration;
    }

    /**
     * <p>
     * The maximum number of workers that run in your environment. For example, <code>20</code>.
     * </p>
     * 
     * @return The maximum number of workers that run in your environment. For example, <code>20</code>.
     */
    public final Integer maxWorkers() {
        return maxWorkers;
    }

    /**
     * <p>
     * The minimum number of workers that run in your environment. For example, <code>2</code>.
     * </p>
     * 
     * @return The minimum number of workers that run in your environment. For example, <code>2</code>.
     */
    public final Integer minWorkers() {
        return minWorkers;
    }

    /**
     * <p>
     * The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.
     * </p>
     * 
     * @return The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Describes the VPC networking components used to secure and enable network traffic between the Amazon Web Services
     * resources for your environment. To learn more, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon
     * MWAA</a>.
     * </p>
     * 
     * @return Describes the VPC networking components used to secure and enable network traffic between the Amazon Web
     *         Services resources for your environment. To learn more, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon
     *         MWAA</a>.
     */
    public final NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom
     * plugins</a>.
     * </p>
     * 
     * @return The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing
     *         custom plugins</a>.
     */
    public final String pluginsS3ObjectVersion() {
        return pluginsS3ObjectVersion;
    }

    /**
     * <p>
     * The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example,
     * <code>plugins.zip</code>. To learn more, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom
     * plugins</a>.
     * </p>
     * 
     * @return The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example,
     *         <code>plugins.zip</code>. To learn more, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing
     *         custom plugins</a>.
     */
    public final String pluginsS3Path() {
        return pluginsS3Path;
    }

    /**
     * <p>
     * The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python
     * dependencies</a>.
     * </p>
     * 
     * @return The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python
     *         dependencies</a>.
     */
    public final String requirementsS3ObjectVersion() {
        return requirementsS3ObjectVersion;
    }

    /**
     * <p>
     * The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example,
     * <code>requirements.txt</code>. To learn more, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python
     * dependencies</a>.
     * </p>
     * 
     * @return The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example,
     *         <code>requirements.txt</code>. To learn more, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python
     *         dependencies</a>.
     */
    public final String requirementsS3Path() {
        return requirementsS3Path;
    }

    /**
     * <p>
     * The number of Apache Airflow schedulers that run in your Amazon MWAA environment.
     * </p>
     * 
     * @return The number of Apache Airflow schedulers that run in your Amazon MWAA environment.
     */
    public final Integer schedulers() {
        return schedulers;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the service-linked role of the environment. To learn more, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html">Amazon MWAA Service-linked role</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the service-linked role of the environment. To learn more, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html">Amazon MWAA Service-linked
     *         role</a>.
     */
    public final String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For
     * example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. To learn more, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for
     * Amazon MWAA</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are
     *         stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. To learn more, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket
     *         for Amazon MWAA</a>.
     */
    public final String sourceBucketArn() {
        return sourceBucketArn;
    }

    /**
     * <p>
     * The status of the Amazon MWAA environment. Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - Indicates the request to create the environment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment could
     * not be created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - Indicates the request to update the environment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - Indicates the request to delete the environment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment has been
     * deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNAVAILABLE</code> - Indicates the request failed, but the environment was unable to rollback and is not in
     * a stable state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment has
     * rolled back successfully and is ready to use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. To learn more,
     * see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA
     * troubleshooting</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon MWAA environment. Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - Indicates the request to create the environment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment
     *         could not be created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - Indicates the request to update the environment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - Indicates the request to delete the environment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment
     *         has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNAVAILABLE</code> - Indicates the request failed, but the environment was unable to rollback and
     *         is not in a stable state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment
     *         has rolled back successfully and is ready to use.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. To
     *         learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon
     *         MWAA troubleshooting</a>.
     * @see EnvironmentStatus
     */
    public final EnvironmentStatus status() {
        return EnvironmentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Amazon MWAA environment. Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - Indicates the request to create the environment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment could
     * not be created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - Indicates the request to update the environment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - Indicates the request to delete the environment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment has been
     * deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNAVAILABLE</code> - Indicates the request failed, but the environment was unable to rollback and is not in
     * a stable state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment has
     * rolled back successfully and is ready to use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. To learn more,
     * see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA
     * troubleshooting</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon MWAA environment. Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - Indicates the request to create the environment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment
     *         could not be created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - Indicates the request to update the environment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - Indicates the request to delete the environment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment
     *         has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNAVAILABLE</code> - Indicates the request failed, but the environment was unable to rollback and
     *         is not in a stable state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment
     *         has rolled back successfully and is ready to use.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. To
     *         learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon
     *         MWAA troubleshooting</a>.
     * @see EnvironmentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value tag pairs associated to your environment. For example, <code>"Environment": "Staging"</code>. To
     * learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web
     * Services resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key-value tag pairs associated to your environment. For example,
     *         <code>"Environment": "Staging"</code>. To learn more, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The Apache Airflow <i>Web server</i> access mode. To learn more, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access
     * modes</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webserverAccessMode} will return {@link WebserverAccessMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #webserverAccessModeAsString}.
     * </p>
     * 
     * @return The Apache Airflow <i>Web server</i> access mode. To learn more, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow
     *         access modes</a>.
     * @see WebserverAccessMode
     */
    public final WebserverAccessMode webserverAccessMode() {
        return WebserverAccessMode.fromValue(webserverAccessMode);
    }

    /**
     * <p>
     * The Apache Airflow <i>Web server</i> access mode. To learn more, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access
     * modes</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webserverAccessMode} will return {@link WebserverAccessMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #webserverAccessModeAsString}.
     * </p>
     * 
     * @return The Apache Airflow <i>Web server</i> access mode. To learn more, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow
     *         access modes</a>.
     * @see WebserverAccessMode
     */
    public final String webserverAccessModeAsString() {
        return webserverAccessMode;
    }

    /**
     * <p>
     * The Apache Airflow <i>Web server</i> host name for the Amazon MWAA environment. To learn more, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html">Accessing the Apache Airflow
     * UI</a>.
     * </p>
     * 
     * @return The Apache Airflow <i>Web server</i> host name for the Amazon MWAA environment. To learn more, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html">Accessing the Apache
     *         Airflow UI</a>.
     */
    public final String webserverUrl() {
        return webserverUrl;
    }

    /**
     * <p>
     * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly maintenance
     * updates are scheduled. For example: <code>TUE:03:30</code>.
     * </p>
     * 
     * @return The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly
     *         maintenance updates are scheduled. For example: <code>TUE:03:30</code>.
     */
    public final String weeklyMaintenanceWindowStart() {
        return weeklyMaintenanceWindowStart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAirflowConfigurationOptions() ? airflowConfigurationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(airflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(dagS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(environmentClass());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(maxWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(minWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(pluginsS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(pluginsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(requirementsS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(requirementsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(schedulers());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(webserverAccessModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(webserverUrl());
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceWindowStart());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Environment)) {
            return false;
        }
        Environment other = (Environment) obj;
        return hasAirflowConfigurationOptions() == other.hasAirflowConfigurationOptions()
                && Objects.equals(airflowConfigurationOptions(), other.airflowConfigurationOptions())
                && Objects.equals(airflowVersion(), other.airflowVersion()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(dagS3Path(), other.dagS3Path())
                && Objects.equals(environmentClass(), other.environmentClass())
                && Objects.equals(executionRoleArn(), other.executionRoleArn()) && Objects.equals(kmsKey(), other.kmsKey())
                && Objects.equals(lastUpdate(), other.lastUpdate())
                && Objects.equals(loggingConfiguration(), other.loggingConfiguration())
                && Objects.equals(maxWorkers(), other.maxWorkers()) && Objects.equals(minWorkers(), other.minWorkers())
                && Objects.equals(name(), other.name()) && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(pluginsS3ObjectVersion(), other.pluginsS3ObjectVersion())
                && Objects.equals(pluginsS3Path(), other.pluginsS3Path())
                && Objects.equals(requirementsS3ObjectVersion(), other.requirementsS3ObjectVersion())
                && Objects.equals(requirementsS3Path(), other.requirementsS3Path())
                && Objects.equals(schedulers(), other.schedulers()) && Objects.equals(serviceRoleArn(), other.serviceRoleArn())
                && Objects.equals(sourceBucketArn(), other.sourceBucketArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(webserverAccessModeAsString(), other.webserverAccessModeAsString())
                && Objects.equals(webserverUrl(), other.webserverUrl())
                && Objects.equals(weeklyMaintenanceWindowStart(), other.weeklyMaintenanceWindowStart());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("Environment")
                .add("AirflowConfigurationOptions",
                        airflowConfigurationOptions() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AirflowVersion", airflowVersion()).add("Arn", arn()).add("CreatedAt", createdAt())
                .add("DagS3Path", dagS3Path()).add("EnvironmentClass", environmentClass())
                .add("ExecutionRoleArn", executionRoleArn()).add("KmsKey", kmsKey()).add("LastUpdate", lastUpdate())
                .add("LoggingConfiguration", loggingConfiguration()).add("MaxWorkers", maxWorkers())
                .add("MinWorkers", minWorkers()).add("Name", name()).add("NetworkConfiguration", networkConfiguration())
                .add("PluginsS3ObjectVersion", pluginsS3ObjectVersion()).add("PluginsS3Path", pluginsS3Path())
                .add("RequirementsS3ObjectVersion", requirementsS3ObjectVersion())
                .add("RequirementsS3Path", requirementsS3Path()).add("Schedulers", schedulers())
                .add("ServiceRoleArn", serviceRoleArn()).add("SourceBucketArn", sourceBucketArn())
                .add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null)
                .add("WebserverAccessMode", webserverAccessModeAsString()).add("WebserverUrl", webserverUrl())
                .add("WeeklyMaintenanceWindowStart", weeklyMaintenanceWindowStart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AirflowConfigurationOptions":
            return Optional.ofNullable(clazz.cast(airflowConfigurationOptions()));
        case "AirflowVersion":
            return Optional.ofNullable(clazz.cast(airflowVersion()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "DagS3Path":
            return Optional.ofNullable(clazz.cast(dagS3Path()));
        case "EnvironmentClass":
            return Optional.ofNullable(clazz.cast(environmentClass()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "KmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "LastUpdate":
            return Optional.ofNullable(clazz.cast(lastUpdate()));
        case "LoggingConfiguration":
            return Optional.ofNullable(clazz.cast(loggingConfiguration()));
        case "MaxWorkers":
            return Optional.ofNullable(clazz.cast(maxWorkers()));
        case "MinWorkers":
            return Optional.ofNullable(clazz.cast(minWorkers()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NetworkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "PluginsS3ObjectVersion":
            return Optional.ofNullable(clazz.cast(pluginsS3ObjectVersion()));
        case "PluginsS3Path":
            return Optional.ofNullable(clazz.cast(pluginsS3Path()));
        case "RequirementsS3ObjectVersion":
            return Optional.ofNullable(clazz.cast(requirementsS3ObjectVersion()));
        case "RequirementsS3Path":
            return Optional.ofNullable(clazz.cast(requirementsS3Path()));
        case "Schedulers":
            return Optional.ofNullable(clazz.cast(schedulers()));
        case "ServiceRoleArn":
            return Optional.ofNullable(clazz.cast(serviceRoleArn()));
        case "SourceBucketArn":
            return Optional.ofNullable(clazz.cast(sourceBucketArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "WebserverAccessMode":
            return Optional.ofNullable(clazz.cast(webserverAccessModeAsString()));
        case "WebserverUrl":
            return Optional.ofNullable(clazz.cast(webserverUrl()));
        case "WeeklyMaintenanceWindowStart":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceWindowStart()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Environment, T> g) {
        return obj -> g.apply((Environment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Environment> {
        /**
         * <p>
         * A list of key-value pairs containing the Apache Airflow configuration options attached to your environment.
         * To learn more, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow
         * configuration options</a>.
         * </p>
         * 
         * @param airflowConfigurationOptions
         *        A list of key-value pairs containing the Apache Airflow configuration options attached to your
         *        environment. To learn more, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow
         *        configuration options</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder airflowConfigurationOptions(Map<String, String> airflowConfigurationOptions);

        /**
         * <p>
         * The Apache Airflow version on your environment. Valid values: <code>1.10.12</code>, <code>2.0.2</code>,
         * <code>2.2.2</code>, and <code>2.4.3</code>.
         * </p>
         * 
         * @param airflowVersion
         *        The Apache Airflow version on your environment. Valid values: <code>1.10.12</code>, <code>2.0.2</code>
         *        , <code>2.2.2</code>, and <code>2.4.3</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder airflowVersion(String airflowVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon MWAA environment.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The day and time the environment was created.
         * </p>
         * 
         * @param createdAt
         *        The day and time the environment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. To learn more,
         * see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or
         * updating DAGs</a>.
         * </p>
         * 
         * @param dagS3Path
         *        The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. To
         *        learn more, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or
         *        updating DAGs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dagS3Path(String dagS3Path);

        /**
         * <p>
         * The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>,
         * <code>mw1.large</code>. To learn more, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment
         * class</a>.
         * </p>
         * 
         * @param environmentClass
         *        The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>,
         *        <code>mw1.large</code>. To learn more, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA
         *        environment class</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentClass(String environmentClass);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web Services
         * resources in your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. To
         * learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA
         * Execution role</a>.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web
         *        Services resources in your environment. For example,
         *        <code>arn:aws:iam::123456789:role/my-execution-role</code>. To learn more, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution
         *        role</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The Amazon Web Services Key Management Service (KMS) encryption key used to encrypt the data in your
         * environment.
         * </p>
         * 
         * @param kmsKey
         *        The Amazon Web Services Key Management Service (KMS) encryption key used to encrypt the data in your
         *        environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The status of the last update on the environment.
         * </p>
         * 
         * @param lastUpdate
         *        The status of the last update on the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdate(LastUpdate lastUpdate);

        /**
         * <p>
         * The status of the last update on the environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link LastUpdate.Builder} avoiding the need to
         * create one manually via {@link LastUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LastUpdate.Builder#build()} is called immediately and its result
         * is passed to {@link #lastUpdate(LastUpdate)}.
         * 
         * @param lastUpdate
         *        a consumer that will call methods on {@link LastUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastUpdate(LastUpdate)
         */
        default Builder lastUpdate(Consumer<LastUpdate.Builder> lastUpdate) {
            return lastUpdate(LastUpdate.builder().applyMutation(lastUpdate).build());
        }

        /**
         * <p>
         * The Apache Airflow logs published to CloudWatch Logs.
         * </p>
         * 
         * @param loggingConfiguration
         *        The Apache Airflow logs published to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfiguration(LoggingConfiguration loggingConfiguration);

        /**
         * <p>
         * The Apache Airflow logs published to CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoggingConfiguration.Builder} avoiding
         * the need to create one manually via {@link LoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #loggingConfiguration(LoggingConfiguration)}.
         * 
         * @param loggingConfiguration
         *        a consumer that will call methods on {@link LoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfiguration(LoggingConfiguration)
         */
        default Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return loggingConfiguration(LoggingConfiguration.builder().applyMutation(loggingConfiguration).build());
        }

        /**
         * <p>
         * The maximum number of workers that run in your environment. For example, <code>20</code>.
         * </p>
         * 
         * @param maxWorkers
         *        The maximum number of workers that run in your environment. For example, <code>20</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWorkers(Integer maxWorkers);

        /**
         * <p>
         * The minimum number of workers that run in your environment. For example, <code>2</code>.
         * </p>
         * 
         * @param minWorkers
         *        The minimum number of workers that run in your environment. For example, <code>2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minWorkers(Integer minWorkers);

        /**
         * <p>
         * The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.
         * </p>
         * 
         * @param name
         *        The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Describes the VPC networking components used to secure and enable network traffic between the Amazon Web
         * Services resources for your environment. To learn more, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon
         * MWAA</a>.
         * </p>
         * 
         * @param networkConfiguration
         *        Describes the VPC networking components used to secure and enable network traffic between the Amazon
         *        Web Services resources for your environment. To learn more, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on
         *        Amazon MWAA</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * Describes the VPC networking components used to secure and enable network traffic between the Amazon Web
         * Services resources for your environment. To learn more, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon
         * MWAA</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing
         * custom plugins</a>.
         * </p>
         * 
         * @param pluginsS3ObjectVersion
         *        The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html"
         *        >Installing custom plugins</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginsS3ObjectVersion(String pluginsS3ObjectVersion);

        /**
         * <p>
         * The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example,
         * <code>plugins.zip</code>. To learn more, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing
         * custom plugins</a>.
         * </p>
         * 
         * @param pluginsS3Path
         *        The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example,
         *        <code>plugins.zip</code>. To learn more, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html"
         *        >Installing custom plugins</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginsS3Path(String pluginsS3Path);

        /**
         * <p>
         * The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python
         * dependencies</a>.
         * </p>
         * 
         * @param requirementsS3ObjectVersion
         *        The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing
         *        Python dependencies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requirementsS3ObjectVersion(String requirementsS3ObjectVersion);

        /**
         * <p>
         * The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example,
         * <code>requirements.txt</code>. To learn more, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python
         * dependencies</a>.
         * </p>
         * 
         * @param requirementsS3Path
         *        The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example,
         *        <code>requirements.txt</code>. To learn more, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing
         *        Python dependencies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requirementsS3Path(String requirementsS3Path);

        /**
         * <p>
         * The number of Apache Airflow schedulers that run in your Amazon MWAA environment.
         * </p>
         * 
         * @param schedulers
         *        The number of Apache Airflow schedulers that run in your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedulers(Integer schedulers);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the service-linked role of the environment. To learn more, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html">Amazon MWAA Service-linked role</a>.
         * </p>
         * 
         * @param serviceRoleArn
         *        The Amazon Resource Name (ARN) for the service-linked role of the environment. To learn more, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html">Amazon MWAA Service-linked
         *        role</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored.
         * For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. To learn more, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for
         * Amazon MWAA</a>.
         * </p>
         * 
         * @param sourceBucketArn
         *        The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are
         *        stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. To learn more, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3
         *        bucket for Amazon MWAA</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBucketArn(String sourceBucketArn);

        /**
         * <p>
         * The status of the Amazon MWAA environment. Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - Indicates the request to create the environment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment
         * could not be created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - Indicates the request to update the environment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - Indicates the request to delete the environment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment has
         * been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNAVAILABLE</code> - Indicates the request failed, but the environment was unable to rollback and is
         * not in a stable state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment has
         * rolled back successfully and is ready to use.
         * </p>
         * </li>
         * </ul>
         * <p>
         * We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. To learn
         * more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA
         * troubleshooting</a>.
         * </p>
         * 
         * @param status
         *        The status of the Amazon MWAA environment. Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - Indicates the request to create the environment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the
         *        environment could not be created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - Indicates the request to update the environment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - Indicates the request to delete the environment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> - Indicates the request to delete the environment is complete, and the
         *        environment has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNAVAILABLE</code> - Indicates the request failed, but the environment was unable to rollback
         *        and is not in a stable state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the
         *        environment has rolled back successfully and is ready to use.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. To
         *        learn more, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA
         *        troubleshooting</a>.
         * @see EnvironmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Amazon MWAA environment. Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - Indicates the request to create the environment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment
         * could not be created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - Indicates the request to update the environment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - Indicates the request to delete the environment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment has
         * been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNAVAILABLE</code> - Indicates the request failed, but the environment was unable to rollback and is
         * not in a stable state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment has
         * rolled back successfully and is ready to use.
         * </p>
         * </li>
         * </ul>
         * <p>
         * We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. To learn
         * more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA
         * troubleshooting</a>.
         * </p>
         * 
         * @param status
         *        The status of the Amazon MWAA environment. Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - Indicates the request to create the environment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the
         *        environment could not be created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - Indicates the request to update the environment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - Indicates the request to delete the environment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> - Indicates the request to delete the environment is complete, and the
         *        environment has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNAVAILABLE</code> - Indicates the request failed, but the environment was unable to rollback
         *        and is not in a stable state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the
         *        environment has rolled back successfully and is ready to use.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. To
         *        learn more, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA
         *        troubleshooting</a>.
         * @see EnvironmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentStatus
         */
        Builder status(EnvironmentStatus status);

        /**
         * <p>
         * The key-value tag pairs associated to your environment. For example, <code>"Environment": "Staging"</code>.
         * To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon
         * Web Services resources</a>.
         * </p>
         * 
         * @param tags
         *        The key-value tag pairs associated to your environment. For example,
         *        <code>"Environment": "Staging"</code>. To learn more, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The Apache Airflow <i>Web server</i> access mode. To learn more, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access
         * modes</a>.
         * </p>
         * 
         * @param webserverAccessMode
         *        The Apache Airflow <i>Web server</i> access mode. To learn more, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow
         *        access modes</a>.
         * @see WebserverAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebserverAccessMode
         */
        Builder webserverAccessMode(String webserverAccessMode);

        /**
         * <p>
         * The Apache Airflow <i>Web server</i> access mode. To learn more, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access
         * modes</a>.
         * </p>
         * 
         * @param webserverAccessMode
         *        The Apache Airflow <i>Web server</i> access mode. To learn more, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow
         *        access modes</a>.
         * @see WebserverAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebserverAccessMode
         */
        Builder webserverAccessMode(WebserverAccessMode webserverAccessMode);

        /**
         * <p>
         * The Apache Airflow <i>Web server</i> host name for the Amazon MWAA environment. To learn more, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html">Accessing the Apache Airflow
         * UI</a>.
         * </p>
         * 
         * @param webserverUrl
         *        The Apache Airflow <i>Web server</i> host name for the Amazon MWAA environment. To learn more, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html">Accessing the Apache
         *        Airflow UI</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webserverUrl(String webserverUrl);

        /**
         * <p>
         * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly
         * maintenance updates are scheduled. For example: <code>TUE:03:30</code>.
         * </p>
         * 
         * @param weeklyMaintenanceWindowStart
         *        The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly
         *        maintenance updates are scheduled. For example: <code>TUE:03:30</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> airflowConfigurationOptions = DefaultSdkAutoConstructMap.getInstance();

        private String airflowVersion;

        private String arn;

        private Instant createdAt;

        private String dagS3Path;

        private String environmentClass;

        private String executionRoleArn;

        private String kmsKey;

        private LastUpdate lastUpdate;

        private LoggingConfiguration loggingConfiguration;

        private Integer maxWorkers;

        private Integer minWorkers;

        private String name;

        private NetworkConfiguration networkConfiguration;

        private String pluginsS3ObjectVersion;

        private String pluginsS3Path;

        private String requirementsS3ObjectVersion;

        private String requirementsS3Path;

        private Integer schedulers;

        private String serviceRoleArn;

        private String sourceBucketArn;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String webserverAccessMode;

        private String webserverUrl;

        private String weeklyMaintenanceWindowStart;

        private BuilderImpl() {
        }

        private BuilderImpl(Environment model) {
            airflowConfigurationOptions(model.airflowConfigurationOptions);
            airflowVersion(model.airflowVersion);
            arn(model.arn);
            createdAt(model.createdAt);
            dagS3Path(model.dagS3Path);
            environmentClass(model.environmentClass);
            executionRoleArn(model.executionRoleArn);
            kmsKey(model.kmsKey);
            lastUpdate(model.lastUpdate);
            loggingConfiguration(model.loggingConfiguration);
            maxWorkers(model.maxWorkers);
            minWorkers(model.minWorkers);
            name(model.name);
            networkConfiguration(model.networkConfiguration);
            pluginsS3ObjectVersion(model.pluginsS3ObjectVersion);
            pluginsS3Path(model.pluginsS3Path);
            requirementsS3ObjectVersion(model.requirementsS3ObjectVersion);
            requirementsS3Path(model.requirementsS3Path);
            schedulers(model.schedulers);
            serviceRoleArn(model.serviceRoleArn);
            sourceBucketArn(model.sourceBucketArn);
            status(model.status);
            tags(model.tags);
            webserverAccessMode(model.webserverAccessMode);
            webserverUrl(model.webserverUrl);
            weeklyMaintenanceWindowStart(model.weeklyMaintenanceWindowStart);
        }

        public final Map<String, String> getAirflowConfigurationOptions() {
            if (airflowConfigurationOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return airflowConfigurationOptions;
        }

        public final void setAirflowConfigurationOptions(Map<String, String> airflowConfigurationOptions) {
            this.airflowConfigurationOptions = AirflowConfigurationOptionsCopier.copy(airflowConfigurationOptions);
        }

        @Override
        public final Builder airflowConfigurationOptions(Map<String, String> airflowConfigurationOptions) {
            this.airflowConfigurationOptions = AirflowConfigurationOptionsCopier.copy(airflowConfigurationOptions);
            return this;
        }

        public final String getAirflowVersion() {
            return airflowVersion;
        }

        public final void setAirflowVersion(String airflowVersion) {
            this.airflowVersion = airflowVersion;
        }

        @Override
        public final Builder airflowVersion(String airflowVersion) {
            this.airflowVersion = airflowVersion;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDagS3Path() {
            return dagS3Path;
        }

        public final void setDagS3Path(String dagS3Path) {
            this.dagS3Path = dagS3Path;
        }

        @Override
        public final Builder dagS3Path(String dagS3Path) {
            this.dagS3Path = dagS3Path;
            return this;
        }

        public final String getEnvironmentClass() {
            return environmentClass;
        }

        public final void setEnvironmentClass(String environmentClass) {
            this.environmentClass = environmentClass;
        }

        @Override
        public final Builder environmentClass(String environmentClass) {
            this.environmentClass = environmentClass;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final LastUpdate.Builder getLastUpdate() {
            return lastUpdate != null ? lastUpdate.toBuilder() : null;
        }

        public final void setLastUpdate(LastUpdate.BuilderImpl lastUpdate) {
            this.lastUpdate = lastUpdate != null ? lastUpdate.build() : null;
        }

        @Override
        public final Builder lastUpdate(LastUpdate lastUpdate) {
            this.lastUpdate = lastUpdate;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return loggingConfiguration != null ? loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final Integer getMaxWorkers() {
            return maxWorkers;
        }

        public final void setMaxWorkers(Integer maxWorkers) {
            this.maxWorkers = maxWorkers;
        }

        @Override
        public final Builder maxWorkers(Integer maxWorkers) {
            this.maxWorkers = maxWorkers;
            return this;
        }

        public final Integer getMinWorkers() {
            return minWorkers;
        }

        public final void setMinWorkers(Integer minWorkers) {
            this.minWorkers = minWorkers;
        }

        @Override
        public final Builder minWorkers(Integer minWorkers) {
            this.minWorkers = minWorkers;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getPluginsS3ObjectVersion() {
            return pluginsS3ObjectVersion;
        }

        public final void setPluginsS3ObjectVersion(String pluginsS3ObjectVersion) {
            this.pluginsS3ObjectVersion = pluginsS3ObjectVersion;
        }

        @Override
        public final Builder pluginsS3ObjectVersion(String pluginsS3ObjectVersion) {
            this.pluginsS3ObjectVersion = pluginsS3ObjectVersion;
            return this;
        }

        public final String getPluginsS3Path() {
            return pluginsS3Path;
        }

        public final void setPluginsS3Path(String pluginsS3Path) {
            this.pluginsS3Path = pluginsS3Path;
        }

        @Override
        public final Builder pluginsS3Path(String pluginsS3Path) {
            this.pluginsS3Path = pluginsS3Path;
            return this;
        }

        public final String getRequirementsS3ObjectVersion() {
            return requirementsS3ObjectVersion;
        }

        public final void setRequirementsS3ObjectVersion(String requirementsS3ObjectVersion) {
            this.requirementsS3ObjectVersion = requirementsS3ObjectVersion;
        }

        @Override
        public final Builder requirementsS3ObjectVersion(String requirementsS3ObjectVersion) {
            this.requirementsS3ObjectVersion = requirementsS3ObjectVersion;
            return this;
        }

        public final String getRequirementsS3Path() {
            return requirementsS3Path;
        }

        public final void setRequirementsS3Path(String requirementsS3Path) {
            this.requirementsS3Path = requirementsS3Path;
        }

        @Override
        public final Builder requirementsS3Path(String requirementsS3Path) {
            this.requirementsS3Path = requirementsS3Path;
            return this;
        }

        public final Integer getSchedulers() {
            return schedulers;
        }

        public final void setSchedulers(Integer schedulers) {
            this.schedulers = schedulers;
        }

        @Override
        public final Builder schedulers(Integer schedulers) {
            this.schedulers = schedulers;
            return this;
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final String getSourceBucketArn() {
            return sourceBucketArn;
        }

        public final void setSourceBucketArn(String sourceBucketArn) {
            this.sourceBucketArn = sourceBucketArn;
        }

        @Override
        public final Builder sourceBucketArn(String sourceBucketArn) {
            this.sourceBucketArn = sourceBucketArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWebserverAccessMode() {
            return webserverAccessMode;
        }

        public final void setWebserverAccessMode(String webserverAccessMode) {
            this.webserverAccessMode = webserverAccessMode;
        }

        @Override
        public final Builder webserverAccessMode(String webserverAccessMode) {
            this.webserverAccessMode = webserverAccessMode;
            return this;
        }

        @Override
        public final Builder webserverAccessMode(WebserverAccessMode webserverAccessMode) {
            this.webserverAccessMode(webserverAccessMode == null ? null : webserverAccessMode.toString());
            return this;
        }

        public final String getWebserverUrl() {
            return webserverUrl;
        }

        public final void setWebserverUrl(String webserverUrl) {
            this.webserverUrl = webserverUrl;
        }

        @Override
        public final Builder webserverUrl(String webserverUrl) {
            this.webserverUrl = webserverUrl;
            return this;
        }

        public final String getWeeklyMaintenanceWindowStart() {
            return weeklyMaintenanceWindowStart;
        }

        public final void setWeeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
        }

        @Override
        public final Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        @Override
        public Environment build() {
            return new Environment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
