/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaa;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mwaa.DefaultMwaaAsyncClient;
import software.amazon.awssdk.services.mwaa.DefaultMwaaBaseClientBuilder;
import software.amazon.awssdk.services.mwaa.MwaaAsyncClient;
import software.amazon.awssdk.services.mwaa.MwaaAsyncClientBuilder;
import software.amazon.awssdk.services.mwaa.MwaaServiceClientConfiguration;
import software.amazon.awssdk.services.mwaa.endpoints.MwaaEndpointProvider;

@SdkInternalApi
final class DefaultMwaaAsyncClientBuilder
extends DefaultMwaaBaseClientBuilder<MwaaAsyncClientBuilder, MwaaAsyncClient>
implements MwaaAsyncClientBuilder {
    DefaultMwaaAsyncClientBuilder() {
    }

    @Override
    public DefaultMwaaAsyncClientBuilder endpointProvider(MwaaEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MwaaAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMwaaAsyncClientBuilder.validateClientOptions(clientConfiguration);
        MwaaServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMwaaAsyncClient client = new DefaultMwaaAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MwaaServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MwaaServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

