/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon Managed Workflows for Apache Airflow (MWAA) environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Environment implements SdkPojo, Serializable, ToCopyableBuilder<Environment.Builder, Environment> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Environment::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Environment::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Environment::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(Environment::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> WEBSERVER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebserverUrl").getter(getter(Environment::webserverUrl)).setter(setter(Builder::webserverUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverUrl").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(Environment::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRoleArn").getter(getter(Environment::serviceRoleArn)).setter(setter(Builder::serviceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KmsKey")
            .getter(getter(Environment::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()).build();

    private static final SdkField<String> AIRFLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AirflowVersion").getter(getter(Environment::airflowVersion)).setter(setter(Builder::airflowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowVersion").build()).build();

    private static final SdkField<String> SOURCE_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceBucketArn").getter(getter(Environment::sourceBucketArn)).setter(setter(Builder::sourceBucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBucketArn").build()).build();

    private static final SdkField<String> DAG_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DagS3Path").getter(getter(Environment::dagS3Path)).setter(setter(Builder::dagS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagS3Path").build()).build();

    private static final SdkField<String> PLUGINS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PluginsS3Path").getter(getter(Environment::pluginsS3Path)).setter(setter(Builder::pluginsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginsS3Path").build()).build();

    private static final SdkField<String> PLUGINS_S3_OBJECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PluginsS3ObjectVersion").getter(getter(Environment::pluginsS3ObjectVersion))
            .setter(setter(Builder::pluginsS3ObjectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginsS3ObjectVersion").build())
            .build();

    private static final SdkField<String> REQUIREMENTS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequirementsS3Path").getter(getter(Environment::requirementsS3Path))
            .setter(setter(Builder::requirementsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirementsS3Path").build())
            .build();

    private static final SdkField<String> REQUIREMENTS_S3_OBJECT_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequirementsS3ObjectVersion")
            .getter(getter(Environment::requirementsS3ObjectVersion))
            .setter(setter(Builder::requirementsS3ObjectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirementsS3ObjectVersion")
                    .build()).build();

    private static final SdkField<String> STARTUP_SCRIPT_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartupScriptS3Path").getter(getter(Environment::startupScriptS3Path))
            .setter(setter(Builder::startupScriptS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupScriptS3Path").build())
            .build();

    private static final SdkField<String> STARTUP_SCRIPT_S3_OBJECT_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StartupScriptS3ObjectVersion")
            .getter(getter(Environment::startupScriptS3ObjectVersion))
            .setter(setter(Builder::startupScriptS3ObjectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupScriptS3ObjectVersion")
                    .build()).build();

    private static final SdkField<Map<String, String>> AIRFLOW_CONFIGURATION_OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AirflowConfigurationOptions")
            .getter(getter(Environment::airflowConfigurationOptions))
            .setter(setter(Builder::airflowConfigurationOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowConfigurationOptions")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ENVIRONMENT_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentClass").getter(getter(Environment::environmentClass))
            .setter(setter(Builder::environmentClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentClass").build()).build();

    private static final SdkField<Integer> MAX_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxWorkers").getter(getter(Environment::maxWorkers)).setter(setter(Builder::maxWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWorkers").build()).build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("NetworkConfiguration")
            .getter(getter(Environment::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build())
            .build();

    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField
            .<LoggingConfiguration> builder(MarshallingType.SDK_POJO).memberName("LoggingConfiguration")
            .getter(getter(Environment::loggingConfiguration)).setter(setter(Builder::loggingConfiguration))
            .constructor(LoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build())
            .build();

    private static final SdkField<LastUpdate> LAST_UPDATE_FIELD = SdkField.<LastUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("LastUpdate").getter(getter(Environment::lastUpdate)).setter(setter(Builder::lastUpdate))
            .constructor(LastUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdate").build()).build();

    private static final SdkField<String> WEEKLY_MAINTENANCE_WINDOW_START_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WeeklyMaintenanceWindowStart")
            .getter(getter(Environment::weeklyMaintenanceWindowStart))
            .setter(setter(Builder::weeklyMaintenanceWindowStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceWindowStart")
                    .build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Environment::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WEBSERVER_ACCESS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebserverAccessMode").getter(getter(Environment::webserverAccessModeAsString))
            .setter(setter(Builder::webserverAccessMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverAccessMode").build())
            .build();

    private static final SdkField<Integer> MIN_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinWorkers").getter(getter(Environment::minWorkers)).setter(setter(Builder::minWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinWorkers").build()).build();

    private static final SdkField<Integer> SCHEDULERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Schedulers").getter(getter(Environment::schedulers)).setter(setter(Builder::schedulers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedulers").build()).build();

    private static final SdkField<String> WEBSERVER_VPC_ENDPOINT_SERVICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WebserverVpcEndpointService")
            .getter(getter(Environment::webserverVpcEndpointService))
            .setter(setter(Builder::webserverVpcEndpointService))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverVpcEndpointService")
                    .build()).build();

    private static final SdkField<String> DATABASE_VPC_ENDPOINT_SERVICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DatabaseVpcEndpointService")
            .getter(getter(Environment::databaseVpcEndpointService))
            .setter(setter(Builder::databaseVpcEndpointService))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseVpcEndpointService").build())
            .build();

    private static final SdkField<String> CELERY_EXECUTOR_QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CeleryExecutorQueue").getter(getter(Environment::celeryExecutorQueue))
            .setter(setter(Builder::celeryExecutorQueue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CeleryExecutorQueue").build())
            .build();

    private static final SdkField<String> ENDPOINT_MANAGEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointManagement").getter(getter(Environment::endpointManagementAsString))
            .setter(setter(Builder::endpointManagement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointManagement").build())
            .build();

    private static final SdkField<Integer> MIN_WEBSERVERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinWebservers").getter(getter(Environment::minWebservers)).setter(setter(Builder::minWebservers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinWebservers").build()).build();

    private static final SdkField<Integer> MAX_WEBSERVERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxWebservers").getter(getter(Environment::maxWebservers)).setter(setter(Builder::maxWebservers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWebservers").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD,
            ARN_FIELD, CREATED_AT_FIELD, WEBSERVER_URL_FIELD, EXECUTION_ROLE_ARN_FIELD, SERVICE_ROLE_ARN_FIELD, KMS_KEY_FIELD,
            AIRFLOW_VERSION_FIELD, SOURCE_BUCKET_ARN_FIELD, DAG_S3_PATH_FIELD, PLUGINS_S3_PATH_FIELD,
            PLUGINS_S3_OBJECT_VERSION_FIELD, REQUIREMENTS_S3_PATH_FIELD, REQUIREMENTS_S3_OBJECT_VERSION_FIELD,
            STARTUP_SCRIPT_S3_PATH_FIELD, STARTUP_SCRIPT_S3_OBJECT_VERSION_FIELD, AIRFLOW_CONFIGURATION_OPTIONS_FIELD,
            ENVIRONMENT_CLASS_FIELD, MAX_WORKERS_FIELD, NETWORK_CONFIGURATION_FIELD, LOGGING_CONFIGURATION_FIELD,
            LAST_UPDATE_FIELD, WEEKLY_MAINTENANCE_WINDOW_START_FIELD, TAGS_FIELD, WEBSERVER_ACCESS_MODE_FIELD, MIN_WORKERS_FIELD,
            SCHEDULERS_FIELD, WEBSERVER_VPC_ENDPOINT_SERVICE_FIELD, DATABASE_VPC_ENDPOINT_SERVICE_FIELD,
            CELERY_EXECUTOR_QUEUE_FIELD, ENDPOINT_MANAGEMENT_FIELD, MIN_WEBSERVERS_FIELD, MAX_WEBSERVERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String status;

    private final String arn;

    private final Instant createdAt;

    private final String webserverUrl;

    private final String executionRoleArn;

    private final String serviceRoleArn;

    private final String kmsKey;

    private final String airflowVersion;

    private final String sourceBucketArn;

    private final String dagS3Path;

    private final String pluginsS3Path;

    private final String pluginsS3ObjectVersion;

    private final String requirementsS3Path;

    private final String requirementsS3ObjectVersion;

    private final String startupScriptS3Path;

    private final String startupScriptS3ObjectVersion;

    private final Map<String, String> airflowConfigurationOptions;

    private final String environmentClass;

    private final Integer maxWorkers;

    private final NetworkConfiguration networkConfiguration;

    private final LoggingConfiguration loggingConfiguration;

    private final LastUpdate lastUpdate;

    private final String weeklyMaintenanceWindowStart;

    private final Map<String, String> tags;

    private final String webserverAccessMode;

    private final Integer minWorkers;

    private final Integer schedulers;

    private final String webserverVpcEndpointService;

    private final String databaseVpcEndpointService;

    private final String celeryExecutorQueue;

    private final String endpointManagement;

    private final Integer minWebservers;

    private final Integer maxWebservers;

    private Environment(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.webserverUrl = builder.webserverUrl;
        this.executionRoleArn = builder.executionRoleArn;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.kmsKey = builder.kmsKey;
        this.airflowVersion = builder.airflowVersion;
        this.sourceBucketArn = builder.sourceBucketArn;
        this.dagS3Path = builder.dagS3Path;
        this.pluginsS3Path = builder.pluginsS3Path;
        this.pluginsS3ObjectVersion = builder.pluginsS3ObjectVersion;
        this.requirementsS3Path = builder.requirementsS3Path;
        this.requirementsS3ObjectVersion = builder.requirementsS3ObjectVersion;
        this.startupScriptS3Path = builder.startupScriptS3Path;
        this.startupScriptS3ObjectVersion = builder.startupScriptS3ObjectVersion;
        this.airflowConfigurationOptions = builder.airflowConfigurationOptions;
        this.environmentClass = builder.environmentClass;
        this.maxWorkers = builder.maxWorkers;
        this.networkConfiguration = builder.networkConfiguration;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.lastUpdate = builder.lastUpdate;
        this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
        this.tags = builder.tags;
        this.webserverAccessMode = builder.webserverAccessMode;
        this.minWorkers = builder.minWorkers;
        this.schedulers = builder.schedulers;
        this.webserverVpcEndpointService = builder.webserverVpcEndpointService;
        this.databaseVpcEndpointService = builder.databaseVpcEndpointService;
        this.celeryExecutorQueue = builder.celeryExecutorQueue;
        this.endpointManagement = builder.endpointManagement;
        this.minWebservers = builder.minWebservers;
        this.maxWebservers = builder.maxWebservers;
    }

    /**
     * <p>
     * The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.
     * </p>
     * 
     * @return The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the Amazon MWAA environment.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - Indicates the request to create the environment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATING_SNAPSHOT</code> - Indicates the request to update environment details, or upgrade the environment
     * version, is in progress and Amazon MWAA is creating a storage volume snapshot of the Amazon RDS database cluster
     * associated with the environment. A database snapshot is a backup created at a specific point in time. Amazon MWAA
     * uses snapshots to recover environment metadata if the process to update or upgrade an environment fails.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment could
     * not be created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code> - Indicates the request was successful, but the process to create the environment is paused
     * until you create the required VPC endpoints in your VPC. After you create the VPC endpoints, the process resumes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - Indicates the request to update the environment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROLLING_BACK</code> - Indicates the request to update environment details, or upgrade the environment
     * version, failed and Amazon MWAA is restoring the environment using the latest storage volume snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - Indicates the request to delete the environment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment has been
     * deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNAVAILABLE</code> - Indicates the request failed, but the environment did not return to its previous state
     * and is not stable.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment was
     * restored to its previous state successfully and is ready to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MAINTENANCE</code> - Indicates that the environment is undergoing maintenance. Depending on the type of
     * work Amazon MWAA is performing, your environment might become unavailable during this process. After all
     * operations are done, your environment will return to its status prior to mainteneace operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. For more
     * information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA
     * troubleshooting</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon MWAA environment.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - Indicates the request to create the environment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATING_SNAPSHOT</code> - Indicates the request to update environment details, or upgrade the
     *         environment version, is in progress and Amazon MWAA is creating a storage volume snapshot of the Amazon
     *         RDS database cluster associated with the environment. A database snapshot is a backup created at a
     *         specific point in time. Amazon MWAA uses snapshots to recover environment metadata if the process to
     *         update or upgrade an environment fails.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment
     *         could not be created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - Indicates the request was successful, but the process to create the environment is
     *         paused until you create the required VPC endpoints in your VPC. After you create the VPC endpoints, the
     *         process resumes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - Indicates the request to update the environment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROLLING_BACK</code> - Indicates the request to update environment details, or upgrade the
     *         environment version, failed and Amazon MWAA is restoring the environment using the latest storage volume
     *         snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - Indicates the request to delete the environment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment
     *         has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNAVAILABLE</code> - Indicates the request failed, but the environment did not return to its
     *         previous state and is not stable.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment
     *         was restored to its previous state successfully and is ready to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MAINTENANCE</code> - Indicates that the environment is undergoing maintenance. Depending on the
     *         type of work Amazon MWAA is performing, your environment might become unavailable during this process.
     *         After all operations are done, your environment will return to its status prior to mainteneace
     *         operations.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA
     *         troubleshooting</a>.
     * @see EnvironmentStatus
     */
    public final EnvironmentStatus status() {
        return EnvironmentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Amazon MWAA environment.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - Indicates the request to create the environment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATING_SNAPSHOT</code> - Indicates the request to update environment details, or upgrade the environment
     * version, is in progress and Amazon MWAA is creating a storage volume snapshot of the Amazon RDS database cluster
     * associated with the environment. A database snapshot is a backup created at a specific point in time. Amazon MWAA
     * uses snapshots to recover environment metadata if the process to update or upgrade an environment fails.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment could
     * not be created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code> - Indicates the request was successful, but the process to create the environment is paused
     * until you create the required VPC endpoints in your VPC. After you create the VPC endpoints, the process resumes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - Indicates the request to update the environment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROLLING_BACK</code> - Indicates the request to update environment details, or upgrade the environment
     * version, failed and Amazon MWAA is restoring the environment using the latest storage volume snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - Indicates the request to delete the environment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment has been
     * deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNAVAILABLE</code> - Indicates the request failed, but the environment did not return to its previous state
     * and is not stable.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment was
     * restored to its previous state successfully and is ready to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MAINTENANCE</code> - Indicates that the environment is undergoing maintenance. Depending on the type of
     * work Amazon MWAA is performing, your environment might become unavailable during this process. After all
     * operations are done, your environment will return to its status prior to mainteneace operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. For more
     * information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA
     * troubleshooting</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon MWAA environment.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - Indicates the request to create the environment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATING_SNAPSHOT</code> - Indicates the request to update environment details, or upgrade the
     *         environment version, is in progress and Amazon MWAA is creating a storage volume snapshot of the Amazon
     *         RDS database cluster associated with the environment. A database snapshot is a backup created at a
     *         specific point in time. Amazon MWAA uses snapshots to recover environment metadata if the process to
     *         update or upgrade an environment fails.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment
     *         could not be created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - Indicates the request was successful, but the process to create the environment is
     *         paused until you create the required VPC endpoints in your VPC. After you create the VPC endpoints, the
     *         process resumes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - Indicates the request to update the environment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROLLING_BACK</code> - Indicates the request to update environment details, or upgrade the
     *         environment version, failed and Amazon MWAA is restoring the environment using the latest storage volume
     *         snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - Indicates the request to delete the environment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment
     *         has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNAVAILABLE</code> - Indicates the request failed, but the environment did not return to its
     *         previous state and is not stable.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment
     *         was restored to its previous state successfully and is ready to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MAINTENANCE</code> - Indicates that the environment is undergoing maintenance. Depending on the
     *         type of work Amazon MWAA is performing, your environment might become unavailable during this process.
     *         After all operations are done, your environment will return to its status prior to mainteneace
     *         operations.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA
     *         troubleshooting</a>.
     * @see EnvironmentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon MWAA environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon MWAA environment.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The day and time the environment was created.
     * </p>
     * 
     * @return The day and time the environment was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Apache Airflow <i>web server</i> host name for the Amazon MWAA environment. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html">Accessing the Apache Airflow
     * UI</a>.
     * </p>
     * 
     * @return The Apache Airflow <i>web server</i> host name for the Amazon MWAA environment. For more information, see
     *         <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html">Accessing the Apache
     *         Airflow UI</a>.
     */
    public final String webserverUrl() {
        return webserverUrl;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web Services
     * resources in your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. For more
     * information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA
     * Execution role</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web
     *         Services resources in your environment. For example,
     *         <code>arn:aws:iam::123456789:role/my-execution-role</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution
     *         role</a>.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the service-linked role of the environment. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html">Amazon MWAA Service-linked role</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the service-linked role of the environment. For more information, see
     *         <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html">Amazon MWAA Service-linked
     *         role</a>.
     */
    public final String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * The KMS encryption key used to encrypt the data in your environment.
     * </p>
     * 
     * @return The KMS encryption key used to encrypt the data in your environment.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The Apache Airflow version on your environment.
     * </p>
     * <p>
     * Valid values: <code>1.10.12</code>, <code>2.0.2</code>, <code>2.2.2</code>, <code>2.4.3</code>,
     * <code>2.5.1</code>, <code>2.6.3</code>, <code>2.7.2</code>, <code>2.8.1</code>.
     * </p>
     * 
     * @return The Apache Airflow version on your environment.</p>
     *         <p>
     *         Valid values: <code>1.10.12</code>, <code>2.0.2</code>, <code>2.2.2</code>, <code>2.4.3</code>,
     *         <code>2.5.1</code>, <code>2.6.3</code>, <code>2.7.2</code>, <code>2.8.1</code>.
     */
    public final String airflowVersion() {
        return airflowVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For
     * example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for
     * Amazon MWAA</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are
     *         stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. For more information, see
     *         <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3
     *         bucket for Amazon MWAA</a>.
     */
    public final String sourceBucketArn() {
        return sourceBucketArn;
    }

    /**
     * <p>
     * The relative path to the DAGs folder in your Amazon S3 bucket. For example,
     * <code>s3://mwaa-environment/dags</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a>.
     * </p>
     * 
     * @return The relative path to the DAGs folder in your Amazon S3 bucket. For example,
     *         <code>s3://mwaa-environment/dags</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating
     *         DAGs</a>.
     */
    public final String dagS3Path() {
        return dagS3Path;
    }

    /**
     * <p>
     * The relative path to the file in your Amazon S3 bucket. For example,
     * <code>s3://mwaa-environment/plugins.zip</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom
     * plugins</a>.
     * </p>
     * 
     * @return The relative path to the file in your Amazon S3 bucket. For example,
     *         <code>s3://mwaa-environment/plugins.zip</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing
     *         custom plugins</a>.
     */
    public final String pluginsS3Path() {
        return pluginsS3Path;
    }

    /**
     * <p>
     * The version of the <code>plugins.zip</code> file in your Amazon S3 bucket. You must specify the <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a> that Amazon
     * S3 assigns to the file.
     * </p>
     * <p>
     * Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The
     * following is an example:
     * </p>
     * <p>
     * <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom
     * plugins</a>.
     * </p>
     * 
     * @return The version of the <code>plugins.zip</code> file in your Amazon S3 bucket. You must specify the <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a>
     *         that Amazon S3 assigns to the file.</p>
     *         <p>
     *         Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long.
     *         The following is an example:
     *         </p>
     *         <p>
     *         <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing
     *         custom plugins</a>.
     */
    public final String pluginsS3ObjectVersion() {
        return pluginsS3ObjectVersion;
    }

    /**
     * <p>
     * The relative path to the <code>requirements.txt</code> file in your Amazon S3 bucket. For example,
     * <code>s3://mwaa-environment/requirements.txt</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python
     * dependencies</a>.
     * </p>
     * 
     * @return The relative path to the <code>requirements.txt</code> file in your Amazon S3 bucket. For example,
     *         <code>s3://mwaa-environment/requirements.txt</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python
     *         dependencies</a>.
     */
    public final String requirementsS3Path() {
        return requirementsS3Path;
    }

    /**
     * <p>
     * The version of the <code>requirements.txt </code> file on your Amazon S3 bucket. You must specify the <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a> that Amazon
     * S3 assigns to the file.
     * </p>
     * <p>
     * Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The
     * following is an example:
     * </p>
     * <p>
     * <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python
     * dependencies</a>.
     * </p>
     * 
     * @return The version of the <code>requirements.txt </code> file on your Amazon S3 bucket. You must specify the <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a>
     *         that Amazon S3 assigns to the file.</p>
     *         <p>
     *         Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long.
     *         The following is an example:
     *         </p>
     *         <p>
     *         <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python
     *         dependencies</a>.
     */
    public final String requirementsS3ObjectVersion() {
        return requirementsS3ObjectVersion;
    }

    /**
     * <p>
     * The relative path to the startup shell script in your Amazon S3 bucket. For example,
     * <code>s3://mwaa-environment/startup.sh</code>.
     * </p>
     * <p>
     * Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You can
     * use this script to install dependencies, modify Apache Airflow configuration options, and set environment
     * variables. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup script</a>.
     * </p>
     * 
     * @return The relative path to the startup shell script in your Amazon S3 bucket. For example,
     *         <code>s3://mwaa-environment/startup.sh</code>.</p>
     *         <p>
     *         Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process.
     *         You can use this script to install dependencies, modify Apache Airflow configuration options, and set
     *         environment variables. For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup
     *         script</a>.
     */
    public final String startupScriptS3Path() {
        return startupScriptS3Path;
    }

    /**
     * <p>
     * The version of the startup shell script in your Amazon S3 bucket. You must specify the <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a> that Amazon
     * S3 assigns to the file.
     * </p>
     * <p>
     * Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The
     * following is an example:
     * </p>
     * <p>
     * <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup script</a>.
     * </p>
     * 
     * @return The version of the startup shell script in your Amazon S3 bucket. You must specify the <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a>
     *         that Amazon S3 assigns to the file.</p>
     *         <p>
     *         Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long.
     *         The following is an example:
     *         </p>
     *         <p>
     *         <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup
     *         script</a>.
     */
    public final String startupScriptS3ObjectVersion() {
        return startupScriptS3ObjectVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the AirflowConfigurationOptions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAirflowConfigurationOptions() {
        return airflowConfigurationOptions != null && !(airflowConfigurationOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs containing the Apache Airflow configuration options attached to your environment. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow
     * configuration options</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAirflowConfigurationOptions} method.
     * </p>
     * 
     * @return A list of key-value pairs containing the Apache Airflow configuration options attached to your
     *         environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow
     *         configuration options</a>.
     */
    public final Map<String, String> airflowConfigurationOptions() {
        return airflowConfigurationOptions;
    }

    /**
     * <p>
     * The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>, <code>mw1.xlarge</code>, and <code>mw1.2xlarge</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment
     * class</a>.
     * </p>
     * 
     * @return The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>,
     *         <code>mw1.large</code>, <code>mw1.xlarge</code>, and <code>mw1.2xlarge</code>. For more information, see
     *         <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA
     *         environment class</a>.
     */
    public final String environmentClass() {
        return environmentClass;
    }

    /**
     * <p>
     * The maximum number of workers that run in your environment. For example, <code>20</code>.
     * </p>
     * 
     * @return The maximum number of workers that run in your environment. For example, <code>20</code>.
     */
    public final Integer maxWorkers() {
        return maxWorkers;
    }

    /**
     * <p>
     * Describes the VPC networking components used to secure and enable network traffic between the Amazon Web Services
     * resources for your environment. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon
     * MWAA</a>.
     * </p>
     * 
     * @return Describes the VPC networking components used to secure and enable network traffic between the Amazon Web
     *         Services resources for your environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon
     *         MWAA</a>.
     */
    public final NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The Apache Airflow logs published to CloudWatch Logs.
     * </p>
     * 
     * @return The Apache Airflow logs published to CloudWatch Logs.
     */
    public final LoggingConfiguration loggingConfiguration() {
        return loggingConfiguration;
    }

    /**
     * <p>
     * The status of the last update on the environment.
     * </p>
     * 
     * @return The status of the last update on the environment.
     */
    public final LastUpdate lastUpdate() {
        return lastUpdate;
    }

    /**
     * <p>
     * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly maintenance
     * updates are scheduled. For example: <code>TUE:03:30</code>.
     * </p>
     * 
     * @return The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly
     *         maintenance updates are scheduled. For example: <code>TUE:03:30</code>.
     */
    public final String weeklyMaintenanceWindowStart() {
        return weeklyMaintenanceWindowStart;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value tag pairs associated to your environment. For example, <code>"Environment": "Staging"</code>. For
     * more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web
     * Services resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key-value tag pairs associated to your environment. For example,
     *         <code>"Environment": "Staging"</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The Apache Airflow <i>web server</i> access mode. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access
     * modes</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webserverAccessMode} will return {@link WebserverAccessMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #webserverAccessModeAsString}.
     * </p>
     * 
     * @return The Apache Airflow <i>web server</i> access mode. For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow
     *         access modes</a>.
     * @see WebserverAccessMode
     */
    public final WebserverAccessMode webserverAccessMode() {
        return WebserverAccessMode.fromValue(webserverAccessMode);
    }

    /**
     * <p>
     * The Apache Airflow <i>web server</i> access mode. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access
     * modes</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webserverAccessMode} will return {@link WebserverAccessMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #webserverAccessModeAsString}.
     * </p>
     * 
     * @return The Apache Airflow <i>web server</i> access mode. For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow
     *         access modes</a>.
     * @see WebserverAccessMode
     */
    public final String webserverAccessModeAsString() {
        return webserverAccessMode;
    }

    /**
     * <p>
     * The minimum number of workers that run in your environment. For example, <code>2</code>.
     * </p>
     * 
     * @return The minimum number of workers that run in your environment. For example, <code>2</code>.
     */
    public final Integer minWorkers() {
        return minWorkers;
    }

    /**
     * <p>
     * The number of Apache Airflow schedulers that run in your Amazon MWAA environment.
     * </p>
     * 
     * @return The number of Apache Airflow schedulers that run in your Amazon MWAA environment.
     */
    public final Integer schedulers() {
        return schedulers;
    }

    /**
     * <p>
     * The VPC endpoint for the environment's web server.
     * </p>
     * 
     * @return The VPC endpoint for the environment's web server.
     */
    public final String webserverVpcEndpointService() {
        return webserverVpcEndpointService;
    }

    /**
     * <p>
     * The VPC endpoint for the environment's Amazon RDS database.
     * </p>
     * 
     * @return The VPC endpoint for the environment's Amazon RDS database.
     */
    public final String databaseVpcEndpointService() {
        return databaseVpcEndpointService;
    }

    /**
     * <p>
     * The queue ARN for the environment's <a
     * href="https://airflow.apache.org/docs/apache-airflow/stable/core-concepts/executor/celery.html">Celery
     * Executor</a>. Amazon MWAA uses a Celery Executor to distribute tasks across multiple workers. When you create an
     * environment in a shared VPC, you must provide access to the Celery Executor queue from your VPC.
     * </p>
     * 
     * @return The queue ARN for the environment's <a
     *         href="https://airflow.apache.org/docs/apache-airflow/stable/core-concepts/executor/celery.html">Celery
     *         Executor</a>. Amazon MWAA uses a Celery Executor to distribute tasks across multiple workers. When you
     *         create an environment in a shared VPC, you must provide access to the Celery Executor queue from your
     *         VPC.
     */
    public final String celeryExecutorQueue() {
        return celeryExecutorQueue;
    }

    /**
     * <p>
     * Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or by
     * Amazon MWAA. If set to <code>SERVICE</code>, Amazon MWAA will create and manage the required VPC endpoints in
     * your VPC. If set to <code>CUSTOMER</code>, you must create, and manage, the VPC endpoints in your VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #endpointManagement} will return {@link EndpointManagement#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #endpointManagementAsString}.
     * </p>
     * 
     * @return Defines whether the VPC endpoints configured for the environment are created, and managed, by the
     *         customer or by Amazon MWAA. If set to <code>SERVICE</code>, Amazon MWAA will create and manage the
     *         required VPC endpoints in your VPC. If set to <code>CUSTOMER</code>, you must create, and manage, the VPC
     *         endpoints in your VPC.
     * @see EndpointManagement
     */
    public final EndpointManagement endpointManagement() {
        return EndpointManagement.fromValue(endpointManagement);
    }

    /**
     * <p>
     * Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or by
     * Amazon MWAA. If set to <code>SERVICE</code>, Amazon MWAA will create and manage the required VPC endpoints in
     * your VPC. If set to <code>CUSTOMER</code>, you must create, and manage, the VPC endpoints in your VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #endpointManagement} will return {@link EndpointManagement#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #endpointManagementAsString}.
     * </p>
     * 
     * @return Defines whether the VPC endpoints configured for the environment are created, and managed, by the
     *         customer or by Amazon MWAA. If set to <code>SERVICE</code>, Amazon MWAA will create and manage the
     *         required VPC endpoints in your VPC. If set to <code>CUSTOMER</code>, you must create, and manage, the VPC
     *         endpoints in your VPC.
     * @see EndpointManagement
     */
    public final String endpointManagementAsString() {
        return endpointManagement;
    }

    /**
     * <p>
     * The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number of
     * Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with
     * your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the
     * transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web servers,
     * and scales down to the number set in <code>MinxWebserers</code>.
     * </p>
     * <p>
     * Valid values: Accepts between <code>2</code> and <code>5</code>. Defaults to <code>2</code>.
     * </p>
     * 
     * @return The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number
     *         of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you
     *         interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI.
     *         As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the
     *         additional web servers, and scales down to the number set in <code>MinxWebserers</code>. </p>
     *         <p>
     *         Valid values: Accepts between <code>2</code> and <code>5</code>. Defaults to <code>2</code>.
     */
    public final Integer minWebservers() {
        return minWebservers;
    }

    /**
     * <p>
     * The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number of
     * Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with
     * your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in
     * scenarios where your workload requires network calls to the Apache Airflow REST API with a high
     * transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set in
     * <code>MaxWebserers</code>. As TPS rates decrease Amazon MWAA disposes of the additional web servers, and scales
     * down to the number set in <code>MinxWebserers</code>.
     * </p>
     * <p>
     * Valid values: Accepts between <code>2</code> and <code>5</code>. Defaults to <code>2</code>.
     * </p>
     * 
     * @return The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number
     *         of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you
     *         interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI.
     *         For example, in scenarios where your workload requires network calls to the Apache Airflow REST API with
     *         a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the
     *         number set in <code>MaxWebserers</code>. As TPS rates decrease Amazon MWAA disposes of the additional web
     *         servers, and scales down to the number set in <code>MinxWebserers</code>. </p>
     *         <p>
     *         Valid values: Accepts between <code>2</code> and <code>5</code>. Defaults to <code>2</code>.
     */
    public final Integer maxWebservers() {
        return maxWebservers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(webserverUrl());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(airflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(dagS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(pluginsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(pluginsS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(requirementsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(requirementsS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(startupScriptS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(startupScriptS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasAirflowConfigurationOptions() ? airflowConfigurationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(environmentClass());
        hashCode = 31 * hashCode + Objects.hashCode(maxWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(webserverAccessModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(schedulers());
        hashCode = 31 * hashCode + Objects.hashCode(webserverVpcEndpointService());
        hashCode = 31 * hashCode + Objects.hashCode(databaseVpcEndpointService());
        hashCode = 31 * hashCode + Objects.hashCode(celeryExecutorQueue());
        hashCode = 31 * hashCode + Objects.hashCode(endpointManagementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minWebservers());
        hashCode = 31 * hashCode + Objects.hashCode(maxWebservers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Environment)) {
            return false;
        }
        Environment other = (Environment) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(webserverUrl(), other.webserverUrl())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(kmsKey(), other.kmsKey())
                && Objects.equals(airflowVersion(), other.airflowVersion())
                && Objects.equals(sourceBucketArn(), other.sourceBucketArn()) && Objects.equals(dagS3Path(), other.dagS3Path())
                && Objects.equals(pluginsS3Path(), other.pluginsS3Path())
                && Objects.equals(pluginsS3ObjectVersion(), other.pluginsS3ObjectVersion())
                && Objects.equals(requirementsS3Path(), other.requirementsS3Path())
                && Objects.equals(requirementsS3ObjectVersion(), other.requirementsS3ObjectVersion())
                && Objects.equals(startupScriptS3Path(), other.startupScriptS3Path())
                && Objects.equals(startupScriptS3ObjectVersion(), other.startupScriptS3ObjectVersion())
                && hasAirflowConfigurationOptions() == other.hasAirflowConfigurationOptions()
                && Objects.equals(airflowConfigurationOptions(), other.airflowConfigurationOptions())
                && Objects.equals(environmentClass(), other.environmentClass())
                && Objects.equals(maxWorkers(), other.maxWorkers())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(loggingConfiguration(), other.loggingConfiguration())
                && Objects.equals(lastUpdate(), other.lastUpdate())
                && Objects.equals(weeklyMaintenanceWindowStart(), other.weeklyMaintenanceWindowStart())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(webserverAccessModeAsString(), other.webserverAccessModeAsString())
                && Objects.equals(minWorkers(), other.minWorkers()) && Objects.equals(schedulers(), other.schedulers())
                && Objects.equals(webserverVpcEndpointService(), other.webserverVpcEndpointService())
                && Objects.equals(databaseVpcEndpointService(), other.databaseVpcEndpointService())
                && Objects.equals(celeryExecutorQueue(), other.celeryExecutorQueue())
                && Objects.equals(endpointManagementAsString(), other.endpointManagementAsString())
                && Objects.equals(minWebservers(), other.minWebservers())
                && Objects.equals(maxWebservers(), other.maxWebservers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("Environment")
                .add("Name", name())
                .add("Status", statusAsString())
                .add("Arn", arn())
                .add("CreatedAt", createdAt())
                .add("WebserverUrl", webserverUrl())
                .add("ExecutionRoleArn", executionRoleArn())
                .add("ServiceRoleArn", serviceRoleArn())
                .add("KmsKey", kmsKey())
                .add("AirflowVersion", airflowVersion())
                .add("SourceBucketArn", sourceBucketArn())
                .add("DagS3Path", dagS3Path())
                .add("PluginsS3Path", pluginsS3Path())
                .add("PluginsS3ObjectVersion", pluginsS3ObjectVersion())
                .add("RequirementsS3Path", requirementsS3Path())
                .add("RequirementsS3ObjectVersion", requirementsS3ObjectVersion())
                .add("StartupScriptS3Path", startupScriptS3Path())
                .add("StartupScriptS3ObjectVersion", startupScriptS3ObjectVersion())
                .add("AirflowConfigurationOptions",
                        airflowConfigurationOptions() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EnvironmentClass", environmentClass()).add("MaxWorkers", maxWorkers())
                .add("NetworkConfiguration", networkConfiguration()).add("LoggingConfiguration", loggingConfiguration())
                .add("LastUpdate", lastUpdate()).add("WeeklyMaintenanceWindowStart", weeklyMaintenanceWindowStart())
                .add("Tags", hasTags() ? tags() : null).add("WebserverAccessMode", webserverAccessModeAsString())
                .add("MinWorkers", minWorkers()).add("Schedulers", schedulers())
                .add("WebserverVpcEndpointService", webserverVpcEndpointService())
                .add("DatabaseVpcEndpointService", databaseVpcEndpointService())
                .add("CeleryExecutorQueue", celeryExecutorQueue()).add("EndpointManagement", endpointManagementAsString())
                .add("MinWebservers", minWebservers()).add("MaxWebservers", maxWebservers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "WebserverUrl":
            return Optional.ofNullable(clazz.cast(webserverUrl()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "ServiceRoleArn":
            return Optional.ofNullable(clazz.cast(serviceRoleArn()));
        case "KmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "AirflowVersion":
            return Optional.ofNullable(clazz.cast(airflowVersion()));
        case "SourceBucketArn":
            return Optional.ofNullable(clazz.cast(sourceBucketArn()));
        case "DagS3Path":
            return Optional.ofNullable(clazz.cast(dagS3Path()));
        case "PluginsS3Path":
            return Optional.ofNullable(clazz.cast(pluginsS3Path()));
        case "PluginsS3ObjectVersion":
            return Optional.ofNullable(clazz.cast(pluginsS3ObjectVersion()));
        case "RequirementsS3Path":
            return Optional.ofNullable(clazz.cast(requirementsS3Path()));
        case "RequirementsS3ObjectVersion":
            return Optional.ofNullable(clazz.cast(requirementsS3ObjectVersion()));
        case "StartupScriptS3Path":
            return Optional.ofNullable(clazz.cast(startupScriptS3Path()));
        case "StartupScriptS3ObjectVersion":
            return Optional.ofNullable(clazz.cast(startupScriptS3ObjectVersion()));
        case "AirflowConfigurationOptions":
            return Optional.ofNullable(clazz.cast(airflowConfigurationOptions()));
        case "EnvironmentClass":
            return Optional.ofNullable(clazz.cast(environmentClass()));
        case "MaxWorkers":
            return Optional.ofNullable(clazz.cast(maxWorkers()));
        case "NetworkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "LoggingConfiguration":
            return Optional.ofNullable(clazz.cast(loggingConfiguration()));
        case "LastUpdate":
            return Optional.ofNullable(clazz.cast(lastUpdate()));
        case "WeeklyMaintenanceWindowStart":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceWindowStart()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "WebserverAccessMode":
            return Optional.ofNullable(clazz.cast(webserverAccessModeAsString()));
        case "MinWorkers":
            return Optional.ofNullable(clazz.cast(minWorkers()));
        case "Schedulers":
            return Optional.ofNullable(clazz.cast(schedulers()));
        case "WebserverVpcEndpointService":
            return Optional.ofNullable(clazz.cast(webserverVpcEndpointService()));
        case "DatabaseVpcEndpointService":
            return Optional.ofNullable(clazz.cast(databaseVpcEndpointService()));
        case "CeleryExecutorQueue":
            return Optional.ofNullable(clazz.cast(celeryExecutorQueue()));
        case "EndpointManagement":
            return Optional.ofNullable(clazz.cast(endpointManagementAsString()));
        case "MinWebservers":
            return Optional.ofNullable(clazz.cast(minWebservers()));
        case "MaxWebservers":
            return Optional.ofNullable(clazz.cast(maxWebservers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Environment, T> g) {
        return obj -> g.apply((Environment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Environment> {
        /**
         * <p>
         * The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.
         * </p>
         * 
         * @param name
         *        The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the Amazon MWAA environment.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - Indicates the request to create the environment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATING_SNAPSHOT</code> - Indicates the request to update environment details, or upgrade the
         * environment version, is in progress and Amazon MWAA is creating a storage volume snapshot of the Amazon RDS
         * database cluster associated with the environment. A database snapshot is a backup created at a specific point
         * in time. Amazon MWAA uses snapshots to recover environment metadata if the process to update or upgrade an
         * environment fails.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment
         * could not be created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code> - Indicates the request was successful, but the process to create the environment is
         * paused until you create the required VPC endpoints in your VPC. After you create the VPC endpoints, the
         * process resumes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - Indicates the request to update the environment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROLLING_BACK</code> - Indicates the request to update environment details, or upgrade the environment
         * version, failed and Amazon MWAA is restoring the environment using the latest storage volume snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - Indicates the request to delete the environment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment has
         * been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNAVAILABLE</code> - Indicates the request failed, but the environment did not return to its previous
         * state and is not stable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment was
         * restored to its previous state successfully and is ready to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MAINTENANCE</code> - Indicates that the environment is undergoing maintenance. Depending on the type of
         * work Amazon MWAA is performing, your environment might become unavailable during this process. After all
         * operations are done, your environment will return to its status prior to mainteneace operations.
         * </p>
         * </li>
         * </ul>
         * <p>
         * We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. For more
         * information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA
         * troubleshooting</a>.
         * </p>
         * 
         * @param status
         *        The status of the Amazon MWAA environment.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - Indicates the request to create the environment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATING_SNAPSHOT</code> - Indicates the request to update environment details, or upgrade the
         *        environment version, is in progress and Amazon MWAA is creating a storage volume snapshot of the
         *        Amazon RDS database cluster associated with the environment. A database snapshot is a backup created
         *        at a specific point in time. Amazon MWAA uses snapshots to recover environment metadata if the process
         *        to update or upgrade an environment fails.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the
         *        environment could not be created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - Indicates the request was successful, but the process to create the environment
         *        is paused until you create the required VPC endpoints in your VPC. After you create the VPC endpoints,
         *        the process resumes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - Indicates the request to update the environment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROLLING_BACK</code> - Indicates the request to update environment details, or upgrade the
         *        environment version, failed and Amazon MWAA is restoring the environment using the latest storage
         *        volume snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - Indicates the request to delete the environment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> - Indicates the request to delete the environment is complete, and the
         *        environment has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNAVAILABLE</code> - Indicates the request failed, but the environment did not return to its
         *        previous state and is not stable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the
         *        environment was restored to its previous state successfully and is ready to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MAINTENANCE</code> - Indicates that the environment is undergoing maintenance. Depending on the
         *        type of work Amazon MWAA is performing, your environment might become unavailable during this process.
         *        After all operations are done, your environment will return to its status prior to mainteneace
         *        operations.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA
         *        troubleshooting</a>.
         * @see EnvironmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Amazon MWAA environment.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - Indicates the request to create the environment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATING_SNAPSHOT</code> - Indicates the request to update environment details, or upgrade the
         * environment version, is in progress and Amazon MWAA is creating a storage volume snapshot of the Amazon RDS
         * database cluster associated with the environment. A database snapshot is a backup created at a specific point
         * in time. Amazon MWAA uses snapshots to recover environment metadata if the process to update or upgrade an
         * environment fails.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment
         * could not be created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code> - Indicates the request was successful, but the process to create the environment is
         * paused until you create the required VPC endpoints in your VPC. After you create the VPC endpoints, the
         * process resumes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - Indicates the request to update the environment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROLLING_BACK</code> - Indicates the request to update environment details, or upgrade the environment
         * version, failed and Amazon MWAA is restoring the environment using the latest storage volume snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - Indicates the request to delete the environment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment has
         * been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNAVAILABLE</code> - Indicates the request failed, but the environment did not return to its previous
         * state and is not stable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment was
         * restored to its previous state successfully and is ready to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MAINTENANCE</code> - Indicates that the environment is undergoing maintenance. Depending on the type of
         * work Amazon MWAA is performing, your environment might become unavailable during this process. After all
         * operations are done, your environment will return to its status prior to mainteneace operations.
         * </p>
         * </li>
         * </ul>
         * <p>
         * We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. For more
         * information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA
         * troubleshooting</a>.
         * </p>
         * 
         * @param status
         *        The status of the Amazon MWAA environment.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - Indicates the request to create the environment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATING_SNAPSHOT</code> - Indicates the request to update environment details, or upgrade the
         *        environment version, is in progress and Amazon MWAA is creating a storage volume snapshot of the
         *        Amazon RDS database cluster associated with the environment. A database snapshot is a backup created
         *        at a specific point in time. Amazon MWAA uses snapshots to recover environment metadata if the process
         *        to update or upgrade an environment fails.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the
         *        environment could not be created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - Indicates the request was successful, but the process to create the environment
         *        is paused until you create the required VPC endpoints in your VPC. After you create the VPC endpoints,
         *        the process resumes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - Indicates the request to update the environment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROLLING_BACK</code> - Indicates the request to update environment details, or upgrade the
         *        environment version, failed and Amazon MWAA is restoring the environment using the latest storage
         *        volume snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - Indicates the request to delete the environment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> - Indicates the request to delete the environment is complete, and the
         *        environment has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNAVAILABLE</code> - Indicates the request failed, but the environment did not return to its
         *        previous state and is not stable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the
         *        environment was restored to its previous state successfully and is ready to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MAINTENANCE</code> - Indicates that the environment is undergoing maintenance. Depending on the
         *        type of work Amazon MWAA is performing, your environment might become unavailable during this process.
         *        After all operations are done, your environment will return to its status prior to mainteneace
         *        operations.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA
         *        troubleshooting</a>.
         * @see EnvironmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentStatus
         */
        Builder status(EnvironmentStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon MWAA environment.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The day and time the environment was created.
         * </p>
         * 
         * @param createdAt
         *        The day and time the environment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Apache Airflow <i>web server</i> host name for the Amazon MWAA environment. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html">Accessing the Apache Airflow
         * UI</a>.
         * </p>
         * 
         * @param webserverUrl
         *        The Apache Airflow <i>web server</i> host name for the Amazon MWAA environment. For more information,
         *        see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html">Accessing the
         *        Apache Airflow UI</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webserverUrl(String webserverUrl);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web Services
         * resources in your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution
         * role</a>.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web
         *        Services resources in your environment. For example,
         *        <code>arn:aws:iam::123456789:role/my-execution-role</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution
         *        role</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the service-linked role of the environment. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html">Amazon MWAA Service-linked role</a>.
         * </p>
         * 
         * @param serviceRoleArn
         *        The Amazon Resource Name (ARN) for the service-linked role of the environment. For more information,
         *        see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html">Amazon MWAA
         *        Service-linked role</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * The KMS encryption key used to encrypt the data in your environment.
         * </p>
         * 
         * @param kmsKey
         *        The KMS encryption key used to encrypt the data in your environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The Apache Airflow version on your environment.
         * </p>
         * <p>
         * Valid values: <code>1.10.12</code>, <code>2.0.2</code>, <code>2.2.2</code>, <code>2.4.3</code>,
         * <code>2.5.1</code>, <code>2.6.3</code>, <code>2.7.2</code>, <code>2.8.1</code>.
         * </p>
         * 
         * @param airflowVersion
         *        The Apache Airflow version on your environment.</p>
         *        <p>
         *        Valid values: <code>1.10.12</code>, <code>2.0.2</code>, <code>2.2.2</code>, <code>2.4.3</code>,
         *        <code>2.5.1</code>, <code>2.6.3</code>, <code>2.7.2</code>, <code>2.8.1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder airflowVersion(String airflowVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored.
         * For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for
         * Amazon MWAA</a>.
         * </p>
         * 
         * @param sourceBucketArn
         *        The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are
         *        stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. For more information,
         *        see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon
         *        S3 bucket for Amazon MWAA</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBucketArn(String sourceBucketArn);

        /**
         * <p>
         * The relative path to the DAGs folder in your Amazon S3 bucket. For example,
         * <code>s3://mwaa-environment/dags</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating
         * DAGs</a>.
         * </p>
         * 
         * @param dagS3Path
         *        The relative path to the DAGs folder in your Amazon S3 bucket. For example,
         *        <code>s3://mwaa-environment/dags</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or
         *        updating DAGs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dagS3Path(String dagS3Path);

        /**
         * <p>
         * The relative path to the file in your Amazon S3 bucket. For example,
         * <code>s3://mwaa-environment/plugins.zip</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing
         * custom plugins</a>.
         * </p>
         * 
         * @param pluginsS3Path
         *        The relative path to the file in your Amazon S3 bucket. For example,
         *        <code>s3://mwaa-environment/plugins.zip</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html"
         *        >Installing custom plugins</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginsS3Path(String pluginsS3Path);

        /**
         * <p>
         * The version of the <code>plugins.zip</code> file in your Amazon S3 bucket. You must specify the <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a> that
         * Amazon S3 assigns to the file.
         * </p>
         * <p>
         * Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The
         * following is an example:
         * </p>
         * <p>
         * <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing
         * custom plugins</a>.
         * </p>
         * 
         * @param pluginsS3ObjectVersion
         *        The version of the <code>plugins.zip</code> file in your Amazon S3 bucket. You must specify the <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a>
         *        that Amazon S3 assigns to the file.</p>
         *        <p>
         *        Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes
         *        long. The following is an example:
         *        </p>
         *        <p>
         *        <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html"
         *        >Installing custom plugins</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginsS3ObjectVersion(String pluginsS3ObjectVersion);

        /**
         * <p>
         * The relative path to the <code>requirements.txt</code> file in your Amazon S3 bucket. For example,
         * <code>s3://mwaa-environment/requirements.txt</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python
         * dependencies</a>.
         * </p>
         * 
         * @param requirementsS3Path
         *        The relative path to the <code>requirements.txt</code> file in your Amazon S3 bucket. For example,
         *        <code>s3://mwaa-environment/requirements.txt</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing
         *        Python dependencies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requirementsS3Path(String requirementsS3Path);

        /**
         * <p>
         * The version of the <code>requirements.txt </code> file on your Amazon S3 bucket. You must specify the <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a> that
         * Amazon S3 assigns to the file.
         * </p>
         * <p>
         * Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The
         * following is an example:
         * </p>
         * <p>
         * <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python
         * dependencies</a>.
         * </p>
         * 
         * @param requirementsS3ObjectVersion
         *        The version of the <code>requirements.txt </code> file on your Amazon S3 bucket. You must specify the
         *        <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version
         *        ID</a> that Amazon S3 assigns to the file.</p>
         *        <p>
         *        Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes
         *        long. The following is an example:
         *        </p>
         *        <p>
         *        <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing
         *        Python dependencies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requirementsS3ObjectVersion(String requirementsS3ObjectVersion);

        /**
         * <p>
         * The relative path to the startup shell script in your Amazon S3 bucket. For example,
         * <code>s3://mwaa-environment/startup.sh</code>.
         * </p>
         * <p>
         * Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You
         * can use this script to install dependencies, modify Apache Airflow configuration options, and set environment
         * variables. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup
         * script</a>.
         * </p>
         * 
         * @param startupScriptS3Path
         *        The relative path to the startup shell script in your Amazon S3 bucket. For example,
         *        <code>s3://mwaa-environment/startup.sh</code>.</p>
         *        <p>
         *        Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process.
         *        You can use this script to install dependencies, modify Apache Airflow configuration options, and set
         *        environment variables. For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup
         *        script</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startupScriptS3Path(String startupScriptS3Path);

        /**
         * <p>
         * The version of the startup shell script in your Amazon S3 bucket. You must specify the <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a> that
         * Amazon S3 assigns to the file.
         * </p>
         * <p>
         * Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The
         * following is an example:
         * </p>
         * <p>
         * <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup
         * script</a>.
         * </p>
         * 
         * @param startupScriptS3ObjectVersion
         *        The version of the startup shell script in your Amazon S3 bucket. You must specify the <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a>
         *        that Amazon S3 assigns to the file.</p>
         *        <p>
         *        Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes
         *        long. The following is an example:
         *        </p>
         *        <p>
         *        <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup
         *        script</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startupScriptS3ObjectVersion(String startupScriptS3ObjectVersion);

        /**
         * <p>
         * A list of key-value pairs containing the Apache Airflow configuration options attached to your environment.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow
         * configuration options</a>.
         * </p>
         * 
         * @param airflowConfigurationOptions
         *        A list of key-value pairs containing the Apache Airflow configuration options attached to your
         *        environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow
         *        configuration options</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder airflowConfigurationOptions(Map<String, String> airflowConfigurationOptions);

        /**
         * <p>
         * The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>,
         * <code>mw1.large</code>, <code>mw1.xlarge</code>, and <code>mw1.2xlarge</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment
         * class</a>.
         * </p>
         * 
         * @param environmentClass
         *        The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>,
         *        <code>mw1.large</code>, <code>mw1.xlarge</code>, and <code>mw1.2xlarge</code>. For more information,
         *        see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA
         *        environment class</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentClass(String environmentClass);

        /**
         * <p>
         * The maximum number of workers that run in your environment. For example, <code>20</code>.
         * </p>
         * 
         * @param maxWorkers
         *        The maximum number of workers that run in your environment. For example, <code>20</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWorkers(Integer maxWorkers);

        /**
         * <p>
         * Describes the VPC networking components used to secure and enable network traffic between the Amazon Web
         * Services resources for your environment. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon
         * MWAA</a>.
         * </p>
         * 
         * @param networkConfiguration
         *        Describes the VPC networking components used to secure and enable network traffic between the Amazon
         *        Web Services resources for your environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on
         *        Amazon MWAA</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * Describes the VPC networking components used to secure and enable network traffic between the Amazon Web
         * Services resources for your environment. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon
         * MWAA</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * The Apache Airflow logs published to CloudWatch Logs.
         * </p>
         * 
         * @param loggingConfiguration
         *        The Apache Airflow logs published to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfiguration(LoggingConfiguration loggingConfiguration);

        /**
         * <p>
         * The Apache Airflow logs published to CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoggingConfiguration.Builder} avoiding
         * the need to create one manually via {@link LoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #loggingConfiguration(LoggingConfiguration)}.
         * 
         * @param loggingConfiguration
         *        a consumer that will call methods on {@link LoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfiguration(LoggingConfiguration)
         */
        default Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return loggingConfiguration(LoggingConfiguration.builder().applyMutation(loggingConfiguration).build());
        }

        /**
         * <p>
         * The status of the last update on the environment.
         * </p>
         * 
         * @param lastUpdate
         *        The status of the last update on the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdate(LastUpdate lastUpdate);

        /**
         * <p>
         * The status of the last update on the environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link LastUpdate.Builder} avoiding the need to
         * create one manually via {@link LastUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LastUpdate.Builder#build()} is called immediately and its result
         * is passed to {@link #lastUpdate(LastUpdate)}.
         * 
         * @param lastUpdate
         *        a consumer that will call methods on {@link LastUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastUpdate(LastUpdate)
         */
        default Builder lastUpdate(Consumer<LastUpdate.Builder> lastUpdate) {
            return lastUpdate(LastUpdate.builder().applyMutation(lastUpdate).build());
        }

        /**
         * <p>
         * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly
         * maintenance updates are scheduled. For example: <code>TUE:03:30</code>.
         * </p>
         * 
         * @param weeklyMaintenanceWindowStart
         *        The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly
         *        maintenance updates are scheduled. For example: <code>TUE:03:30</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart);

        /**
         * <p>
         * The key-value tag pairs associated to your environment. For example, <code>"Environment": "Staging"</code>.
         * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging
         * Amazon Web Services resources</a>.
         * </p>
         * 
         * @param tags
         *        The key-value tag pairs associated to your environment. For example,
         *        <code>"Environment": "Staging"</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The Apache Airflow <i>web server</i> access mode. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access
         * modes</a>.
         * </p>
         * 
         * @param webserverAccessMode
         *        The Apache Airflow <i>web server</i> access mode. For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow
         *        access modes</a>.
         * @see WebserverAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebserverAccessMode
         */
        Builder webserverAccessMode(String webserverAccessMode);

        /**
         * <p>
         * The Apache Airflow <i>web server</i> access mode. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access
         * modes</a>.
         * </p>
         * 
         * @param webserverAccessMode
         *        The Apache Airflow <i>web server</i> access mode. For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow
         *        access modes</a>.
         * @see WebserverAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebserverAccessMode
         */
        Builder webserverAccessMode(WebserverAccessMode webserverAccessMode);

        /**
         * <p>
         * The minimum number of workers that run in your environment. For example, <code>2</code>.
         * </p>
         * 
         * @param minWorkers
         *        The minimum number of workers that run in your environment. For example, <code>2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minWorkers(Integer minWorkers);

        /**
         * <p>
         * The number of Apache Airflow schedulers that run in your Amazon MWAA environment.
         * </p>
         * 
         * @param schedulers
         *        The number of Apache Airflow schedulers that run in your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedulers(Integer schedulers);

        /**
         * <p>
         * The VPC endpoint for the environment's web server.
         * </p>
         * 
         * @param webserverVpcEndpointService
         *        The VPC endpoint for the environment's web server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webserverVpcEndpointService(String webserverVpcEndpointService);

        /**
         * <p>
         * The VPC endpoint for the environment's Amazon RDS database.
         * </p>
         * 
         * @param databaseVpcEndpointService
         *        The VPC endpoint for the environment's Amazon RDS database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseVpcEndpointService(String databaseVpcEndpointService);

        /**
         * <p>
         * The queue ARN for the environment's <a
         * href="https://airflow.apache.org/docs/apache-airflow/stable/core-concepts/executor/celery.html">Celery
         * Executor</a>. Amazon MWAA uses a Celery Executor to distribute tasks across multiple workers. When you create
         * an environment in a shared VPC, you must provide access to the Celery Executor queue from your VPC.
         * </p>
         * 
         * @param celeryExecutorQueue
         *        The queue ARN for the environment's <a
         *        href="https://airflow.apache.org/docs/apache-airflow/stable/core-concepts/executor/celery.html">Celery
         *        Executor</a>. Amazon MWAA uses a Celery Executor to distribute tasks across multiple workers. When you
         *        create an environment in a shared VPC, you must provide access to the Celery Executor queue from your
         *        VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder celeryExecutorQueue(String celeryExecutorQueue);

        /**
         * <p>
         * Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or
         * by Amazon MWAA. If set to <code>SERVICE</code>, Amazon MWAA will create and manage the required VPC endpoints
         * in your VPC. If set to <code>CUSTOMER</code>, you must create, and manage, the VPC endpoints in your VPC.
         * </p>
         * 
         * @param endpointManagement
         *        Defines whether the VPC endpoints configured for the environment are created, and managed, by the
         *        customer or by Amazon MWAA. If set to <code>SERVICE</code>, Amazon MWAA will create and manage the
         *        required VPC endpoints in your VPC. If set to <code>CUSTOMER</code>, you must create, and manage, the
         *        VPC endpoints in your VPC.
         * @see EndpointManagement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointManagement
         */
        Builder endpointManagement(String endpointManagement);

        /**
         * <p>
         * Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or
         * by Amazon MWAA. If set to <code>SERVICE</code>, Amazon MWAA will create and manage the required VPC endpoints
         * in your VPC. If set to <code>CUSTOMER</code>, you must create, and manage, the VPC endpoints in your VPC.
         * </p>
         * 
         * @param endpointManagement
         *        Defines whether the VPC endpoints configured for the environment are created, and managed, by the
         *        customer or by Amazon MWAA. If set to <code>SERVICE</code>, Amazon MWAA will create and manage the
         *        required VPC endpoints in your VPC. If set to <code>CUSTOMER</code>, you must create, and manage, the
         *        VPC endpoints in your VPC.
         * @see EndpointManagement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointManagement
         */
        Builder endpointManagement(EndpointManagement endpointManagement);

        /**
         * <p>
         * The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number of
         * Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with
         * your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the
         * transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web
         * servers, and scales down to the number set in <code>MinxWebserers</code>.
         * </p>
         * <p>
         * Valid values: Accepts between <code>2</code> and <code>5</code>. Defaults to <code>2</code>.
         * </p>
         * 
         * @param minWebservers
         *        The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the
         *        number of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when
         *        you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow
         *        CLI. As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the
         *        additional web servers, and scales down to the number set in <code>MinxWebserers</code>. </p>
         *        <p>
         *        Valid values: Accepts between <code>2</code> and <code>5</code>. Defaults to <code>2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minWebservers(Integer minWebservers);

        /**
         * <p>
         * The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number of
         * Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with
         * your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in
         * scenarios where your workload requires network calls to the Apache Airflow REST API with a high
         * transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set
         * in <code>MaxWebserers</code>. As TPS rates decrease Amazon MWAA disposes of the additional web servers, and
         * scales down to the number set in <code>MinxWebserers</code>.
         * </p>
         * <p>
         * Valid values: Accepts between <code>2</code> and <code>5</code>. Defaults to <code>2</code>.
         * </p>
         * 
         * @param maxWebservers
         *        The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the
         *        number of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when
         *        you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow
         *        CLI. For example, in scenarios where your workload requires network calls to the Apache Airflow REST
         *        API with a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers
         *        up to the number set in <code>MaxWebserers</code>. As TPS rates decrease Amazon MWAA disposes of the
         *        additional web servers, and scales down to the number set in <code>MinxWebserers</code>. </p>
         *        <p>
         *        Valid values: Accepts between <code>2</code> and <code>5</code>. Defaults to <code>2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWebservers(Integer maxWebservers);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private String arn;

        private Instant createdAt;

        private String webserverUrl;

        private String executionRoleArn;

        private String serviceRoleArn;

        private String kmsKey;

        private String airflowVersion;

        private String sourceBucketArn;

        private String dagS3Path;

        private String pluginsS3Path;

        private String pluginsS3ObjectVersion;

        private String requirementsS3Path;

        private String requirementsS3ObjectVersion;

        private String startupScriptS3Path;

        private String startupScriptS3ObjectVersion;

        private Map<String, String> airflowConfigurationOptions = DefaultSdkAutoConstructMap.getInstance();

        private String environmentClass;

        private Integer maxWorkers;

        private NetworkConfiguration networkConfiguration;

        private LoggingConfiguration loggingConfiguration;

        private LastUpdate lastUpdate;

        private String weeklyMaintenanceWindowStart;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String webserverAccessMode;

        private Integer minWorkers;

        private Integer schedulers;

        private String webserverVpcEndpointService;

        private String databaseVpcEndpointService;

        private String celeryExecutorQueue;

        private String endpointManagement;

        private Integer minWebservers;

        private Integer maxWebservers;

        private BuilderImpl() {
        }

        private BuilderImpl(Environment model) {
            name(model.name);
            status(model.status);
            arn(model.arn);
            createdAt(model.createdAt);
            webserverUrl(model.webserverUrl);
            executionRoleArn(model.executionRoleArn);
            serviceRoleArn(model.serviceRoleArn);
            kmsKey(model.kmsKey);
            airflowVersion(model.airflowVersion);
            sourceBucketArn(model.sourceBucketArn);
            dagS3Path(model.dagS3Path);
            pluginsS3Path(model.pluginsS3Path);
            pluginsS3ObjectVersion(model.pluginsS3ObjectVersion);
            requirementsS3Path(model.requirementsS3Path);
            requirementsS3ObjectVersion(model.requirementsS3ObjectVersion);
            startupScriptS3Path(model.startupScriptS3Path);
            startupScriptS3ObjectVersion(model.startupScriptS3ObjectVersion);
            airflowConfigurationOptions(model.airflowConfigurationOptions);
            environmentClass(model.environmentClass);
            maxWorkers(model.maxWorkers);
            networkConfiguration(model.networkConfiguration);
            loggingConfiguration(model.loggingConfiguration);
            lastUpdate(model.lastUpdate);
            weeklyMaintenanceWindowStart(model.weeklyMaintenanceWindowStart);
            tags(model.tags);
            webserverAccessMode(model.webserverAccessMode);
            minWorkers(model.minWorkers);
            schedulers(model.schedulers);
            webserverVpcEndpointService(model.webserverVpcEndpointService);
            databaseVpcEndpointService(model.databaseVpcEndpointService);
            celeryExecutorQueue(model.celeryExecutorQueue);
            endpointManagement(model.endpointManagement);
            minWebservers(model.minWebservers);
            maxWebservers(model.maxWebservers);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getWebserverUrl() {
            return webserverUrl;
        }

        public final void setWebserverUrl(String webserverUrl) {
            this.webserverUrl = webserverUrl;
        }

        @Override
        public final Builder webserverUrl(String webserverUrl) {
            this.webserverUrl = webserverUrl;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getAirflowVersion() {
            return airflowVersion;
        }

        public final void setAirflowVersion(String airflowVersion) {
            this.airflowVersion = airflowVersion;
        }

        @Override
        public final Builder airflowVersion(String airflowVersion) {
            this.airflowVersion = airflowVersion;
            return this;
        }

        public final String getSourceBucketArn() {
            return sourceBucketArn;
        }

        public final void setSourceBucketArn(String sourceBucketArn) {
            this.sourceBucketArn = sourceBucketArn;
        }

        @Override
        public final Builder sourceBucketArn(String sourceBucketArn) {
            this.sourceBucketArn = sourceBucketArn;
            return this;
        }

        public final String getDagS3Path() {
            return dagS3Path;
        }

        public final void setDagS3Path(String dagS3Path) {
            this.dagS3Path = dagS3Path;
        }

        @Override
        public final Builder dagS3Path(String dagS3Path) {
            this.dagS3Path = dagS3Path;
            return this;
        }

        public final String getPluginsS3Path() {
            return pluginsS3Path;
        }

        public final void setPluginsS3Path(String pluginsS3Path) {
            this.pluginsS3Path = pluginsS3Path;
        }

        @Override
        public final Builder pluginsS3Path(String pluginsS3Path) {
            this.pluginsS3Path = pluginsS3Path;
            return this;
        }

        public final String getPluginsS3ObjectVersion() {
            return pluginsS3ObjectVersion;
        }

        public final void setPluginsS3ObjectVersion(String pluginsS3ObjectVersion) {
            this.pluginsS3ObjectVersion = pluginsS3ObjectVersion;
        }

        @Override
        public final Builder pluginsS3ObjectVersion(String pluginsS3ObjectVersion) {
            this.pluginsS3ObjectVersion = pluginsS3ObjectVersion;
            return this;
        }

        public final String getRequirementsS3Path() {
            return requirementsS3Path;
        }

        public final void setRequirementsS3Path(String requirementsS3Path) {
            this.requirementsS3Path = requirementsS3Path;
        }

        @Override
        public final Builder requirementsS3Path(String requirementsS3Path) {
            this.requirementsS3Path = requirementsS3Path;
            return this;
        }

        public final String getRequirementsS3ObjectVersion() {
            return requirementsS3ObjectVersion;
        }

        public final void setRequirementsS3ObjectVersion(String requirementsS3ObjectVersion) {
            this.requirementsS3ObjectVersion = requirementsS3ObjectVersion;
        }

        @Override
        public final Builder requirementsS3ObjectVersion(String requirementsS3ObjectVersion) {
            this.requirementsS3ObjectVersion = requirementsS3ObjectVersion;
            return this;
        }

        public final String getStartupScriptS3Path() {
            return startupScriptS3Path;
        }

        public final void setStartupScriptS3Path(String startupScriptS3Path) {
            this.startupScriptS3Path = startupScriptS3Path;
        }

        @Override
        public final Builder startupScriptS3Path(String startupScriptS3Path) {
            this.startupScriptS3Path = startupScriptS3Path;
            return this;
        }

        public final String getStartupScriptS3ObjectVersion() {
            return startupScriptS3ObjectVersion;
        }

        public final void setStartupScriptS3ObjectVersion(String startupScriptS3ObjectVersion) {
            this.startupScriptS3ObjectVersion = startupScriptS3ObjectVersion;
        }

        @Override
        public final Builder startupScriptS3ObjectVersion(String startupScriptS3ObjectVersion) {
            this.startupScriptS3ObjectVersion = startupScriptS3ObjectVersion;
            return this;
        }

        public final Map<String, String> getAirflowConfigurationOptions() {
            if (airflowConfigurationOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return airflowConfigurationOptions;
        }

        public final void setAirflowConfigurationOptions(Map<String, String> airflowConfigurationOptions) {
            this.airflowConfigurationOptions = AirflowConfigurationOptionsCopier.copy(airflowConfigurationOptions);
        }

        @Override
        public final Builder airflowConfigurationOptions(Map<String, String> airflowConfigurationOptions) {
            this.airflowConfigurationOptions = AirflowConfigurationOptionsCopier.copy(airflowConfigurationOptions);
            return this;
        }

        public final String getEnvironmentClass() {
            return environmentClass;
        }

        public final void setEnvironmentClass(String environmentClass) {
            this.environmentClass = environmentClass;
        }

        @Override
        public final Builder environmentClass(String environmentClass) {
            this.environmentClass = environmentClass;
            return this;
        }

        public final Integer getMaxWorkers() {
            return maxWorkers;
        }

        public final void setMaxWorkers(Integer maxWorkers) {
            this.maxWorkers = maxWorkers;
        }

        @Override
        public final Builder maxWorkers(Integer maxWorkers) {
            this.maxWorkers = maxWorkers;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return loggingConfiguration != null ? loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final LastUpdate.Builder getLastUpdate() {
            return lastUpdate != null ? lastUpdate.toBuilder() : null;
        }

        public final void setLastUpdate(LastUpdate.BuilderImpl lastUpdate) {
            this.lastUpdate = lastUpdate != null ? lastUpdate.build() : null;
        }

        @Override
        public final Builder lastUpdate(LastUpdate lastUpdate) {
            this.lastUpdate = lastUpdate;
            return this;
        }

        public final String getWeeklyMaintenanceWindowStart() {
            return weeklyMaintenanceWindowStart;
        }

        public final void setWeeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
        }

        @Override
        public final Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWebserverAccessMode() {
            return webserverAccessMode;
        }

        public final void setWebserverAccessMode(String webserverAccessMode) {
            this.webserverAccessMode = webserverAccessMode;
        }

        @Override
        public final Builder webserverAccessMode(String webserverAccessMode) {
            this.webserverAccessMode = webserverAccessMode;
            return this;
        }

        @Override
        public final Builder webserverAccessMode(WebserverAccessMode webserverAccessMode) {
            this.webserverAccessMode(webserverAccessMode == null ? null : webserverAccessMode.toString());
            return this;
        }

        public final Integer getMinWorkers() {
            return minWorkers;
        }

        public final void setMinWorkers(Integer minWorkers) {
            this.minWorkers = minWorkers;
        }

        @Override
        public final Builder minWorkers(Integer minWorkers) {
            this.minWorkers = minWorkers;
            return this;
        }

        public final Integer getSchedulers() {
            return schedulers;
        }

        public final void setSchedulers(Integer schedulers) {
            this.schedulers = schedulers;
        }

        @Override
        public final Builder schedulers(Integer schedulers) {
            this.schedulers = schedulers;
            return this;
        }

        public final String getWebserverVpcEndpointService() {
            return webserverVpcEndpointService;
        }

        public final void setWebserverVpcEndpointService(String webserverVpcEndpointService) {
            this.webserverVpcEndpointService = webserverVpcEndpointService;
        }

        @Override
        public final Builder webserverVpcEndpointService(String webserverVpcEndpointService) {
            this.webserverVpcEndpointService = webserverVpcEndpointService;
            return this;
        }

        public final String getDatabaseVpcEndpointService() {
            return databaseVpcEndpointService;
        }

        public final void setDatabaseVpcEndpointService(String databaseVpcEndpointService) {
            this.databaseVpcEndpointService = databaseVpcEndpointService;
        }

        @Override
        public final Builder databaseVpcEndpointService(String databaseVpcEndpointService) {
            this.databaseVpcEndpointService = databaseVpcEndpointService;
            return this;
        }

        public final String getCeleryExecutorQueue() {
            return celeryExecutorQueue;
        }

        public final void setCeleryExecutorQueue(String celeryExecutorQueue) {
            this.celeryExecutorQueue = celeryExecutorQueue;
        }

        @Override
        public final Builder celeryExecutorQueue(String celeryExecutorQueue) {
            this.celeryExecutorQueue = celeryExecutorQueue;
            return this;
        }

        public final String getEndpointManagement() {
            return endpointManagement;
        }

        public final void setEndpointManagement(String endpointManagement) {
            this.endpointManagement = endpointManagement;
        }

        @Override
        public final Builder endpointManagement(String endpointManagement) {
            this.endpointManagement = endpointManagement;
            return this;
        }

        @Override
        public final Builder endpointManagement(EndpointManagement endpointManagement) {
            this.endpointManagement(endpointManagement == null ? null : endpointManagement.toString());
            return this;
        }

        public final Integer getMinWebservers() {
            return minWebservers;
        }

        public final void setMinWebservers(Integer minWebservers) {
            this.minWebservers = minWebservers;
        }

        @Override
        public final Builder minWebservers(Integer minWebservers) {
            this.minWebservers = minWebservers;
            return this;
        }

        public final Integer getMaxWebservers() {
            return maxWebservers;
        }

        public final void setMaxWebservers(Integer maxWebservers) {
            this.maxWebservers = maxWebservers;
        }

        @Override
        public final Builder maxWebservers(Integer maxWebservers) {
            this.maxWebservers = maxWebservers;
            return this;
        }

        @Override
        public Environment build() {
            return new Environment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
