/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaa.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the Apache Airflow log types to send to CloudWatch Logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingConfigurationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<LoggingConfigurationInput.Builder, LoggingConfigurationInput> {
    private static final SdkField<ModuleLoggingConfigurationInput> DAG_PROCESSING_LOGS_FIELD = SdkField
            .<ModuleLoggingConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("DagProcessingLogs")
            .getter(getter(LoggingConfigurationInput::dagProcessingLogs)).setter(setter(Builder::dagProcessingLogs))
            .constructor(ModuleLoggingConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagProcessingLogs").build()).build();

    private static final SdkField<ModuleLoggingConfigurationInput> SCHEDULER_LOGS_FIELD = SdkField
            .<ModuleLoggingConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("SchedulerLogs")
            .getter(getter(LoggingConfigurationInput::schedulerLogs)).setter(setter(Builder::schedulerLogs))
            .constructor(ModuleLoggingConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchedulerLogs").build()).build();

    private static final SdkField<ModuleLoggingConfigurationInput> WEBSERVER_LOGS_FIELD = SdkField
            .<ModuleLoggingConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("WebserverLogs")
            .getter(getter(LoggingConfigurationInput::webserverLogs)).setter(setter(Builder::webserverLogs))
            .constructor(ModuleLoggingConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverLogs").build()).build();

    private static final SdkField<ModuleLoggingConfigurationInput> WORKER_LOGS_FIELD = SdkField
            .<ModuleLoggingConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("WorkerLogs")
            .getter(getter(LoggingConfigurationInput::workerLogs)).setter(setter(Builder::workerLogs))
            .constructor(ModuleLoggingConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerLogs").build()).build();

    private static final SdkField<ModuleLoggingConfigurationInput> TASK_LOGS_FIELD = SdkField
            .<ModuleLoggingConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("TaskLogs")
            .getter(getter(LoggingConfigurationInput::taskLogs)).setter(setter(Builder::taskLogs))
            .constructor(ModuleLoggingConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAG_PROCESSING_LOGS_FIELD,
            SCHEDULER_LOGS_FIELD, WEBSERVER_LOGS_FIELD, WORKER_LOGS_FIELD, TASK_LOGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ModuleLoggingConfigurationInput dagProcessingLogs;

    private final ModuleLoggingConfigurationInput schedulerLogs;

    private final ModuleLoggingConfigurationInput webserverLogs;

    private final ModuleLoggingConfigurationInput workerLogs;

    private final ModuleLoggingConfigurationInput taskLogs;

    private LoggingConfigurationInput(BuilderImpl builder) {
        this.dagProcessingLogs = builder.dagProcessingLogs;
        this.schedulerLogs = builder.schedulerLogs;
        this.webserverLogs = builder.webserverLogs;
        this.workerLogs = builder.workerLogs;
        this.taskLogs = builder.taskLogs;
    }

    /**
     * <p>
     * Publishes Airflow DAG processing logs to CloudWatch Logs.
     * </p>
     * 
     * @return Publishes Airflow DAG processing logs to CloudWatch Logs.
     */
    public final ModuleLoggingConfigurationInput dagProcessingLogs() {
        return dagProcessingLogs;
    }

    /**
     * <p>
     * Publishes Airflow scheduler logs to CloudWatch Logs.
     * </p>
     * 
     * @return Publishes Airflow scheduler logs to CloudWatch Logs.
     */
    public final ModuleLoggingConfigurationInput schedulerLogs() {
        return schedulerLogs;
    }

    /**
     * <p>
     * Publishes Airflow web server logs to CloudWatch Logs.
     * </p>
     * 
     * @return Publishes Airflow web server logs to CloudWatch Logs.
     */
    public final ModuleLoggingConfigurationInput webserverLogs() {
        return webserverLogs;
    }

    /**
     * <p>
     * Publishes Airflow worker logs to CloudWatch Logs.
     * </p>
     * 
     * @return Publishes Airflow worker logs to CloudWatch Logs.
     */
    public final ModuleLoggingConfigurationInput workerLogs() {
        return workerLogs;
    }

    /**
     * <p>
     * Publishes Airflow task logs to CloudWatch Logs.
     * </p>
     * 
     * @return Publishes Airflow task logs to CloudWatch Logs.
     */
    public final ModuleLoggingConfigurationInput taskLogs() {
        return taskLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dagProcessingLogs());
        hashCode = 31 * hashCode + Objects.hashCode(schedulerLogs());
        hashCode = 31 * hashCode + Objects.hashCode(webserverLogs());
        hashCode = 31 * hashCode + Objects.hashCode(workerLogs());
        hashCode = 31 * hashCode + Objects.hashCode(taskLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfigurationInput)) {
            return false;
        }
        LoggingConfigurationInput other = (LoggingConfigurationInput) obj;
        return Objects.equals(dagProcessingLogs(), other.dagProcessingLogs())
                && Objects.equals(schedulerLogs(), other.schedulerLogs())
                && Objects.equals(webserverLogs(), other.webserverLogs()) && Objects.equals(workerLogs(), other.workerLogs())
                && Objects.equals(taskLogs(), other.taskLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoggingConfigurationInput").add("DagProcessingLogs", dagProcessingLogs())
                .add("SchedulerLogs", schedulerLogs()).add("WebserverLogs", webserverLogs()).add("WorkerLogs", workerLogs())
                .add("TaskLogs", taskLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DagProcessingLogs":
            return Optional.ofNullable(clazz.cast(dagProcessingLogs()));
        case "SchedulerLogs":
            return Optional.ofNullable(clazz.cast(schedulerLogs()));
        case "WebserverLogs":
            return Optional.ofNullable(clazz.cast(webserverLogs()));
        case "WorkerLogs":
            return Optional.ofNullable(clazz.cast(workerLogs()));
        case "TaskLogs":
            return Optional.ofNullable(clazz.cast(taskLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfigurationInput, T> g) {
        return obj -> g.apply((LoggingConfigurationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingConfigurationInput> {
        /**
         * <p>
         * Publishes Airflow DAG processing logs to CloudWatch Logs.
         * </p>
         * 
         * @param dagProcessingLogs
         *        Publishes Airflow DAG processing logs to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dagProcessingLogs(ModuleLoggingConfigurationInput dagProcessingLogs);

        /**
         * <p>
         * Publishes Airflow DAG processing logs to CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModuleLoggingConfigurationInput.Builder}
         * avoiding the need to create one manually via {@link ModuleLoggingConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModuleLoggingConfigurationInput.Builder#build()} is called
         * immediately and its result is passed to {@link #dagProcessingLogs(ModuleLoggingConfigurationInput)}.
         * 
         * @param dagProcessingLogs
         *        a consumer that will call methods on {@link ModuleLoggingConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dagProcessingLogs(ModuleLoggingConfigurationInput)
         */
        default Builder dagProcessingLogs(Consumer<ModuleLoggingConfigurationInput.Builder> dagProcessingLogs) {
            return dagProcessingLogs(ModuleLoggingConfigurationInput.builder().applyMutation(dagProcessingLogs).build());
        }

        /**
         * <p>
         * Publishes Airflow scheduler logs to CloudWatch Logs.
         * </p>
         * 
         * @param schedulerLogs
         *        Publishes Airflow scheduler logs to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedulerLogs(ModuleLoggingConfigurationInput schedulerLogs);

        /**
         * <p>
         * Publishes Airflow scheduler logs to CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModuleLoggingConfigurationInput.Builder}
         * avoiding the need to create one manually via {@link ModuleLoggingConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModuleLoggingConfigurationInput.Builder#build()} is called
         * immediately and its result is passed to {@link #schedulerLogs(ModuleLoggingConfigurationInput)}.
         * 
         * @param schedulerLogs
         *        a consumer that will call methods on {@link ModuleLoggingConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedulerLogs(ModuleLoggingConfigurationInput)
         */
        default Builder schedulerLogs(Consumer<ModuleLoggingConfigurationInput.Builder> schedulerLogs) {
            return schedulerLogs(ModuleLoggingConfigurationInput.builder().applyMutation(schedulerLogs).build());
        }

        /**
         * <p>
         * Publishes Airflow web server logs to CloudWatch Logs.
         * </p>
         * 
         * @param webserverLogs
         *        Publishes Airflow web server logs to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webserverLogs(ModuleLoggingConfigurationInput webserverLogs);

        /**
         * <p>
         * Publishes Airflow web server logs to CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModuleLoggingConfigurationInput.Builder}
         * avoiding the need to create one manually via {@link ModuleLoggingConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModuleLoggingConfigurationInput.Builder#build()} is called
         * immediately and its result is passed to {@link #webserverLogs(ModuleLoggingConfigurationInput)}.
         * 
         * @param webserverLogs
         *        a consumer that will call methods on {@link ModuleLoggingConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webserverLogs(ModuleLoggingConfigurationInput)
         */
        default Builder webserverLogs(Consumer<ModuleLoggingConfigurationInput.Builder> webserverLogs) {
            return webserverLogs(ModuleLoggingConfigurationInput.builder().applyMutation(webserverLogs).build());
        }

        /**
         * <p>
         * Publishes Airflow worker logs to CloudWatch Logs.
         * </p>
         * 
         * @param workerLogs
         *        Publishes Airflow worker logs to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerLogs(ModuleLoggingConfigurationInput workerLogs);

        /**
         * <p>
         * Publishes Airflow worker logs to CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModuleLoggingConfigurationInput.Builder}
         * avoiding the need to create one manually via {@link ModuleLoggingConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModuleLoggingConfigurationInput.Builder#build()} is called
         * immediately and its result is passed to {@link #workerLogs(ModuleLoggingConfigurationInput)}.
         * 
         * @param workerLogs
         *        a consumer that will call methods on {@link ModuleLoggingConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workerLogs(ModuleLoggingConfigurationInput)
         */
        default Builder workerLogs(Consumer<ModuleLoggingConfigurationInput.Builder> workerLogs) {
            return workerLogs(ModuleLoggingConfigurationInput.builder().applyMutation(workerLogs).build());
        }

        /**
         * <p>
         * Publishes Airflow task logs to CloudWatch Logs.
         * </p>
         * 
         * @param taskLogs
         *        Publishes Airflow task logs to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskLogs(ModuleLoggingConfigurationInput taskLogs);

        /**
         * <p>
         * Publishes Airflow task logs to CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModuleLoggingConfigurationInput.Builder}
         * avoiding the need to create one manually via {@link ModuleLoggingConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModuleLoggingConfigurationInput.Builder#build()} is called
         * immediately and its result is passed to {@link #taskLogs(ModuleLoggingConfigurationInput)}.
         * 
         * @param taskLogs
         *        a consumer that will call methods on {@link ModuleLoggingConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskLogs(ModuleLoggingConfigurationInput)
         */
        default Builder taskLogs(Consumer<ModuleLoggingConfigurationInput.Builder> taskLogs) {
            return taskLogs(ModuleLoggingConfigurationInput.builder().applyMutation(taskLogs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ModuleLoggingConfigurationInput dagProcessingLogs;

        private ModuleLoggingConfigurationInput schedulerLogs;

        private ModuleLoggingConfigurationInput webserverLogs;

        private ModuleLoggingConfigurationInput workerLogs;

        private ModuleLoggingConfigurationInput taskLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfigurationInput model) {
            dagProcessingLogs(model.dagProcessingLogs);
            schedulerLogs(model.schedulerLogs);
            webserverLogs(model.webserverLogs);
            workerLogs(model.workerLogs);
            taskLogs(model.taskLogs);
        }

        public final ModuleLoggingConfigurationInput.Builder getDagProcessingLogs() {
            return dagProcessingLogs != null ? dagProcessingLogs.toBuilder() : null;
        }

        public final void setDagProcessingLogs(ModuleLoggingConfigurationInput.BuilderImpl dagProcessingLogs) {
            this.dagProcessingLogs = dagProcessingLogs != null ? dagProcessingLogs.build() : null;
        }

        @Override
        public final Builder dagProcessingLogs(ModuleLoggingConfigurationInput dagProcessingLogs) {
            this.dagProcessingLogs = dagProcessingLogs;
            return this;
        }

        public final ModuleLoggingConfigurationInput.Builder getSchedulerLogs() {
            return schedulerLogs != null ? schedulerLogs.toBuilder() : null;
        }

        public final void setSchedulerLogs(ModuleLoggingConfigurationInput.BuilderImpl schedulerLogs) {
            this.schedulerLogs = schedulerLogs != null ? schedulerLogs.build() : null;
        }

        @Override
        public final Builder schedulerLogs(ModuleLoggingConfigurationInput schedulerLogs) {
            this.schedulerLogs = schedulerLogs;
            return this;
        }

        public final ModuleLoggingConfigurationInput.Builder getWebserverLogs() {
            return webserverLogs != null ? webserverLogs.toBuilder() : null;
        }

        public final void setWebserverLogs(ModuleLoggingConfigurationInput.BuilderImpl webserverLogs) {
            this.webserverLogs = webserverLogs != null ? webserverLogs.build() : null;
        }

        @Override
        public final Builder webserverLogs(ModuleLoggingConfigurationInput webserverLogs) {
            this.webserverLogs = webserverLogs;
            return this;
        }

        public final ModuleLoggingConfigurationInput.Builder getWorkerLogs() {
            return workerLogs != null ? workerLogs.toBuilder() : null;
        }

        public final void setWorkerLogs(ModuleLoggingConfigurationInput.BuilderImpl workerLogs) {
            this.workerLogs = workerLogs != null ? workerLogs.build() : null;
        }

        @Override
        public final Builder workerLogs(ModuleLoggingConfigurationInput workerLogs) {
            this.workerLogs = workerLogs;
            return this;
        }

        public final ModuleLoggingConfigurationInput.Builder getTaskLogs() {
            return taskLogs != null ? taskLogs.toBuilder() : null;
        }

        public final void setTaskLogs(ModuleLoggingConfigurationInput.BuilderImpl taskLogs) {
            this.taskLogs = taskLogs != null ? taskLogs.build() : null;
        }

        @Override
        public final Builder taskLogs(ModuleLoggingConfigurationInput taskLogs) {
            this.taskLogs = taskLogs;
            return this;
        }

        @Override
        public LoggingConfigurationInput build() {
            return new LoggingConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
