/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEnvironmentRequest extends MwaaRequest implements
        ToCopyableBuilder<UpdateEnvironmentRequest.Builder, UpdateEnvironmentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateEnvironmentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(UpdateEnvironmentRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<String> AIRFLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AirflowVersion").getter(getter(UpdateEnvironmentRequest::airflowVersion))
            .setter(setter(Builder::airflowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowVersion").build()).build();

    private static final SdkField<String> SOURCE_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceBucketArn").getter(getter(UpdateEnvironmentRequest::sourceBucketArn))
            .setter(setter(Builder::sourceBucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBucketArn").build()).build();

    private static final SdkField<String> DAG_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DagS3Path").getter(getter(UpdateEnvironmentRequest::dagS3Path)).setter(setter(Builder::dagS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagS3Path").build()).build();

    private static final SdkField<String> PLUGINS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PluginsS3Path").getter(getter(UpdateEnvironmentRequest::pluginsS3Path))
            .setter(setter(Builder::pluginsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginsS3Path").build()).build();

    private static final SdkField<String> PLUGINS_S3_OBJECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PluginsS3ObjectVersion").getter(getter(UpdateEnvironmentRequest::pluginsS3ObjectVersion))
            .setter(setter(Builder::pluginsS3ObjectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginsS3ObjectVersion").build())
            .build();

    private static final SdkField<String> REQUIREMENTS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequirementsS3Path").getter(getter(UpdateEnvironmentRequest::requirementsS3Path))
            .setter(setter(Builder::requirementsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirementsS3Path").build())
            .build();

    private static final SdkField<String> REQUIREMENTS_S3_OBJECT_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequirementsS3ObjectVersion")
            .getter(getter(UpdateEnvironmentRequest::requirementsS3ObjectVersion))
            .setter(setter(Builder::requirementsS3ObjectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirementsS3ObjectVersion")
                    .build()).build();

    private static final SdkField<String> STARTUP_SCRIPT_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartupScriptS3Path").getter(getter(UpdateEnvironmentRequest::startupScriptS3Path))
            .setter(setter(Builder::startupScriptS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupScriptS3Path").build())
            .build();

    private static final SdkField<String> STARTUP_SCRIPT_S3_OBJECT_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StartupScriptS3ObjectVersion")
            .getter(getter(UpdateEnvironmentRequest::startupScriptS3ObjectVersion))
            .setter(setter(Builder::startupScriptS3ObjectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupScriptS3ObjectVersion")
                    .build()).build();

    private static final SdkField<Map<String, String>> AIRFLOW_CONFIGURATION_OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AirflowConfigurationOptions")
            .getter(getter(UpdateEnvironmentRequest::airflowConfigurationOptions))
            .setter(setter(Builder::airflowConfigurationOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowConfigurationOptions")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ENVIRONMENT_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentClass").getter(getter(UpdateEnvironmentRequest::environmentClass))
            .setter(setter(Builder::environmentClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentClass").build()).build();

    private static final SdkField<Integer> MAX_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxWorkers").getter(getter(UpdateEnvironmentRequest::maxWorkers)).setter(setter(Builder::maxWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWorkers").build()).build();

    private static final SdkField<UpdateNetworkConfigurationInput> NETWORK_CONFIGURATION_FIELD = SdkField
            .<UpdateNetworkConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("NetworkConfiguration")
            .getter(getter(UpdateEnvironmentRequest::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(UpdateNetworkConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build())
            .build();

    private static final SdkField<LoggingConfigurationInput> LOGGING_CONFIGURATION_FIELD = SdkField
            .<LoggingConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("LoggingConfiguration")
            .getter(getter(UpdateEnvironmentRequest::loggingConfiguration)).setter(setter(Builder::loggingConfiguration))
            .constructor(LoggingConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build())
            .build();

    private static final SdkField<String> WEEKLY_MAINTENANCE_WINDOW_START_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WeeklyMaintenanceWindowStart")
            .getter(getter(UpdateEnvironmentRequest::weeklyMaintenanceWindowStart))
            .setter(setter(Builder::weeklyMaintenanceWindowStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceWindowStart")
                    .build()).build();

    private static final SdkField<String> WEBSERVER_ACCESS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebserverAccessMode").getter(getter(UpdateEnvironmentRequest::webserverAccessModeAsString))
            .setter(setter(Builder::webserverAccessMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverAccessMode").build())
            .build();

    private static final SdkField<Integer> MIN_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinWorkers").getter(getter(UpdateEnvironmentRequest::minWorkers)).setter(setter(Builder::minWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinWorkers").build()).build();

    private static final SdkField<Integer> SCHEDULERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Schedulers").getter(getter(UpdateEnvironmentRequest::schedulers)).setter(setter(Builder::schedulers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedulers").build()).build();

    private static final SdkField<Integer> MIN_WEBSERVERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinWebservers").getter(getter(UpdateEnvironmentRequest::minWebservers))
            .setter(setter(Builder::minWebservers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinWebservers").build()).build();

    private static final SdkField<Integer> MAX_WEBSERVERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxWebservers").getter(getter(UpdateEnvironmentRequest::maxWebservers))
            .setter(setter(Builder::maxWebservers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWebservers").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            EXECUTION_ROLE_ARN_FIELD, AIRFLOW_VERSION_FIELD, SOURCE_BUCKET_ARN_FIELD, DAG_S3_PATH_FIELD, PLUGINS_S3_PATH_FIELD,
            PLUGINS_S3_OBJECT_VERSION_FIELD, REQUIREMENTS_S3_PATH_FIELD, REQUIREMENTS_S3_OBJECT_VERSION_FIELD,
            STARTUP_SCRIPT_S3_PATH_FIELD, STARTUP_SCRIPT_S3_OBJECT_VERSION_FIELD, AIRFLOW_CONFIGURATION_OPTIONS_FIELD,
            ENVIRONMENT_CLASS_FIELD, MAX_WORKERS_FIELD, NETWORK_CONFIGURATION_FIELD, LOGGING_CONFIGURATION_FIELD,
            WEEKLY_MAINTENANCE_WINDOW_START_FIELD, WEBSERVER_ACCESS_MODE_FIELD, MIN_WORKERS_FIELD, SCHEDULERS_FIELD,
            MIN_WEBSERVERS_FIELD, MAX_WEBSERVERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String executionRoleArn;

    private final String airflowVersion;

    private final String sourceBucketArn;

    private final String dagS3Path;

    private final String pluginsS3Path;

    private final String pluginsS3ObjectVersion;

    private final String requirementsS3Path;

    private final String requirementsS3ObjectVersion;

    private final String startupScriptS3Path;

    private final String startupScriptS3ObjectVersion;

    private final Map<String, String> airflowConfigurationOptions;

    private final String environmentClass;

    private final Integer maxWorkers;

    private final UpdateNetworkConfigurationInput networkConfiguration;

    private final LoggingConfigurationInput loggingConfiguration;

    private final String weeklyMaintenanceWindowStart;

    private final String webserverAccessMode;

    private final Integer minWorkers;

    private final Integer schedulers;

    private final Integer minWebservers;

    private final Integer maxWebservers;

    private UpdateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.executionRoleArn = builder.executionRoleArn;
        this.airflowVersion = builder.airflowVersion;
        this.sourceBucketArn = builder.sourceBucketArn;
        this.dagS3Path = builder.dagS3Path;
        this.pluginsS3Path = builder.pluginsS3Path;
        this.pluginsS3ObjectVersion = builder.pluginsS3ObjectVersion;
        this.requirementsS3Path = builder.requirementsS3Path;
        this.requirementsS3ObjectVersion = builder.requirementsS3ObjectVersion;
        this.startupScriptS3Path = builder.startupScriptS3Path;
        this.startupScriptS3ObjectVersion = builder.startupScriptS3ObjectVersion;
        this.airflowConfigurationOptions = builder.airflowConfigurationOptions;
        this.environmentClass = builder.environmentClass;
        this.maxWorkers = builder.maxWorkers;
        this.networkConfiguration = builder.networkConfiguration;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
        this.webserverAccessMode = builder.webserverAccessMode;
        this.minWorkers = builder.minWorkers;
        this.schedulers = builder.schedulers;
        this.minWebservers = builder.minWebservers;
        this.maxWebservers = builder.maxWebservers;
    }

    /**
     * <p>
     * The name of your Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.
     * </p>
     * 
     * @return The name of your Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web Services
     * resources in your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. For more
     * information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA
     * Execution role</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web
     *         Services resources in your environment. For example,
     *         <code>arn:aws:iam::123456789:role/my-execution-role</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution
     *         role</a>.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The Apache Airflow version for your environment. To upgrade your environment, specify a newer version of Apache
     * Airflow supported by Amazon MWAA.
     * </p>
     * <p>
     * Before you upgrade an environment, make sure your requirements, DAGs, plugins, and other resources used in your
     * workflows are compatible with the new Apache Airflow version. For more information about updating your resources,
     * see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/upgrading-environment.html">Upgrading an Amazon
     * MWAA environment</a>.
     * </p>
     * <p>
     * Valid values: <code>1.10.12</code>, <code>2.0.2</code>, <code>2.2.2</code>, <code>2.4.3</code>,
     * <code>2.5.1</code>, <code>2.6.3</code>, <code>2.7.2</code>, <code>2.8.1</code>, <code>2.9.2</code>,
     * <code>2.10.1</code>, and <code>2.10.3</code>.
     * </p>
     * 
     * @return The Apache Airflow version for your environment. To upgrade your environment, specify a newer version of
     *         Apache Airflow supported by Amazon MWAA.</p>
     *         <p>
     *         Before you upgrade an environment, make sure your requirements, DAGs, plugins, and other resources used
     *         in your workflows are compatible with the new Apache Airflow version. For more information about updating
     *         your resources, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/upgrading-environment.html">Upgrading an Amazon
     *         MWAA environment</a>.
     *         </p>
     *         <p>
     *         Valid values: <code>1.10.12</code>, <code>2.0.2</code>, <code>2.2.2</code>, <code>2.4.3</code>,
     *         <code>2.5.1</code>, <code>2.6.3</code>, <code>2.7.2</code>, <code>2.8.1</code>, <code>2.9.2</code>,
     *         <code>2.10.1</code>, and <code>2.10.3</code>.
     */
    public final String airflowVersion() {
        return airflowVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For
     * example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for
     * Amazon MWAA</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are
     *         stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. For more information, see
     *         <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3
     *         bucket for Amazon MWAA</a>.
     */
    public final String sourceBucketArn() {
        return sourceBucketArn;
    }

    /**
     * <p>
     * The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. For more
     * information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding
     * or updating DAGs</a>.
     * </p>
     * 
     * @return The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating
     *         DAGs</a>.
     */
    public final String dagS3Path() {
        return dagS3Path;
    }

    /**
     * <p>
     * The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example,
     * <code>plugins.zip</code>. If specified, then the plugins.zip version is required. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom
     * plugins</a>.
     * </p>
     * 
     * @return The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example,
     *         <code>plugins.zip</code>. If specified, then the plugins.zip version is required. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing
     *         custom plugins</a>.
     */
    public final String pluginsS3Path() {
        return pluginsS3Path;
    }

    /**
     * <p>
     * The version of the plugins.zip file on your Amazon S3 bucket. You must specify a version each time a
     * <code>plugins.zip</code> file is updated. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning
     * works</a>.
     * </p>
     * 
     * @return The version of the plugins.zip file on your Amazon S3 bucket. You must specify a version each time a
     *         <code>plugins.zip</code> file is updated. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning
     *         works</a>.
     */
    public final String pluginsS3ObjectVersion() {
        return pluginsS3ObjectVersion;
    }

    /**
     * <p>
     * The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example,
     * <code>requirements.txt</code>. If specified, then a file version is required. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python
     * dependencies</a>.
     * </p>
     * 
     * @return The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example,
     *         <code>requirements.txt</code>. If specified, then a file version is required. For more information, see
     *         <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing
     *         Python dependencies</a>.
     */
    public final String requirementsS3Path() {
        return requirementsS3Path;
    }

    /**
     * <p>
     * The version of the requirements.txt file on your Amazon S3 bucket. You must specify a version each time a
     * <code>requirements.txt</code> file is updated. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning
     * works</a>.
     * </p>
     * 
     * @return The version of the requirements.txt file on your Amazon S3 bucket. You must specify a version each time a
     *         <code>requirements.txt</code> file is updated. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning
     *         works</a>.
     */
    public final String requirementsS3ObjectVersion() {
        return requirementsS3ObjectVersion;
    }

    /**
     * <p>
     * The relative path to the startup shell script in your Amazon S3 bucket. For example,
     * <code>s3://mwaa-environment/startup.sh</code>.
     * </p>
     * <p>
     * Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You can
     * use this script to install dependencies, modify Apache Airflow configuration options, and set environment
     * variables. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup script</a>.
     * </p>
     * 
     * @return The relative path to the startup shell script in your Amazon S3 bucket. For example,
     *         <code>s3://mwaa-environment/startup.sh</code>.</p>
     *         <p>
     *         Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process.
     *         You can use this script to install dependencies, modify Apache Airflow configuration options, and set
     *         environment variables. For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup
     *         script</a>.
     */
    public final String startupScriptS3Path() {
        return startupScriptS3Path;
    }

    /**
     * <p>
     * The version of the startup shell script in your Amazon S3 bucket. You must specify the <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a> that Amazon
     * S3 assigns to the file every time you update the script.
     * </p>
     * <p>
     * Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The
     * following is an example:
     * </p>
     * <p>
     * <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup script</a>.
     * </p>
     * 
     * @return The version of the startup shell script in your Amazon S3 bucket. You must specify the <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a>
     *         that Amazon S3 assigns to the file every time you update the script. </p>
     *         <p>
     *         Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long.
     *         The following is an example:
     *         </p>
     *         <p>
     *         <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup
     *         script</a>.
     */
    public final String startupScriptS3ObjectVersion() {
        return startupScriptS3ObjectVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the AirflowConfigurationOptions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAirflowConfigurationOptions() {
        return airflowConfigurationOptions != null && !(airflowConfigurationOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your
     * environment. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow
     * configuration options</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAirflowConfigurationOptions} method.
     * </p>
     * 
     * @return A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your
     *         environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow
     *         configuration options</a>.
     */
    public final Map<String, String> airflowConfigurationOptions() {
        return airflowConfigurationOptions;
    }

    /**
     * <p>
     * The environment class type. Valid values: <code>mw1.micro</code>, <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>, <code>mw1.xlarge</code>, and <code>mw1.2xlarge</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment
     * class</a>.
     * </p>
     * 
     * @return The environment class type. Valid values: <code>mw1.micro</code>, <code>mw1.small</code>,
     *         <code>mw1.medium</code>, <code>mw1.large</code>, <code>mw1.xlarge</code>, and <code>mw1.2xlarge</code>.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment
     *         class</a>.
     */
    public final String environmentClass() {
        return environmentClass;
    }

    /**
     * <p>
     * The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow
     * workers up to the number you specify in the <code>MaxWorkers</code> field. For example, <code>20</code>. When
     * there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one
     * worker that is included with your environment, or the number you specify in <code>MinWorkers</code>.
     * </p>
     * 
     * @return The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache
     *         Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. For example,
     *         <code>20</code>. When there are no more tasks running, and no more in the queue, MWAA disposes of the
     *         extra workers leaving the one worker that is included with your environment, or the number you specify in
     *         <code>MinWorkers</code>.
     */
    public final Integer maxWorkers() {
        return maxWorkers;
    }

    /**
     * <p>
     * The VPC networking components used to secure and enable network traffic between the Amazon Web Services resources
     * for your environment. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon
     * MWAA</a>.
     * </p>
     * 
     * @return The VPC networking components used to secure and enable network traffic between the Amazon Web Services
     *         resources for your environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon
     *         MWAA</a>.
     */
    public final UpdateNetworkConfigurationInput networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The Apache Airflow log types to send to CloudWatch Logs.
     * </p>
     * 
     * @return The Apache Airflow log types to send to CloudWatch Logs.
     */
    public final LoggingConfigurationInput loggingConfiguration() {
        return loggingConfiguration;
    }

    /**
     * <p>
     * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time to start weekly
     * maintenance updates of your environment in the following format: <code>DAY:HH:MM</code>. For example:
     * <code>TUE:03:30</code>. You can specify a start time in 30 minute increments only.
     * </p>
     * 
     * @return The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time to start weekly
     *         maintenance updates of your environment in the following format: <code>DAY:HH:MM</code>. For example:
     *         <code>TUE:03:30</code>. You can specify a start time in 30 minute increments only.
     */
    public final String weeklyMaintenanceWindowStart() {
        return weeklyMaintenanceWindowStart;
    }

    /**
     * <p>
     * The Apache Airflow <i>Web server</i> access mode. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access
     * modes</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webserverAccessMode} will return {@link WebserverAccessMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #webserverAccessModeAsString}.
     * </p>
     * 
     * @return The Apache Airflow <i>Web server</i> access mode. For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow
     *         access modes</a>.
     * @see WebserverAccessMode
     */
    public final WebserverAccessMode webserverAccessMode() {
        return WebserverAccessMode.fromValue(webserverAccessMode);
    }

    /**
     * <p>
     * The Apache Airflow <i>Web server</i> access mode. For more information, see <a
     * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access
     * modes</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webserverAccessMode} will return {@link WebserverAccessMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #webserverAccessModeAsString}.
     * </p>
     * 
     * @return The Apache Airflow <i>Web server</i> access mode. For more information, see <a
     *         href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow
     *         access modes</a>.
     * @see WebserverAccessMode
     */
    public final String webserverAccessModeAsString() {
        return webserverAccessMode;
    }

    /**
     * <p>
     * The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow
     * workers up to the number you specify in the <code>MaxWorkers</code> field. When there are no more tasks running,
     * and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the
     * <code>MinWorkers</code> field. For example, <code>2</code>.
     * </p>
     * 
     * @return The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache
     *         Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. When there are no more
     *         tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you
     *         specify in the <code>MinWorkers</code> field. For example, <code>2</code>.
     */
    public final Integer minWorkers() {
        return minWorkers;
    }

    /**
     * <p>
     * The number of Apache Airflow schedulers to run in your Amazon MWAA environment.
     * </p>
     * 
     * @return The number of Apache Airflow schedulers to run in your Amazon MWAA environment.
     */
    public final Integer schedulers() {
        return schedulers;
    }

    /**
     * <p>
     * The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number of
     * Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with
     * your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the
     * transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web servers,
     * and scales down to the number set in <code>MinxWebserers</code>.
     * </p>
     * <p>
     * Valid values: For environments larger than mw1.micro, accepts values from <code>2</code> to <code>5</code>.
     * Defaults to <code>2</code> for all environment sizes except mw1.micro, which defaults to <code>1</code>.
     * </p>
     * 
     * @return The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number
     *         of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you
     *         interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI.
     *         As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the
     *         additional web servers, and scales down to the number set in <code>MinxWebserers</code>. </p>
     *         <p>
     *         Valid values: For environments larger than mw1.micro, accepts values from <code>2</code> to
     *         <code>5</code>. Defaults to <code>2</code> for all environment sizes except mw1.micro, which defaults to
     *         <code>1</code>.
     */
    public final Integer minWebservers() {
        return minWebservers;
    }

    /**
     * <p>
     * The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number of
     * Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with
     * your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in
     * scenarios where your workload requires network calls to the Apache Airflow REST API with a high
     * transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set in
     * <code>MaxWebserers</code>. As TPS rates decrease Amazon MWAA disposes of the additional web servers, and scales
     * down to the number set in <code>MinxWebserers</code>.
     * </p>
     * <p>
     * Valid values: For environments larger than mw1.micro, accepts values from <code>2</code> to <code>5</code>.
     * Defaults to <code>2</code> for all environment sizes except mw1.micro, which defaults to <code>1</code>.
     * </p>
     * 
     * @return The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number
     *         of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you
     *         interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI.
     *         For example, in scenarios where your workload requires network calls to the Apache Airflow REST API with
     *         a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the
     *         number set in <code>MaxWebserers</code>. As TPS rates decrease Amazon MWAA disposes of the additional web
     *         servers, and scales down to the number set in <code>MinxWebserers</code>. </p>
     *         <p>
     *         Valid values: For environments larger than mw1.micro, accepts values from <code>2</code> to
     *         <code>5</code>. Defaults to <code>2</code> for all environment sizes except mw1.micro, which defaults to
     *         <code>1</code>.
     */
    public final Integer maxWebservers() {
        return maxWebservers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(airflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(dagS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(pluginsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(pluginsS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(requirementsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(requirementsS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(startupScriptS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(startupScriptS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasAirflowConfigurationOptions() ? airflowConfigurationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(environmentClass());
        hashCode = 31 * hashCode + Objects.hashCode(maxWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(webserverAccessModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(schedulers());
        hashCode = 31 * hashCode + Objects.hashCode(minWebservers());
        hashCode = 31 * hashCode + Objects.hashCode(maxWebservers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentRequest)) {
            return false;
        }
        UpdateEnvironmentRequest other = (UpdateEnvironmentRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(airflowVersion(), other.airflowVersion())
                && Objects.equals(sourceBucketArn(), other.sourceBucketArn()) && Objects.equals(dagS3Path(), other.dagS3Path())
                && Objects.equals(pluginsS3Path(), other.pluginsS3Path())
                && Objects.equals(pluginsS3ObjectVersion(), other.pluginsS3ObjectVersion())
                && Objects.equals(requirementsS3Path(), other.requirementsS3Path())
                && Objects.equals(requirementsS3ObjectVersion(), other.requirementsS3ObjectVersion())
                && Objects.equals(startupScriptS3Path(), other.startupScriptS3Path())
                && Objects.equals(startupScriptS3ObjectVersion(), other.startupScriptS3ObjectVersion())
                && hasAirflowConfigurationOptions() == other.hasAirflowConfigurationOptions()
                && Objects.equals(airflowConfigurationOptions(), other.airflowConfigurationOptions())
                && Objects.equals(environmentClass(), other.environmentClass())
                && Objects.equals(maxWorkers(), other.maxWorkers())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(loggingConfiguration(), other.loggingConfiguration())
                && Objects.equals(weeklyMaintenanceWindowStart(), other.weeklyMaintenanceWindowStart())
                && Objects.equals(webserverAccessModeAsString(), other.webserverAccessModeAsString())
                && Objects.equals(minWorkers(), other.minWorkers()) && Objects.equals(schedulers(), other.schedulers())
                && Objects.equals(minWebservers(), other.minWebservers())
                && Objects.equals(maxWebservers(), other.maxWebservers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateEnvironmentRequest")
                .add("Name", name())
                .add("ExecutionRoleArn", executionRoleArn())
                .add("AirflowVersion", airflowVersion())
                .add("SourceBucketArn", sourceBucketArn())
                .add("DagS3Path", dagS3Path())
                .add("PluginsS3Path", pluginsS3Path())
                .add("PluginsS3ObjectVersion", pluginsS3ObjectVersion())
                .add("RequirementsS3Path", requirementsS3Path())
                .add("RequirementsS3ObjectVersion", requirementsS3ObjectVersion())
                .add("StartupScriptS3Path", startupScriptS3Path())
                .add("StartupScriptS3ObjectVersion", startupScriptS3ObjectVersion())
                .add("AirflowConfigurationOptions",
                        airflowConfigurationOptions() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EnvironmentClass", environmentClass()).add("MaxWorkers", maxWorkers())
                .add("NetworkConfiguration", networkConfiguration()).add("LoggingConfiguration", loggingConfiguration())
                .add("WeeklyMaintenanceWindowStart", weeklyMaintenanceWindowStart())
                .add("WebserverAccessMode", webserverAccessModeAsString()).add("MinWorkers", minWorkers())
                .add("Schedulers", schedulers()).add("MinWebservers", minWebservers()).add("MaxWebservers", maxWebservers())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "AirflowVersion":
            return Optional.ofNullable(clazz.cast(airflowVersion()));
        case "SourceBucketArn":
            return Optional.ofNullable(clazz.cast(sourceBucketArn()));
        case "DagS3Path":
            return Optional.ofNullable(clazz.cast(dagS3Path()));
        case "PluginsS3Path":
            return Optional.ofNullable(clazz.cast(pluginsS3Path()));
        case "PluginsS3ObjectVersion":
            return Optional.ofNullable(clazz.cast(pluginsS3ObjectVersion()));
        case "RequirementsS3Path":
            return Optional.ofNullable(clazz.cast(requirementsS3Path()));
        case "RequirementsS3ObjectVersion":
            return Optional.ofNullable(clazz.cast(requirementsS3ObjectVersion()));
        case "StartupScriptS3Path":
            return Optional.ofNullable(clazz.cast(startupScriptS3Path()));
        case "StartupScriptS3ObjectVersion":
            return Optional.ofNullable(clazz.cast(startupScriptS3ObjectVersion()));
        case "AirflowConfigurationOptions":
            return Optional.ofNullable(clazz.cast(airflowConfigurationOptions()));
        case "EnvironmentClass":
            return Optional.ofNullable(clazz.cast(environmentClass()));
        case "MaxWorkers":
            return Optional.ofNullable(clazz.cast(maxWorkers()));
        case "NetworkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "LoggingConfiguration":
            return Optional.ofNullable(clazz.cast(loggingConfiguration()));
        case "WeeklyMaintenanceWindowStart":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceWindowStart()));
        case "WebserverAccessMode":
            return Optional.ofNullable(clazz.cast(webserverAccessModeAsString()));
        case "MinWorkers":
            return Optional.ofNullable(clazz.cast(minWorkers()));
        case "Schedulers":
            return Optional.ofNullable(clazz.cast(schedulers()));
        case "MinWebservers":
            return Optional.ofNullable(clazz.cast(minWebservers()));
        case "MaxWebservers":
            return Optional.ofNullable(clazz.cast(maxWebservers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("AirflowVersion", AIRFLOW_VERSION_FIELD);
        map.put("SourceBucketArn", SOURCE_BUCKET_ARN_FIELD);
        map.put("DagS3Path", DAG_S3_PATH_FIELD);
        map.put("PluginsS3Path", PLUGINS_S3_PATH_FIELD);
        map.put("PluginsS3ObjectVersion", PLUGINS_S3_OBJECT_VERSION_FIELD);
        map.put("RequirementsS3Path", REQUIREMENTS_S3_PATH_FIELD);
        map.put("RequirementsS3ObjectVersion", REQUIREMENTS_S3_OBJECT_VERSION_FIELD);
        map.put("StartupScriptS3Path", STARTUP_SCRIPT_S3_PATH_FIELD);
        map.put("StartupScriptS3ObjectVersion", STARTUP_SCRIPT_S3_OBJECT_VERSION_FIELD);
        map.put("AirflowConfigurationOptions", AIRFLOW_CONFIGURATION_OPTIONS_FIELD);
        map.put("EnvironmentClass", ENVIRONMENT_CLASS_FIELD);
        map.put("MaxWorkers", MAX_WORKERS_FIELD);
        map.put("NetworkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("LoggingConfiguration", LOGGING_CONFIGURATION_FIELD);
        map.put("WeeklyMaintenanceWindowStart", WEEKLY_MAINTENANCE_WINDOW_START_FIELD);
        map.put("WebserverAccessMode", WEBSERVER_ACCESS_MODE_FIELD);
        map.put("MinWorkers", MIN_WORKERS_FIELD);
        map.put("Schedulers", SCHEDULERS_FIELD);
        map.put("MinWebservers", MIN_WEBSERVERS_FIELD);
        map.put("MaxWebservers", MAX_WEBSERVERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentRequest, T> g) {
        return obj -> g.apply((UpdateEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MwaaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEnvironmentRequest> {
        /**
         * <p>
         * The name of your Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.
         * </p>
         * 
         * @param name
         *        The name of your Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web Services
         * resources in your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution
         * role</a>.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web
         *        Services resources in your environment. For example,
         *        <code>arn:aws:iam::123456789:role/my-execution-role</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution
         *        role</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The Apache Airflow version for your environment. To upgrade your environment, specify a newer version of
         * Apache Airflow supported by Amazon MWAA.
         * </p>
         * <p>
         * Before you upgrade an environment, make sure your requirements, DAGs, plugins, and other resources used in
         * your workflows are compatible with the new Apache Airflow version. For more information about updating your
         * resources, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/upgrading-environment.html">Upgrading an Amazon MWAA
         * environment</a>.
         * </p>
         * <p>
         * Valid values: <code>1.10.12</code>, <code>2.0.2</code>, <code>2.2.2</code>, <code>2.4.3</code>,
         * <code>2.5.1</code>, <code>2.6.3</code>, <code>2.7.2</code>, <code>2.8.1</code>, <code>2.9.2</code>,
         * <code>2.10.1</code>, and <code>2.10.3</code>.
         * </p>
         * 
         * @param airflowVersion
         *        The Apache Airflow version for your environment. To upgrade your environment, specify a newer version
         *        of Apache Airflow supported by Amazon MWAA.</p>
         *        <p>
         *        Before you upgrade an environment, make sure your requirements, DAGs, plugins, and other resources
         *        used in your workflows are compatible with the new Apache Airflow version. For more information about
         *        updating your resources, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/upgrading-environment.html">Upgrading an
         *        Amazon MWAA environment</a>.
         *        </p>
         *        <p>
         *        Valid values: <code>1.10.12</code>, <code>2.0.2</code>, <code>2.2.2</code>, <code>2.4.3</code>,
         *        <code>2.5.1</code>, <code>2.6.3</code>, <code>2.7.2</code>, <code>2.8.1</code>, <code>2.9.2</code>,
         *        <code>2.10.1</code>, and <code>2.10.3</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder airflowVersion(String airflowVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored.
         * For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for
         * Amazon MWAA</a>.
         * </p>
         * 
         * @param sourceBucketArn
         *        The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are
         *        stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. For more information,
         *        see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon
         *        S3 bucket for Amazon MWAA</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBucketArn(String sourceBucketArn);

        /**
         * <p>
         * The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating
         * DAGs</a>.
         * </p>
         * 
         * @param dagS3Path
         *        The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or
         *        updating DAGs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dagS3Path(String dagS3Path);

        /**
         * <p>
         * The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example,
         * <code>plugins.zip</code>. If specified, then the plugins.zip version is required. For more information, see
         * <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing
         * custom plugins</a>.
         * </p>
         * 
         * @param pluginsS3Path
         *        The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example,
         *        <code>plugins.zip</code>. If specified, then the plugins.zip version is required. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html"
         *        >Installing custom plugins</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginsS3Path(String pluginsS3Path);

        /**
         * <p>
         * The version of the plugins.zip file on your Amazon S3 bucket. You must specify a version each time a
         * <code>plugins.zip</code> file is updated. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning
         * works</a>.
         * </p>
         * 
         * @param pluginsS3ObjectVersion
         *        The version of the plugins.zip file on your Amazon S3 bucket. You must specify a version each time a
         *        <code>plugins.zip</code> file is updated. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3
         *        Versioning works</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginsS3ObjectVersion(String pluginsS3ObjectVersion);

        /**
         * <p>
         * The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example,
         * <code>requirements.txt</code>. If specified, then a file version is required. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python
         * dependencies</a>.
         * </p>
         * 
         * @param requirementsS3Path
         *        The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example,
         *        <code>requirements.txt</code>. If specified, then a file version is required. For more information,
         *        see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing
         *        Python dependencies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requirementsS3Path(String requirementsS3Path);

        /**
         * <p>
         * The version of the requirements.txt file on your Amazon S3 bucket. You must specify a version each time a
         * <code>requirements.txt</code> file is updated. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning
         * works</a>.
         * </p>
         * 
         * @param requirementsS3ObjectVersion
         *        The version of the requirements.txt file on your Amazon S3 bucket. You must specify a version each
         *        time a <code>requirements.txt</code> file is updated. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3
         *        Versioning works</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requirementsS3ObjectVersion(String requirementsS3ObjectVersion);

        /**
         * <p>
         * The relative path to the startup shell script in your Amazon S3 bucket. For example,
         * <code>s3://mwaa-environment/startup.sh</code>.
         * </p>
         * <p>
         * Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You
         * can use this script to install dependencies, modify Apache Airflow configuration options, and set environment
         * variables. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup
         * script</a>.
         * </p>
         * 
         * @param startupScriptS3Path
         *        The relative path to the startup shell script in your Amazon S3 bucket. For example,
         *        <code>s3://mwaa-environment/startup.sh</code>.</p>
         *        <p>
         *        Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process.
         *        You can use this script to install dependencies, modify Apache Airflow configuration options, and set
         *        environment variables. For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup
         *        script</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startupScriptS3Path(String startupScriptS3Path);

        /**
         * <p>
         * The version of the startup shell script in your Amazon S3 bucket. You must specify the <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a> that
         * Amazon S3 assigns to the file every time you update the script.
         * </p>
         * <p>
         * Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The
         * following is an example:
         * </p>
         * <p>
         * <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup
         * script</a>.
         * </p>
         * 
         * @param startupScriptS3ObjectVersion
         *        The version of the startup shell script in your Amazon S3 bucket. You must specify the <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a>
         *        that Amazon S3 assigns to the file every time you update the script. </p>
         *        <p>
         *        Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes
         *        long. The following is an example:
         *        </p>
         *        <p>
         *        <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup
         *        script</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startupScriptS3ObjectVersion(String startupScriptS3ObjectVersion);

        /**
         * <p>
         * A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your
         * environment. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow
         * configuration options</a>.
         * </p>
         * 
         * @param airflowConfigurationOptions
         *        A list of key-value pairs containing the Apache Airflow configuration options you want to attach to
         *        your environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow
         *        configuration options</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder airflowConfigurationOptions(Map<String, String> airflowConfigurationOptions);

        /**
         * <p>
         * The environment class type. Valid values: <code>mw1.micro</code>, <code>mw1.small</code>,
         * <code>mw1.medium</code>, <code>mw1.large</code>, <code>mw1.xlarge</code>, and <code>mw1.2xlarge</code>. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment
         * class</a>.
         * </p>
         * 
         * @param environmentClass
         *        The environment class type. Valid values: <code>mw1.micro</code>, <code>mw1.small</code>,
         *        <code>mw1.medium</code>, <code>mw1.large</code>, <code>mw1.xlarge</code>, and <code>mw1.2xlarge</code>
         *        . For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA
         *        environment class</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentClass(String environmentClass);

        /**
         * <p>
         * The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache
         * Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. For example,
         * <code>20</code>. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra
         * workers leaving the one worker that is included with your environment, or the number you specify in
         * <code>MinWorkers</code>.
         * </p>
         * 
         * @param maxWorkers
         *        The maximum number of workers that you want to run in your environment. MWAA scales the number of
         *        Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. For example,
         *        <code>20</code>. When there are no more tasks running, and no more in the queue, MWAA disposes of the
         *        extra workers leaving the one worker that is included with your environment, or the number you specify
         *        in <code>MinWorkers</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWorkers(Integer maxWorkers);

        /**
         * <p>
         * The VPC networking components used to secure and enable network traffic between the Amazon Web Services
         * resources for your environment. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon
         * MWAA</a>.
         * </p>
         * 
         * @param networkConfiguration
         *        The VPC networking components used to secure and enable network traffic between the Amazon Web
         *        Services resources for your environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on
         *        Amazon MWAA</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(UpdateNetworkConfigurationInput networkConfiguration);

        /**
         * <p>
         * The VPC networking components used to secure and enable network traffic between the Amazon Web Services
         * resources for your environment. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon
         * MWAA</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateNetworkConfigurationInput.Builder}
         * avoiding the need to create one manually via {@link UpdateNetworkConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateNetworkConfigurationInput.Builder#build()} is called
         * immediately and its result is passed to {@link #networkConfiguration(UpdateNetworkConfigurationInput)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link UpdateNetworkConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(UpdateNetworkConfigurationInput)
         */
        default Builder networkConfiguration(Consumer<UpdateNetworkConfigurationInput.Builder> networkConfiguration) {
            return networkConfiguration(UpdateNetworkConfigurationInput.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * The Apache Airflow log types to send to CloudWatch Logs.
         * </p>
         * 
         * @param loggingConfiguration
         *        The Apache Airflow log types to send to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfiguration(LoggingConfigurationInput loggingConfiguration);

        /**
         * <p>
         * The Apache Airflow log types to send to CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoggingConfigurationInput.Builder}
         * avoiding the need to create one manually via {@link LoggingConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingConfigurationInput.Builder#build()} is called immediately
         * and its result is passed to {@link #loggingConfiguration(LoggingConfigurationInput)}.
         * 
         * @param loggingConfiguration
         *        a consumer that will call methods on {@link LoggingConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfiguration(LoggingConfigurationInput)
         */
        default Builder loggingConfiguration(Consumer<LoggingConfigurationInput.Builder> loggingConfiguration) {
            return loggingConfiguration(LoggingConfigurationInput.builder().applyMutation(loggingConfiguration).build());
        }

        /**
         * <p>
         * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time to start weekly
         * maintenance updates of your environment in the following format: <code>DAY:HH:MM</code>. For example:
         * <code>TUE:03:30</code>. You can specify a start time in 30 minute increments only.
         * </p>
         * 
         * @param weeklyMaintenanceWindowStart
         *        The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time to start weekly
         *        maintenance updates of your environment in the following format: <code>DAY:HH:MM</code>. For example:
         *        <code>TUE:03:30</code>. You can specify a start time in 30 minute increments only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart);

        /**
         * <p>
         * The Apache Airflow <i>Web server</i> access mode. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access
         * modes</a>.
         * </p>
         * 
         * @param webserverAccessMode
         *        The Apache Airflow <i>Web server</i> access mode. For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow
         *        access modes</a>.
         * @see WebserverAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebserverAccessMode
         */
        Builder webserverAccessMode(String webserverAccessMode);

        /**
         * <p>
         * The Apache Airflow <i>Web server</i> access mode. For more information, see <a
         * href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access
         * modes</a>.
         * </p>
         * 
         * @param webserverAccessMode
         *        The Apache Airflow <i>Web server</i> access mode. For more information, see <a
         *        href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow
         *        access modes</a>.
         * @see WebserverAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebserverAccessMode
         */
        Builder webserverAccessMode(WebserverAccessMode webserverAccessMode);

        /**
         * <p>
         * The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache
         * Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. When there are no more
         * tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you
         * specify in the <code>MinWorkers</code> field. For example, <code>2</code>.
         * </p>
         * 
         * @param minWorkers
         *        The minimum number of workers that you want to run in your environment. MWAA scales the number of
         *        Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. When there
         *        are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the
         *        worker count you specify in the <code>MinWorkers</code> field. For example, <code>2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minWorkers(Integer minWorkers);

        /**
         * <p>
         * The number of Apache Airflow schedulers to run in your Amazon MWAA environment.
         * </p>
         * 
         * @param schedulers
         *        The number of Apache Airflow schedulers to run in your Amazon MWAA environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedulers(Integer schedulers);

        /**
         * <p>
         * The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number of
         * Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with
         * your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the
         * transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web
         * servers, and scales down to the number set in <code>MinxWebserers</code>.
         * </p>
         * <p>
         * Valid values: For environments larger than mw1.micro, accepts values from <code>2</code> to <code>5</code>.
         * Defaults to <code>2</code> for all environment sizes except mw1.micro, which defaults to <code>1</code>.
         * </p>
         * 
         * @param minWebservers
         *        The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the
         *        number of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when
         *        you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow
         *        CLI. As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the
         *        additional web servers, and scales down to the number set in <code>MinxWebserers</code>. </p>
         *        <p>
         *        Valid values: For environments larger than mw1.micro, accepts values from <code>2</code> to
         *        <code>5</code>. Defaults to <code>2</code> for all environment sizes except mw1.micro, which defaults
         *        to <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minWebservers(Integer minWebservers);

        /**
         * <p>
         * The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number of
         * Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with
         * your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in
         * scenarios where your workload requires network calls to the Apache Airflow REST API with a high
         * transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set
         * in <code>MaxWebserers</code>. As TPS rates decrease Amazon MWAA disposes of the additional web servers, and
         * scales down to the number set in <code>MinxWebserers</code>.
         * </p>
         * <p>
         * Valid values: For environments larger than mw1.micro, accepts values from <code>2</code> to <code>5</code>.
         * Defaults to <code>2</code> for all environment sizes except mw1.micro, which defaults to <code>1</code>.
         * </p>
         * 
         * @param maxWebservers
         *        The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the
         *        number of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when
         *        you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow
         *        CLI. For example, in scenarios where your workload requires network calls to the Apache Airflow REST
         *        API with a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers
         *        up to the number set in <code>MaxWebserers</code>. As TPS rates decrease Amazon MWAA disposes of the
         *        additional web servers, and scales down to the number set in <code>MinxWebserers</code>. </p>
         *        <p>
         *        Valid values: For environments larger than mw1.micro, accepts values from <code>2</code> to
         *        <code>5</code>. Defaults to <code>2</code> for all environment sizes except mw1.micro, which defaults
         *        to <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWebservers(Integer maxWebservers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MwaaRequest.BuilderImpl implements Builder {
        private String name;

        private String executionRoleArn;

        private String airflowVersion;

        private String sourceBucketArn;

        private String dagS3Path;

        private String pluginsS3Path;

        private String pluginsS3ObjectVersion;

        private String requirementsS3Path;

        private String requirementsS3ObjectVersion;

        private String startupScriptS3Path;

        private String startupScriptS3ObjectVersion;

        private Map<String, String> airflowConfigurationOptions = DefaultSdkAutoConstructMap.getInstance();

        private String environmentClass;

        private Integer maxWorkers;

        private UpdateNetworkConfigurationInput networkConfiguration;

        private LoggingConfigurationInput loggingConfiguration;

        private String weeklyMaintenanceWindowStart;

        private String webserverAccessMode;

        private Integer minWorkers;

        private Integer schedulers;

        private Integer minWebservers;

        private Integer maxWebservers;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentRequest model) {
            super(model);
            name(model.name);
            executionRoleArn(model.executionRoleArn);
            airflowVersion(model.airflowVersion);
            sourceBucketArn(model.sourceBucketArn);
            dagS3Path(model.dagS3Path);
            pluginsS3Path(model.pluginsS3Path);
            pluginsS3ObjectVersion(model.pluginsS3ObjectVersion);
            requirementsS3Path(model.requirementsS3Path);
            requirementsS3ObjectVersion(model.requirementsS3ObjectVersion);
            startupScriptS3Path(model.startupScriptS3Path);
            startupScriptS3ObjectVersion(model.startupScriptS3ObjectVersion);
            airflowConfigurationOptions(model.airflowConfigurationOptions);
            environmentClass(model.environmentClass);
            maxWorkers(model.maxWorkers);
            networkConfiguration(model.networkConfiguration);
            loggingConfiguration(model.loggingConfiguration);
            weeklyMaintenanceWindowStart(model.weeklyMaintenanceWindowStart);
            webserverAccessMode(model.webserverAccessMode);
            minWorkers(model.minWorkers);
            schedulers(model.schedulers);
            minWebservers(model.minWebservers);
            maxWebservers(model.maxWebservers);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getAirflowVersion() {
            return airflowVersion;
        }

        public final void setAirflowVersion(String airflowVersion) {
            this.airflowVersion = airflowVersion;
        }

        @Override
        public final Builder airflowVersion(String airflowVersion) {
            this.airflowVersion = airflowVersion;
            return this;
        }

        public final String getSourceBucketArn() {
            return sourceBucketArn;
        }

        public final void setSourceBucketArn(String sourceBucketArn) {
            this.sourceBucketArn = sourceBucketArn;
        }

        @Override
        public final Builder sourceBucketArn(String sourceBucketArn) {
            this.sourceBucketArn = sourceBucketArn;
            return this;
        }

        public final String getDagS3Path() {
            return dagS3Path;
        }

        public final void setDagS3Path(String dagS3Path) {
            this.dagS3Path = dagS3Path;
        }

        @Override
        public final Builder dagS3Path(String dagS3Path) {
            this.dagS3Path = dagS3Path;
            return this;
        }

        public final String getPluginsS3Path() {
            return pluginsS3Path;
        }

        public final void setPluginsS3Path(String pluginsS3Path) {
            this.pluginsS3Path = pluginsS3Path;
        }

        @Override
        public final Builder pluginsS3Path(String pluginsS3Path) {
            this.pluginsS3Path = pluginsS3Path;
            return this;
        }

        public final String getPluginsS3ObjectVersion() {
            return pluginsS3ObjectVersion;
        }

        public final void setPluginsS3ObjectVersion(String pluginsS3ObjectVersion) {
            this.pluginsS3ObjectVersion = pluginsS3ObjectVersion;
        }

        @Override
        public final Builder pluginsS3ObjectVersion(String pluginsS3ObjectVersion) {
            this.pluginsS3ObjectVersion = pluginsS3ObjectVersion;
            return this;
        }

        public final String getRequirementsS3Path() {
            return requirementsS3Path;
        }

        public final void setRequirementsS3Path(String requirementsS3Path) {
            this.requirementsS3Path = requirementsS3Path;
        }

        @Override
        public final Builder requirementsS3Path(String requirementsS3Path) {
            this.requirementsS3Path = requirementsS3Path;
            return this;
        }

        public final String getRequirementsS3ObjectVersion() {
            return requirementsS3ObjectVersion;
        }

        public final void setRequirementsS3ObjectVersion(String requirementsS3ObjectVersion) {
            this.requirementsS3ObjectVersion = requirementsS3ObjectVersion;
        }

        @Override
        public final Builder requirementsS3ObjectVersion(String requirementsS3ObjectVersion) {
            this.requirementsS3ObjectVersion = requirementsS3ObjectVersion;
            return this;
        }

        public final String getStartupScriptS3Path() {
            return startupScriptS3Path;
        }

        public final void setStartupScriptS3Path(String startupScriptS3Path) {
            this.startupScriptS3Path = startupScriptS3Path;
        }

        @Override
        public final Builder startupScriptS3Path(String startupScriptS3Path) {
            this.startupScriptS3Path = startupScriptS3Path;
            return this;
        }

        public final String getStartupScriptS3ObjectVersion() {
            return startupScriptS3ObjectVersion;
        }

        public final void setStartupScriptS3ObjectVersion(String startupScriptS3ObjectVersion) {
            this.startupScriptS3ObjectVersion = startupScriptS3ObjectVersion;
        }

        @Override
        public final Builder startupScriptS3ObjectVersion(String startupScriptS3ObjectVersion) {
            this.startupScriptS3ObjectVersion = startupScriptS3ObjectVersion;
            return this;
        }

        public final Map<String, String> getAirflowConfigurationOptions() {
            if (airflowConfigurationOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return airflowConfigurationOptions;
        }

        public final void setAirflowConfigurationOptions(Map<String, String> airflowConfigurationOptions) {
            this.airflowConfigurationOptions = AirflowConfigurationOptionsCopier.copy(airflowConfigurationOptions);
        }

        @Override
        public final Builder airflowConfigurationOptions(Map<String, String> airflowConfigurationOptions) {
            this.airflowConfigurationOptions = AirflowConfigurationOptionsCopier.copy(airflowConfigurationOptions);
            return this;
        }

        public final String getEnvironmentClass() {
            return environmentClass;
        }

        public final void setEnvironmentClass(String environmentClass) {
            this.environmentClass = environmentClass;
        }

        @Override
        public final Builder environmentClass(String environmentClass) {
            this.environmentClass = environmentClass;
            return this;
        }

        public final Integer getMaxWorkers() {
            return maxWorkers;
        }

        public final void setMaxWorkers(Integer maxWorkers) {
            this.maxWorkers = maxWorkers;
        }

        @Override
        public final Builder maxWorkers(Integer maxWorkers) {
            this.maxWorkers = maxWorkers;
            return this;
        }

        public final UpdateNetworkConfigurationInput.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(UpdateNetworkConfigurationInput.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(UpdateNetworkConfigurationInput networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final LoggingConfigurationInput.Builder getLoggingConfiguration() {
            return loggingConfiguration != null ? loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfigurationInput.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfigurationInput loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final String getWeeklyMaintenanceWindowStart() {
            return weeklyMaintenanceWindowStart;
        }

        public final void setWeeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
        }

        @Override
        public final Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        public final String getWebserverAccessMode() {
            return webserverAccessMode;
        }

        public final void setWebserverAccessMode(String webserverAccessMode) {
            this.webserverAccessMode = webserverAccessMode;
        }

        @Override
        public final Builder webserverAccessMode(String webserverAccessMode) {
            this.webserverAccessMode = webserverAccessMode;
            return this;
        }

        @Override
        public final Builder webserverAccessMode(WebserverAccessMode webserverAccessMode) {
            this.webserverAccessMode(webserverAccessMode == null ? null : webserverAccessMode.toString());
            return this;
        }

        public final Integer getMinWorkers() {
            return minWorkers;
        }

        public final void setMinWorkers(Integer minWorkers) {
            this.minWorkers = minWorkers;
        }

        @Override
        public final Builder minWorkers(Integer minWorkers) {
            this.minWorkers = minWorkers;
            return this;
        }

        public final Integer getSchedulers() {
            return schedulers;
        }

        public final void setSchedulers(Integer schedulers) {
            this.schedulers = schedulers;
        }

        @Override
        public final Builder schedulers(Integer schedulers) {
            this.schedulers = schedulers;
            return this;
        }

        public final Integer getMinWebservers() {
            return minWebservers;
        }

        public final void setMinWebservers(Integer minWebservers) {
            this.minWebservers = minWebservers;
        }

        @Override
        public final Builder minWebservers(Integer minWebservers) {
            this.minWebservers = minWebservers;
            return this;
        }

        public final Integer getMaxWebservers() {
            return maxWebservers;
        }

        public final void setMaxWebservers(Integer maxWebservers) {
            this.maxWebservers = maxWebservers;
        }

        @Override
        public final Builder maxWebservers(Integer maxWebservers) {
            this.maxWebservers = maxWebservers;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnvironmentRequest build() {
            return new UpdateEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
