/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWebLoginTokenResponse extends MwaaResponse implements
        ToCopyableBuilder<CreateWebLoginTokenResponse.Builder, CreateWebLoginTokenResponse> {
    private static final SdkField<String> WEB_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebToken").getter(getter(CreateWebLoginTokenResponse::webToken)).setter(setter(Builder::webToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebToken").build()).build();

    private static final SdkField<String> WEB_SERVER_HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebServerHostname").getter(getter(CreateWebLoginTokenResponse::webServerHostname))
            .setter(setter(Builder::webServerHostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebServerHostname").build()).build();

    private static final SdkField<String> IAM_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamIdentity").getter(getter(CreateWebLoginTokenResponse::iamIdentity))
            .setter(setter(Builder::iamIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamIdentity").build()).build();

    private static final SdkField<String> AIRFLOW_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AirflowIdentity").getter(getter(CreateWebLoginTokenResponse::airflowIdentity))
            .setter(setter(Builder::airflowIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowIdentity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_TOKEN_FIELD,
            WEB_SERVER_HOSTNAME_FIELD, IAM_IDENTITY_FIELD, AIRFLOW_IDENTITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String webToken;

    private final String webServerHostname;

    private final String iamIdentity;

    private final String airflowIdentity;

    private CreateWebLoginTokenResponse(BuilderImpl builder) {
        super(builder);
        this.webToken = builder.webToken;
        this.webServerHostname = builder.webServerHostname;
        this.iamIdentity = builder.iamIdentity;
        this.airflowIdentity = builder.airflowIdentity;
    }

    /**
     * <p>
     * An Airflow web server login token.
     * </p>
     * 
     * @return An Airflow web server login token.
     */
    public final String webToken() {
        return webToken;
    }

    /**
     * <p>
     * The Airflow web server hostname for the environment.
     * </p>
     * 
     * @return The Airflow web server hostname for the environment.
     */
    public final String webServerHostname() {
        return webServerHostname;
    }

    /**
     * <p>
     * The name of the IAM identity creating the web login token. This might be an IAM user, or an assumed or federated
     * identity. For example, <code>assumed-role/Admin/your-name</code>.
     * </p>
     * 
     * @return The name of the IAM identity creating the web login token. This might be an IAM user, or an assumed or
     *         federated identity. For example, <code>assumed-role/Admin/your-name</code>.
     */
    public final String iamIdentity() {
        return iamIdentity;
    }

    /**
     * <p>
     * The user name of the Apache Airflow identity creating the web login token.
     * </p>
     * 
     * @return The user name of the Apache Airflow identity creating the web login token.
     */
    public final String airflowIdentity() {
        return airflowIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webToken());
        hashCode = 31 * hashCode + Objects.hashCode(webServerHostname());
        hashCode = 31 * hashCode + Objects.hashCode(iamIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(airflowIdentity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebLoginTokenResponse)) {
            return false;
        }
        CreateWebLoginTokenResponse other = (CreateWebLoginTokenResponse) obj;
        return Objects.equals(webToken(), other.webToken()) && Objects.equals(webServerHostname(), other.webServerHostname())
                && Objects.equals(iamIdentity(), other.iamIdentity())
                && Objects.equals(airflowIdentity(), other.airflowIdentity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWebLoginTokenResponse")
                .add("WebToken", webToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WebServerHostname", webServerHostname()).add("IamIdentity", iamIdentity())
                .add("AirflowIdentity", airflowIdentity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebToken":
            return Optional.ofNullable(clazz.cast(webToken()));
        case "WebServerHostname":
            return Optional.ofNullable(clazz.cast(webServerHostname()));
        case "IamIdentity":
            return Optional.ofNullable(clazz.cast(iamIdentity()));
        case "AirflowIdentity":
            return Optional.ofNullable(clazz.cast(airflowIdentity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WebToken", WEB_TOKEN_FIELD);
        map.put("WebServerHostname", WEB_SERVER_HOSTNAME_FIELD);
        map.put("IamIdentity", IAM_IDENTITY_FIELD);
        map.put("AirflowIdentity", AIRFLOW_IDENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWebLoginTokenResponse, T> g) {
        return obj -> g.apply((CreateWebLoginTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MwaaResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateWebLoginTokenResponse> {
        /**
         * <p>
         * An Airflow web server login token.
         * </p>
         * 
         * @param webToken
         *        An Airflow web server login token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webToken(String webToken);

        /**
         * <p>
         * The Airflow web server hostname for the environment.
         * </p>
         * 
         * @param webServerHostname
         *        The Airflow web server hostname for the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webServerHostname(String webServerHostname);

        /**
         * <p>
         * The name of the IAM identity creating the web login token. This might be an IAM user, or an assumed or
         * federated identity. For example, <code>assumed-role/Admin/your-name</code>.
         * </p>
         * 
         * @param iamIdentity
         *        The name of the IAM identity creating the web login token. This might be an IAM user, or an assumed or
         *        federated identity. For example, <code>assumed-role/Admin/your-name</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamIdentity(String iamIdentity);

        /**
         * <p>
         * The user name of the Apache Airflow identity creating the web login token.
         * </p>
         * 
         * @param airflowIdentity
         *        The user name of the Apache Airflow identity creating the web login token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder airflowIdentity(String airflowIdentity);
    }

    static final class BuilderImpl extends MwaaResponse.BuilderImpl implements Builder {
        private String webToken;

        private String webServerHostname;

        private String iamIdentity;

        private String airflowIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWebLoginTokenResponse model) {
            super(model);
            webToken(model.webToken);
            webServerHostname(model.webServerHostname);
            iamIdentity(model.iamIdentity);
            airflowIdentity(model.airflowIdentity);
        }

        public final String getWebToken() {
            return webToken;
        }

        public final void setWebToken(String webToken) {
            this.webToken = webToken;
        }

        @Override
        public final Builder webToken(String webToken) {
            this.webToken = webToken;
            return this;
        }

        public final String getWebServerHostname() {
            return webServerHostname;
        }

        public final void setWebServerHostname(String webServerHostname) {
            this.webServerHostname = webServerHostname;
        }

        @Override
        public final Builder webServerHostname(String webServerHostname) {
            this.webServerHostname = webServerHostname;
            return this;
        }

        public final String getIamIdentity() {
            return iamIdentity;
        }

        public final void setIamIdentity(String iamIdentity) {
            this.iamIdentity = iamIdentity;
        }

        @Override
        public final Builder iamIdentity(String iamIdentity) {
            this.iamIdentity = iamIdentity;
            return this;
        }

        public final String getAirflowIdentity() {
            return airflowIdentity;
        }

        public final void setAirflowIdentity(String airflowIdentity) {
            this.airflowIdentity = airflowIdentity;
        }

        @Override
        public final Builder airflowIdentity(String airflowIdentity) {
            this.airflowIdentity = airflowIdentity;
            return this;
        }

        @Override
        public CreateWebLoginTokenResponse build() {
            return new CreateWebLoginTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
