/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeRestApiRequest extends MwaaRequest implements
        ToCopyableBuilder<InvokeRestApiRequest.Builder, InvokeRestApiRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(InvokeRestApiRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(InvokeRestApiRequest::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Method")
            .getter(getter(InvokeRestApiRequest::methodAsString)).setter(setter(Builder::method))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Method").build()).build();

    private static final SdkField<Document> QUERY_PARAMETERS_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("QueryParameters").getter(getter(InvokeRestApiRequest::queryParameters))
            .setter(setter(Builder::queryParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryParameters").build()).build();

    private static final SdkField<Document> BODY_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT).memberName("Body")
            .getter(getter(InvokeRestApiRequest::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PATH_FIELD,
            METHOD_FIELD, QUERY_PARAMETERS_FIELD, BODY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String path;

    private final String method;

    private final Document queryParameters;

    private final Document body;

    private InvokeRestApiRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.path = builder.path;
        this.method = builder.method;
        this.queryParameters = builder.queryParameters;
        this.body = builder.body;
    }

    /**
     * <p>
     * The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.
     * </p>
     * 
     * @return The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Apache Airflow REST API endpoint path to be called. For example, <code>/dags/123456/clearTaskInstances</code>
     * . For more information, see <a
     * href="https://airflow.apache.org/docs/apache-airflow/stable/stable-rest-api-ref.html">Apache Airflow API</a>
     * </p>
     * 
     * @return The Apache Airflow REST API endpoint path to be called. For example,
     *         <code>/dags/123456/clearTaskInstances</code>. For more information, see <a
     *         href="https://airflow.apache.org/docs/apache-airflow/stable/stable-rest-api-ref.html">Apache Airflow
     *         API</a>
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The HTTP method used for making Airflow REST API calls. For example, <code>POST</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #method} will
     * return {@link RestApiMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #methodAsString}.
     * </p>
     * 
     * @return The HTTP method used for making Airflow REST API calls. For example, <code>POST</code>.
     * @see RestApiMethod
     */
    public final RestApiMethod method() {
        return RestApiMethod.fromValue(method);
    }

    /**
     * <p>
     * The HTTP method used for making Airflow REST API calls. For example, <code>POST</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #method} will
     * return {@link RestApiMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #methodAsString}.
     * </p>
     * 
     * @return The HTTP method used for making Airflow REST API calls. For example, <code>POST</code>.
     * @see RestApiMethod
     */
    public final String methodAsString() {
        return method;
    }

    /**
     * <p>
     * Query parameters to be included in the Apache Airflow REST API call, provided as a JSON object.
     * </p>
     * 
     * @return Query parameters to be included in the Apache Airflow REST API call, provided as a JSON object.
     */
    public final Document queryParameters() {
        return queryParameters;
    }

    /**
     * <p>
     * The request body for the Apache Airflow REST API call, provided as a JSON object.
     * </p>
     * 
     * @return The request body for the Apache Airflow REST API call, provided as a JSON object.
     */
    public final Document body() {
        return body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(methodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queryParameters());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeRestApiRequest)) {
            return false;
        }
        InvokeRestApiRequest other = (InvokeRestApiRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(path(), other.path())
                && Objects.equals(methodAsString(), other.methodAsString())
                && Objects.equals(queryParameters(), other.queryParameters()) && Objects.equals(body(), other.body());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeRestApiRequest").add("Name", name()).add("Path", path()).add("Method", methodAsString())
                .add("QueryParameters", queryParameters()).add("Body", body() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "Method":
            return Optional.ofNullable(clazz.cast(methodAsString()));
        case "QueryParameters":
            return Optional.ofNullable(clazz.cast(queryParameters()));
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Path", PATH_FIELD);
        map.put("Method", METHOD_FIELD);
        map.put("QueryParameters", QUERY_PARAMETERS_FIELD);
        map.put("Body", BODY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeRestApiRequest, T> g) {
        return obj -> g.apply((InvokeRestApiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MwaaRequest.Builder, SdkPojo, CopyableBuilder<Builder, InvokeRestApiRequest> {
        /**
         * <p>
         * The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.
         * </p>
         * 
         * @param name
         *        The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Apache Airflow REST API endpoint path to be called. For example,
         * <code>/dags/123456/clearTaskInstances</code>. For more information, see <a
         * href="https://airflow.apache.org/docs/apache-airflow/stable/stable-rest-api-ref.html">Apache Airflow API</a>
         * </p>
         * 
         * @param path
         *        The Apache Airflow REST API endpoint path to be called. For example,
         *        <code>/dags/123456/clearTaskInstances</code>. For more information, see <a
         *        href="https://airflow.apache.org/docs/apache-airflow/stable/stable-rest-api-ref.html">Apache Airflow
         *        API</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The HTTP method used for making Airflow REST API calls. For example, <code>POST</code>.
         * </p>
         * 
         * @param method
         *        The HTTP method used for making Airflow REST API calls. For example, <code>POST</code>.
         * @see RestApiMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RestApiMethod
         */
        Builder method(String method);

        /**
         * <p>
         * The HTTP method used for making Airflow REST API calls. For example, <code>POST</code>.
         * </p>
         * 
         * @param method
         *        The HTTP method used for making Airflow REST API calls. For example, <code>POST</code>.
         * @see RestApiMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RestApiMethod
         */
        Builder method(RestApiMethod method);

        /**
         * <p>
         * Query parameters to be included in the Apache Airflow REST API call, provided as a JSON object.
         * </p>
         * 
         * @param queryParameters
         *        Query parameters to be included in the Apache Airflow REST API call, provided as a JSON object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParameters(Document queryParameters);

        /**
         * <p>
         * The request body for the Apache Airflow REST API call, provided as a JSON object.
         * </p>
         * 
         * @param body
         *        The request body for the Apache Airflow REST API call, provided as a JSON object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(Document body);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MwaaRequest.BuilderImpl implements Builder {
        private String name;

        private String path;

        private String method;

        private Document queryParameters;

        private Document body;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeRestApiRequest model) {
            super(model);
            name(model.name);
            path(model.path);
            method(model.method);
            queryParameters(model.queryParameters);
            body(model.body);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getMethod() {
            return method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        @Override
        public final Builder method(RestApiMethod method) {
            this.method(method == null ? null : method.toString());
            return this;
        }

        public final Document getQueryParameters() {
            return queryParameters;
        }

        public final void setQueryParameters(Document queryParameters) {
            this.queryParameters = queryParameters;
        }

        @Override
        public final Builder queryParameters(Document queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        public final Document getBody() {
            return body;
        }

        public final void setBody(Document body) {
            this.body = body;
        }

        @Override
        public final Builder body(Document body) {
            this.body = body;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeRestApiRequest build() {
            return new InvokeRestApiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
