/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeRestApiResponse extends MwaaResponse implements
        ToCopyableBuilder<InvokeRestApiResponse.Builder, InvokeRestApiResponse> {
    private static final SdkField<Integer> REST_API_STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RestApiStatusCode").getter(getter(InvokeRestApiResponse::restApiStatusCode))
            .setter(setter(Builder::restApiStatusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestApiStatusCode").build()).build();

    private static final SdkField<Document> REST_API_RESPONSE_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("RestApiResponse").getter(getter(InvokeRestApiResponse::restApiResponse))
            .setter(setter(Builder::restApiResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestApiResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_STATUS_CODE_FIELD,
            REST_API_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer restApiStatusCode;

    private final Document restApiResponse;

    private InvokeRestApiResponse(BuilderImpl builder) {
        super(builder);
        this.restApiStatusCode = builder.restApiStatusCode;
        this.restApiResponse = builder.restApiResponse;
    }

    /**
     * <p>
     * The HTTP status code returned by the Apache Airflow REST API call.
     * </p>
     * 
     * @return The HTTP status code returned by the Apache Airflow REST API call.
     */
    public final Integer restApiStatusCode() {
        return restApiStatusCode;
    }

    /**
     * <p>
     * The response data from the Apache Airflow REST API call, provided as a JSON object.
     * </p>
     * 
     * @return The response data from the Apache Airflow REST API call, provided as a JSON object.
     */
    public final Document restApiResponse() {
        return restApiResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiStatusCode());
        hashCode = 31 * hashCode + Objects.hashCode(restApiResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeRestApiResponse)) {
            return false;
        }
        InvokeRestApiResponse other = (InvokeRestApiResponse) obj;
        return Objects.equals(restApiStatusCode(), other.restApiStatusCode())
                && Objects.equals(restApiResponse(), other.restApiResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeRestApiResponse").add("RestApiStatusCode", restApiStatusCode())
                .add("RestApiResponse", restApiResponse() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RestApiStatusCode":
            return Optional.ofNullable(clazz.cast(restApiStatusCode()));
        case "RestApiResponse":
            return Optional.ofNullable(clazz.cast(restApiResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RestApiStatusCode", REST_API_STATUS_CODE_FIELD);
        map.put("RestApiResponse", REST_API_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeRestApiResponse, T> g) {
        return obj -> g.apply((InvokeRestApiResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MwaaResponse.Builder, SdkPojo, CopyableBuilder<Builder, InvokeRestApiResponse> {
        /**
         * <p>
         * The HTTP status code returned by the Apache Airflow REST API call.
         * </p>
         * 
         * @param restApiStatusCode
         *        The HTTP status code returned by the Apache Airflow REST API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiStatusCode(Integer restApiStatusCode);

        /**
         * <p>
         * The response data from the Apache Airflow REST API call, provided as a JSON object.
         * </p>
         * 
         * @param restApiResponse
         *        The response data from the Apache Airflow REST API call, provided as a JSON object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiResponse(Document restApiResponse);
    }

    static final class BuilderImpl extends MwaaResponse.BuilderImpl implements Builder {
        private Integer restApiStatusCode;

        private Document restApiResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeRestApiResponse model) {
            super(model);
            restApiStatusCode(model.restApiStatusCode);
            restApiResponse(model.restApiResponse);
        }

        public final Integer getRestApiStatusCode() {
            return restApiStatusCode;
        }

        public final void setRestApiStatusCode(Integer restApiStatusCode) {
            this.restApiStatusCode = restApiStatusCode;
        }

        @Override
        public final Builder restApiStatusCode(Integer restApiStatusCode) {
            this.restApiStatusCode = restApiStatusCode;
            return this;
        }

        public final Document getRestApiResponse() {
            return restApiResponse;
        }

        public final void setRestApiResponse(Document restApiResponse) {
            this.restApiResponse = restApiResponse;
        }

        @Override
        public final Builder restApiResponse(Document restApiResponse) {
            this.restApiResponse = restApiResponse;
            return this;
        }

        @Override
        public InvokeRestApiResponse build() {
            return new InvokeRestApiResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
