/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaa.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Apache Airflow log types that are published to CloudWatch Logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LoggingConfiguration.Builder, LoggingConfiguration> {
    private static final SdkField<ModuleLoggingConfiguration> DAG_PROCESSING_LOGS_FIELD = SdkField
            .<ModuleLoggingConfiguration> builder(MarshallingType.SDK_POJO).memberName("DagProcessingLogs")
            .getter(getter(LoggingConfiguration::dagProcessingLogs)).setter(setter(Builder::dagProcessingLogs))
            .constructor(ModuleLoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagProcessingLogs").build()).build();

    private static final SdkField<ModuleLoggingConfiguration> SCHEDULER_LOGS_FIELD = SdkField
            .<ModuleLoggingConfiguration> builder(MarshallingType.SDK_POJO).memberName("SchedulerLogs")
            .getter(getter(LoggingConfiguration::schedulerLogs)).setter(setter(Builder::schedulerLogs))
            .constructor(ModuleLoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchedulerLogs").build()).build();

    private static final SdkField<ModuleLoggingConfiguration> WEBSERVER_LOGS_FIELD = SdkField
            .<ModuleLoggingConfiguration> builder(MarshallingType.SDK_POJO).memberName("WebserverLogs")
            .getter(getter(LoggingConfiguration::webserverLogs)).setter(setter(Builder::webserverLogs))
            .constructor(ModuleLoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverLogs").build()).build();

    private static final SdkField<ModuleLoggingConfiguration> WORKER_LOGS_FIELD = SdkField
            .<ModuleLoggingConfiguration> builder(MarshallingType.SDK_POJO).memberName("WorkerLogs")
            .getter(getter(LoggingConfiguration::workerLogs)).setter(setter(Builder::workerLogs))
            .constructor(ModuleLoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerLogs").build()).build();

    private static final SdkField<ModuleLoggingConfiguration> TASK_LOGS_FIELD = SdkField
            .<ModuleLoggingConfiguration> builder(MarshallingType.SDK_POJO).memberName("TaskLogs")
            .getter(getter(LoggingConfiguration::taskLogs)).setter(setter(Builder::taskLogs))
            .constructor(ModuleLoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAG_PROCESSING_LOGS_FIELD,
            SCHEDULER_LOGS_FIELD, WEBSERVER_LOGS_FIELD, WORKER_LOGS_FIELD, TASK_LOGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ModuleLoggingConfiguration dagProcessingLogs;

    private final ModuleLoggingConfiguration schedulerLogs;

    private final ModuleLoggingConfiguration webserverLogs;

    private final ModuleLoggingConfiguration workerLogs;

    private final ModuleLoggingConfiguration taskLogs;

    private LoggingConfiguration(BuilderImpl builder) {
        this.dagProcessingLogs = builder.dagProcessingLogs;
        this.schedulerLogs = builder.schedulerLogs;
        this.webserverLogs = builder.webserverLogs;
        this.workerLogs = builder.workerLogs;
        this.taskLogs = builder.taskLogs;
    }

    /**
     * <p>
     * The Airflow DAG processing logs published to CloudWatch Logs and the log level.
     * </p>
     * 
     * @return The Airflow DAG processing logs published to CloudWatch Logs and the log level.
     */
    public final ModuleLoggingConfiguration dagProcessingLogs() {
        return dagProcessingLogs;
    }

    /**
     * <p>
     * The Airflow scheduler logs published to CloudWatch Logs and the log level.
     * </p>
     * 
     * @return The Airflow scheduler logs published to CloudWatch Logs and the log level.
     */
    public final ModuleLoggingConfiguration schedulerLogs() {
        return schedulerLogs;
    }

    /**
     * <p>
     * The Airflow web server logs published to CloudWatch Logs and the log level.
     * </p>
     * 
     * @return The Airflow web server logs published to CloudWatch Logs and the log level.
     */
    public final ModuleLoggingConfiguration webserverLogs() {
        return webserverLogs;
    }

    /**
     * <p>
     * The Airflow worker logs published to CloudWatch Logs and the log level.
     * </p>
     * 
     * @return The Airflow worker logs published to CloudWatch Logs and the log level.
     */
    public final ModuleLoggingConfiguration workerLogs() {
        return workerLogs;
    }

    /**
     * <p>
     * The Airflow task logs published to CloudWatch Logs and the log level.
     * </p>
     * 
     * @return The Airflow task logs published to CloudWatch Logs and the log level.
     */
    public final ModuleLoggingConfiguration taskLogs() {
        return taskLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dagProcessingLogs());
        hashCode = 31 * hashCode + Objects.hashCode(schedulerLogs());
        hashCode = 31 * hashCode + Objects.hashCode(webserverLogs());
        hashCode = 31 * hashCode + Objects.hashCode(workerLogs());
        hashCode = 31 * hashCode + Objects.hashCode(taskLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfiguration)) {
            return false;
        }
        LoggingConfiguration other = (LoggingConfiguration) obj;
        return Objects.equals(dagProcessingLogs(), other.dagProcessingLogs())
                && Objects.equals(schedulerLogs(), other.schedulerLogs())
                && Objects.equals(webserverLogs(), other.webserverLogs()) && Objects.equals(workerLogs(), other.workerLogs())
                && Objects.equals(taskLogs(), other.taskLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoggingConfiguration").add("DagProcessingLogs", dagProcessingLogs())
                .add("SchedulerLogs", schedulerLogs()).add("WebserverLogs", webserverLogs()).add("WorkerLogs", workerLogs())
                .add("TaskLogs", taskLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DagProcessingLogs":
            return Optional.ofNullable(clazz.cast(dagProcessingLogs()));
        case "SchedulerLogs":
            return Optional.ofNullable(clazz.cast(schedulerLogs()));
        case "WebserverLogs":
            return Optional.ofNullable(clazz.cast(webserverLogs()));
        case "WorkerLogs":
            return Optional.ofNullable(clazz.cast(workerLogs()));
        case "TaskLogs":
            return Optional.ofNullable(clazz.cast(taskLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DagProcessingLogs", DAG_PROCESSING_LOGS_FIELD);
        map.put("SchedulerLogs", SCHEDULER_LOGS_FIELD);
        map.put("WebserverLogs", WEBSERVER_LOGS_FIELD);
        map.put("WorkerLogs", WORKER_LOGS_FIELD);
        map.put("TaskLogs", TASK_LOGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfiguration, T> g) {
        return obj -> g.apply((LoggingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingConfiguration> {
        /**
         * <p>
         * The Airflow DAG processing logs published to CloudWatch Logs and the log level.
         * </p>
         * 
         * @param dagProcessingLogs
         *        The Airflow DAG processing logs published to CloudWatch Logs and the log level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dagProcessingLogs(ModuleLoggingConfiguration dagProcessingLogs);

        /**
         * <p>
         * The Airflow DAG processing logs published to CloudWatch Logs and the log level.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModuleLoggingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ModuleLoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModuleLoggingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #dagProcessingLogs(ModuleLoggingConfiguration)}.
         * 
         * @param dagProcessingLogs
         *        a consumer that will call methods on {@link ModuleLoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dagProcessingLogs(ModuleLoggingConfiguration)
         */
        default Builder dagProcessingLogs(Consumer<ModuleLoggingConfiguration.Builder> dagProcessingLogs) {
            return dagProcessingLogs(ModuleLoggingConfiguration.builder().applyMutation(dagProcessingLogs).build());
        }

        /**
         * <p>
         * The Airflow scheduler logs published to CloudWatch Logs and the log level.
         * </p>
         * 
         * @param schedulerLogs
         *        The Airflow scheduler logs published to CloudWatch Logs and the log level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedulerLogs(ModuleLoggingConfiguration schedulerLogs);

        /**
         * <p>
         * The Airflow scheduler logs published to CloudWatch Logs and the log level.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModuleLoggingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ModuleLoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModuleLoggingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #schedulerLogs(ModuleLoggingConfiguration)}.
         * 
         * @param schedulerLogs
         *        a consumer that will call methods on {@link ModuleLoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedulerLogs(ModuleLoggingConfiguration)
         */
        default Builder schedulerLogs(Consumer<ModuleLoggingConfiguration.Builder> schedulerLogs) {
            return schedulerLogs(ModuleLoggingConfiguration.builder().applyMutation(schedulerLogs).build());
        }

        /**
         * <p>
         * The Airflow web server logs published to CloudWatch Logs and the log level.
         * </p>
         * 
         * @param webserverLogs
         *        The Airflow web server logs published to CloudWatch Logs and the log level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webserverLogs(ModuleLoggingConfiguration webserverLogs);

        /**
         * <p>
         * The Airflow web server logs published to CloudWatch Logs and the log level.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModuleLoggingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ModuleLoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModuleLoggingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #webserverLogs(ModuleLoggingConfiguration)}.
         * 
         * @param webserverLogs
         *        a consumer that will call methods on {@link ModuleLoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webserverLogs(ModuleLoggingConfiguration)
         */
        default Builder webserverLogs(Consumer<ModuleLoggingConfiguration.Builder> webserverLogs) {
            return webserverLogs(ModuleLoggingConfiguration.builder().applyMutation(webserverLogs).build());
        }

        /**
         * <p>
         * The Airflow worker logs published to CloudWatch Logs and the log level.
         * </p>
         * 
         * @param workerLogs
         *        The Airflow worker logs published to CloudWatch Logs and the log level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerLogs(ModuleLoggingConfiguration workerLogs);

        /**
         * <p>
         * The Airflow worker logs published to CloudWatch Logs and the log level.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModuleLoggingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ModuleLoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModuleLoggingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #workerLogs(ModuleLoggingConfiguration)}.
         * 
         * @param workerLogs
         *        a consumer that will call methods on {@link ModuleLoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workerLogs(ModuleLoggingConfiguration)
         */
        default Builder workerLogs(Consumer<ModuleLoggingConfiguration.Builder> workerLogs) {
            return workerLogs(ModuleLoggingConfiguration.builder().applyMutation(workerLogs).build());
        }

        /**
         * <p>
         * The Airflow task logs published to CloudWatch Logs and the log level.
         * </p>
         * 
         * @param taskLogs
         *        The Airflow task logs published to CloudWatch Logs and the log level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskLogs(ModuleLoggingConfiguration taskLogs);

        /**
         * <p>
         * The Airflow task logs published to CloudWatch Logs and the log level.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModuleLoggingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ModuleLoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModuleLoggingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #taskLogs(ModuleLoggingConfiguration)}.
         * 
         * @param taskLogs
         *        a consumer that will call methods on {@link ModuleLoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskLogs(ModuleLoggingConfiguration)
         */
        default Builder taskLogs(Consumer<ModuleLoggingConfiguration.Builder> taskLogs) {
            return taskLogs(ModuleLoggingConfiguration.builder().applyMutation(taskLogs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ModuleLoggingConfiguration dagProcessingLogs;

        private ModuleLoggingConfiguration schedulerLogs;

        private ModuleLoggingConfiguration webserverLogs;

        private ModuleLoggingConfiguration workerLogs;

        private ModuleLoggingConfiguration taskLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfiguration model) {
            dagProcessingLogs(model.dagProcessingLogs);
            schedulerLogs(model.schedulerLogs);
            webserverLogs(model.webserverLogs);
            workerLogs(model.workerLogs);
            taskLogs(model.taskLogs);
        }

        public final ModuleLoggingConfiguration.Builder getDagProcessingLogs() {
            return dagProcessingLogs != null ? dagProcessingLogs.toBuilder() : null;
        }

        public final void setDagProcessingLogs(ModuleLoggingConfiguration.BuilderImpl dagProcessingLogs) {
            this.dagProcessingLogs = dagProcessingLogs != null ? dagProcessingLogs.build() : null;
        }

        @Override
        public final Builder dagProcessingLogs(ModuleLoggingConfiguration dagProcessingLogs) {
            this.dagProcessingLogs = dagProcessingLogs;
            return this;
        }

        public final ModuleLoggingConfiguration.Builder getSchedulerLogs() {
            return schedulerLogs != null ? schedulerLogs.toBuilder() : null;
        }

        public final void setSchedulerLogs(ModuleLoggingConfiguration.BuilderImpl schedulerLogs) {
            this.schedulerLogs = schedulerLogs != null ? schedulerLogs.build() : null;
        }

        @Override
        public final Builder schedulerLogs(ModuleLoggingConfiguration schedulerLogs) {
            this.schedulerLogs = schedulerLogs;
            return this;
        }

        public final ModuleLoggingConfiguration.Builder getWebserverLogs() {
            return webserverLogs != null ? webserverLogs.toBuilder() : null;
        }

        public final void setWebserverLogs(ModuleLoggingConfiguration.BuilderImpl webserverLogs) {
            this.webserverLogs = webserverLogs != null ? webserverLogs.build() : null;
        }

        @Override
        public final Builder webserverLogs(ModuleLoggingConfiguration webserverLogs) {
            this.webserverLogs = webserverLogs;
            return this;
        }

        public final ModuleLoggingConfiguration.Builder getWorkerLogs() {
            return workerLogs != null ? workerLogs.toBuilder() : null;
        }

        public final void setWorkerLogs(ModuleLoggingConfiguration.BuilderImpl workerLogs) {
            this.workerLogs = workerLogs != null ? workerLogs.build() : null;
        }

        @Override
        public final Builder workerLogs(ModuleLoggingConfiguration workerLogs) {
            this.workerLogs = workerLogs;
            return this;
        }

        public final ModuleLoggingConfiguration.Builder getTaskLogs() {
            return taskLogs != null ? taskLogs.toBuilder() : null;
        }

        public final void setTaskLogs(ModuleLoggingConfiguration.BuilderImpl taskLogs) {
            this.taskLogs = taskLogs != null ? taskLogs.build() : null;
        }

        @Override
        public final Builder taskLogs(ModuleLoggingConfiguration taskLogs) {
            this.taskLogs = taskLogs;
            return this;
        }

        @Override
        public LoggingConfiguration build() {
            return new LoggingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
