/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaaserverless;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.mwaaserverless.model.CreateWorkflowRequest;
import software.amazon.awssdk.services.mwaaserverless.model.CreateWorkflowResponse;
import software.amazon.awssdk.services.mwaaserverless.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.mwaaserverless.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.mwaaserverless.model.GetTaskInstanceRequest;
import software.amazon.awssdk.services.mwaaserverless.model.GetTaskInstanceResponse;
import software.amazon.awssdk.services.mwaaserverless.model.GetWorkflowRequest;
import software.amazon.awssdk.services.mwaaserverless.model.GetWorkflowResponse;
import software.amazon.awssdk.services.mwaaserverless.model.GetWorkflowRunRequest;
import software.amazon.awssdk.services.mwaaserverless.model.GetWorkflowRunResponse;
import software.amazon.awssdk.services.mwaaserverless.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mwaaserverless.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mwaaserverless.model.ListTaskInstancesRequest;
import software.amazon.awssdk.services.mwaaserverless.model.ListTaskInstancesResponse;
import software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowRunsRequest;
import software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowRunsResponse;
import software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowVersionsRequest;
import software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowVersionsResponse;
import software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.mwaaserverless.model.StartWorkflowRunRequest;
import software.amazon.awssdk.services.mwaaserverless.model.StartWorkflowRunResponse;
import software.amazon.awssdk.services.mwaaserverless.model.StopWorkflowRunRequest;
import software.amazon.awssdk.services.mwaaserverless.model.StopWorkflowRunResponse;
import software.amazon.awssdk.services.mwaaserverless.model.TagResourceRequest;
import software.amazon.awssdk.services.mwaaserverless.model.TagResourceResponse;
import software.amazon.awssdk.services.mwaaserverless.model.UntagResourceRequest;
import software.amazon.awssdk.services.mwaaserverless.model.UntagResourceResponse;
import software.amazon.awssdk.services.mwaaserverless.model.UpdateWorkflowRequest;
import software.amazon.awssdk.services.mwaaserverless.model.UpdateWorkflowResponse;
import software.amazon.awssdk.services.mwaaserverless.paginators.ListTaskInstancesPublisher;
import software.amazon.awssdk.services.mwaaserverless.paginators.ListWorkflowRunsPublisher;
import software.amazon.awssdk.services.mwaaserverless.paginators.ListWorkflowVersionsPublisher;
import software.amazon.awssdk.services.mwaaserverless.paginators.ListWorkflowsPublisher;

/**
 * Service client for accessing AmazonMWAAServerless asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon Managed Workflows for Apache Airflow Serverless provides a managed workflow orchestration platform for running
 * Apache Airflow workflows in a serverless environment. You can use Amazon Managed Workflows for Apache Airflow
 * Serverless to create, manage, and run data processing workflows without managing the underlying infrastructure,
 * Airflow clusters, metadata databases, or scheduling overhead. The service provides secure multi-tenant run
 * environments with automatic scaling, comprehensive logging, and integration with multiple Amazon Web Services
 * services for orchestrating complex analytics workloads.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MwaaServerlessAsyncClient extends AwsClient {
    String SERVICE_NAME = "airflow-serverless";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "airflow-serverless";

    /**
     * <p>
     * Creates a new workflow in Amazon Managed Workflows for Apache Airflow Serverless. This operation initializes a
     * workflow with the specified configuration including the workflow definition, execution role, and optional
     * settings for encryption, logging, and networking. You must provide the workflow definition as a YAML file stored
     * in Amazon S3 that defines the DAG structure using supported Amazon Web Services operators. Amazon Managed
     * Workflows for Apache Airflow Serverless automatically creates the first version of the workflow and sets up the
     * necessary execution environment with multi-tenant isolation and security controls.
     * </p>
     *
     * @param createWorkflowRequest
     * @return A Java Future containing the result of the CreateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ConflictException You cannot create a resource that already exists, or the resource is in a state
     *         that prevents the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request exceeds the service quota for Amazon Managed Workflows for
     *         Apache Airflow Serverless resources. This can occur when you attempt to create more workflows than
     *         allowed, exceed concurrent workflow run limits, or surpass task execution limits. Amazon Managed
     *         Workflows for Apache Airflow Serverless implements admission control using DynamoDB-based counters to
     *         manage resource utilization across the multi-tenant environment. Contact Amazon Web Services Support to
     *         request quota increases if you need higher limits for your use case.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/CreateWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkflowResponse> createWorkflow(CreateWorkflowRequest createWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new workflow in Amazon Managed Workflows for Apache Airflow Serverless. This operation initializes a
     * workflow with the specified configuration including the workflow definition, execution role, and optional
     * settings for encryption, logging, and networking. You must provide the workflow definition as a YAML file stored
     * in Amazon S3 that defines the DAG structure using supported Amazon Web Services operators. Amazon Managed
     * Workflows for Apache Airflow Serverless automatically creates the first version of the workflow and sets up the
     * necessary execution environment with multi-tenant isolation and security controls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWorkflowRequest#builder()}
     * </p>
     *
     * @param createWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.CreateWorkflowRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ConflictException You cannot create a resource that already exists, or the resource is in a state
     *         that prevents the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request exceeds the service quota for Amazon Managed Workflows for
     *         Apache Airflow Serverless resources. This can occur when you attempt to create more workflows than
     *         allowed, exceed concurrent workflow run limits, or surpass task execution limits. Amazon Managed
     *         Workflows for Apache Airflow Serverless implements admission control using DynamoDB-based counters to
     *         manage resource utilization across the multi-tenant environment. Contact Amazon Web Services Support to
     *         request quota increases if you need higher limits for your use case.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/CreateWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkflowResponse> createWorkflow(Consumer<CreateWorkflowRequest.Builder> createWorkflowRequest) {
        return createWorkflow(CreateWorkflowRequest.builder().applyMutation(createWorkflowRequest).build());
    }

    /**
     * <p>
     * Deletes a workflow and all its versions. This operation permanently removes the workflow and cannot be undone.
     * Amazon Managed Workflows for Apache Airflow Serverless ensures that all associated resources are properly cleaned
     * up, including stopping any running executions, removing scheduled triggers, and cleaning up execution history.
     * The deletion process respects the multi-tenant isolation boundaries and ensures that no residual data or
     * configurations remain that could affect other customers or workflows.
     * </p>
     *
     * @param deleteWorkflowRequest
     * @return A Java Future containing the result of the DeleteWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/DeleteWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkflowResponse> deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workflow and all its versions. This operation permanently removes the workflow and cannot be undone.
     * Amazon Managed Workflows for Apache Airflow Serverless ensures that all associated resources are properly cleaned
     * up, including stopping any running executions, removing scheduled triggers, and cleaning up execution history.
     * The deletion process respects the multi-tenant isolation boundaries and ensures that no residual data or
     * configurations remain that could affect other customers or workflows.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkflowRequest#builder()}
     * </p>
     *
     * @param deleteWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.DeleteWorkflowRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/DeleteWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkflowResponse> deleteWorkflow(Consumer<DeleteWorkflowRequest.Builder> deleteWorkflowRequest) {
        return deleteWorkflow(DeleteWorkflowRequest.builder().applyMutation(deleteWorkflowRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific task instance within a workflow run. Task instances represent
     * individual tasks that are executed as part of a workflow in the Amazon Managed Workflows for Apache Airflow
     * Serverless environment. Each task instance runs in an isolated ECS container with dedicated resources and
     * security boundaries. The service tracks task execution state, retry attempts, and provides detailed timing and
     * error information for troubleshooting and monitoring purposes.
     * </p>
     *
     * @param getTaskInstanceRequest
     * @return A Java Future containing the result of the GetTaskInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.GetTaskInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/GetTaskInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTaskInstanceResponse> getTaskInstance(GetTaskInstanceRequest getTaskInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific task instance within a workflow run. Task instances represent
     * individual tasks that are executed as part of a workflow in the Amazon Managed Workflows for Apache Airflow
     * Serverless environment. Each task instance runs in an isolated ECS container with dedicated resources and
     * security boundaries. The service tracks task execution state, retry attempts, and provides detailed timing and
     * error information for troubleshooting and monitoring purposes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTaskInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link GetTaskInstanceRequest#builder()}
     * </p>
     *
     * @param getTaskInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.GetTaskInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTaskInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.GetTaskInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/GetTaskInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTaskInstanceResponse> getTaskInstance(
            Consumer<GetTaskInstanceRequest.Builder> getTaskInstanceRequest) {
        return getTaskInstance(GetTaskInstanceRequest.builder().applyMutation(getTaskInstanceRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a workflow, including its configuration, status, and metadata.
     * </p>
     *
     * @param getWorkflowRequest
     * @return A Java Future containing the result of the GetWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/GetWorkflow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWorkflowResponse> getWorkflow(GetWorkflowRequest getWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a workflow, including its configuration, status, and metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkflowRequest#builder()}
     * </p>
     *
     * @param getWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.GetWorkflowRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/GetWorkflow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWorkflowResponse> getWorkflow(Consumer<GetWorkflowRequest.Builder> getWorkflowRequest) {
        return getWorkflow(GetWorkflowRequest.builder().applyMutation(getWorkflowRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific workflow run, including its status, execution details, and task
     * instances.
     * </p>
     *
     * @param getWorkflowRunRequest
     * @return A Java Future containing the result of the GetWorkflowRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.GetWorkflowRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/GetWorkflowRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkflowRunResponse> getWorkflowRun(GetWorkflowRunRequest getWorkflowRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific workflow run, including its status, execution details, and task
     * instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowRunRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkflowRunRequest#builder()}
     * </p>
     *
     * @param getWorkflowRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.GetWorkflowRunRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetWorkflowRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.GetWorkflowRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/GetWorkflowRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkflowRunResponse> getWorkflowRun(Consumer<GetWorkflowRunRequest.Builder> getWorkflowRunRequest) {
        return getWorkflowRun(GetWorkflowRunRequest.builder().applyMutation(getWorkflowRunRequest).build());
    }

    /**
     * <p>
     * Lists all tags that are associated with a specified Amazon Managed Workflows for Apache Airflow Serverless
     * resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags that are associated with a specified Amazon Managed Workflows for Apache Airflow Serverless
     * resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all task instances for a specific workflow run, with optional pagination support.
     * </p>
     *
     * @param listTaskInstancesRequest
     * @return A Java Future containing the result of the ListTaskInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListTaskInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListTaskInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTaskInstancesResponse> listTaskInstances(ListTaskInstancesRequest listTaskInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all task instances for a specific workflow run, with optional pagination support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTaskInstancesRequest.Builder} avoiding the need
     * to create one manually via {@link ListTaskInstancesRequest#builder()}
     * </p>
     *
     * @param listTaskInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.ListTaskInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTaskInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListTaskInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListTaskInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTaskInstancesResponse> listTaskInstances(
            Consumer<ListTaskInstancesRequest.Builder> listTaskInstancesRequest) {
        return listTaskInstances(ListTaskInstancesRequest.builder().applyMutation(listTaskInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaskInstances(software.amazon.awssdk.services.mwaaserverless.model.ListTaskInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mwaaserverless.paginators.ListTaskInstancesPublisher publisher = client.listTaskInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mwaaserverless.paginators.ListTaskInstancesPublisher publisher = client.listTaskInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mwaaserverless.model.ListTaskInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mwaaserverless.model.ListTaskInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaskInstances(software.amazon.awssdk.services.mwaaserverless.model.ListTaskInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTaskInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListTaskInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListTaskInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTaskInstancesPublisher listTaskInstancesPaginator(ListTaskInstancesRequest listTaskInstancesRequest) {
        return new ListTaskInstancesPublisher(this, listTaskInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaskInstances(software.amazon.awssdk.services.mwaaserverless.model.ListTaskInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mwaaserverless.paginators.ListTaskInstancesPublisher publisher = client.listTaskInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mwaaserverless.paginators.ListTaskInstancesPublisher publisher = client.listTaskInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mwaaserverless.model.ListTaskInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mwaaserverless.model.ListTaskInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaskInstances(software.amazon.awssdk.services.mwaaserverless.model.ListTaskInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTaskInstancesRequest.Builder} avoiding the need
     * to create one manually via {@link ListTaskInstancesRequest#builder()}
     * </p>
     *
     * @param listTaskInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.ListTaskInstancesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListTaskInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListTaskInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTaskInstancesPublisher listTaskInstancesPaginator(
            Consumer<ListTaskInstancesRequest.Builder> listTaskInstancesRequest) {
        return listTaskInstancesPaginator(ListTaskInstancesRequest.builder().applyMutation(listTaskInstancesRequest).build());
    }

    /**
     * <p>
     * Lists all runs for a specified workflow, with optional pagination and filtering support.
     * </p>
     *
     * @param listWorkflowRunsRequest
     * @return A Java Future containing the result of the ListWorkflowRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListWorkflowRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListWorkflowRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkflowRunsResponse> listWorkflowRuns(ListWorkflowRunsRequest listWorkflowRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all runs for a specified workflow, with optional pagination and filtering support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowRunsRequest.Builder} avoiding the need
     * to create one manually via {@link ListWorkflowRunsRequest#builder()}
     * </p>
     *
     * @param listWorkflowRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowRunsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListWorkflowRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListWorkflowRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListWorkflowRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkflowRunsResponse> listWorkflowRuns(
            Consumer<ListWorkflowRunsRequest.Builder> listWorkflowRunsRequest) {
        return listWorkflowRuns(ListWorkflowRunsRequest.builder().applyMutation(listWorkflowRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkflowRuns(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mwaaserverless.paginators.ListWorkflowRunsPublisher publisher = client.listWorkflowRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mwaaserverless.paginators.ListWorkflowRunsPublisher publisher = client.listWorkflowRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflowRuns(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkflowRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListWorkflowRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListWorkflowRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowRunsPublisher listWorkflowRunsPaginator(ListWorkflowRunsRequest listWorkflowRunsRequest) {
        return new ListWorkflowRunsPublisher(this, listWorkflowRunsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkflowRuns(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mwaaserverless.paginators.ListWorkflowRunsPublisher publisher = client.listWorkflowRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mwaaserverless.paginators.ListWorkflowRunsPublisher publisher = client.listWorkflowRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflowRuns(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowRunsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowRunsRequest.Builder} avoiding the need
     * to create one manually via {@link ListWorkflowRunsRequest#builder()}
     * </p>
     *
     * @param listWorkflowRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowRunsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListWorkflowRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListWorkflowRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowRunsPublisher listWorkflowRunsPaginator(Consumer<ListWorkflowRunsRequest.Builder> listWorkflowRunsRequest) {
        return listWorkflowRunsPaginator(ListWorkflowRunsRequest.builder().applyMutation(listWorkflowRunsRequest).build());
    }

    /**
     * <p>
     * Lists all versions of a specified workflow, with optional pagination support.
     * </p>
     *
     * @param listWorkflowVersionsRequest
     * @return A Java Future containing the result of the ListWorkflowVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListWorkflowVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListWorkflowVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkflowVersionsResponse> listWorkflowVersions(
            ListWorkflowVersionsRequest listWorkflowVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all versions of a specified workflow, with optional pagination support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkflowVersionsRequest#builder()}
     * </p>
     *
     * @param listWorkflowVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowVersionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListWorkflowVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListWorkflowVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListWorkflowVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkflowVersionsResponse> listWorkflowVersions(
            Consumer<ListWorkflowVersionsRequest.Builder> listWorkflowVersionsRequest) {
        return listWorkflowVersions(ListWorkflowVersionsRequest.builder().applyMutation(listWorkflowVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkflowVersions(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mwaaserverless.paginators.ListWorkflowVersionsPublisher publisher = client.listWorkflowVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mwaaserverless.paginators.ListWorkflowVersionsPublisher publisher = client.listWorkflowVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflowVersions(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkflowVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListWorkflowVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListWorkflowVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowVersionsPublisher listWorkflowVersionsPaginator(ListWorkflowVersionsRequest listWorkflowVersionsRequest) {
        return new ListWorkflowVersionsPublisher(this, listWorkflowVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkflowVersions(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mwaaserverless.paginators.ListWorkflowVersionsPublisher publisher = client.listWorkflowVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mwaaserverless.paginators.ListWorkflowVersionsPublisher publisher = client.listWorkflowVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflowVersions(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkflowVersionsRequest#builder()}
     * </p>
     *
     * @param listWorkflowVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowVersionsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListWorkflowVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListWorkflowVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowVersionsPublisher listWorkflowVersionsPaginator(
            Consumer<ListWorkflowVersionsRequest.Builder> listWorkflowVersionsRequest) {
        return listWorkflowVersionsPaginator(ListWorkflowVersionsRequest.builder().applyMutation(listWorkflowVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all workflows in your account, with optional pagination support. This operation returns summary information
     * for workflows, showing only the most recently created version of each workflow. Amazon Managed Workflows for
     * Apache Airflow Serverless maintains workflow metadata in a highly available, distributed storage system that
     * enables efficient querying and filtering. The service implements proper access controls to ensure you can only
     * view workflows that you have permissions to access, supporting both individual and team-based workflow management
     * scenarios.
     * </p>
     *
     * @param listWorkflowsRequest
     * @return A Java Future containing the result of the ListWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListWorkflows" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListWorkflowsResponse> listWorkflows(ListWorkflowsRequest listWorkflowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all workflows in your account, with optional pagination support. This operation returns summary information
     * for workflows, showing only the most recently created version of each workflow. Amazon Managed Workflows for
     * Apache Airflow Serverless maintains workflow metadata in a highly available, distributed storage system that
     * enables efficient querying and filtering. The service implements proper access controls to ensure you can only
     * view workflows that you have permissions to access, supporting both individual and team-based workflow management
     * scenarios.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkflowsRequest#builder()}
     * </p>
     *
     * @param listWorkflowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListWorkflows" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListWorkflowsResponse> listWorkflows(Consumer<ListWorkflowsRequest.Builder> listWorkflowsRequest) {
        return listWorkflows(ListWorkflowsRequest.builder().applyMutation(listWorkflowsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkflows(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mwaaserverless.paginators.ListWorkflowsPublisher publisher = client.listWorkflowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mwaaserverless.paginators.ListWorkflowsPublisher publisher = client.listWorkflowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflows(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowsRequest)} operation.</b>
     * </p>
     *
     * @param listWorkflowsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListWorkflows" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkflowsPublisher listWorkflowsPaginator(ListWorkflowsRequest listWorkflowsRequest) {
        return new ListWorkflowsPublisher(this, listWorkflowsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkflows(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mwaaserverless.paginators.ListWorkflowsPublisher publisher = client.listWorkflowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mwaaserverless.paginators.ListWorkflowsPublisher publisher = client.listWorkflowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflows(software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkflowsRequest#builder()}
     * </p>
     *
     * @param listWorkflowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/ListWorkflows" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkflowsPublisher listWorkflowsPaginator(Consumer<ListWorkflowsRequest.Builder> listWorkflowsRequest) {
        return listWorkflowsPaginator(ListWorkflowsRequest.builder().applyMutation(listWorkflowsRequest).build());
    }

    /**
     * <p>
     * Starts a new execution of a workflow. This operation creates a workflow run that executes the tasks that are
     * defined in the workflow. Amazon Managed Workflows for Apache Airflow Serverless schedules the workflow execution
     * across its managed Airflow environment, automatically scaling ECS worker tasks based on the workload. The service
     * handles task isolation, dependency resolution, and provides comprehensive monitoring and logging throughout the
     * execution lifecycle.
     * </p>
     *
     * @param startWorkflowRunRequest
     * @return A Java Future containing the result of the StartWorkflowRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ConflictException You cannot create a resource that already exists, or the resource is in a state
     *         that prevents the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request exceeds the service quota for Amazon Managed Workflows for
     *         Apache Airflow Serverless resources. This can occur when you attempt to create more workflows than
     *         allowed, exceed concurrent workflow run limits, or surpass task execution limits. Amazon Managed
     *         Workflows for Apache Airflow Serverless implements admission control using DynamoDB-based counters to
     *         manage resource utilization across the multi-tenant environment. Contact Amazon Web Services Support to
     *         request quota increases if you need higher limits for your use case.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.StartWorkflowRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/StartWorkflowRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartWorkflowRunResponse> startWorkflowRun(StartWorkflowRunRequest startWorkflowRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new execution of a workflow. This operation creates a workflow run that executes the tasks that are
     * defined in the workflow. Amazon Managed Workflows for Apache Airflow Serverless schedules the workflow execution
     * across its managed Airflow environment, automatically scaling ECS worker tasks based on the workload. The service
     * handles task isolation, dependency resolution, and provides comprehensive monitoring and logging throughout the
     * execution lifecycle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartWorkflowRunRequest.Builder} avoiding the need
     * to create one manually via {@link StartWorkflowRunRequest#builder()}
     * </p>
     *
     * @param startWorkflowRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.StartWorkflowRunRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartWorkflowRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ConflictException You cannot create a resource that already exists, or the resource is in a state
     *         that prevents the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request exceeds the service quota for Amazon Managed Workflows for
     *         Apache Airflow Serverless resources. This can occur when you attempt to create more workflows than
     *         allowed, exceed concurrent workflow run limits, or surpass task execution limits. Amazon Managed
     *         Workflows for Apache Airflow Serverless implements admission control using DynamoDB-based counters to
     *         manage resource utilization across the multi-tenant environment. Contact Amazon Web Services Support to
     *         request quota increases if you need higher limits for your use case.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.StartWorkflowRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/StartWorkflowRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartWorkflowRunResponse> startWorkflowRun(
            Consumer<StartWorkflowRunRequest.Builder> startWorkflowRunRequest) {
        return startWorkflowRun(StartWorkflowRunRequest.builder().applyMutation(startWorkflowRunRequest).build());
    }

    /**
     * <p>
     * Stops a running workflow execution. This operation terminates all running tasks and prevents new tasks from
     * starting. Amazon Managed Workflows for Apache Airflow Serverless gracefully shuts down the workflow execution by
     * stopping task scheduling and terminating active ECS worker containers. The operation transitions the workflow run
     * to a <code>STOPPING</code> state and then to <code>STOPPED</code> once all cleanup is complete. In-flight tasks
     * may complete or be terminated depending on their current execution state.
     * </p>
     *
     * @param stopWorkflowRunRequest
     * @return A Java Future containing the result of the StopWorkflowRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.StopWorkflowRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/StopWorkflowRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopWorkflowRunResponse> stopWorkflowRun(StopWorkflowRunRequest stopWorkflowRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a running workflow execution. This operation terminates all running tasks and prevents new tasks from
     * starting. Amazon Managed Workflows for Apache Airflow Serverless gracefully shuts down the workflow execution by
     * stopping task scheduling and terminating active ECS worker containers. The operation transitions the workflow run
     * to a <code>STOPPING</code> state and then to <code>STOPPED</code> once all cleanup is complete. In-flight tasks
     * may complete or be terminated depending on their current execution state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopWorkflowRunRequest.Builder} avoiding the need
     * to create one manually via {@link StopWorkflowRunRequest#builder()}
     * </p>
     *
     * @param stopWorkflowRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.StopWorkflowRunRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopWorkflowRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.StopWorkflowRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/StopWorkflowRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopWorkflowRunResponse> stopWorkflowRun(
            Consumer<StopWorkflowRunRequest.Builder> stopWorkflowRunRequest) {
        return stopWorkflowRun(StopWorkflowRunRequest.builder().applyMutation(stopWorkflowRunRequest).build());
    }

    /**
     * <p>
     * Adds tags to an Amazon Managed Workflows for Apache Airflow Serverless resource. Tags are key-value pairs that
     * help you organize and categorize your resources.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to an Amazon Managed Workflows for Apache Airflow Serverless resource. Tags are key-value pairs that
     * help you organize and categorize your resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from an Amazon Managed Workflows for Apache Airflow Serverless resource. This operation removes the
     * specified tags from the resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from an Amazon Managed Workflows for Apache Airflow Serverless resource. This operation removes the
     * specified tags from the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing workflow with new configuration settings. This operation allows you to modify the workflow
     * definition, role, and other settings. When you update a workflow, Amazon Managed Workflows for Apache Airflow
     * Serverless automatically creates a new version with the updated configuration and disables scheduling on all
     * previous versions to ensure only one version is actively scheduled at a time. The update operation maintains
     * workflow history while providing a clean transition to the new configuration.
     * </p>
     *
     * @param updateWorkflowRequest
     * @return A Java Future containing the result of the UpdateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ConflictException You cannot create a resource that already exists, or the resource is in a state
     *         that prevents the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request exceeds the service quota for Amazon Managed Workflows for
     *         Apache Airflow Serverless resources. This can occur when you attempt to create more workflows than
     *         allowed, exceed concurrent workflow run limits, or surpass task execution limits. Amazon Managed
     *         Workflows for Apache Airflow Serverless implements admission control using DynamoDB-based counters to
     *         manage resource utilization across the multi-tenant environment. Contact Amazon Web Services Support to
     *         request quota increases if you need higher limits for your use case.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.UpdateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/UpdateWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkflowResponse> updateWorkflow(UpdateWorkflowRequest updateWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing workflow with new configuration settings. This operation allows you to modify the workflow
     * definition, role, and other settings. When you update a workflow, Amazon Managed Workflows for Apache Airflow
     * Serverless automatically creates a new version with the updated configuration and disables scheduling on all
     * previous versions to ensure only one version is actively scheduled at a time. The update operation maintains
     * workflow history while providing a clean transition to the new configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWorkflowRequest#builder()}
     * </p>
     *
     * @param updateWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mwaaserverless.model.UpdateWorkflowRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied because too many requests were made in a short period,
     *         exceeding the service rate limits. Amazon Managed Workflows for Apache Airflow Serverless implements
     *         throttling controls to ensure fair resource allocation across all customers in the multi-tenant
     *         environment. This helps maintain service stability and performance. If you encounter throttling,
     *         implement exponential backoff and retry logic in your applications, or consider distributing your API
     *         calls over a longer time period.</li>
     *         <li>ValidationException The specified request parameters are invalid, missing, or inconsistent with
     *         Amazon Managed Workflows for Apache Airflow Serverless service requirements. This can occur when workflow
     *         definitions contain unsupported operators, when required IAM permissions are missing, when S3 locations
     *         are inaccessible, or when network configurations are invalid. The service validates workflow definitions,
     *         execution roles, and resource configurations to ensure compatibility with the managed Airflow environment
     *         and security requirements.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. You can only access or modify a
     *         resource that already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>InternalServerException An unexpected server-side error occurred during request processing.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ConflictException You cannot create a resource that already exists, or the resource is in a state
     *         that prevents the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request exceeds the service quota for Amazon Managed Workflows for
     *         Apache Airflow Serverless resources. This can occur when you attempt to create more workflows than
     *         allowed, exceed concurrent workflow run limits, or surpass task execution limits. Amazon Managed
     *         Workflows for Apache Airflow Serverless implements admission control using DynamoDB-based counters to
     *         manage resource utilization across the multi-tenant environment. Contact Amazon Web Services Support to
     *         request quota increases if you need higher limits for your use case.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MwaaServerlessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MwaaServerlessAsyncClient.UpdateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mwaa-serverless-2024-07-26/UpdateWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkflowResponse> updateWorkflow(Consumer<UpdateWorkflowRequest.Builder> updateWorkflowRequest) {
        return updateWorkflow(UpdateWorkflowRequest.builder().applyMutation(updateWorkflowRequest).build());
    }

    @Override
    default MwaaServerlessServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MwaaServerlessAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MwaaServerlessAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MwaaServerlessAsyncClient}.
     */
    static MwaaServerlessAsyncClientBuilder builder() {
        return new DefaultMwaaServerlessAsyncClientBuilder();
    }
}
