/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaaserverless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTaskInstanceResponse extends MwaaServerlessResponse implements
        ToCopyableBuilder<GetTaskInstanceResponse.Builder, GetTaskInstanceResponse> {
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowArn").getter(getter(GetTaskInstanceResponse::workflowArn)).setter(setter(Builder::workflowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowArn").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RunId")
            .getter(getter(GetTaskInstanceResponse::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()).build();

    private static final SdkField<String> TASK_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskInstanceId").getter(getter(GetTaskInstanceResponse::taskInstanceId))
            .setter(setter(Builder::taskInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskInstanceId").build()).build();

    private static final SdkField<String> WORKFLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowVersion").getter(getter(GetTaskInstanceResponse::workflowVersion))
            .setter(setter(Builder::workflowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowVersion").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetTaskInstanceResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationInSeconds").getter(getter(GetTaskInstanceResponse::durationInSeconds))
            .setter(setter(Builder::durationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()).build();

    private static final SdkField<String> OPERATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperatorName").getter(getter(GetTaskInstanceResponse::operatorName))
            .setter(setter(Builder::operatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatorName").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedAt")
            .getter(getter(GetTaskInstanceResponse::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndedAt")
            .getter(getter(GetTaskInstanceResponse::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedAt")
            .getter(getter(GetTaskInstanceResponse::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> ATTEMPT_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AttemptNumber").getter(getter(GetTaskInstanceResponse::attemptNumber))
            .setter(setter(Builder::attemptNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttemptNumber").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(GetTaskInstanceResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TaskId")
            .getter(getter(GetTaskInstanceResponse::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()).build();

    private static final SdkField<String> LOG_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogStream").getter(getter(GetTaskInstanceResponse::logStream)).setter(setter(Builder::logStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStream").build()).build();

    private static final SdkField<Map<String, String>> XCOM_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Xcom")
            .getter(getter(GetTaskInstanceResponse::xcom))
            .setter(setter(Builder::xcom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Xcom").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ARN_FIELD,
            RUN_ID_FIELD, TASK_INSTANCE_ID_FIELD, WORKFLOW_VERSION_FIELD, STATUS_FIELD, DURATION_IN_SECONDS_FIELD,
            OPERATOR_NAME_FIELD, MODIFIED_AT_FIELD, ENDED_AT_FIELD, STARTED_AT_FIELD, ATTEMPT_NUMBER_FIELD, ERROR_MESSAGE_FIELD,
            TASK_ID_FIELD, LOG_STREAM_FIELD, XCOM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workflowArn;

    private final String runId;

    private final String taskInstanceId;

    private final String workflowVersion;

    private final String status;

    private final Integer durationInSeconds;

    private final String operatorName;

    private final Instant modifiedAt;

    private final Instant endedAt;

    private final Instant startedAt;

    private final Integer attemptNumber;

    private final String errorMessage;

    private final String taskId;

    private final String logStream;

    private final Map<String, String> xcom;

    private GetTaskInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.workflowArn = builder.workflowArn;
        this.runId = builder.runId;
        this.taskInstanceId = builder.taskInstanceId;
        this.workflowVersion = builder.workflowVersion;
        this.status = builder.status;
        this.durationInSeconds = builder.durationInSeconds;
        this.operatorName = builder.operatorName;
        this.modifiedAt = builder.modifiedAt;
        this.endedAt = builder.endedAt;
        this.startedAt = builder.startedAt;
        this.attemptNumber = builder.attemptNumber;
        this.errorMessage = builder.errorMessage;
        this.taskId = builder.taskId;
        this.logStream = builder.logStream;
        this.xcom = builder.xcom;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the workflow that contains this task instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the workflow that contains this task instance.
     */
    public final String workflowArn() {
        return workflowArn;
    }

    /**
     * <p>
     * The unique identifier of the workflow run that contains this task instance.
     * </p>
     * 
     * @return The unique identifier of the workflow run that contains this task instance.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * The unique identifier of this task instance.
     * </p>
     * 
     * @return The unique identifier of this task instance.
     */
    public final String taskInstanceId() {
        return taskInstanceId;
    }

    /**
     * <p>
     * The version of the workflow that contains this task instance.
     * </p>
     * 
     * @return The version of the workflow that contains this task instance.
     */
    public final String workflowVersion() {
        return workflowVersion;
    }

    /**
     * <p>
     * The current status of the task instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the task instance.
     * @see TaskInstanceStatus
     */
    public final TaskInstanceStatus status() {
        return TaskInstanceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the task instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the task instance.
     * @see TaskInstanceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The duration of the task instance execution in seconds. This value is null if the task is not complete.
     * </p>
     * 
     * @return The duration of the task instance execution in seconds. This value is null if the task is not complete.
     */
    public final Integer durationInSeconds() {
        return durationInSeconds;
    }

    /**
     * <p>
     * The name of the Apache Airflow operator used for this task instance.
     * </p>
     * 
     * @return The name of the Apache Airflow operator used for this task instance.
     */
    public final String operatorName() {
        return operatorName;
    }

    /**
     * <p>
     * The timestamp when the task instance was last modified, in ISO 8601 date-time format.
     * </p>
     * 
     * @return The timestamp when the task instance was last modified, in ISO 8601 date-time format.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The timestamp when the task instance completed execution, in ISO 8601 date-time format. This value is null if the
     * task is not complete.
     * </p>
     * 
     * @return The timestamp when the task instance completed execution, in ISO 8601 date-time format. This value is
     *         null if the task is not complete.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The timestamp when the task instance started execution, in ISO 8601 date-time format. This value is null if the
     * task has not started.
     * </p>
     * 
     * @return The timestamp when the task instance started execution, in ISO 8601 date-time format. This value is null
     *         if the task has not started.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The attempt number for this task instance.
     * </p>
     * 
     * @return The attempt number for this task instance.
     */
    public final Integer attemptNumber() {
        return attemptNumber;
    }

    /**
     * <p>
     * The error message if the task instance failed. This value is null if the task completed successfully.
     * </p>
     * 
     * @return The error message if the task instance failed. This value is null if the task completed successfully.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The unique identifier of the task definition within the workflow.
     * </p>
     * 
     * @return The unique identifier of the task definition within the workflow.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The CloudWatch log stream name for this task instance execution.
     * </p>
     * 
     * @return The CloudWatch log stream name for this task instance execution.
     */
    public final String logStream() {
        return logStream;
    }

    /**
     * For responses, this returns true if the service returned a value for the Xcom property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasXcom() {
        return xcom != null && !(xcom instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Cross-communication data exchanged between tasks in the workflow execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasXcom} method.
     * </p>
     * 
     * @return Cross-communication data exchanged between tasks in the workflow execution.
     */
    public final Map<String, String> xcom() {
        return xcom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(taskInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(workflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(operatorName());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(attemptNumber());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(logStream());
        hashCode = 31 * hashCode + Objects.hashCode(hasXcom() ? xcom() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTaskInstanceResponse)) {
            return false;
        }
        GetTaskInstanceResponse other = (GetTaskInstanceResponse) obj;
        return Objects.equals(workflowArn(), other.workflowArn()) && Objects.equals(runId(), other.runId())
                && Objects.equals(taskInstanceId(), other.taskInstanceId())
                && Objects.equals(workflowVersion(), other.workflowVersion())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(durationInSeconds(), other.durationInSeconds())
                && Objects.equals(operatorName(), other.operatorName()) && Objects.equals(modifiedAt(), other.modifiedAt())
                && Objects.equals(endedAt(), other.endedAt()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(attemptNumber(), other.attemptNumber()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(taskId(), other.taskId()) && Objects.equals(logStream(), other.logStream())
                && hasXcom() == other.hasXcom() && Objects.equals(xcom(), other.xcom());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTaskInstanceResponse").add("WorkflowArn", workflowArn()).add("RunId", runId())
                .add("TaskInstanceId", taskInstanceId()).add("WorkflowVersion", workflowVersion())
                .add("Status", statusAsString()).add("DurationInSeconds", durationInSeconds())
                .add("OperatorName", operatorName()).add("ModifiedAt", modifiedAt()).add("EndedAt", endedAt())
                .add("StartedAt", startedAt()).add("AttemptNumber", attemptNumber()).add("ErrorMessage", errorMessage())
                .add("TaskId", taskId()).add("LogStream", logStream()).add("Xcom", hasXcom() ? xcom() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkflowArn":
            return Optional.ofNullable(clazz.cast(workflowArn()));
        case "RunId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "TaskInstanceId":
            return Optional.ofNullable(clazz.cast(taskInstanceId()));
        case "WorkflowVersion":
            return Optional.ofNullable(clazz.cast(workflowVersion()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "DurationInSeconds":
            return Optional.ofNullable(clazz.cast(durationInSeconds()));
        case "OperatorName":
            return Optional.ofNullable(clazz.cast(operatorName()));
        case "ModifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "EndedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "StartedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "AttemptNumber":
            return Optional.ofNullable(clazz.cast(attemptNumber()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "TaskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "LogStream":
            return Optional.ofNullable(clazz.cast(logStream()));
        case "Xcom":
            return Optional.ofNullable(clazz.cast(xcom()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkflowArn", WORKFLOW_ARN_FIELD);
        map.put("RunId", RUN_ID_FIELD);
        map.put("TaskInstanceId", TASK_INSTANCE_ID_FIELD);
        map.put("WorkflowVersion", WORKFLOW_VERSION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DurationInSeconds", DURATION_IN_SECONDS_FIELD);
        map.put("OperatorName", OPERATOR_NAME_FIELD);
        map.put("ModifiedAt", MODIFIED_AT_FIELD);
        map.put("EndedAt", ENDED_AT_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        map.put("AttemptNumber", ATTEMPT_NUMBER_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("TaskId", TASK_ID_FIELD);
        map.put("LogStream", LOG_STREAM_FIELD);
        map.put("Xcom", XCOM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTaskInstanceResponse, T> g) {
        return obj -> g.apply((GetTaskInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MwaaServerlessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTaskInstanceResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the workflow that contains this task instance.
         * </p>
         * 
         * @param workflowArn
         *        The Amazon Resource Name (ARN) of the workflow that contains this task instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowArn(String workflowArn);

        /**
         * <p>
         * The unique identifier of the workflow run that contains this task instance.
         * </p>
         * 
         * @param runId
         *        The unique identifier of the workflow run that contains this task instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The unique identifier of this task instance.
         * </p>
         * 
         * @param taskInstanceId
         *        The unique identifier of this task instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskInstanceId(String taskInstanceId);

        /**
         * <p>
         * The version of the workflow that contains this task instance.
         * </p>
         * 
         * @param workflowVersion
         *        The version of the workflow that contains this task instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowVersion(String workflowVersion);

        /**
         * <p>
         * The current status of the task instance.
         * </p>
         * 
         * @param status
         *        The current status of the task instance.
         * @see TaskInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskInstanceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the task instance.
         * </p>
         * 
         * @param status
         *        The current status of the task instance.
         * @see TaskInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskInstanceStatus
         */
        Builder status(TaskInstanceStatus status);

        /**
         * <p>
         * The duration of the task instance execution in seconds. This value is null if the task is not complete.
         * </p>
         * 
         * @param durationInSeconds
         *        The duration of the task instance execution in seconds. This value is null if the task is not
         *        complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Integer durationInSeconds);

        /**
         * <p>
         * The name of the Apache Airflow operator used for this task instance.
         * </p>
         * 
         * @param operatorName
         *        The name of the Apache Airflow operator used for this task instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatorName(String operatorName);

        /**
         * <p>
         * The timestamp when the task instance was last modified, in ISO 8601 date-time format.
         * </p>
         * 
         * @param modifiedAt
         *        The timestamp when the task instance was last modified, in ISO 8601 date-time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The timestamp when the task instance completed execution, in ISO 8601 date-time format. This value is null if
         * the task is not complete.
         * </p>
         * 
         * @param endedAt
         *        The timestamp when the task instance completed execution, in ISO 8601 date-time format. This value is
         *        null if the task is not complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The timestamp when the task instance started execution, in ISO 8601 date-time format. This value is null if
         * the task has not started.
         * </p>
         * 
         * @param startedAt
         *        The timestamp when the task instance started execution, in ISO 8601 date-time format. This value is
         *        null if the task has not started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The attempt number for this task instance.
         * </p>
         * 
         * @param attemptNumber
         *        The attempt number for this task instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attemptNumber(Integer attemptNumber);

        /**
         * <p>
         * The error message if the task instance failed. This value is null if the task completed successfully.
         * </p>
         * 
         * @param errorMessage
         *        The error message if the task instance failed. This value is null if the task completed successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The unique identifier of the task definition within the workflow.
         * </p>
         * 
         * @param taskId
         *        The unique identifier of the task definition within the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The CloudWatch log stream name for this task instance execution.
         * </p>
         * 
         * @param logStream
         *        The CloudWatch log stream name for this task instance execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStream(String logStream);

        /**
         * <p>
         * Cross-communication data exchanged between tasks in the workflow execution.
         * </p>
         * 
         * @param xcom
         *        Cross-communication data exchanged between tasks in the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xcom(Map<String, String> xcom);
    }

    static final class BuilderImpl extends MwaaServerlessResponse.BuilderImpl implements Builder {
        private String workflowArn;

        private String runId;

        private String taskInstanceId;

        private String workflowVersion;

        private String status;

        private Integer durationInSeconds;

        private String operatorName;

        private Instant modifiedAt;

        private Instant endedAt;

        private Instant startedAt;

        private Integer attemptNumber;

        private String errorMessage;

        private String taskId;

        private String logStream;

        private Map<String, String> xcom = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTaskInstanceResponse model) {
            super(model);
            workflowArn(model.workflowArn);
            runId(model.runId);
            taskInstanceId(model.taskInstanceId);
            workflowVersion(model.workflowVersion);
            status(model.status);
            durationInSeconds(model.durationInSeconds);
            operatorName(model.operatorName);
            modifiedAt(model.modifiedAt);
            endedAt(model.endedAt);
            startedAt(model.startedAt);
            attemptNumber(model.attemptNumber);
            errorMessage(model.errorMessage);
            taskId(model.taskId);
            logStream(model.logStream);
            xcom(model.xcom);
        }

        public final String getWorkflowArn() {
            return workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getTaskInstanceId() {
            return taskInstanceId;
        }

        public final void setTaskInstanceId(String taskInstanceId) {
            this.taskInstanceId = taskInstanceId;
        }

        @Override
        public final Builder taskInstanceId(String taskInstanceId) {
            this.taskInstanceId = taskInstanceId;
            return this;
        }

        public final String getWorkflowVersion() {
            return workflowVersion;
        }

        public final void setWorkflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
        }

        @Override
        public final Builder workflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskInstanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getDurationInSeconds() {
            return durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final String getOperatorName() {
            return operatorName;
        }

        public final void setOperatorName(String operatorName) {
            this.operatorName = operatorName;
        }

        @Override
        public final Builder operatorName(String operatorName) {
            this.operatorName = operatorName;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Integer getAttemptNumber() {
            return attemptNumber;
        }

        public final void setAttemptNumber(Integer attemptNumber) {
            this.attemptNumber = attemptNumber;
        }

        @Override
        public final Builder attemptNumber(Integer attemptNumber) {
            this.attemptNumber = attemptNumber;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getLogStream() {
            return logStream;
        }

        public final void setLogStream(String logStream) {
            this.logStream = logStream;
        }

        @Override
        public final Builder logStream(String logStream) {
            this.logStream = logStream;
            return this;
        }

        public final Map<String, String> getXcom() {
            if (xcom instanceof SdkAutoConstructMap) {
                return null;
            }
            return xcom;
        }

        public final void setXcom(Map<String, String> xcom) {
            this.xcom = GenericMapCopier.copy(xcom);
        }

        @Override
        public final Builder xcom(Map<String, String> xcom) {
            this.xcom = GenericMapCopier.copy(xcom);
            return this;
        }

        @Override
        public GetTaskInstanceResponse build() {
            return new GetTaskInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
