/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaaserverless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowResponse extends MwaaServerlessResponse implements
        ToCopyableBuilder<GetWorkflowResponse.Builder, GetWorkflowResponse> {
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowArn").getter(getter(GetWorkflowResponse::workflowArn)).setter(setter(Builder::workflowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowArn").build()).build();

    private static final SdkField<String> WORKFLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowVersion").getter(getter(GetWorkflowResponse::workflowVersion))
            .setter(setter(Builder::workflowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowVersion").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetWorkflowResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetWorkflowResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(GetWorkflowResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedAt")
            .getter(getter(GetWorkflowResponse::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfiguration")
            .getter(getter(GetWorkflowResponse::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build())
            .build();

    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField
            .<LoggingConfiguration> builder(MarshallingType.SDK_POJO).memberName("LoggingConfiguration")
            .getter(getter(GetWorkflowResponse::loggingConfiguration)).setter(setter(Builder::loggingConfiguration))
            .constructor(LoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build())
            .build();

    private static final SdkField<Integer> ENGINE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EngineVersion").getter(getter(GetWorkflowResponse::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> WORKFLOW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowStatus").getter(getter(GetWorkflowResponse::workflowStatusAsString))
            .setter(setter(Builder::workflowStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowStatus").build()).build();

    private static final SdkField<DefinitionS3Location> DEFINITION_S3_LOCATION_FIELD = SdkField
            .<DefinitionS3Location> builder(MarshallingType.SDK_POJO).memberName("DefinitionS3Location")
            .getter(getter(GetWorkflowResponse::definitionS3Location)).setter(setter(Builder::definitionS3Location))
            .constructor(DefinitionS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefinitionS3Location").build())
            .build();

    private static final SdkField<ScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField
            .<ScheduleConfiguration> builder(MarshallingType.SDK_POJO).memberName("ScheduleConfiguration")
            .getter(getter(GetWorkflowResponse::scheduleConfiguration)).setter(setter(Builder::scheduleConfiguration))
            .constructor(ScheduleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(GetWorkflowResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("NetworkConfiguration")
            .getter(getter(GetWorkflowResponse::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build())
            .build();

    private static final SdkField<String> TRIGGER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TriggerMode").getter(getter(GetWorkflowResponse::triggerMode)).setter(setter(Builder::triggerMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerMode").build()).build();

    private static final SdkField<String> WORKFLOW_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowDefinition").getter(getter(GetWorkflowResponse::workflowDefinition))
            .setter(setter(Builder::workflowDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowDefinition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ARN_FIELD,
            WORKFLOW_VERSION_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD,
            ENCRYPTION_CONFIGURATION_FIELD, LOGGING_CONFIGURATION_FIELD, ENGINE_VERSION_FIELD, WORKFLOW_STATUS_FIELD,
            DEFINITION_S3_LOCATION_FIELD, SCHEDULE_CONFIGURATION_FIELD, ROLE_ARN_FIELD, NETWORK_CONFIGURATION_FIELD,
            TRIGGER_MODE_FIELD, WORKFLOW_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workflowArn;

    private final String workflowVersion;

    private final String name;

    private final String description;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final EncryptionConfiguration encryptionConfiguration;

    private final LoggingConfiguration loggingConfiguration;

    private final Integer engineVersion;

    private final String workflowStatus;

    private final DefinitionS3Location definitionS3Location;

    private final ScheduleConfiguration scheduleConfiguration;

    private final String roleArn;

    private final NetworkConfiguration networkConfiguration;

    private final String triggerMode;

    private final String workflowDefinition;

    private GetWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.workflowArn = builder.workflowArn;
        this.workflowVersion = builder.workflowVersion;
        this.name = builder.name;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.engineVersion = builder.engineVersion;
        this.workflowStatus = builder.workflowStatus;
        this.definitionS3Location = builder.definitionS3Location;
        this.scheduleConfiguration = builder.scheduleConfiguration;
        this.roleArn = builder.roleArn;
        this.networkConfiguration = builder.networkConfiguration;
        this.triggerMode = builder.triggerMode;
        this.workflowDefinition = builder.workflowDefinition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the workflow.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the workflow.
     */
    public final String workflowArn() {
        return workflowArn;
    }

    /**
     * <p>
     * The version identifier of the workflow.
     * </p>
     * 
     * @return The version identifier of the workflow.
     */
    public final String workflowVersion() {
        return workflowVersion;
    }

    /**
     * <p>
     * The name of the workflow.
     * </p>
     * 
     * @return The name of the workflow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the workflow.
     * </p>
     * 
     * @return The description of the workflow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp when the workflow was created, in ISO 8601 date-time format.
     * </p>
     * 
     * @return The timestamp when the workflow was created, in ISO 8601 date-time format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the workflow was last modified, in ISO 8601 date-time format.
     * </p>
     * 
     * @return The timestamp when the workflow was last modified, in ISO 8601 date-time format.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The encryption configuration for the workflow.
     * </p>
     * 
     * @return The encryption configuration for the workflow.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * The logging configuration for the workflow.
     * </p>
     * 
     * @return The logging configuration for the workflow.
     */
    public final LoggingConfiguration loggingConfiguration() {
        return loggingConfiguration;
    }

    /**
     * <p>
     * The version of the Amazon Managed Workflows for Apache Airflow Serverless engine that this workflow uses.
     * </p>
     * 
     * @return The version of the Amazon Managed Workflows for Apache Airflow Serverless engine that this workflow uses.
     */
    public final Integer engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The current status of the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowStatus}
     * will return {@link WorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #workflowStatusAsString}.
     * </p>
     * 
     * @return The current status of the workflow.
     * @see WorkflowStatus
     */
    public final WorkflowStatus workflowStatus() {
        return WorkflowStatus.fromValue(workflowStatus);
    }

    /**
     * <p>
     * The current status of the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowStatus}
     * will return {@link WorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #workflowStatusAsString}.
     * </p>
     * 
     * @return The current status of the workflow.
     * @see WorkflowStatus
     */
    public final String workflowStatusAsString() {
        return workflowStatus;
    }

    /**
     * <p>
     * The Amazon S3 location of the workflow definition file.
     * </p>
     * 
     * @return The Amazon S3 location of the workflow definition file.
     */
    public final DefinitionS3Location definitionS3Location() {
        return definitionS3Location;
    }

    /**
     * <p>
     * The schedule configuration for the workflow, including cron expressions for automated execution. Amazon Managed
     * Workflows for Apache Airflow Serverless uses EventBridge Scheduler for cost-effective, timezone-aware scheduling.
     * When a workflow includes schedule information in its YAML definition, the service automatically configures the
     * appropriate triggers for automated execution. Only one version of a workflow can have an active schedule at any
     * given time.
     * </p>
     * 
     * @return The schedule configuration for the workflow, including cron expressions for automated execution. Amazon
     *         Managed Workflows for Apache Airflow Serverless uses EventBridge Scheduler for cost-effective,
     *         timezone-aware scheduling. When a workflow includes schedule information in its YAML definition, the
     *         service automatically configures the appropriate triggers for automated execution. Only one version of a
     *         workflow can have an active schedule at any given time.
     */
    public final ScheduleConfiguration scheduleConfiguration() {
        return scheduleConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used for workflow execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used for workflow execution.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The network configuration for the workflow execution environment.
     * </p>
     * 
     * @return The network configuration for the workflow execution environment.
     */
    public final NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The trigger mode for the workflow execution.
     * </p>
     * 
     * @return The trigger mode for the workflow execution.
     */
    public final String triggerMode() {
        return triggerMode;
    }

    /**
     * <p>
     * The workflow definition content.
     * </p>
     * 
     * @return The workflow definition content.
     */
    public final String workflowDefinition() {
        return workflowDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(workflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(workflowStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(definitionS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(triggerMode());
        hashCode = 31 * hashCode + Objects.hashCode(workflowDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowResponse)) {
            return false;
        }
        GetWorkflowResponse other = (GetWorkflowResponse) obj;
        return Objects.equals(workflowArn(), other.workflowArn()) && Objects.equals(workflowVersion(), other.workflowVersion())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(modifiedAt(), other.modifiedAt())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(loggingConfiguration(), other.loggingConfiguration())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(workflowStatusAsString(), other.workflowStatusAsString())
                && Objects.equals(definitionS3Location(), other.definitionS3Location())
                && Objects.equals(scheduleConfiguration(), other.scheduleConfiguration())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(triggerMode(), other.triggerMode())
                && Objects.equals(workflowDefinition(), other.workflowDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkflowResponse").add("WorkflowArn", workflowArn())
                .add("WorkflowVersion", workflowVersion()).add("Name", name()).add("Description", description())
                .add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt())
                .add("EncryptionConfiguration", encryptionConfiguration()).add("LoggingConfiguration", loggingConfiguration())
                .add("EngineVersion", engineVersion()).add("WorkflowStatus", workflowStatusAsString())
                .add("DefinitionS3Location", definitionS3Location()).add("ScheduleConfiguration", scheduleConfiguration())
                .add("RoleArn", roleArn()).add("NetworkConfiguration", networkConfiguration()).add("TriggerMode", triggerMode())
                .add("WorkflowDefinition", workflowDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkflowArn":
            return Optional.ofNullable(clazz.cast(workflowArn()));
        case "WorkflowVersion":
            return Optional.ofNullable(clazz.cast(workflowVersion()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ModifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "EncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "LoggingConfiguration":
            return Optional.ofNullable(clazz.cast(loggingConfiguration()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "WorkflowStatus":
            return Optional.ofNullable(clazz.cast(workflowStatusAsString()));
        case "DefinitionS3Location":
            return Optional.ofNullable(clazz.cast(definitionS3Location()));
        case "ScheduleConfiguration":
            return Optional.ofNullable(clazz.cast(scheduleConfiguration()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "NetworkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "TriggerMode":
            return Optional.ofNullable(clazz.cast(triggerMode()));
        case "WorkflowDefinition":
            return Optional.ofNullable(clazz.cast(workflowDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkflowArn", WORKFLOW_ARN_FIELD);
        map.put("WorkflowVersion", WORKFLOW_VERSION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("ModifiedAt", MODIFIED_AT_FIELD);
        map.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("LoggingConfiguration", LOGGING_CONFIGURATION_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("WorkflowStatus", WORKFLOW_STATUS_FIELD);
        map.put("DefinitionS3Location", DEFINITION_S3_LOCATION_FIELD);
        map.put("ScheduleConfiguration", SCHEDULE_CONFIGURATION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("NetworkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("TriggerMode", TRIGGER_MODE_FIELD);
        map.put("WorkflowDefinition", WORKFLOW_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowResponse, T> g) {
        return obj -> g.apply((GetWorkflowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MwaaServerlessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWorkflowResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the workflow.
         * </p>
         * 
         * @param workflowArn
         *        The Amazon Resource Name (ARN) of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowArn(String workflowArn);

        /**
         * <p>
         * The version identifier of the workflow.
         * </p>
         * 
         * @param workflowVersion
         *        The version identifier of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowVersion(String workflowVersion);

        /**
         * <p>
         * The name of the workflow.
         * </p>
         * 
         * @param name
         *        The name of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the workflow.
         * </p>
         * 
         * @param description
         *        The description of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp when the workflow was created, in ISO 8601 date-time format.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the workflow was created, in ISO 8601 date-time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the workflow was last modified, in ISO 8601 date-time format.
         * </p>
         * 
         * @param modifiedAt
         *        The timestamp when the workflow was last modified, in ISO 8601 date-time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The encryption configuration for the workflow.
         * </p>
         * 
         * @param encryptionConfiguration
         *        The encryption configuration for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * The encryption configuration for the workflow.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * <p>
         * The logging configuration for the workflow.
         * </p>
         * 
         * @param loggingConfiguration
         *        The logging configuration for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfiguration(LoggingConfiguration loggingConfiguration);

        /**
         * <p>
         * The logging configuration for the workflow.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoggingConfiguration.Builder} avoiding
         * the need to create one manually via {@link LoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #loggingConfiguration(LoggingConfiguration)}.
         * 
         * @param loggingConfiguration
         *        a consumer that will call methods on {@link LoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfiguration(LoggingConfiguration)
         */
        default Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return loggingConfiguration(LoggingConfiguration.builder().applyMutation(loggingConfiguration).build());
        }

        /**
         * <p>
         * The version of the Amazon Managed Workflows for Apache Airflow Serverless engine that this workflow uses.
         * </p>
         * 
         * @param engineVersion
         *        The version of the Amazon Managed Workflows for Apache Airflow Serverless engine that this workflow
         *        uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(Integer engineVersion);

        /**
         * <p>
         * The current status of the workflow.
         * </p>
         * 
         * @param workflowStatus
         *        The current status of the workflow.
         * @see WorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStatus
         */
        Builder workflowStatus(String workflowStatus);

        /**
         * <p>
         * The current status of the workflow.
         * </p>
         * 
         * @param workflowStatus
         *        The current status of the workflow.
         * @see WorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStatus
         */
        Builder workflowStatus(WorkflowStatus workflowStatus);

        /**
         * <p>
         * The Amazon S3 location of the workflow definition file.
         * </p>
         * 
         * @param definitionS3Location
         *        The Amazon S3 location of the workflow definition file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionS3Location(DefinitionS3Location definitionS3Location);

        /**
         * <p>
         * The Amazon S3 location of the workflow definition file.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefinitionS3Location.Builder} avoiding
         * the need to create one manually via {@link DefinitionS3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefinitionS3Location.Builder#build()} is called immediately and
         * its result is passed to {@link #definitionS3Location(DefinitionS3Location)}.
         * 
         * @param definitionS3Location
         *        a consumer that will call methods on {@link DefinitionS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definitionS3Location(DefinitionS3Location)
         */
        default Builder definitionS3Location(Consumer<DefinitionS3Location.Builder> definitionS3Location) {
            return definitionS3Location(DefinitionS3Location.builder().applyMutation(definitionS3Location).build());
        }

        /**
         * <p>
         * The schedule configuration for the workflow, including cron expressions for automated execution. Amazon
         * Managed Workflows for Apache Airflow Serverless uses EventBridge Scheduler for cost-effective, timezone-aware
         * scheduling. When a workflow includes schedule information in its YAML definition, the service automatically
         * configures the appropriate triggers for automated execution. Only one version of a workflow can have an
         * active schedule at any given time.
         * </p>
         * 
         * @param scheduleConfiguration
         *        The schedule configuration for the workflow, including cron expressions for automated execution.
         *        Amazon Managed Workflows for Apache Airflow Serverless uses EventBridge Scheduler for cost-effective,
         *        timezone-aware scheduling. When a workflow includes schedule information in its YAML definition, the
         *        service automatically configures the appropriate triggers for automated execution. Only one version of
         *        a workflow can have an active schedule at any given time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration);

        /**
         * <p>
         * The schedule configuration for the workflow, including cron expressions for automated execution. Amazon
         * Managed Workflows for Apache Airflow Serverless uses EventBridge Scheduler for cost-effective, timezone-aware
         * scheduling. When a workflow includes schedule information in its YAML definition, the service automatically
         * configures the appropriate triggers for automated execution. Only one version of a workflow can have an
         * active schedule at any given time.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduleConfiguration.Builder} avoiding
         * the need to create one manually via {@link ScheduleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduleConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduleConfiguration(ScheduleConfiguration)}.
         * 
         * @param scheduleConfiguration
         *        a consumer that will call methods on {@link ScheduleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleConfiguration(ScheduleConfiguration)
         */
        default Builder scheduleConfiguration(Consumer<ScheduleConfiguration.Builder> scheduleConfiguration) {
            return scheduleConfiguration(ScheduleConfiguration.builder().applyMutation(scheduleConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used for workflow execution.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role used for workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The network configuration for the workflow execution environment.
         * </p>
         * 
         * @param networkConfiguration
         *        The network configuration for the workflow execution environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * The network configuration for the workflow execution environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * The trigger mode for the workflow execution.
         * </p>
         * 
         * @param triggerMode
         *        The trigger mode for the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerMode(String triggerMode);

        /**
         * <p>
         * The workflow definition content.
         * </p>
         * 
         * @param workflowDefinition
         *        The workflow definition content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowDefinition(String workflowDefinition);
    }

    static final class BuilderImpl extends MwaaServerlessResponse.BuilderImpl implements Builder {
        private String workflowArn;

        private String workflowVersion;

        private String name;

        private String description;

        private Instant createdAt;

        private Instant modifiedAt;

        private EncryptionConfiguration encryptionConfiguration;

        private LoggingConfiguration loggingConfiguration;

        private Integer engineVersion;

        private String workflowStatus;

        private DefinitionS3Location definitionS3Location;

        private ScheduleConfiguration scheduleConfiguration;

        private String roleArn;

        private NetworkConfiguration networkConfiguration;

        private String triggerMode;

        private String workflowDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowResponse model) {
            super(model);
            workflowArn(model.workflowArn);
            workflowVersion(model.workflowVersion);
            name(model.name);
            description(model.description);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            encryptionConfiguration(model.encryptionConfiguration);
            loggingConfiguration(model.loggingConfiguration);
            engineVersion(model.engineVersion);
            workflowStatus(model.workflowStatus);
            definitionS3Location(model.definitionS3Location);
            scheduleConfiguration(model.scheduleConfiguration);
            roleArn(model.roleArn);
            networkConfiguration(model.networkConfiguration);
            triggerMode(model.triggerMode);
            workflowDefinition(model.workflowDefinition);
        }

        public final String getWorkflowArn() {
            return workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getWorkflowVersion() {
            return workflowVersion;
        }

        public final void setWorkflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
        }

        @Override
        public final Builder workflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return loggingConfiguration != null ? loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final Integer getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(Integer engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(Integer engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getWorkflowStatus() {
            return workflowStatus;
        }

        public final void setWorkflowStatus(String workflowStatus) {
            this.workflowStatus = workflowStatus;
        }

        @Override
        public final Builder workflowStatus(String workflowStatus) {
            this.workflowStatus = workflowStatus;
            return this;
        }

        @Override
        public final Builder workflowStatus(WorkflowStatus workflowStatus) {
            this.workflowStatus(workflowStatus == null ? null : workflowStatus.toString());
            return this;
        }

        public final DefinitionS3Location.Builder getDefinitionS3Location() {
            return definitionS3Location != null ? definitionS3Location.toBuilder() : null;
        }

        public final void setDefinitionS3Location(DefinitionS3Location.BuilderImpl definitionS3Location) {
            this.definitionS3Location = definitionS3Location != null ? definitionS3Location.build() : null;
        }

        @Override
        public final Builder definitionS3Location(DefinitionS3Location definitionS3Location) {
            this.definitionS3Location = definitionS3Location;
            return this;
        }

        public final ScheduleConfiguration.Builder getScheduleConfiguration() {
            return scheduleConfiguration != null ? scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(ScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        public final Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getTriggerMode() {
            return triggerMode;
        }

        public final void setTriggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
        }

        @Override
        public final Builder triggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
            return this;
        }

        public final String getWorkflowDefinition() {
            return workflowDefinition;
        }

        public final void setWorkflowDefinition(String workflowDefinition) {
            this.workflowDefinition = workflowDefinition;
        }

        @Override
        public final Builder workflowDefinition(String workflowDefinition) {
            this.workflowDefinition = workflowDefinition;
            return this;
        }

        @Override
        public GetWorkflowResponse build() {
            return new GetWorkflowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
