/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaaserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTaskInstancesResponse extends MwaaServerlessResponse implements
        ToCopyableBuilder<ListTaskInstancesResponse.Builder, ListTaskInstancesResponse> {
    private static final SdkField<List<TaskInstanceSummary>> TASK_INSTANCES_FIELD = SdkField
            .<List<TaskInstanceSummary>> builder(MarshallingType.LIST)
            .memberName("TaskInstances")
            .getter(getter(ListTaskInstancesResponse::taskInstances))
            .setter(setter(Builder::taskInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaskInstanceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskInstanceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTaskInstancesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_INSTANCES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TaskInstanceSummary> taskInstances;

    private final String nextToken;

    private ListTaskInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.taskInstances = builder.taskInstances;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskInstances property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaskInstances() {
        return taskInstances != null && !(taskInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of task instance summaries for the specified workflow run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskInstances} method.
     * </p>
     * 
     * @return A list of task instance summaries for the specified workflow run.
     */
    public final List<TaskInstanceSummary> taskInstances() {
        return taskInstances;
    }

    /**
     * <p>
     * The pagination token you need to use to retrieve the next set of results. This value is null if there are no more
     * results.
     * </p>
     * 
     * @return The pagination token you need to use to retrieve the next set of results. This value is null if there are
     *         no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskInstances() ? taskInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTaskInstancesResponse)) {
            return false;
        }
        ListTaskInstancesResponse other = (ListTaskInstancesResponse) obj;
        return hasTaskInstances() == other.hasTaskInstances() && Objects.equals(taskInstances(), other.taskInstances())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTaskInstancesResponse").add("TaskInstances", hasTaskInstances() ? taskInstances() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskInstances":
            return Optional.ofNullable(clazz.cast(taskInstances()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TaskInstances", TASK_INSTANCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTaskInstancesResponse, T> g) {
        return obj -> g.apply((ListTaskInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MwaaServerlessResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTaskInstancesResponse> {
        /**
         * <p>
         * A list of task instance summaries for the specified workflow run.
         * </p>
         * 
         * @param taskInstances
         *        A list of task instance summaries for the specified workflow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskInstances(Collection<TaskInstanceSummary> taskInstances);

        /**
         * <p>
         * A list of task instance summaries for the specified workflow run.
         * </p>
         * 
         * @param taskInstances
         *        A list of task instance summaries for the specified workflow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskInstances(TaskInstanceSummary... taskInstances);

        /**
         * <p>
         * A list of task instance summaries for the specified workflow run.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mwaaserverless.model.TaskInstanceSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.mwaaserverless.model.TaskInstanceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mwaaserverless.model.TaskInstanceSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #taskInstances(List<TaskInstanceSummary>)}.
         * 
         * @param taskInstances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mwaaserverless.model.TaskInstanceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskInstances(java.util.Collection<TaskInstanceSummary>)
         */
        Builder taskInstances(Consumer<TaskInstanceSummary.Builder>... taskInstances);

        /**
         * <p>
         * The pagination token you need to use to retrieve the next set of results. This value is null if there are no
         * more results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token you need to use to retrieve the next set of results. This value is null if there
         *        are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MwaaServerlessResponse.BuilderImpl implements Builder {
        private List<TaskInstanceSummary> taskInstances = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTaskInstancesResponse model) {
            super(model);
            taskInstances(model.taskInstances);
            nextToken(model.nextToken);
        }

        public final List<TaskInstanceSummary.Builder> getTaskInstances() {
            List<TaskInstanceSummary.Builder> result = TaskInstanceSummariesCopier.copyToBuilder(this.taskInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskInstances(Collection<TaskInstanceSummary.BuilderImpl> taskInstances) {
            this.taskInstances = TaskInstanceSummariesCopier.copyFromBuilder(taskInstances);
        }

        @Override
        public final Builder taskInstances(Collection<TaskInstanceSummary> taskInstances) {
            this.taskInstances = TaskInstanceSummariesCopier.copy(taskInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskInstances(TaskInstanceSummary... taskInstances) {
            taskInstances(Arrays.asList(taskInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskInstances(Consumer<TaskInstanceSummary.Builder>... taskInstances) {
            taskInstances(Stream.of(taskInstances).map(c -> TaskInstanceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTaskInstancesResponse build() {
            return new ListTaskInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
