/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaaserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a workflow run's execution details, including status and timing information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunDetailSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RunDetailSummary.Builder, RunDetailSummary> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RunDetailSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_ON_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedOn")
            .getter(getter(RunDetailSummary::createdOn))
            .setter(setter(Builder::createdOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedOn").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedAt")
            .getter(getter(RunDetailSummary::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndedAt")
            .getter(getter(RunDetailSummary::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            CREATED_ON_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Instant createdOn;

    private final Instant startedAt;

    private final Instant endedAt;

    private RunDetailSummary(BuilderImpl builder) {
        this.status = builder.status;
        this.createdOn = builder.createdOn;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
    }

    /**
     * <p>
     * The current status of the workflow run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the workflow run.
     * @see WorkflowRunStatus
     */
    public final WorkflowRunStatus status() {
        return WorkflowRunStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the workflow run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the workflow run.
     * @see WorkflowRunStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the workflow run was created, in ISO 8601 date-time format.
     * </p>
     * 
     * @return The timestamp when the workflow run was created, in ISO 8601 date-time format.
     */
    public final Instant createdOn() {
        return createdOn;
    }

    /**
     * <p>
     * The timestamp when the workflow run started execution, in ISO 8601 date-time format.
     * </p>
     * 
     * @return The timestamp when the workflow run started execution, in ISO 8601 date-time format.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The timestamp when the workflow run completed execution, in ISO 8601 date-time format. This value is null if the
     * run is not complete.
     * </p>
     * 
     * @return The timestamp when the workflow run completed execution, in ISO 8601 date-time format. This value is null
     *         if the run is not complete.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunDetailSummary)) {
            return false;
        }
        RunDetailSummary other = (RunDetailSummary) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdOn(), other.createdOn())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(endedAt(), other.endedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunDetailSummary").add("Status", statusAsString()).add("CreatedOn", createdOn())
                .add("StartedAt", startedAt()).add("EndedAt", endedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedOn":
            return Optional.ofNullable(clazz.cast(createdOn()));
        case "StartedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "EndedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("CreatedOn", CREATED_ON_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        map.put("EndedAt", ENDED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RunDetailSummary, T> g) {
        return obj -> g.apply((RunDetailSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RunDetailSummary> {
        /**
         * <p>
         * The current status of the workflow run.
         * </p>
         * 
         * @param status
         *        The current status of the workflow run.
         * @see WorkflowRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowRunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the workflow run.
         * </p>
         * 
         * @param status
         *        The current status of the workflow run.
         * @see WorkflowRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowRunStatus
         */
        Builder status(WorkflowRunStatus status);

        /**
         * <p>
         * The timestamp when the workflow run was created, in ISO 8601 date-time format.
         * </p>
         * 
         * @param createdOn
         *        The timestamp when the workflow run was created, in ISO 8601 date-time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdOn(Instant createdOn);

        /**
         * <p>
         * The timestamp when the workflow run started execution, in ISO 8601 date-time format.
         * </p>
         * 
         * @param startedAt
         *        The timestamp when the workflow run started execution, in ISO 8601 date-time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The timestamp when the workflow run completed execution, in ISO 8601 date-time format. This value is null if
         * the run is not complete.
         * </p>
         * 
         * @param endedAt
         *        The timestamp when the workflow run completed execution, in ISO 8601 date-time format. This value is
         *        null if the run is not complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Instant createdOn;

        private Instant startedAt;

        private Instant endedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(RunDetailSummary model) {
            status(model.status);
            createdOn(model.createdOn);
            startedAt(model.startedAt);
            endedAt(model.endedAt);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedOn() {
            return createdOn;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        @Override
        public RunDetailSummary build() {
            return new RunDetailSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
