/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaaserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartWorkflowRunRequest extends MwaaServerlessRequest implements
        ToCopyableBuilder<StartWorkflowRunRequest.Builder, StartWorkflowRunRequest> {
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowArn").getter(getter(StartWorkflowRunRequest::workflowArn)).setter(setter(Builder::workflowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartWorkflowRunRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, Document>> OVERRIDE_PARAMETERS_FIELD = SdkField
            .<Map<String, Document>> builder(MarshallingType.MAP)
            .memberName("OverrideParameters")
            .getter(getter(StartWorkflowRunRequest::overrideParameters))
            .setter(setter(Builder::overrideParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Document> builder(MarshallingType.DOCUMENT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WORKFLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowVersion").getter(getter(StartWorkflowRunRequest::workflowVersion))
            .setter(setter(Builder::workflowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ARN_FIELD,
            CLIENT_TOKEN_FIELD, OVERRIDE_PARAMETERS_FIELD, WORKFLOW_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workflowArn;

    private final String clientToken;

    private final Map<String, Document> overrideParameters;

    private final String workflowVersion;

    private StartWorkflowRunRequest(BuilderImpl builder) {
        super(builder);
        this.workflowArn = builder.workflowArn;
        this.clientToken = builder.clientToken;
        this.overrideParameters = builder.overrideParameters;
        this.workflowVersion = builder.workflowVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the workflow you want to run.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the workflow you want to run.
     */
    public final String workflowArn() {
        return workflowArn;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This token
     * prevents duplicate workflow run requests.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This token
     *         prevents duplicate workflow run requests.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OverrideParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOverrideParameters() {
        return overrideParameters != null && !(overrideParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Optional parameters to override default workflow parameters for this specific run. These parameters are passed to
     * the workflow during execution and can be used to customize behavior without modifying the workflow definition.
     * Parameters are made available as environment variables to tasks and you can reference them within the YAML
     * workflow definition using standard parameter substitution syntax.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOverrideParameters} method.
     * </p>
     * 
     * @return Optional parameters to override default workflow parameters for this specific run. These parameters are
     *         passed to the workflow during execution and can be used to customize behavior without modifying the
     *         workflow definition. Parameters are made available as environment variables to tasks and you can
     *         reference them within the YAML workflow definition using standard parameter substitution syntax.
     */
    public final Map<String, Document> overrideParameters() {
        return overrideParameters;
    }

    /**
     * <p>
     * Optional. The specific version of the workflow to execute. If not specified, the latest version is used.
     * </p>
     * 
     * @return Optional. The specific version of the workflow to execute. If not specified, the latest version is used.
     */
    public final String workflowVersion() {
        return workflowVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasOverrideParameters() ? overrideParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workflowVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartWorkflowRunRequest)) {
            return false;
        }
        StartWorkflowRunRequest other = (StartWorkflowRunRequest) obj;
        return Objects.equals(workflowArn(), other.workflowArn()) && Objects.equals(clientToken(), other.clientToken())
                && hasOverrideParameters() == other.hasOverrideParameters()
                && Objects.equals(overrideParameters(), other.overrideParameters())
                && Objects.equals(workflowVersion(), other.workflowVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartWorkflowRunRequest").add("WorkflowArn", workflowArn()).add("ClientToken", clientToken())
                .add("OverrideParameters", overrideParameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WorkflowVersion", workflowVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkflowArn":
            return Optional.ofNullable(clazz.cast(workflowArn()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "OverrideParameters":
            return Optional.ofNullable(clazz.cast(overrideParameters()));
        case "WorkflowVersion":
            return Optional.ofNullable(clazz.cast(workflowVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkflowArn", WORKFLOW_ARN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("OverrideParameters", OVERRIDE_PARAMETERS_FIELD);
        map.put("WorkflowVersion", WORKFLOW_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartWorkflowRunRequest, T> g) {
        return obj -> g.apply((StartWorkflowRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MwaaServerlessRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartWorkflowRunRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the workflow you want to run.
         * </p>
         * 
         * @param workflowArn
         *        The Amazon Resource Name (ARN) of the workflow you want to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowArn(String workflowArn);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This token
         * prevents duplicate workflow run requests.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This
         *        token prevents duplicate workflow run requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Optional parameters to override default workflow parameters for this specific run. These parameters are
         * passed to the workflow during execution and can be used to customize behavior without modifying the workflow
         * definition. Parameters are made available as environment variables to tasks and you can reference them within
         * the YAML workflow definition using standard parameter substitution syntax.
         * </p>
         * 
         * @param overrideParameters
         *        Optional parameters to override default workflow parameters for this specific run. These parameters
         *        are passed to the workflow during execution and can be used to customize behavior without modifying
         *        the workflow definition. Parameters are made available as environment variables to tasks and you can
         *        reference them within the YAML workflow definition using standard parameter substitution syntax.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideParameters(Map<String, Document> overrideParameters);

        /**
         * <p>
         * Optional. The specific version of the workflow to execute. If not specified, the latest version is used.
         * </p>
         * 
         * @param workflowVersion
         *        Optional. The specific version of the workflow to execute. If not specified, the latest version is
         *        used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowVersion(String workflowVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MwaaServerlessRequest.BuilderImpl implements Builder {
        private String workflowArn;

        private String clientToken;

        private Map<String, Document> overrideParameters = DefaultSdkAutoConstructMap.getInstance();

        private String workflowVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(StartWorkflowRunRequest model) {
            super(model);
            workflowArn(model.workflowArn);
            clientToken(model.clientToken);
            overrideParameters(model.overrideParameters);
            workflowVersion(model.workflowVersion);
        }

        public final String getWorkflowArn() {
            return workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, Document> getOverrideParameters() {
            if (overrideParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return overrideParameters;
        }

        public final void setOverrideParameters(Map<String, Document> overrideParameters) {
            this.overrideParameters = ObjectMapCopier.copy(overrideParameters);
        }

        @Override
        public final Builder overrideParameters(Map<String, Document> overrideParameters) {
            this.overrideParameters = ObjectMapCopier.copy(overrideParameters);
            return this;
        }

        public final String getWorkflowVersion() {
            return workflowVersion;
        }

        public final void setWorkflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
        }

        @Override
        public final Builder workflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartWorkflowRunRequest build() {
            return new StartWorkflowRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
