/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaaserverless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartWorkflowRunResponse extends MwaaServerlessResponse implements
        ToCopyableBuilder<StartWorkflowRunResponse.Builder, StartWorkflowRunResponse> {
    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RunId")
            .getter(getter(StartWorkflowRunResponse::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(StartWorkflowRunResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedAt")
            .getter(getter(StartWorkflowRunResponse::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_ID_FIELD, STATUS_FIELD,
            STARTED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String runId;

    private final String status;

    private final Instant startedAt;

    private StartWorkflowRunResponse(BuilderImpl builder) {
        super(builder);
        this.runId = builder.runId;
        this.status = builder.status;
        this.startedAt = builder.startedAt;
    }

    /**
     * <p>
     * The unique identifier of the newly started workflow run.
     * </p>
     * 
     * @return The unique identifier of the newly started workflow run.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * The initial status of the workflow run. This is typically <code>STARTING</code> when you first create the run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The initial status of the workflow run. This is typically <code>STARTING</code> when you first create the
     *         run.
     * @see WorkflowRunStatus
     */
    public final WorkflowRunStatus status() {
        return WorkflowRunStatus.fromValue(status);
    }

    /**
     * <p>
     * The initial status of the workflow run. This is typically <code>STARTING</code> when you first create the run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The initial status of the workflow run. This is typically <code>STARTING</code> when you first create the
     *         run.
     * @see WorkflowRunStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the workflow run was started, in ISO 8601 date-time format.
     * </p>
     * 
     * @return The timestamp when the workflow run was started, in ISO 8601 date-time format.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartWorkflowRunResponse)) {
            return false;
        }
        StartWorkflowRunResponse other = (StartWorkflowRunResponse) obj;
        return Objects.equals(runId(), other.runId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(startedAt(), other.startedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartWorkflowRunResponse").add("RunId", runId()).add("Status", statusAsString())
                .add("StartedAt", startedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RunId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StartedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RunId", RUN_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartWorkflowRunResponse, T> g) {
        return obj -> g.apply((StartWorkflowRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MwaaServerlessResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartWorkflowRunResponse> {
        /**
         * <p>
         * The unique identifier of the newly started workflow run.
         * </p>
         * 
         * @param runId
         *        The unique identifier of the newly started workflow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The initial status of the workflow run. This is typically <code>STARTING</code> when you first create the
         * run.
         * </p>
         * 
         * @param status
         *        The initial status of the workflow run. This is typically <code>STARTING</code> when you first create
         *        the run.
         * @see WorkflowRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowRunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The initial status of the workflow run. This is typically <code>STARTING</code> when you first create the
         * run.
         * </p>
         * 
         * @param status
         *        The initial status of the workflow run. This is typically <code>STARTING</code> when you first create
         *        the run.
         * @see WorkflowRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowRunStatus
         */
        Builder status(WorkflowRunStatus status);

        /**
         * <p>
         * The timestamp when the workflow run was started, in ISO 8601 date-time format.
         * </p>
         * 
         * @param startedAt
         *        The timestamp when the workflow run was started, in ISO 8601 date-time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);
    }

    static final class BuilderImpl extends MwaaServerlessResponse.BuilderImpl implements Builder {
        private String runId;

        private String status;

        private Instant startedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(StartWorkflowRunResponse model) {
            super(model);
            runId(model.runId);
            status(model.status);
            startedAt(model.startedAt);
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        @Override
        public StartWorkflowRunResponse build() {
            return new StartWorkflowRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
