/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaaserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a task instance within a workflow run, including its status and execution details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskInstanceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskInstanceSummary.Builder, TaskInstanceSummary> {
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowArn").getter(getter(TaskInstanceSummary::workflowArn)).setter(setter(Builder::workflowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowArn").build()).build();

    private static final SdkField<String> WORKFLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowVersion").getter(getter(TaskInstanceSummary::workflowVersion))
            .setter(setter(Builder::workflowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowVersion").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RunId")
            .getter(getter(TaskInstanceSummary::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()).build();

    private static final SdkField<String> TASK_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskInstanceId").getter(getter(TaskInstanceSummary::taskInstanceId))
            .setter(setter(Builder::taskInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskInstanceId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(TaskInstanceSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationInSeconds").getter(getter(TaskInstanceSummary::durationInSeconds))
            .setter(setter(Builder::durationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()).build();

    private static final SdkField<String> OPERATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperatorName").getter(getter(TaskInstanceSummary::operatorName)).setter(setter(Builder::operatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatorName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ARN_FIELD,
            WORKFLOW_VERSION_FIELD, RUN_ID_FIELD, TASK_INSTANCE_ID_FIELD, STATUS_FIELD, DURATION_IN_SECONDS_FIELD,
            OPERATOR_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String workflowArn;

    private final String workflowVersion;

    private final String runId;

    private final String taskInstanceId;

    private final String status;

    private final Integer durationInSeconds;

    private final String operatorName;

    private TaskInstanceSummary(BuilderImpl builder) {
        this.workflowArn = builder.workflowArn;
        this.workflowVersion = builder.workflowVersion;
        this.runId = builder.runId;
        this.taskInstanceId = builder.taskInstanceId;
        this.status = builder.status;
        this.durationInSeconds = builder.durationInSeconds;
        this.operatorName = builder.operatorName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the workflow that contains this task instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the workflow that contains this task instance.
     */
    public final String workflowArn() {
        return workflowArn;
    }

    /**
     * <p>
     * The version of the workflow that contains this task instance.
     * </p>
     * 
     * @return The version of the workflow that contains this task instance.
     */
    public final String workflowVersion() {
        return workflowVersion;
    }

    /**
     * <p>
     * The unique identifier of the workflow run that contains this task instance.
     * </p>
     * 
     * @return The unique identifier of the workflow run that contains this task instance.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * The unique identifier of this task instance.
     * </p>
     * 
     * @return The unique identifier of this task instance.
     */
    public final String taskInstanceId() {
        return taskInstanceId;
    }

    /**
     * <p>
     * The current status of the task instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the task instance.
     * @see TaskInstanceStatus
     */
    public final TaskInstanceStatus status() {
        return TaskInstanceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the task instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the task instance.
     * @see TaskInstanceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The duration of the task instance execution in seconds. This value is null if the task is not complete.
     * </p>
     * 
     * @return The duration of the task instance execution in seconds. This value is null if the task is not complete.
     */
    public final Integer durationInSeconds() {
        return durationInSeconds;
    }

    /**
     * <p>
     * The name of the Apache Airflow operator used for this task instance.
     * </p>
     * 
     * @return The name of the Apache Airflow operator used for this task instance.
     */
    public final String operatorName() {
        return operatorName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(workflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(taskInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(operatorName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskInstanceSummary)) {
            return false;
        }
        TaskInstanceSummary other = (TaskInstanceSummary) obj;
        return Objects.equals(workflowArn(), other.workflowArn()) && Objects.equals(workflowVersion(), other.workflowVersion())
                && Objects.equals(runId(), other.runId()) && Objects.equals(taskInstanceId(), other.taskInstanceId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(durationInSeconds(), other.durationInSeconds())
                && Objects.equals(operatorName(), other.operatorName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskInstanceSummary").add("WorkflowArn", workflowArn())
                .add("WorkflowVersion", workflowVersion()).add("RunId", runId()).add("TaskInstanceId", taskInstanceId())
                .add("Status", statusAsString()).add("DurationInSeconds", durationInSeconds())
                .add("OperatorName", operatorName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkflowArn":
            return Optional.ofNullable(clazz.cast(workflowArn()));
        case "WorkflowVersion":
            return Optional.ofNullable(clazz.cast(workflowVersion()));
        case "RunId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "TaskInstanceId":
            return Optional.ofNullable(clazz.cast(taskInstanceId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "DurationInSeconds":
            return Optional.ofNullable(clazz.cast(durationInSeconds()));
        case "OperatorName":
            return Optional.ofNullable(clazz.cast(operatorName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkflowArn", WORKFLOW_ARN_FIELD);
        map.put("WorkflowVersion", WORKFLOW_VERSION_FIELD);
        map.put("RunId", RUN_ID_FIELD);
        map.put("TaskInstanceId", TASK_INSTANCE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DurationInSeconds", DURATION_IN_SECONDS_FIELD);
        map.put("OperatorName", OPERATOR_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskInstanceSummary, T> g) {
        return obj -> g.apply((TaskInstanceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskInstanceSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the workflow that contains this task instance.
         * </p>
         * 
         * @param workflowArn
         *        The Amazon Resource Name (ARN) of the workflow that contains this task instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowArn(String workflowArn);

        /**
         * <p>
         * The version of the workflow that contains this task instance.
         * </p>
         * 
         * @param workflowVersion
         *        The version of the workflow that contains this task instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowVersion(String workflowVersion);

        /**
         * <p>
         * The unique identifier of the workflow run that contains this task instance.
         * </p>
         * 
         * @param runId
         *        The unique identifier of the workflow run that contains this task instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The unique identifier of this task instance.
         * </p>
         * 
         * @param taskInstanceId
         *        The unique identifier of this task instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskInstanceId(String taskInstanceId);

        /**
         * <p>
         * The current status of the task instance.
         * </p>
         * 
         * @param status
         *        The current status of the task instance.
         * @see TaskInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskInstanceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the task instance.
         * </p>
         * 
         * @param status
         *        The current status of the task instance.
         * @see TaskInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskInstanceStatus
         */
        Builder status(TaskInstanceStatus status);

        /**
         * <p>
         * The duration of the task instance execution in seconds. This value is null if the task is not complete.
         * </p>
         * 
         * @param durationInSeconds
         *        The duration of the task instance execution in seconds. This value is null if the task is not
         *        complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Integer durationInSeconds);

        /**
         * <p>
         * The name of the Apache Airflow operator used for this task instance.
         * </p>
         * 
         * @param operatorName
         *        The name of the Apache Airflow operator used for this task instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatorName(String operatorName);
    }

    static final class BuilderImpl implements Builder {
        private String workflowArn;

        private String workflowVersion;

        private String runId;

        private String taskInstanceId;

        private String status;

        private Integer durationInSeconds;

        private String operatorName;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskInstanceSummary model) {
            workflowArn(model.workflowArn);
            workflowVersion(model.workflowVersion);
            runId(model.runId);
            taskInstanceId(model.taskInstanceId);
            status(model.status);
            durationInSeconds(model.durationInSeconds);
            operatorName(model.operatorName);
        }

        public final String getWorkflowArn() {
            return workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getWorkflowVersion() {
            return workflowVersion;
        }

        public final void setWorkflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
        }

        @Override
        public final Builder workflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getTaskInstanceId() {
            return taskInstanceId;
        }

        public final void setTaskInstanceId(String taskInstanceId) {
            this.taskInstanceId = taskInstanceId;
        }

        @Override
        public final Builder taskInstanceId(String taskInstanceId) {
            this.taskInstanceId = taskInstanceId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskInstanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getDurationInSeconds() {
            return durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final String getOperatorName() {
            return operatorName;
        }

        public final void setOperatorName(String operatorName) {
            this.operatorName = operatorName;
        }

        @Override
        public final Builder operatorName(String operatorName) {
            this.operatorName = operatorName;
            return this;
        }

        @Override
        public TaskInstanceSummary build() {
            return new TaskInstanceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
