/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaaserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a workflow version, including identification and configuration details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowVersionSummary.Builder, WorkflowVersionSummary> {
    private static final SdkField<String> WORKFLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowVersion").getter(getter(WorkflowVersionSummary::workflowVersion))
            .setter(setter(Builder::workflowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowVersion").build()).build();

    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowArn").getter(getter(WorkflowVersionSummary::workflowArn)).setter(setter(Builder::workflowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowArn").build()).build();

    private static final SdkField<Boolean> IS_LATEST_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsLatestVersion").getter(getter(WorkflowVersionSummary::isLatestVersion))
            .setter(setter(Builder::isLatestVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLatestVersion").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(WorkflowVersionSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedAt")
            .getter(getter(WorkflowVersionSummary::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<DefinitionS3Location> DEFINITION_S3_LOCATION_FIELD = SdkField
            .<DefinitionS3Location> builder(MarshallingType.SDK_POJO).memberName("DefinitionS3Location")
            .getter(getter(WorkflowVersionSummary::definitionS3Location)).setter(setter(Builder::definitionS3Location))
            .constructor(DefinitionS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefinitionS3Location").build())
            .build();

    private static final SdkField<ScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField
            .<ScheduleConfiguration> builder(MarshallingType.SDK_POJO).memberName("ScheduleConfiguration")
            .getter(getter(WorkflowVersionSummary::scheduleConfiguration)).setter(setter(Builder::scheduleConfiguration))
            .constructor(ScheduleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build())
            .build();

    private static final SdkField<String> TRIGGER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TriggerMode").getter(getter(WorkflowVersionSummary::triggerMode)).setter(setter(Builder::triggerMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_VERSION_FIELD,
            WORKFLOW_ARN_FIELD, IS_LATEST_VERSION_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, DEFINITION_S3_LOCATION_FIELD,
            SCHEDULE_CONFIGURATION_FIELD, TRIGGER_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String workflowVersion;

    private final String workflowArn;

    private final Boolean isLatestVersion;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final DefinitionS3Location definitionS3Location;

    private final ScheduleConfiguration scheduleConfiguration;

    private final String triggerMode;

    private WorkflowVersionSummary(BuilderImpl builder) {
        this.workflowVersion = builder.workflowVersion;
        this.workflowArn = builder.workflowArn;
        this.isLatestVersion = builder.isLatestVersion;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.definitionS3Location = builder.definitionS3Location;
        this.scheduleConfiguration = builder.scheduleConfiguration;
        this.triggerMode = builder.triggerMode;
    }

    /**
     * <p>
     * The version identifier of the workflow version.
     * </p>
     * 
     * @return The version identifier of the workflow version.
     */
    public final String workflowVersion() {
        return workflowVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the workflow that contains this version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the workflow that contains this version.
     */
    public final String workflowArn() {
        return workflowArn;
    }

    /**
     * <p>
     * Boolean flag that indicates whether this is the latest version of the workflow.
     * </p>
     * 
     * @return Boolean flag that indicates whether this is the latest version of the workflow.
     */
    public final Boolean isLatestVersion() {
        return isLatestVersion;
    }

    /**
     * <p>
     * The timestamp when the workflow version was created, in ISO 8601 date-time format.
     * </p>
     * 
     * @return The timestamp when the workflow version was created, in ISO 8601 date-time format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the workflow version was last modified, in ISO 8601 date-time format.
     * </p>
     * 
     * @return The timestamp when the workflow version was last modified, in ISO 8601 date-time format.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The Amazon S3 location of the workflow definition file for this version.
     * </p>
     * 
     * @return The Amazon S3 location of the workflow definition file for this version.
     */
    public final DefinitionS3Location definitionS3Location() {
        return definitionS3Location;
    }

    /**
     * <p>
     * The schedule configuration for this workflow version.
     * </p>
     * 
     * @return The schedule configuration for this workflow version.
     */
    public final ScheduleConfiguration scheduleConfiguration() {
        return scheduleConfiguration;
    }

    /**
     * <p>
     * The trigger mode for the workflow execution.
     * </p>
     * 
     * @return The trigger mode for the workflow execution.
     */
    public final String triggerMode() {
        return triggerMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(isLatestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(definitionS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(triggerMode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowVersionSummary)) {
            return false;
        }
        WorkflowVersionSummary other = (WorkflowVersionSummary) obj;
        return Objects.equals(workflowVersion(), other.workflowVersion()) && Objects.equals(workflowArn(), other.workflowArn())
                && Objects.equals(isLatestVersion(), other.isLatestVersion()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt())
                && Objects.equals(definitionS3Location(), other.definitionS3Location())
                && Objects.equals(scheduleConfiguration(), other.scheduleConfiguration())
                && Objects.equals(triggerMode(), other.triggerMode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowVersionSummary").add("WorkflowVersion", workflowVersion())
                .add("WorkflowArn", workflowArn()).add("IsLatestVersion", isLatestVersion()).add("CreatedAt", createdAt())
                .add("ModifiedAt", modifiedAt()).add("DefinitionS3Location", definitionS3Location())
                .add("ScheduleConfiguration", scheduleConfiguration()).add("TriggerMode", triggerMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkflowVersion":
            return Optional.ofNullable(clazz.cast(workflowVersion()));
        case "WorkflowArn":
            return Optional.ofNullable(clazz.cast(workflowArn()));
        case "IsLatestVersion":
            return Optional.ofNullable(clazz.cast(isLatestVersion()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ModifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "DefinitionS3Location":
            return Optional.ofNullable(clazz.cast(definitionS3Location()));
        case "ScheduleConfiguration":
            return Optional.ofNullable(clazz.cast(scheduleConfiguration()));
        case "TriggerMode":
            return Optional.ofNullable(clazz.cast(triggerMode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkflowVersion", WORKFLOW_VERSION_FIELD);
        map.put("WorkflowArn", WORKFLOW_ARN_FIELD);
        map.put("IsLatestVersion", IS_LATEST_VERSION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("ModifiedAt", MODIFIED_AT_FIELD);
        map.put("DefinitionS3Location", DEFINITION_S3_LOCATION_FIELD);
        map.put("ScheduleConfiguration", SCHEDULE_CONFIGURATION_FIELD);
        map.put("TriggerMode", TRIGGER_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowVersionSummary, T> g) {
        return obj -> g.apply((WorkflowVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowVersionSummary> {
        /**
         * <p>
         * The version identifier of the workflow version.
         * </p>
         * 
         * @param workflowVersion
         *        The version identifier of the workflow version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowVersion(String workflowVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the workflow that contains this version.
         * </p>
         * 
         * @param workflowArn
         *        The Amazon Resource Name (ARN) of the workflow that contains this version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowArn(String workflowArn);

        /**
         * <p>
         * Boolean flag that indicates whether this is the latest version of the workflow.
         * </p>
         * 
         * @param isLatestVersion
         *        Boolean flag that indicates whether this is the latest version of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLatestVersion(Boolean isLatestVersion);

        /**
         * <p>
         * The timestamp when the workflow version was created, in ISO 8601 date-time format.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the workflow version was created, in ISO 8601 date-time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the workflow version was last modified, in ISO 8601 date-time format.
         * </p>
         * 
         * @param modifiedAt
         *        The timestamp when the workflow version was last modified, in ISO 8601 date-time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The Amazon S3 location of the workflow definition file for this version.
         * </p>
         * 
         * @param definitionS3Location
         *        The Amazon S3 location of the workflow definition file for this version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionS3Location(DefinitionS3Location definitionS3Location);

        /**
         * <p>
         * The Amazon S3 location of the workflow definition file for this version.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefinitionS3Location.Builder} avoiding
         * the need to create one manually via {@link DefinitionS3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefinitionS3Location.Builder#build()} is called immediately and
         * its result is passed to {@link #definitionS3Location(DefinitionS3Location)}.
         * 
         * @param definitionS3Location
         *        a consumer that will call methods on {@link DefinitionS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definitionS3Location(DefinitionS3Location)
         */
        default Builder definitionS3Location(Consumer<DefinitionS3Location.Builder> definitionS3Location) {
            return definitionS3Location(DefinitionS3Location.builder().applyMutation(definitionS3Location).build());
        }

        /**
         * <p>
         * The schedule configuration for this workflow version.
         * </p>
         * 
         * @param scheduleConfiguration
         *        The schedule configuration for this workflow version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration);

        /**
         * <p>
         * The schedule configuration for this workflow version.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduleConfiguration.Builder} avoiding
         * the need to create one manually via {@link ScheduleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduleConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduleConfiguration(ScheduleConfiguration)}.
         * 
         * @param scheduleConfiguration
         *        a consumer that will call methods on {@link ScheduleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleConfiguration(ScheduleConfiguration)
         */
        default Builder scheduleConfiguration(Consumer<ScheduleConfiguration.Builder> scheduleConfiguration) {
            return scheduleConfiguration(ScheduleConfiguration.builder().applyMutation(scheduleConfiguration).build());
        }

        /**
         * <p>
         * The trigger mode for the workflow execution.
         * </p>
         * 
         * @param triggerMode
         *        The trigger mode for the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerMode(String triggerMode);
    }

    static final class BuilderImpl implements Builder {
        private String workflowVersion;

        private String workflowArn;

        private Boolean isLatestVersion;

        private Instant createdAt;

        private Instant modifiedAt;

        private DefinitionS3Location definitionS3Location;

        private ScheduleConfiguration scheduleConfiguration;

        private String triggerMode;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowVersionSummary model) {
            workflowVersion(model.workflowVersion);
            workflowArn(model.workflowArn);
            isLatestVersion(model.isLatestVersion);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            definitionS3Location(model.definitionS3Location);
            scheduleConfiguration(model.scheduleConfiguration);
            triggerMode(model.triggerMode);
        }

        public final String getWorkflowVersion() {
            return workflowVersion;
        }

        public final void setWorkflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
        }

        @Override
        public final Builder workflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
            return this;
        }

        public final String getWorkflowArn() {
            return workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final Boolean getIsLatestVersion() {
            return isLatestVersion;
        }

        public final void setIsLatestVersion(Boolean isLatestVersion) {
            this.isLatestVersion = isLatestVersion;
        }

        @Override
        public final Builder isLatestVersion(Boolean isLatestVersion) {
            this.isLatestVersion = isLatestVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final DefinitionS3Location.Builder getDefinitionS3Location() {
            return definitionS3Location != null ? definitionS3Location.toBuilder() : null;
        }

        public final void setDefinitionS3Location(DefinitionS3Location.BuilderImpl definitionS3Location) {
            this.definitionS3Location = definitionS3Location != null ? definitionS3Location.build() : null;
        }

        @Override
        public final Builder definitionS3Location(DefinitionS3Location definitionS3Location) {
            this.definitionS3Location = definitionS3Location;
            return this;
        }

        public final ScheduleConfiguration.Builder getScheduleConfiguration() {
            return scheduleConfiguration != null ? scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(ScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        public final Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        public final String getTriggerMode() {
            return triggerMode;
        }

        public final void setTriggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
        }

        @Override
        public final Builder triggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
            return this;
        }

        @Override
        public WorkflowVersionSummary build() {
            return new WorkflowVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
