/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the result of a successful invocation of the <a>DescribeDBEngineVersions</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbEngineVersionsResponse extends NeptuneResponse implements
        ToCopyableBuilder<DescribeDbEngineVersionsResponse.Builder, DescribeDbEngineVersionsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDbEngineVersionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<DBEngineVersion>> DB_ENGINE_VERSIONS_FIELD = SdkField
            .<List<DBEngineVersion>> builder(MarshallingType.LIST)
            .getter(getter(DescribeDbEngineVersionsResponse::dbEngineVersions))
            .setter(setter(Builder::dbEngineVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBEngineVersion")
                            .memberFieldInfo(
                                    SdkField.<DBEngineVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBEngineVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBEngineVersion").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            DB_ENGINE_VERSIONS_FIELD));

    private final String marker;

    private final List<DBEngineVersion> dbEngineVersions;

    private DescribeDbEngineVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbEngineVersions = builder.dbEngineVersions;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * A list of <code>DBEngineVersion</code> elements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>DBEngineVersion</code> elements.
     */
    public List<DBEngineVersion> dbEngineVersions() {
        return dbEngineVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(dbEngineVersions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbEngineVersionsResponse)) {
            return false;
        }
        DescribeDbEngineVersionsResponse other = (DescribeDbEngineVersionsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(dbEngineVersions(), other.dbEngineVersions());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeDbEngineVersionsResponse").add("Marker", marker())
                .add("DBEngineVersions", dbEngineVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "DBEngineVersions":
            return Optional.ofNullable(clazz.cast(dbEngineVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbEngineVersionsResponse, T> g) {
        return obj -> g.apply((DescribeDbEngineVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDbEngineVersionsResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of <code>DBEngineVersion</code> elements.
         * </p>
         * 
         * @param dbEngineVersions
         *        A list of <code>DBEngineVersion</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbEngineVersions(Collection<DBEngineVersion> dbEngineVersions);

        /**
         * <p>
         * A list of <code>DBEngineVersion</code> elements.
         * </p>
         * 
         * @param dbEngineVersions
         *        A list of <code>DBEngineVersion</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbEngineVersions(DBEngineVersion... dbEngineVersions);

        /**
         * <p>
         * A list of <code>DBEngineVersion</code> elements.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBEngineVersion>.Builder} avoiding the need
         * to create one manually via {@link List<DBEngineVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBEngineVersion>.Builder#build()} is called immediately and
         * its result is passed to {@link #dbEngineVersions(List<DBEngineVersion>)}.
         * 
         * @param dbEngineVersions
         *        a consumer that will call methods on {@link List<DBEngineVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbEngineVersions(List<DBEngineVersion>)
         */
        Builder dbEngineVersions(Consumer<DBEngineVersion.Builder>... dbEngineVersions);
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private String marker;

        private List<DBEngineVersion> dbEngineVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbEngineVersionsResponse model) {
            super(model);
            marker(model.marker);
            dbEngineVersions(model.dbEngineVersions);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBEngineVersion.Builder> getDBEngineVersions() {
            return dbEngineVersions != null ? dbEngineVersions.stream().map(DBEngineVersion::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbEngineVersions(Collection<DBEngineVersion> dbEngineVersions) {
            this.dbEngineVersions = DBEngineVersionListCopier.copy(dbEngineVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbEngineVersions(DBEngineVersion... dbEngineVersions) {
            dbEngineVersions(Arrays.asList(dbEngineVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbEngineVersions(Consumer<DBEngineVersion.Builder>... dbEngineVersions) {
            dbEngineVersions(Stream.of(dbEngineVersions).map(c -> DBEngineVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDBEngineVersions(Collection<DBEngineVersion.BuilderImpl> dbEngineVersions) {
            this.dbEngineVersions = DBEngineVersionListCopier.copyFromBuilder(dbEngineVersions);
        }

        @Override
        public DescribeDbEngineVersionsResponse build() {
            return new DescribeDbEngineVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
