/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveTagsFromResourceRequest extends NeptuneRequest implements
        ToCopyableBuilder<RemoveTagsFromResourceRequest.Builder, RemoveTagsFromResourceRequest> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemoveTagsFromResourceRequest::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final SdkField<List<String>> TAG_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RemoveTagsFromResourceRequest::tagKeys))
            .setter(setter(Builder::tagKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD,
            TAG_KEYS_FIELD));

    private final String resourceName;

    private final List<String> tagKeys;

    private RemoveTagsFromResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceName = builder.resourceName;
        this.tagKeys = builder.tagKeys;
    }

    /**
     * <p>
     * The Amazon Neptune resource that the tags are removed from. This value is an Amazon Resource Name (ARN). For
     * information about creating an ARN, see <a
     * href="http://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing">
     * Constructing an Amazon Resource Name (ARN)</a>.
     * </p>
     * 
     * @return The Amazon Neptune resource that the tags are removed from. This value is an Amazon Resource Name (ARN).
     *         For information about creating an ARN, see <a
     *         href="http://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing">
     *         Constructing an Amazon Resource Name (ARN)</a>.
     */
    public String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The tag key (name) of the tag to be removed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tag key (name) of the tag to be removed.
     */
    public List<String> tagKeys() {
        return tagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(tagKeys());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsFromResourceRequest)) {
            return false;
        }
        RemoveTagsFromResourceRequest other = (RemoveTagsFromResourceRequest) obj;
        return Objects.equals(resourceName(), other.resourceName()) && Objects.equals(tagKeys(), other.tagKeys());
    }

    @Override
    public String toString() {
        return ToString.builder("RemoveTagsFromResourceRequest").add("ResourceName", resourceName()).add("TagKeys", tagKeys())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "TagKeys":
            return Optional.ofNullable(clazz.cast(tagKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveTagsFromResourceRequest, T> g) {
        return obj -> g.apply((RemoveTagsFromResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneRequest.Builder, SdkPojo, CopyableBuilder<Builder, RemoveTagsFromResourceRequest> {
        /**
         * <p>
         * The Amazon Neptune resource that the tags are removed from. This value is an Amazon Resource Name (ARN). For
         * information about creating an ARN, see <a
         * href="http://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing">
         * Constructing an Amazon Resource Name (ARN)</a>.
         * </p>
         * 
         * @param resourceName
         *        The Amazon Neptune resource that the tags are removed from. This value is an Amazon Resource Name
         *        (ARN). For information about creating an ARN, see <a
         *        href="http://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing">
         *        Constructing an Amazon Resource Name (ARN)</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The tag key (name) of the tag to be removed.
         * </p>
         * 
         * @param tagKeys
         *        The tag key (name) of the tag to be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(Collection<String> tagKeys);

        /**
         * <p>
         * The tag key (name) of the tag to be removed.
         * </p>
         * 
         * @param tagKeys
         *        The tag key (name) of the tag to be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(String... tagKeys);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneRequest.BuilderImpl implements Builder {
        private String resourceName;

        private List<String> tagKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTagsFromResourceRequest model) {
            super(model);
            resourceName(model.resourceName);
            tagKeys(model.tagKeys);
        }

        public final String getResourceName() {
            return resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final Collection<String> getTagKeys() {
            return tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = KeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String... tagKeys) {
            tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = KeyListCopier.copy(tagKeys);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveTagsFromResourceRequest build() {
            return new RemoveTagsFromResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
