/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A range of integer values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Range implements SdkPojo, Serializable, ToCopyableBuilder<Range.Builder, Range> {
    private static final SdkField<Integer> FROM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Range::from)).setter(setter(Builder::from))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("From").build()).build();

    private static final SdkField<Integer> TO_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Range::to)).setter(setter(Builder::to))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("To").build()).build();

    private static final SdkField<Integer> STEP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Range::step)).setter(setter(Builder::step))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Step").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_FIELD, TO_FIELD,
            STEP_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer from;

    private final Integer to;

    private final Integer step;

    private Range(BuilderImpl builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.step = builder.step;
    }

    /**
     * <p>
     * The minimum value in the range.
     * </p>
     * 
     * @return The minimum value in the range.
     */
    public Integer from() {
        return from;
    }

    /**
     * <p>
     * The maximum value in the range.
     * </p>
     * 
     * @return The maximum value in the range.
     */
    public Integer to() {
        return to;
    }

    /**
     * <p>
     * The step value for the range. For example, if you have a range of 5,000 to 10,000, with a step value of 1,000,
     * the valid values start at 5,000 and step up by 1,000. Even though 7,500 is within the range, it isn't a valid
     * value for the range. The valid values are 5,000, 6,000, 7,000, 8,000...
     * </p>
     * 
     * @return The step value for the range. For example, if you have a range of 5,000 to 10,000, with a step value of
     *         1,000, the valid values start at 5,000 and step up by 1,000. Even though 7,500 is within the range, it
     *         isn't a valid value for the range. The valid values are 5,000, 6,000, 7,000, 8,000...
     */
    public Integer step() {
        return step;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(to());
        hashCode = 31 * hashCode + Objects.hashCode(step());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range) obj;
        return Objects.equals(from(), other.from()) && Objects.equals(to(), other.to()) && Objects.equals(step(), other.step());
    }

    @Override
    public String toString() {
        return ToString.builder("Range").add("From", from()).add("To", to()).add("Step", step()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "From":
            return Optional.ofNullable(clazz.cast(from()));
        case "To":
            return Optional.ofNullable(clazz.cast(to()));
        case "Step":
            return Optional.ofNullable(clazz.cast(step()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Range, T> g) {
        return obj -> g.apply((Range) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Range> {
        /**
         * <p>
         * The minimum value in the range.
         * </p>
         * 
         * @param from
         *        The minimum value in the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(Integer from);

        /**
         * <p>
         * The maximum value in the range.
         * </p>
         * 
         * @param to
         *        The maximum value in the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(Integer to);

        /**
         * <p>
         * The step value for the range. For example, if you have a range of 5,000 to 10,000, with a step value of
         * 1,000, the valid values start at 5,000 and step up by 1,000. Even though 7,500 is within the range, it isn't
         * a valid value for the range. The valid values are 5,000, 6,000, 7,000, 8,000...
         * </p>
         * 
         * @param step
         *        The step value for the range. For example, if you have a range of 5,000 to 10,000, with a step value
         *        of 1,000, the valid values start at 5,000 and step up by 1,000. Even though 7,500 is within the range,
         *        it isn't a valid value for the range. The valid values are 5,000, 6,000, 7,000, 8,000...
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder step(Integer step);
    }

    static final class BuilderImpl implements Builder {
        private Integer from;

        private Integer to;

        private Integer step;

        private BuilderImpl() {
        }

        private BuilderImpl(Range model) {
            from(model.from);
            to(model.to);
            step(model.step);
        }

        public final Integer getFrom() {
            return from;
        }

        @Override
        public final Builder from(Integer from) {
            this.from = from;
            return this;
        }

        public final void setFrom(Integer from) {
            this.from = from;
        }

        public final Integer getTo() {
            return to;
        }

        @Override
        public final Builder to(Integer to) {
            this.to = to;
            return this;
        }

        public final void setTo(Integer to) {
            this.to = to;
        }

        public final Integer getStep() {
            return step;
        }

        @Override
        public final Builder step(Integer step) {
            this.step = step;
            return this;
        }

        public final void setStep(Integer step) {
            this.step = step;
        }

        @Override
        public Range build() {
            return new Range(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
