/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptune.NeptuneClient;
import software.amazon.awssdk.services.neptune.model.DBInstance;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse;

public class DescribeDBInstancesIterable
implements SdkIterable<DescribeDbInstancesResponse> {
    private final NeptuneClient client;
    private final DescribeDbInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBInstancesIterable(NeptuneClient client, DescribeDbInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbInstancesResponseFetcher();
    }

    public Iterator<DescribeDbInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBInstance> dbInstances() {
        Function<DescribeDbInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbInstances() != null) {
                return response.dbInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbInstancesResponseFetcher
    implements SyncPageFetcher<DescribeDbInstancesResponse> {
        private DescribeDbInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbInstancesResponse nextPage(DescribeDbInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBInstancesIterable.this.client.describeDBInstances(DescribeDBInstancesIterable.this.firstRequest);
            }
            return DescribeDBInstancesIterable.this.client.describeDBInstances((DescribeDbInstancesRequest)((Object)DescribeDBInstancesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

